/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.OsThemeDetector;
import com.jthemedetecor.util.ConcurrentHashSet;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(WindowsThemeDetector.class);
    private static final String REGISTRY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize";
    private static final String REGISTRY_VALUE = "AppsUseLightTheme";
    private final Set<Consumer<Boolean>> listeners = new ConcurrentHashSet<Consumer<Boolean>>();
    private volatile DetectorThread detectorThread;

    WindowsThemeDetector() {
    }

    @Override
    public boolean isDark() {
        return Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)REGISTRY_PATH, (String)REGISTRY_VALUE) == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void registerListener(Consumer<Boolean> darkThemeListener2) {
        void var2_5;
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener2);
        boolean darkThemeListener2 = this.listeners.add(darkThemeListener2);
        boolean singleListener = darkThemeListener2 && this.listeners.size() == 1;
        DetectorThread currentDetectorThread = this.detectorThread;
        boolean bl = threadInterrupted = currentDetectorThread != null && currentDetectorThread.isInterrupted();
        if (singleListener || var2_5 != false) {
            void var1_3;
            DetectorThread newDetectorThread;
            this.detectorThread = newDetectorThread = new DetectorThread(this);
            var1_3.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void removeListener(Consumer<Boolean> darkThemeListener) {
        void var1_1;
        this.listeners.remove(var1_1);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }

    private static final class DetectorThread
    extends Thread {
        private final WindowsThemeDetector themeDetector;
        private boolean lastValue;

        /*
         * WARNING - void declaration
         */
        DetectorThread(WindowsThemeDetector themeDetector) {
            void var1_1;
            this.themeDetector = themeDetector;
            this.lastValue = var1_1.isDark();
            this.setName("Windows 10 Theme Detector Thread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            void var1_1;
            WinReg.HKEYByReference hkey = new WinReg.HKEYByReference();
            int err = Advapi32.INSTANCE.RegOpenKeyEx(WinReg.HKEY_CURRENT_USER, WindowsThemeDetector.REGISTRY_PATH, 0, 131097, hkey);
            if (err != 0) {
                throw new Win32Exception(err);
            }
            while (!this.isInterrupted()) {
                err = Advapi32.INSTANCE.RegNotifyChangeKeyValue(hkey.getValue(), false, 4, null, false);
                if (err != 0) {
                    throw new Win32Exception(err);
                }
                boolean currentDetection = ((OsThemeDetector)this.themeDetector).isDark();
                if (currentDetection == this.lastValue) continue;
                this.lastValue = currentDetection;
                logger.debug("Theme change detected: dark: {}", (Object)currentDetection);
                for (Consumer<Boolean> listener : this.themeDetector.listeners) {
                    try {
                        listener.accept(currentDetection);
                    }
                    catch (RuntimeException e) {
                        logger.error("Caught exception during listener notifying ", (Throwable)e);
                    }
                }
            }
            Advapi32Util.registryCloseKey((WinReg.HKEY)var1_1.getValue());
        }
    }
}

