/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.GnomeThemeDetector;
import com.jthemedetecor.MacOSThemeDetector;
import com.jthemedetecor.WindowsThemeDetector;
import com.jthemedetecor.util.OsInfo;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;

public abstract class OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(OsThemeDetector.class);
    private static volatile OsThemeDetector osThemeDetector;

    OsThemeDetector() {
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ThreadSafe
    public static OsThemeDetector getDetector() {
        void var0;
        OsThemeDetector instance = osThemeDetector;
        if (instance != null) return var0;
        Class<OsThemeDetector> clazz = OsThemeDetector.class;
        synchronized (OsThemeDetector.class) {
            instance = osThemeDetector;
            if (instance != null) return var0;
            osThemeDetector = instance = OsThemeDetector.createDetector();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return var0;
        }
    }

    private static OsThemeDetector createDetector() {
        if (OsInfo.isWindows10OrLater()) {
            OsThemeDetector.logDetection("Windows 10", WindowsThemeDetector.class);
            return new WindowsThemeDetector();
        }
        if (OsInfo.isGnome()) {
            OsThemeDetector.logDetection("Gnome", GnomeThemeDetector.class);
            return new GnomeThemeDetector();
        }
        if (OsInfo.isMacOsMojaveOrLater()) {
            OsThemeDetector.logDetection("MacOS", MacOSThemeDetector.class);
            return new MacOSThemeDetector();
        }
        logger.debug("Theme detection is not supported on the system: {} {}", (Object)OsInfo.getFamily(), (Object)OsInfo.getVersion());
        logger.debug("Creating empty detector...");
        return new EmptyDetector();
    }

    /*
     * WARNING - void declaration
     */
    private static void logDetection(String desktop, Class<? extends OsThemeDetector> detectorClass) {
        void var1_1;
        String string;
        logger.debug("Supported Desktop detected: {}", (Object)string);
        logger.debug("Creating {}...", (Object)var1_1.getName());
    }

    @ThreadSafe
    public abstract boolean isDark();

    @ThreadSafe
    public abstract void registerListener(Consumer<Boolean> var1);

    @ThreadSafe
    public abstract void removeListener(Consumer<Boolean> var1);

    @ThreadSafe
    public static boolean isSupported() {
        return OsInfo.isWindows10OrLater() || OsInfo.isMacOsMojaveOrLater() || OsInfo.isGnome();
    }

    private static final class EmptyDetector
    extends OsThemeDetector {
        private EmptyDetector() {
        }

        @Override
        public final boolean isDark() {
            return false;
        }

        @Override
        public final void registerListener(Consumer<Boolean> darkThemeListener) {
        }

        @Override
        public final void removeListener(Consumer<Boolean> darkThemeListener) {
        }
    }
}

