/*
 * Decompiled with CFR 0.152.
 */
package com.jthemedetecor;

import com.jthemedetecor.OsThemeDetector;
import com.jthemedetecor.util.ConcurrentHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GnomeThemeDetector
extends OsThemeDetector {
    private static final Logger logger = LoggerFactory.getLogger(GnomeThemeDetector.class);
    private static final String MONITORING_CMD = "gsettings monitor org.gnome.desktop.interface";
    private static final String[] GET_CMD = new String[]{"gsettings get org.gnome.desktop.interface gtk-theme", "gsettings get org.gnome.desktop.interface color-scheme"};
    private final Set<Consumer<Boolean>> listeners = new ConcurrentHashSet<Consumer<Boolean>>();
    private final Pattern darkThemeNamePattern = Pattern.compile(".*dark.*", 2);
    private volatile DetectorThread detectorThread;

    GnomeThemeDetector() {
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDark() {
        try {
            Runtime runtime = Runtime.getRuntime();
            String[] stringArray = GET_CMD;
            int n = GET_CMD.length;
            int n2 = 0;
            while (n2 < n) {
                String cmd = stringArray[n2];
                Process process = runtime.exec(cmd);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String readLine = reader.readLine();
                    if (readLine != null && this.isDarkTheme(readLine)) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }
        catch (IOException e) {
            void var1_3;
            logger.error("Couldn't detect Linux OS theme", (Throwable)var1_3);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isDarkTheme(String gtkTheme) {
        void var1_1;
        return this.darkThemeNamePattern.matcher((CharSequence)var1_1).matches();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void registerListener(Consumer<Boolean> darkThemeListener2) {
        void var2_5;
        boolean threadInterrupted;
        Objects.requireNonNull(darkThemeListener2);
        boolean darkThemeListener2 = this.listeners.add(darkThemeListener2);
        boolean singleListener = darkThemeListener2 && this.listeners.size() == 1;
        DetectorThread currentDetectorThread = this.detectorThread;
        boolean bl = threadInterrupted = currentDetectorThread != null && currentDetectorThread.isInterrupted();
        if (singleListener || var2_5 != false) {
            void var1_3;
            DetectorThread newDetectorThread;
            this.detectorThread = newDetectorThread = new DetectorThread(this);
            var1_3.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void removeListener(Consumer<Boolean> darkThemeListener) {
        void var1_1;
        this.listeners.remove(var1_1);
        if (this.listeners.isEmpty()) {
            this.detectorThread.interrupt();
            this.detectorThread = null;
        }
    }

    private static final class DetectorThread
    extends Thread {
        private final GnomeThemeDetector detector;
        private final Pattern outputPattern = Pattern.compile("(gtk-theme|color-scheme).*", 2);
        private boolean lastValue;

        /*
         * WARNING - void declaration
         */
        DetectorThread(GnomeThemeDetector detector) {
            void var1_1;
            this.detector = detector;
            this.lastValue = var1_1.isDark();
            this.setName("GTK Theme Detector Thread");
            this.setDaemon(true);
            this.setPriority(4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            try {
                BufferedReader reader;
                block11: {
                    Runtime runtime = Runtime.getRuntime();
                    Process monitoringProcess = runtime.exec(GnomeThemeDetector.MONITORING_CMD);
                    reader = new BufferedReader(new InputStreamReader(monitoringProcess.getInputStream()));
                    try {
                        while (!this.isInterrupted()) {
                            String readLine = reader.readLine();
                            if (readLine == null || !this.outputPattern.matcher(readLine).matches()) continue;
                            String[] stringArray = readLine.split("\\s");
                            String value = stringArray[1];
                            boolean currentDetection = this.detector.isDarkTheme(value);
                            logger.debug("Theme changed detection, dark: {}", (Object)currentDetection);
                            if (currentDetection == this.lastValue) continue;
                            this.lastValue = currentDetection;
                            for (Consumer consumer : this.detector.listeners) {
                                try {
                                    consumer.accept(currentDetection);
                                }
                                catch (RuntimeException runtimeException) {
                                    logger.error("Caught exception during listener notifying ", (Throwable)runtimeException);
                                }
                            }
                        }
                        logger.debug("ThemeDetectorThread has been interrupted!");
                        if (!monitoringProcess.isAlive()) break block11;
                        monitoringProcess.destroy();
                        logger.debug("Monitoring process has been destroyed!");
                    }
                    catch (Throwable throwable) {
                        try {
                            void var2_4;
                            var2_4.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                logger.error("Couldn't start monitoring process ", (Throwable)e);
                return;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                void var1_3;
                logger.error("Couldn't parse command line output", (Throwable)var1_3);
            }
        }
    }
}

