/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.DsGetDC;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.LMAccess;
import com.sun.jna.platform.win32.Netapi32;
import com.sun.jna.platform.win32.Ole32Util;
import com.sun.jna.platform.win32.Secur32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;

public abstract class Netapi32Util {
    public static String getDCName() {
        return Netapi32Util.getDCName(null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String getDCName(String serverName, String domainName) {
        PointerByReference bufptr = new PointerByReference();
        try {
            void var1_4;
            int rc = Netapi32.INSTANCE.NetGetDCName((String)var1_4, serverName, bufptr);
            if (rc != 0) {
                void var0_1;
                throw new Win32Exception((int)var0_1);
            }
            String string = bufptr.getValue().getWideString(0L);
            return string;
        }
        finally {
            if (0 != Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }
    }

    public static int getJoinStatus() {
        return Netapi32Util.getJoinStatus(null);
    }

    /*
     * WARNING - void declaration
     */
    public static int getJoinStatus(String computerName) {
        int rc3;
        int n;
        PointerByReference lpNameBuffer = new PointerByReference();
        IntByReference bufferType = new IntByReference();
        try {
            void var2_6;
            int rc2 = Netapi32.INSTANCE.NetGetJoinInformation(computerName, lpNameBuffer, bufferType);
            if (rc2 != 0) {
                throw new Win32Exception(n);
            }
            n = var2_6.getValue();
        }
        catch (Throwable throwable) {
            void rc3;
            if (rc3.getPointer() != null && (rc = Netapi32.INSTANCE.NetApiBufferFree(rc3.getValue())) != 0) {
                void var1_5;
                throw new Win32Exception((int)var1_5);
            }
            throw throwable;
        }
        if (lpNameBuffer.getPointer() != null && (rc3 = Netapi32.INSTANCE.NetApiBufferFree(lpNameBuffer.getValue())) != 0) {
            throw new Win32Exception(rc3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static String getDomainName(String computerName) {
        int rc3;
        String string;
        PointerByReference lpNameBuffer = new PointerByReference();
        IntByReference bufferType = new IntByReference();
        try {
            void var2_7;
            int rc2 = Netapi32.INSTANCE.NetGetJoinInformation(computerName, lpNameBuffer, (IntByReference)var2_7);
            if (rc2 != 0) {
                void var0_1;
                throw new Win32Exception((int)var0_1);
            }
            string = lpNameBuffer.getValue().getWideString(0L);
        }
        catch (Throwable throwable) {
            void rc3;
            if (rc3.getPointer() != null && (rc = Netapi32.INSTANCE.NetApiBufferFree(rc3.getValue())) != 0) {
                void var1_6;
                throw new Win32Exception((int)var1_6);
            }
            throw throwable;
        }
        if (lpNameBuffer.getPointer() != null && (rc3 = Netapi32.INSTANCE.NetApiBufferFree(lpNameBuffer.getValue())) != 0) {
            throw new Win32Exception(rc3);
        }
        return string;
    }

    public static LocalGroup[] getLocalGroups() {
        return Netapi32Util.getLocalGroups(null);
    }

    /*
     * WARNING - void declaration
     */
    public static LocalGroup[] getLocalGroups(String serverName) {
        int rc;
        LocalGroup[] localGroupArray;
        PointerByReference bufptr = new PointerByReference();
        LMAccess.LOCALGROUP_INFO_1[] entriesRead = new IntByReference();
        IntByReference totalEntries = new IntByReference();
        try {
            void var0_2;
            LMAccess.LOCALGROUP_INFO_1 lOCALGROUP_INFO_1;
            int rc2 = Netapi32.INSTANCE.NetLocalGroupEnum(serverName, 1, bufptr, -1, (IntByReference)entriesRead, (IntByReference)lOCALGROUP_INFO_1, null);
            if (rc2 != 0 || bufptr.getValue() == Pointer.NULL) {
                throw new Win32Exception(rc2);
            }
            ArrayList<LocalGroup> result = new ArrayList<LocalGroup>();
            if (entriesRead.getValue() > 0) {
                lOCALGROUP_INFO_1 = new LMAccess.LOCALGROUP_INFO_1(bufptr.getValue());
                LMAccess.LOCALGROUP_INFO_1[] lOCALGROUP_INFO_1Array = (LMAccess.LOCALGROUP_INFO_1[])lOCALGROUP_INFO_1.toArray(entriesRead.getValue());
                entriesRead = lOCALGROUP_INFO_1Array;
                entriesRead = lOCALGROUP_INFO_1Array;
                int n = lOCALGROUP_INFO_1Array.length;
                for (int i = 0; i < n; ++i) {
                    LMAccess.LOCALGROUP_INFO_1 lgpi = entriesRead[i];
                    LocalGroup lgp = new LocalGroup();
                    new LocalGroup().name = lgpi.lgrui1_name;
                    lgp.comment = lgpi.lgrui1_comment;
                    result.add(lgp);
                }
            }
            localGroupArray = var0_2.toArray(new LocalGroup[0]);
        }
        catch (Throwable throwable) {
            int rc3;
            if (bufptr.getValue() != Pointer.NULL && (rc3 = Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) != 0) {
                void var1_5;
                throw new Win32Exception((int)var1_5);
            }
            throw throwable;
        }
        if (bufptr.getValue() != Pointer.NULL && (rc = Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) != 0) {
            void var2_7;
            throw new Win32Exception((int)var2_7);
        }
        return localGroupArray;
    }

    public static Group[] getGlobalGroups() {
        return Netapi32Util.getGlobalGroups(null);
    }

    /*
     * WARNING - void declaration
     */
    public static Group[] getGlobalGroups(String serverName) {
        int rc;
        Group[] groupArray;
        PointerByReference bufptr = new PointerByReference();
        LMAccess.GROUP_INFO_1[] entriesRead = new IntByReference();
        IntByReference totalEntries = new IntByReference();
        try {
            void var0_2;
            LMAccess.GROUP_INFO_1 gROUP_INFO_1;
            int rc2 = Netapi32.INSTANCE.NetGroupEnum(serverName, 1, bufptr, -1, (IntByReference)entriesRead, (IntByReference)gROUP_INFO_1, null);
            if (rc2 != 0 || bufptr.getValue() == Pointer.NULL) {
                throw new Win32Exception(rc2);
            }
            ArrayList<LocalGroup> result = new ArrayList<LocalGroup>();
            if (entriesRead.getValue() > 0) {
                gROUP_INFO_1 = new LMAccess.GROUP_INFO_1(bufptr.getValue());
                LMAccess.GROUP_INFO_1[] gROUP_INFO_1Array = (LMAccess.GROUP_INFO_1[])gROUP_INFO_1.toArray(entriesRead.getValue());
                entriesRead = gROUP_INFO_1Array;
                entriesRead = gROUP_INFO_1Array;
                int n = gROUP_INFO_1Array.length;
                for (int i = 0; i < n; ++i) {
                    LMAccess.GROUP_INFO_1 lgpi = entriesRead[i];
                    LocalGroup lgp = new LocalGroup();
                    new LocalGroup().name = lgpi.grpi1_name;
                    lgp.comment = lgpi.grpi1_comment;
                    result.add(lgp);
                }
            }
            groupArray = var0_2.toArray(new LocalGroup[0]);
        }
        catch (Throwable throwable) {
            int rc3;
            if (bufptr.getValue() != Pointer.NULL && (rc3 = Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) != 0) {
                void var1_5;
                throw new Win32Exception((int)var1_5);
            }
            throw throwable;
        }
        if (bufptr.getValue() != Pointer.NULL && (rc = Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) != 0) {
            void var2_7;
            throw new Win32Exception((int)var2_7);
        }
        return groupArray;
    }

    public static User[] getUsers() {
        return Netapi32Util.getUsers(null);
    }

    /*
     * WARNING - void declaration
     */
    public static User[] getUsers(String serverName) {
        int rc;
        User[] userArray;
        PointerByReference bufptr = new PointerByReference();
        LMAccess.USER_INFO_1[] entriesRead = new IntByReference();
        IntByReference totalEntries = new IntByReference();
        try {
            void var0_2;
            LMAccess.USER_INFO_1 uSER_INFO_1;
            int rc2 = Netapi32.INSTANCE.NetUserEnum(serverName, 1, 0, bufptr, -1, (IntByReference)entriesRead, (IntByReference)uSER_INFO_1, null);
            if (rc2 != 0 || bufptr.getValue() == Pointer.NULL) {
                throw new Win32Exception(rc2);
            }
            ArrayList<User> result = new ArrayList<User>();
            if (entriesRead.getValue() > 0) {
                uSER_INFO_1 = new LMAccess.USER_INFO_1(bufptr.getValue());
                LMAccess.USER_INFO_1[] uSER_INFO_1Array = (LMAccess.USER_INFO_1[])uSER_INFO_1.toArray(entriesRead.getValue());
                entriesRead = uSER_INFO_1Array;
                entriesRead = uSER_INFO_1Array;
                int n = uSER_INFO_1Array.length;
                for (int i = 0; i < n; ++i) {
                    LMAccess.USER_INFO_1 lu = entriesRead[i];
                    User auser = new User();
                    if (lu.usri1_name != null) {
                        auser.name = lu.usri1_name;
                    }
                    result.add(auser);
                }
            }
            userArray = var0_2.toArray(new User[0]);
        }
        catch (Throwable throwable) {
            int rc3;
            if (bufptr.getValue() != Pointer.NULL && (rc3 = Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) != 0) {
                void var1_5;
                throw new Win32Exception((int)var1_5);
            }
            throw throwable;
        }
        if (bufptr.getValue() != Pointer.NULL && (rc = Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) != 0) {
            void var2_7;
            throw new Win32Exception((int)var2_7);
        }
        return userArray;
    }

    public static Group[] getCurrentUserLocalGroups() {
        return Netapi32Util.getUserLocalGroups(Secur32Util.getUserNameEx(2));
    }

    public static Group[] getUserLocalGroups(String userName) {
        return Netapi32Util.getUserLocalGroups(userName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Group[] getUserLocalGroups(String userName, String serverName) {
        int rc;
        PointerByReference bufptr = new PointerByReference();
        LMAccess.LOCALGROUP_USERS_INFO_0[] entriesread2 = new IntByReference();
        IntByReference totalentries = new IntByReference();
        try {
            void var0_2;
            int rc2 = Netapi32.INSTANCE.NetUserGetLocalGroups((String)serverName, userName, 0, 0, bufptr, -1, (IntByReference)entriesread2, totalentries);
            if (rc2 != 0) {
                throw new Win32Exception(rc2);
            }
            ArrayList<LocalGroup> result = new ArrayList<LocalGroup>();
            if (entriesread2.getValue() > 0) {
                serverName = new LMAccess.LOCALGROUP_USERS_INFO_0(bufptr.getValue());
                entriesread2 = (LMAccess.LOCALGROUP_USERS_INFO_0[])serverName.toArray(entriesread2.getValue());
                serverName = entriesread2;
                int entriesread2 = entriesread2.length;
                for (int i = 0; i < entriesread2; ++i) {
                    Group lgpi = serverName[i];
                    LocalGroup lgp = new LocalGroup();
                    if (((LMAccess.LOCALGROUP_USERS_INFO_0)((Object)lgpi)).lgrui0_name != null) {
                        lgp.name = ((LMAccess.LOCALGROUP_USERS_INFO_0)((Object)lgpi)).lgrui0_name;
                    }
                    result.add(lgp);
                }
            }
            serverName = var0_2.toArray(new Group[0]);
        }
        catch (Throwable throwable) {
            void var2_6;
            int rc3;
            if (bufptr.getValue() != Pointer.NULL && (rc3 = Netapi32.INSTANCE.NetApiBufferFree(var2_6.getValue())) != 0) {
                void var1_5;
                throw new Win32Exception((int)var1_5);
            }
            throw throwable;
        }
        if (bufptr.getValue() != Pointer.NULL && (rc = Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) != 0) {
            void var3_9;
            throw new Win32Exception((int)var3_9);
        }
        return serverName;
    }

    public static Group[] getUserGroups(String userName) {
        return Netapi32Util.getUserGroups(userName, null);
    }

    /*
     * WARNING - void declaration
     */
    public static Group[] getUserGroups(String userName, String serverName) {
        int rc;
        PointerByReference bufptr = new PointerByReference();
        LMAccess.GROUP_USERS_INFO_0[] entriesread2 = new IntByReference();
        IntByReference totalentries = new IntByReference();
        try {
            void var0_2;
            int rc2 = Netapi32.INSTANCE.NetUserGetGroups((String)serverName, userName, 0, bufptr, -1, (IntByReference)entriesread2, totalentries);
            if (rc2 != 0) {
                throw new Win32Exception(rc2);
            }
            ArrayList<Group> result = new ArrayList<Group>();
            if (entriesread2.getValue() > 0) {
                serverName = new LMAccess.GROUP_USERS_INFO_0(bufptr.getValue());
                entriesread2 = (LMAccess.GROUP_USERS_INFO_0[])serverName.toArray(entriesread2.getValue());
                serverName = entriesread2;
                int entriesread2 = entriesread2.length;
                for (int i = 0; i < entriesread2; ++i) {
                    Group lgpi = serverName[i];
                    Group lgp = new Group();
                    if (((LMAccess.GROUP_USERS_INFO_0)((Object)lgpi)).grui0_name != null) {
                        lgp.name = ((LMAccess.GROUP_USERS_INFO_0)((Object)lgpi)).grui0_name;
                    }
                    result.add(lgp);
                }
            }
            serverName = var0_2.toArray(new Group[0]);
        }
        catch (Throwable throwable) {
            void var2_6;
            int rc3;
            if (bufptr.getValue() != Pointer.NULL && (rc3 = Netapi32.INSTANCE.NetApiBufferFree(var2_6.getValue())) != 0) {
                void var1_5;
                throw new Win32Exception((int)var1_5);
            }
            throw throwable;
        }
        if (bufptr.getValue() != Pointer.NULL && (rc = Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue())) != 0) {
            void var3_9;
            throw new Win32Exception((int)var3_9);
        }
        return serverName;
    }

    /*
     * WARNING - void declaration
     */
    public static DomainController getDC() {
        void var2_2;
        void var0;
        DsGetDC.PDOMAIN_CONTROLLER_INFO pdci = new DsGetDC.PDOMAIN_CONTROLLER_INFO();
        int rc = Netapi32.INSTANCE.DsGetDcName(null, null, null, null, 0, pdci);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        DomainController dc = new DomainController();
        new DomainController().address = pdci.dci.DomainControllerAddress;
        dc.addressType = pdci.dci.DomainControllerAddressType;
        dc.clientSiteName = pdci.dci.ClientSiteName;
        dc.dnsForestName = pdci.dci.DnsForestName;
        dc.domainGuid = pdci.dci.DomainGuid;
        dc.domainName = pdci.dci.DomainName;
        dc.flags = pdci.dci.Flags;
        dc.name = pdci.dci.DomainControllerName;
        rc = Netapi32.INSTANCE.NetApiBufferFree(var0.dci.getPointer());
        if (rc != 0) {
            void var1_1;
            throw new Win32Exception((int)var1_1);
        }
        return var2_2;
    }

    public static DomainTrust[] getDomainTrusts() {
        return Netapi32Util.getDomainTrusts(null);
    }

    /*
     * WARNING - void declaration
     */
    public static DomainTrust[] getDomainTrusts(String serverName) {
        PointerByReference domainsPointerRef = new PointerByReference();
        IntByReference domainTrustCount = new IntByReference();
        int rc = Netapi32.INSTANCE.DsEnumerateDomainTrusts(serverName, 63, domainsPointerRef, domainTrustCount);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        try {
            void var0_2;
            ArrayList<DomainTrust> trusts = new ArrayList<DomainTrust>(domainTrustCount.getValue());
            if (domainTrustCount.getValue() > 0) {
                DsGetDC.DS_DOMAIN_TRUSTS[] dS_DOMAIN_TRUSTSArray;
                DsGetDC.DS_DOMAIN_TRUSTS dS_DOMAIN_TRUSTS = new DsGetDC.DS_DOMAIN_TRUSTS(domainsPointerRef.getValue());
                DsGetDC.DS_DOMAIN_TRUSTS[] dS_DOMAIN_TRUSTSArray2 = (DsGetDC.DS_DOMAIN_TRUSTS[])dS_DOMAIN_TRUSTS.toArray(new DsGetDC.DS_DOMAIN_TRUSTS[dS_DOMAIN_TRUSTSArray.getValue()]);
                dS_DOMAIN_TRUSTSArray = dS_DOMAIN_TRUSTSArray2;
                dS_DOMAIN_TRUSTSArray = dS_DOMAIN_TRUSTSArray2;
                int n = dS_DOMAIN_TRUSTSArray2.length;
                for (int i = 0; i < n; ++i) {
                    DsGetDC.DS_DOMAIN_TRUSTS domainTrust = dS_DOMAIN_TRUSTSArray[i];
                    DomainTrust t = new DomainTrust();
                    if (domainTrust.DnsDomainName != null) {
                        t.DnsDomainName = domainTrust.DnsDomainName;
                    }
                    if (domainTrust.NetbiosDomainName != null) {
                        t.NetbiosDomainName = domainTrust.NetbiosDomainName;
                    }
                    t.DomainSid = domainTrust.DomainSid;
                    if (domainTrust.DomainSid != null) {
                        t.DomainSidString = Advapi32Util.convertSidToStringSid(domainTrust.DomainSid);
                    }
                    t.DomainGuid = domainTrust.DomainGuid;
                    if (domainTrust.DomainGuid != null) {
                        t.DomainGuidString = Ole32Util.getStringFromGUID(domainTrust.DomainGuid);
                    }
                    DomainTrust.access$002(t, domainTrust.Flags);
                    trusts.add(t);
                }
            }
            DomainTrust[] domainTrustArray = var0_2.toArray(new DomainTrust[0]);
            int n = Netapi32.INSTANCE.NetApiBufferFree(domainsPointerRef.getValue());
            if (n != 0) {
                throw new Win32Exception(n);
            }
            return domainTrustArray;
        }
        catch (Throwable throwable) {
            void var2_6;
            int n = Netapi32.INSTANCE.NetApiBufferFree(var2_6.getValue());
            if (n != 0) {
                throw new Win32Exception(n);
            }
            throw throwable;
        }
    }

    public static UserInfo getUserInfo(String accountName) {
        return Netapi32Util.getUserInfo(accountName, Netapi32Util.getDCName());
    }

    /*
     * WARNING - void declaration
     */
    public static UserInfo getUserInfo(String accountName, String domainName) {
        void var0_1;
        block6: {
            void var0_2;
            PointerByReference bufptr = new PointerByReference();
            try {
                void var1_4;
                int rc = Netapi32.INSTANCE.NetUserGetInfo(domainName, accountName, 23, bufptr);
                if (rc != 0) break block6;
                LMAccess.USER_INFO_23 info_23 = new LMAccess.USER_INFO_23(bufptr.getValue());
                UserInfo userInfo = new UserInfo();
                new UserInfo().comment = info_23.usri23_comment;
                userInfo.flags = info_23.usri23_flags;
                userInfo.fullName = info_23.usri23_full_name;
                userInfo.name = info_23.usri23_name;
                if (info_23.usri23_user_sid != null) {
                    userInfo.sidString = Advapi32Util.convertSidToStringSid(info_23.usri23_user_sid);
                }
                userInfo.sid = var0_2.usri23_user_sid;
                var0_2 = var1_4;
            }
            catch (Throwable throwable) {
                if (bufptr.getValue() != Pointer.NULL) {
                    void var2_5;
                    Netapi32.INSTANCE.NetApiBufferFree(var2_5.getValue());
                }
                throw throwable;
            }
            if (bufptr.getValue() != Pointer.NULL) {
                Netapi32.INSTANCE.NetApiBufferFree(bufptr.getValue());
            }
            return var0_2;
        }
        throw new Win32Exception((int)var0_1);
    }

    public static class LocalGroup
    extends Group {
        public String comment;
    }

    public static class Group {
        public String name;
    }

    public static class User {
        public String name;
        public String comment;
    }

    public static class DomainController {
        public String name;
        public String address;
        public int addressType;
        public Guid.GUID domainGuid;
        public String domainName;
        public String dnsForestName;
        public int flags;
        public String clientSiteName;
    }

    public static class DomainTrust {
        public String NetbiosDomainName;
        public String DnsDomainName;
        public WinNT.PSID DomainSid;
        public String DomainSidString;
        public Guid.GUID DomainGuid;
        public String DomainGuidString;
        private int flags;

        public boolean isInForest() {
            return (this.flags & 1) != 0;
        }

        public boolean isOutbound() {
            return (this.flags & 2) != 0;
        }

        public boolean isRoot() {
            return (this.flags & 4) != 0;
        }

        public boolean isPrimary() {
            return (this.flags & 8) != 0;
        }

        public boolean isNativeMode() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isInbound() {
            return (this.flags & 0x20) != 0;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$002(DomainTrust x0, int x1) {
            void var1_1;
            x0.flags = var1_1;
            return x0.flags;
        }
    }

    public static class UserInfo
    extends User {
        public String fullName;
        public String sidString;
        public WinNT.PSID sid;
        public int flags;
    }
}

