/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.tlb.imp;

import com.sun.jna.platform.win32.COM.ITypeInfo;
import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLibUtil;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbAbstractMethod;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbBase;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbFunctionDispId;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbFunctionVTable;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbPropertyGet;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbPropertyPut;
import com.sun.jna.platform.win32.OaIdl;

public class TlbCoClass
extends TlbBase {
    /*
     * WARNING - void declaration
     */
    public TlbCoClass(int index, String packagename, TypeLibUtil typeLibUtil, String bindingMode) {
        super(index, typeLibUtil, null);
        void var2_6;
        TypeInfoUtil typeInfoUtil = typeLibUtil.getTypeInfoUtil(index);
        TypeLibUtil.TypeLibDoc typeLibDoc = this.typeLibUtil.getDocumentation(index);
        String docString = typeLibDoc.getDocString();
        if (typeLibDoc.getName().length() > 0) {
            this.name = typeLibDoc.getName();
        }
        this.logInfo("Type of kind 'CoClass' found: " + this.name);
        this.createPackageName(packagename);
        TlbCoClass tlbCoClass = this;
        tlbCoClass.createClassName(tlbCoClass.name);
        TlbCoClass tlbCoClass2 = this;
        tlbCoClass2.setFilename(tlbCoClass2.name);
        Object guidStr = this.typeLibUtil.getLibAttr().guid.toGuidString();
        int majorVerNum = this.typeLibUtil.getLibAttr().wMajorVerNum.intValue();
        int minorVerNum = this.typeLibUtil.getLibAttr().wMinorVerNum.intValue();
        String version = majorVerNum + "." + minorVerNum;
        String clsid = typeInfoUtil.getTypeAttr().guid.toGuidString();
        this.createJavaDocHeader((String)guidStr, version, docString);
        this.createCLSID(clsid);
        TlbCoClass tlbCoClass3 = this;
        tlbCoClass3.createCLSIDName(tlbCoClass3.name);
        guidStr = typeInfoUtil.getTypeAttr();
        int cImplTypes = ((OaIdl.TYPEATTR)((Object)guidStr)).cImplTypes.intValue();
        String interfaces = "";
        for (int i = 0; i < cImplTypes; ++i) {
            OaIdl.HREFTYPE refTypeOfImplType = typeInfoUtil.getRefTypeOfImplType(i);
            ITypeInfo refTypeInfo = typeInfoUtil.getRefTypeInfo(refTypeOfImplType);
            TypeInfoUtil refTypeInfoUtil = new TypeInfoUtil(refTypeInfo);
            this.createFunctions(refTypeInfoUtil, bindingMode);
            TypeInfoUtil.TypeInfoDoc documentation = refTypeInfoUtil.getDocumentation(new OaIdl.MEMBERID(-1));
            interfaces = interfaces + documentation.getName();
            if (i >= cImplTypes - 1) continue;
            interfaces = interfaces + ", ";
        }
        this.createInterfaces((String)var2_6);
        TlbCoClass tlbCoClass4 = this;
        tlbCoClass4.createContent(tlbCoClass4.content);
    }

    protected void createFunctions(TypeInfoUtil typeInfoUtil, String bindingMode) {
        bindingMode = typeInfoUtil.getTypeAttr();
        int cFuncs = ((OaIdl.TYPEATTR)((Object)bindingMode)).cFuncs.intValue();
        for (int i = 0; i < cFuncs; ++i) {
            OaIdl.FUNCDESC funcDesc = typeInfoUtil.getFuncDesc(i);
            TlbAbstractMethod method = null;
            if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_FUNC.value) {
                method = this.isVTableMode() ? new TlbFunctionVTable(i, this.index, this.typeLibUtil, funcDesc, typeInfoUtil) : new TlbFunctionDispId(i, this.index, this.typeLibUtil, funcDesc, typeInfoUtil);
            } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYGET.value) {
                method = new TlbPropertyGet(i, this.index, this.typeLibUtil, funcDesc, typeInfoUtil);
            } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYPUT.value) {
                method = new TlbPropertyPut(i, this.index, this.typeLibUtil, funcDesc, typeInfoUtil);
            } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYPUTREF.value) {
                method = new TlbPropertyPut(i, this.index, this.typeLibUtil, funcDesc, typeInfoUtil);
            }
            if (!this.isReservedMethod(method.getMethodName())) {
                this.content = this.content + method.getClassBuffer();
                if (i < cFuncs - 1) {
                    this.content = this.content + "\n";
                }
            }
            typeInfoUtil.ReleaseFuncDesc(funcDesc);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createJavaDocHeader(String guid, String version, String helpstring) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.replaceVariable("uuid", (String)var1_1);
        this.replaceVariable("version", (String)var2_2);
        this.replaceVariable("helpstring", (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void createCLSIDName(String clsidName) {
        void var1_1;
        this.replaceVariable("clsidname", var1_1.toUpperCase());
    }

    /*
     * WARNING - void declaration
     */
    protected void createCLSID(String clsid) {
        void var1_1;
        this.replaceVariable("clsid", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void createInterfaces(String interfaces) {
        void var1_1;
        this.replaceVariable("interfaces", (String)var1_1);
    }

    @Override
    protected String getClassTemplate() {
        return "com/sun/jna/platform/win32/COM/tlb/imp/TlbCoClass.template";
    }
}

