/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.Wbemcli;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OaIdlUtil;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;

public interface Wbemcli {
    public static final int WBEM_FLAG_RETURN_WBEM_COMPLETE = 0;
    public static final int WBEM_FLAG_RETURN_IMMEDIATELY = 16;
    public static final int WBEM_FLAG_FORWARD_ONLY = 32;
    public static final int WBEM_FLAG_NO_ERROR_OBJECT = 64;
    public static final int WBEM_FLAG_SEND_STATUS = 128;
    public static final int WBEM_FLAG_ENSURE_LOCATABLE = 256;
    public static final int WBEM_FLAG_DIRECT_READ = 512;
    public static final int WBEM_MASK_RESERVED_FLAGS = 126976;
    public static final int WBEM_FLAG_USE_AMENDED_QUALIFIERS = 131072;
    public static final int WBEM_FLAG_STRONG_VALIDATION = 0x100000;
    public static final int WBEM_INFINITE = -1;
    public static final int WBEM_S_NO_ERROR = 0;
    public static final int WBEM_S_FALSE = 1;
    public static final int WBEM_S_TIMEDOUT = 262148;
    public static final int WBEM_S_NO_MORE_DATA = 262149;
    public static final int WBEM_E_INVALID_NAMESPACE = -2147217394;
    public static final int WBEM_E_INVALID_CLASS = -2147217392;
    public static final int WBEM_E_INVALID_QUERY = -2147217385;
    public static final int CIM_ILLEGAL = 4095;
    public static final int CIM_EMPTY = 0;
    public static final int CIM_SINT8 = 16;
    public static final int CIM_UINT8 = 17;
    public static final int CIM_SINT16 = 2;
    public static final int CIM_UINT16 = 18;
    public static final int CIM_SINT32 = 3;
    public static final int CIM_UINT32 = 19;
    public static final int CIM_SINT64 = 20;
    public static final int CIM_UINT64 = 21;
    public static final int CIM_REAL32 = 4;
    public static final int CIM_REAL64 = 5;
    public static final int CIM_BOOLEAN = 11;
    public static final int CIM_STRING = 8;
    public static final int CIM_DATETIME = 101;
    public static final int CIM_REFERENCE = 102;
    public static final int CIM_CHAR16 = 103;
    public static final int CIM_OBJECT = 13;
    public static final int CIM_FLAG_ARRAY = 8192;

    public static class IWbemContext
    extends Unknown {
        public static final Guid.CLSID CLSID_WbemContext = new Guid.CLSID("674B6698-EE92-11D0-AD71-00C04FD8FDFF");
        public static final Guid.GUID IID_IWbemContext = new Guid.GUID("44aca674-e8fc-11d0-a07c-00c04fb68820");

        public IWbemContext() {
        }

        /*
         * WARNING - void declaration
         */
        public static IWbemContext create() {
            void var0;
            PointerByReference pbr = new PointerByReference();
            WinNT.HRESULT hRESULT = Ole32.INSTANCE.CoCreateInstance(CLSID_WbemContext, null, 1, IID_IWbemContext, pbr);
            if (COMUtils.FAILED(hRESULT)) {
                return null;
            }
            return new IWbemContext(var0.getValue());
        }

        /*
         * WARNING - void declaration
         */
        public IWbemContext(Pointer pvInstance) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void SetValue(String wszName, int lFlag, Variant.VARIANT pValue) {
            WTypes.BSTR wszNameBSTR = OleAuto.INSTANCE.SysAllocString(wszName);
            try {
                void var3_5;
                void var2_2;
                WinNT.HRESULT hRESULT = (WinNT.HRESULT)((Object)this._invokeNativeObject(8, new Object[]{this.getPointer(), wszNameBSTR, (int)var2_2, var3_5}, WinNT.HRESULT.class));
                COMUtils.checkRC(hRESULT);
                OleAuto.INSTANCE.SysFreeString(wszNameBSTR);
                return;
            }
            catch (Throwable throwable) {
                void var1_1;
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var1_1);
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void SetValue(String wszName, int lFlag, boolean pValue) {
            void var2_2;
            void var1_1;
            void var3_3;
            Variant.VARIANT aVariant = new Variant.VARIANT();
            aVariant.setValue(11, (Object)(var3_3 != false ? Variant.VARIANT_TRUE : Variant.VARIANT_FALSE));
            this.SetValue((String)var1_1, (int)var2_2, aVariant);
            OleAuto.INSTANCE.VariantClear(aVariant);
        }

        /*
         * WARNING - void declaration
         */
        public void SetValue(String wszName, int lFlag, String pValue) {
            Variant.VARIANT aVariant = new Variant.VARIANT();
            WTypes.BSTR strValue = OleAuto.INSTANCE.SysAllocString(pValue);
            try {
                void var2_3;
                void var1_1;
                aVariant.setValue(30, (Object)strValue);
                this.SetValue((String)var1_1, (int)var2_3, aVariant);
                OleAuto.INSTANCE.SysFreeString(strValue);
                return;
            }
            catch (Throwable throwable) {
                void var3_4;
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var3_4);
                throw throwable;
            }
        }
    }

    public static class IWbemServices
    extends Unknown {
        public IWbemServices() {
        }

        /*
         * WARNING - void declaration
         */
        public IWbemServices(Pointer pvInstance) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT ExecMethod(WTypes.BSTR strObjectPath, WTypes.BSTR strMethodName, int lFlags, IWbemContext pCtx, Pointer pInParams, PointerByReference ppOutParams, PointerByReference ppCallResult) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(24, new Object[]{this.getPointer(), var1_1, var2_2, (int)var3_3, pCtx, pInParams, ppOutParams, ppCallResult}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public IWbemClassObject ExecMethod(String strObjectPath, String strMethodName, int lFlags, IWbemContext pCtx, IWbemClassObject inParams) {
            WTypes.BSTR strObjectPathBSTR = OleAuto.INSTANCE.SysAllocString(strObjectPath);
            WTypes.BSTR strMethodNameBSTR = OleAuto.INSTANCE.SysAllocString(strMethodName);
            try {
                void var3_3;
                PointerByReference ppOutParams = new PointerByReference();
                Object object = this.ExecMethod(strObjectPathBSTR, strMethodNameBSTR, (int)var3_3, pCtx, inParams.getPointer(), ppOutParams, null);
                COMUtils.checkRC(object);
                object = new IWbemClassObject(ppOutParams.getValue());
                OleAuto.INSTANCE.SysFreeString(strObjectPathBSTR);
                OleAuto.INSTANCE.SysFreeString(strMethodNameBSTR);
                return object;
            }
            catch (Throwable throwable) {
                void var2_2;
                void var1_1;
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var1_1);
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var2_2);
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT ExecQuery(WTypes.BSTR strQueryLanguage, WTypes.BSTR strQuery, int lFlags, IWbemContext pCtx, PointerByReference ppEnum) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(20, new Object[]{this.getPointer(), var1_1, var2_2, (int)var3_3, pCtx, ppEnum}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public IEnumWbemClassObject ExecQuery(String strQueryLanguage, String strQuery, int lFlags, IWbemContext pCtx) {
            WTypes.BSTR strQueryLanguageBSTR = OleAuto.INSTANCE.SysAllocString(strQueryLanguage);
            WTypes.BSTR strQueryBSTR = OleAuto.INSTANCE.SysAllocString(strQuery);
            try {
                void var3_3;
                PointerByReference pbr = new PointerByReference();
                Object object = this.ExecQuery(strQueryLanguageBSTR, strQueryBSTR, (int)var3_3, pCtx, pbr);
                COMUtils.checkRC(object);
                object = new IEnumWbemClassObject(pbr.getValue());
                OleAuto.INSTANCE.SysFreeString(strQueryLanguageBSTR);
                OleAuto.INSTANCE.SysFreeString(strQueryBSTR);
                return object;
            }
            catch (Throwable throwable) {
                void var2_2;
                void var1_1;
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var1_1);
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var2_2);
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT GetObject(WTypes.BSTR strObjectPath, int lFlags, IWbemContext pCtx, PointerByReference ppObject, PointerByReference ppCallResult) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(6, new Object[]{this.getPointer(), var1_1, (int)var2_2, var3_3, ppObject, ppCallResult}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public IWbemClassObject GetObject(String strObjectPath, int lFlags, IWbemContext pCtx) {
            WTypes.BSTR strObjectPathBSTR = OleAuto.INSTANCE.SysAllocString(strObjectPath);
            try {
                void var3_5;
                void var2_2;
                PointerByReference ppObject = new PointerByReference();
                Object object = this.GetObject(strObjectPathBSTR, (int)var2_2, (IWbemContext)var3_5, ppObject, null);
                COMUtils.checkRC(object);
                object = new IWbemClassObject(ppObject.getValue());
                OleAuto.INSTANCE.SysFreeString(strObjectPathBSTR);
                return object;
            }
            catch (Throwable throwable) {
                void var1_1;
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var1_1);
                throw throwable;
            }
        }
    }

    public static class IWbemLocator
    extends Unknown {
        public static final Guid.CLSID CLSID_WbemLocator = new Guid.CLSID("4590f811-1d3a-11d0-891f-00aa004b2e24");
        public static final Guid.GUID IID_IWbemLocator = new Guid.GUID("dc12a687-737f-11cf-884d-00aa004b2e24");

        public IWbemLocator() {
        }

        /*
         * WARNING - void declaration
         */
        private IWbemLocator(Pointer pvInstance) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static IWbemLocator create() {
            void var0;
            PointerByReference pbr = new PointerByReference();
            WinNT.HRESULT hRESULT = Ole32.INSTANCE.CoCreateInstance(CLSID_WbemLocator, null, 1, IID_IWbemLocator, pbr);
            if (COMUtils.FAILED(hRESULT)) {
                return null;
            }
            return new IWbemLocator(var0.getValue());
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT ConnectServer(WTypes.BSTR strNetworkResource, WTypes.BSTR strUser, WTypes.BSTR strPassword, WTypes.BSTR strLocale, int lSecurityFlags, WTypes.BSTR strAuthority, IWbemContext pCtx, PointerByReference ppNamespace) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(3, new Object[]{this.getPointer(), var1_1, var2_2, var3_3, strLocale, lSecurityFlags, strAuthority, pCtx, ppNamespace}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public IWbemServices ConnectServer(String strNetworkResource, String strUser, String strPassword, String strLocale, int lSecurityFlags, String strAuthority, IWbemContext pCtx) {
            WTypes.BSTR strNetworkResourceBSTR = OleAuto.INSTANCE.SysAllocString(strNetworkResource);
            WTypes.BSTR strUserBSTR = OleAuto.INSTANCE.SysAllocString(strUser);
            WTypes.BSTR strPasswordBSTR = OleAuto.INSTANCE.SysAllocString(strPassword);
            WTypes.BSTR strLocaleBSTR = OleAuto.INSTANCE.SysAllocString(strLocale);
            WTypes.BSTR strAuthorityBSTR = OleAuto.INSTANCE.SysAllocString(strAuthority);
            PointerByReference pbr = new PointerByReference();
            try {
                Object object = this.ConnectServer(strNetworkResourceBSTR, strUserBSTR, strPasswordBSTR, strLocaleBSTR, lSecurityFlags, strAuthorityBSTR, pCtx, pbr);
                COMUtils.checkRC(object);
                object = new IWbemServices(pbr.getValue());
                OleAuto.INSTANCE.SysFreeString(strNetworkResourceBSTR);
                OleAuto.INSTANCE.SysFreeString(strUserBSTR);
                OleAuto.INSTANCE.SysFreeString(strPasswordBSTR);
                OleAuto.INSTANCE.SysFreeString(strLocaleBSTR);
                OleAuto.INSTANCE.SysFreeString(strAuthorityBSTR);
                return object;
            }
            catch (Throwable throwable) {
                void var3_3;
                void var2_2;
                void var1_1;
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var1_1);
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var2_2);
                OleAuto.INSTANCE.SysFreeString((WTypes.BSTR)var3_3);
                OleAuto.INSTANCE.SysFreeString(strLocaleBSTR);
                OleAuto.INSTANCE.SysFreeString(strAuthorityBSTR);
                throw throwable;
            }
        }
    }

    public static class IEnumWbemClassObject
    extends Unknown {
        public IEnumWbemClassObject() {
        }

        /*
         * WARNING - void declaration
         */
        public IEnumWbemClassObject(Pointer pvInstance) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT Next(int lTimeOut, int uCount, Pointer[] ppObjects, IntByReference puReturned) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(4, new Object[]{this.getPointer(), (int)var1_1, (int)var2_2, var3_3, puReturned}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public IWbemClassObject[] Next(int lTimeOut2, int uCount) {
            void var1_2;
            Pointer[] resultArray = new Pointer[uCount];
            IntByReference resultCount = new IntByReference();
            WinNT.HRESULT lTimeOut2 = this.Next(lTimeOut2, uCount, resultArray, resultCount);
            COMUtils.checkRC(lTimeOut2);
            IWbemClassObject[] returnValue = new IWbemClassObject[resultCount.getValue()];
            for (int i = 0; i < resultCount.getValue(); ++i) {
                returnValue[i] = new IWbemClassObject(resultArray[i]);
            }
            return var1_2;
        }
    }

    public static class IWbemClassObject
    extends Unknown {
        public IWbemClassObject() {
        }

        /*
         * WARNING - void declaration
         */
        public IWbemClassObject(Pointer pvInstance) {
            super((Pointer)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT Get(WString wszName, int lFlags, Variant.VARIANT.ByReference pVal, IntByReference pType, IntByReference plFlavor) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(4, new Object[]{this.getPointer(), var1_1, (int)var2_2, var3_3, pType, plFlavor}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT Get(String wszName, int lFlags, Variant.VARIANT.ByReference pVal, IntByReference pType, IntByReference plFlavor) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.Get(wszName == null ? null : new WString((String)var1_1), (int)var2_2, (Variant.VARIANT.ByReference)var3_3, pType, plFlavor);
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT GetMethod(String wszName, int lFlags, PointerByReference ppInSignature, PointerByReference ppOutSignature) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.GetMethod(wszName == null ? null : new WString((String)var1_1), (int)var2_2, (PointerByReference)var3_3, ppOutSignature);
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT GetMethod(WString wszName, int lFlags, PointerByReference ppInSignature, PointerByReference ppOutSignature) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(19, new Object[]{this.getPointer(), var1_1, (int)var2_2, var3_3, ppOutSignature}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public IWbemClassObject GetMethod(String wszName) {
            void var2_2;
            WinNT.HRESULT hRESULT;
            PointerByReference ppInSignature = new PointerByReference();
            hRESULT = this.GetMethod((String)((Object)hRESULT), 0, ppInSignature, null);
            COMUtils.checkRC(hRESULT);
            return new IWbemClassObject(var2_2.getValue());
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT GetNames(String wszQualifierName, int lFlags, Variant.VARIANT.ByReference pQualifierVal, PointerByReference pNames) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.GetNames(wszQualifierName == null ? null : new WString((String)var1_1), (int)var2_2, (Variant.VARIANT.ByReference)var3_3, pNames);
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT GetNames(WString wszQualifierName, int lFlags, Variant.VARIANT.ByReference pQualifierVal, PointerByReference pNames) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(7, new Object[]{this.getPointer(), var1_1, (int)var2_2, var3_3, pNames}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public String[] GetNames(String wszQualifierName, int lFlags, Variant.VARIANT.ByReference pQualifierVal) {
            void var2_3;
            PointerByReference pbr = new PointerByReference();
            COMUtils.checkRC(this.GetNames(wszQualifierName, lFlags, pQualifierVal, pbr));
            Object[] nameObjects = (Object[])OaIdlUtil.toPrimitiveArray(new OaIdl.SAFEARRAY(pbr.getValue()), true);
            String[] names = new String[nameObjects.length];
            for (int i = 0; i < nameObjects.length; ++i) {
                names[i] = (String)nameObjects[i];
            }
            return var2_3;
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT GetQualifierSet(PointerByReference ppQualSet) {
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(3, new Object[]{this.getPointer(), var1_1}, WinNT.HRESULT.class));
        }

        public IWbemQualifierSet GetQualifierSet() {
            IWbemQualifierSet iWbemQualifierSet;
            PointerByReference ppQualSet = new PointerByReference();
            WinNT.HRESULT hRESULT = this.GetQualifierSet(ppQualSet);
            COMUtils.checkRC(hRESULT);
            iWbemQualifierSet = new IWbemQualifierSet(iWbemQualifierSet.getValue());
            return iWbemQualifierSet;
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT GetPropertyQualifierSet(WString wszProperty, PointerByReference ppQualSet) {
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(11, new Object[]{this.getPointer(), var1_1, var2_2}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public IWbemQualifierSet GetPropertyQualifierSet(String strProperty) {
            void var2_2;
            IWbemQualifierSet iWbemQualifierSet;
            WString wszProperty = new WString(strProperty);
            PointerByReference ppQualSet = new PointerByReference();
            COMUtils.checkRC(this.GetPropertyQualifierSet((WString)iWbemQualifierSet, ppQualSet));
            iWbemQualifierSet = new IWbemQualifierSet(var2_2.getValue());
            return iWbemQualifierSet;
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT Put(String wszName, int lFlags, Variant.VARIANT pVal, int Type2) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.Put(wszName == null ? null : new WString((String)var1_1), (int)var2_2, (Variant.VARIANT)var3_3, Type2);
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT Put(WString wszName, int lFlags, Variant.VARIANT pVal, int Type2) {
            void var3_3;
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(5, new Object[]{this.getPointer(), var1_1, (int)var2_2, var3_3, Type2}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public void Put(String wszName, String pValue) {
            Variant.VARIANT aVariant = new Variant.VARIANT();
            WTypes.BSTR strValue = OleAuto.INSTANCE.SysAllocString(pValue);
            try {
                WinNT.HRESULT hRESULT;
                void var2_3;
                aVariant.setValue(8, (Object)var2_3);
                hRESULT = this.Put((String)((Object)hRESULT), 0, aVariant, 0);
                COMUtils.checkRC(hRESULT);
                OleAuto.INSTANCE.VariantClear(aVariant);
            }
            catch (Throwable throwable) {
                void var3_4;
                OleAuto.INSTANCE.VariantClear((Variant.VARIANT)var3_4);
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        public WinNT.HRESULT SpawnInstance(int lFlags, PointerByReference ppNewInstance) {
            void var2_2;
            void var1_1;
            return (WinNT.HRESULT)((Object)this._invokeNativeObject(15, new Object[]{this.getPointer(), (int)var1_1, var2_2}, WinNT.HRESULT.class));
        }

        /*
         * WARNING - void declaration
         */
        public IWbemClassObject SpawnInstance() {
            void var1_1;
            PointerByReference ppNewInstance = new PointerByReference();
            WinNT.HRESULT hRESULT = this.SpawnInstance(0, ppNewInstance);
            COMUtils.checkRC(hRESULT);
            return new IWbemClassObject(var1_1.getValue());
        }
    }

    public static interface WBEM_CONDITION_FLAG_TYPE {
        public static final int WBEM_FLAG_ALWAYS = 0;
        public static final int WBEM_FLAG_ONLY_IF_TRUE = 1;
        public static final int WBEM_FLAG_ONLY_IF_FALSE = 2;
        public static final int WBEM_FLAG_ONLY_IF_IDENTICAL = 3;
        public static final int WBEM_MASK_PRIMARY_CONDITION = 3;
        public static final int WBEM_FLAG_KEYS_ONLY = 4;
        public static final int WBEM_FLAG_REFS_ONLY = 8;
        public static final int WBEM_FLAG_LOCAL_ONLY = 16;
        public static final int WBEM_FLAG_PROPAGATED_ONLY = 32;
        public static final int WBEM_FLAG_SYSTEM_ONLY = 48;
        public static final int WBEM_FLAG_NONSYSTEM_ONLY = 64;
        public static final int WBEM_MASK_CONDITION_ORIGIN = 112;
        public static final int WBEM_FLAG_CLASS_OVERRIDES_ONLY = 256;
        public static final int WBEM_FLAG_CLASS_LOCAL_AND_OVERRIDES = 512;
        public static final int WBEM_MASK_CLASS_CONDITION = 768;
    }
}

