/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.linux;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.linux.XAttr;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;

public abstract class XAttrUtil {
    private XAttrUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static void setXAttr(String path, String name, String value) throws IOException {
        void var2_2;
        void var1_1;
        XAttrUtil.setXAttr(path, (String)var1_1, (String)var2_2, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static void setXAttr(String path, String name, String value, String encoding) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        XAttrUtil.setXAttr(path, (String)var1_1, var2_2.getBytes((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void setXAttr(String path2, String name, byte[] value) throws IOException {
        void var2_3;
        void var1_2;
        int path2 = XAttr.INSTANCE.setxattr(path2, (String)var1_2, value, new XAttr.size_t(((void)var2_3).length), 0);
        if (path2 != 0) {
            void var0_1;
            int eno = Native.getLastError();
            throw new IOException("errno: " + (int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void lSetXAttr(String path, String name, String value) throws IOException {
        void var2_2;
        void var1_1;
        XAttrUtil.lSetXAttr(path, (String)var1_1, (String)var2_2, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static void lSetXAttr(String path, String name, String value, String encoding) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        XAttrUtil.lSetXAttr(path, (String)var1_1, var2_2.getBytes((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void lSetXAttr(String path2, String name, byte[] value) throws IOException {
        void var2_3;
        void var1_2;
        int path2 = XAttr.INSTANCE.lsetxattr(path2, (String)var1_2, value, new XAttr.size_t(((void)var2_3).length), 0);
        if (path2 != 0) {
            void var0_1;
            int eno = Native.getLastError();
            throw new IOException("errno: " + (int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void fSetXAttr(int fd, String name, String value) throws IOException {
        void var2_2;
        void var1_1;
        XAttrUtil.fSetXAttr(fd, (String)var1_1, (String)var2_2, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static void fSetXAttr(int fd, String name, String value, String encoding) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        XAttrUtil.fSetXAttr(fd, (String)var1_1, var2_2.getBytes((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static void fSetXAttr(int fd, String name, byte[] value) throws IOException {
        void var2_2;
        void var1_1;
        if ((fd = XAttr.INSTANCE.fsetxattr(fd, (String)var1_1, value, new XAttr.size_t(((void)var2_2).length), 0)) != 0) {
            int n;
            int eno = Native.getLastError();
            throw new IOException("errno: " + n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getXAttr(String path, String name) throws IOException {
        void var1_1;
        return XAttrUtil.getXAttr(path, (String)var1_1, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static String getXAttr(String path, String name, String encoding) throws IOException {
        void var2_2;
        Object object;
        void var1_1;
        Object valueMem = XAttrUtil.getXAttrBytes(path, (String)var1_1);
        return new String((byte[])object, Charset.forName((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getXAttrBytes(String path, String name) throws IOException {
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.getxattr(path, name, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            byte[] valueMem = new byte[retval.intValue()];
            if ((retval = XAttr.INSTANCE.getxattr(path, name, valueMem, new XAttr.size_t(valueMem.length))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static Memory getXAttrAsMemory(String path, String name) throws IOException {
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.getxattr(path, name, (Pointer)null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            if (retval.longValue() == 0L) {
                return null;
            }
            Memory valueMem = new Memory(retval.longValue());
            if ((retval = XAttr.INSTANCE.getxattr(path, name, (Pointer)valueMem, new XAttr.size_t(valueMem.size()))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static String lGetXAttr(String path, String name) throws IOException {
        void var1_1;
        return XAttrUtil.lGetXAttr(path, (String)var1_1, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static String lGetXAttr(String path, String name, String encoding) throws IOException {
        void var2_2;
        Object object;
        void var1_1;
        Object valueMem = XAttrUtil.lGetXAttrBytes(path, (String)var1_1);
        return new String((byte[])object, Charset.forName((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] lGetXAttrBytes(String path, String name) throws IOException {
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.lgetxattr(path, name, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            byte[] valueMem = new byte[retval.intValue()];
            if ((retval = XAttr.INSTANCE.lgetxattr(path, name, valueMem, new XAttr.size_t(valueMem.length))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static Memory lGetXAttrAsMemory(String path, String name) throws IOException {
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.lgetxattr(path, name, (Pointer)null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            if (retval.longValue() == 0L) {
                return null;
            }
            Memory valueMem = new Memory(retval.longValue());
            if ((retval = XAttr.INSTANCE.lgetxattr(path, name, (Pointer)valueMem, new XAttr.size_t(valueMem.size()))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static String fGetXAttr(int fd, String name) throws IOException {
        void var1_1;
        return XAttrUtil.fGetXAttr(fd, (String)var1_1, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static String fGetXAttr(int fd, String name, String encoding) throws IOException {
        void var2_3;
        void var0_1;
        void var1_2;
        byte[] valueMem = XAttrUtil.fGetXAttrBytes(fd, (String)var1_2);
        return new String((byte[])var0_1, Charset.forName((String)var2_3));
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] fGetXAttrBytes(int fd, String name) throws IOException {
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.fgetxattr(fd, name, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            byte[] valueMem = new byte[retval.intValue()];
            if ((retval = XAttr.INSTANCE.fgetxattr(fd, name, valueMem, new XAttr.size_t(valueMem.length))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public static Memory fGetXAttrAsMemory(int fd, String name) throws IOException {
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.fgetxattr(fd, name, (Pointer)null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            if (retval.longValue() == 0L) {
                return null;
            }
            Memory valueMem = new Memory(retval.longValue());
            if ((retval = XAttr.INSTANCE.fgetxattr(fd, name, (Pointer)valueMem, new XAttr.size_t(valueMem.size()))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return var3_4;
    }

    public static Collection<String> listXAttr(String path) throws IOException {
        return XAttrUtil.listXAttr(path, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<String> listXAttr(String path, String encoding) throws IOException {
        void var1_1;
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.listxattr(path, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            byte[] listMem = new byte[retval.intValue()];
            if ((retval = XAttr.INSTANCE.listxattr(path, listMem, new XAttr.size_t(listMem.length))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return XAttrUtil.splitBufferToStrings((byte[])var3_4, (String)var1_1);
    }

    public static Collection<String> lListXAttr(String path) throws IOException {
        return XAttrUtil.lListXAttr(path, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<String> lListXAttr(String path, String encoding) throws IOException {
        void var1_1;
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.llistxattr(path, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            byte[] listMem = new byte[retval.intValue()];
            if ((retval = XAttr.INSTANCE.llistxattr(path, listMem, new XAttr.size_t(listMem.length))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return XAttrUtil.splitBufferToStrings((byte[])var3_4, (String)var1_1);
    }

    public static Collection<String> fListXAttr(int fd) throws IOException {
        return XAttrUtil.fListXAttr(fd, Native.getDefaultStringEncoding());
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<String> fListXAttr(int fd, String encoding) throws IOException {
        void var1_1;
        void var3_4;
        void var2_3;
        int eno = 0;
        do {
            XAttr.ssize_t retval;
            if ((retval = XAttr.INSTANCE.flistxattr(fd, (byte[])null, XAttr.size_t.ZERO)).longValue() < 0L) {
                eno = Native.getLastError();
                throw new IOException("errno: " + eno);
            }
            byte[] listMem = new byte[retval.intValue()];
            if ((retval = XAttr.INSTANCE.flistxattr(fd, listMem, new XAttr.size_t(listMem.length))).longValue() >= 0L || (eno = Native.getLastError()) == 34) continue;
            throw new IOException("errno: " + eno);
        } while (var2_3.longValue() < 0L && eno == 34);
        return XAttrUtil.splitBufferToStrings((byte[])var3_4, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void removeXAttr(String path2, String name) throws IOException {
        void var1_2;
        int path2 = XAttr.INSTANCE.removexattr(path2, (String)var1_2);
        if (path2 != 0) {
            void var0_1;
            int eno = Native.getLastError();
            throw new IOException("errno: " + (int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void lRemoveXAttr(String path2, String name) throws IOException {
        void var1_2;
        int path2 = XAttr.INSTANCE.lremovexattr(path2, (String)var1_2);
        if (path2 != 0) {
            void var0_1;
            int eno = Native.getLastError();
            throw new IOException("errno: " + (int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void fRemoveXAttr(int fd, String name) throws IOException {
        void var1_1;
        if ((fd = XAttr.INSTANCE.fremovexattr(fd, (String)var1_1)) != 0) {
            int n;
            int eno = Native.getLastError();
            throw new IOException("errno: " + n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Collection<String> splitBufferToStrings(byte[] valueMem, String encoding) throws IOException {
        void var2_2;
        Charset charset = Charset.forName(encoding);
        LinkedHashSet<void> attributesList = new LinkedHashSet<void>(1);
        int offset = 0;
        for (int i = 0; i < valueMem.length; ++i) {
            void var3_4;
            if (valueMem[i] != 0) continue;
            String name = new String(valueMem, offset, i - offset, charset);
            attributesList.add(var3_4);
            int n = i + 1;
        }
        return var2_2;
    }
}

