/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.util.datetime.Format;

abstract class FormatCache<F extends Format> {
    static final int NONE = -1;
    private final ConcurrentMap<MultipartKey, F> cInstanceCache = new ConcurrentHashMap<MultipartKey, F>(7);
    private static final ConcurrentMap<MultipartKey, String> cDateTimeInstanceCache = new ConcurrentHashMap<MultipartKey, String>(7);

    FormatCache() {
    }

    public F getInstance() {
        return this.getDateTimeInstance(3, 3, TimeZone.getDefault(), Locale.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public F getInstance(String pattern, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        Format previousValue;
        MultipartKey key;
        Format format;
        if (pattern == null) {
            throw new NullPointerException("pattern must not be null");
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((format = (Format)this.cInstanceCache.get(key = new MultipartKey(pattern, timeZone, locale))) == null && (previousValue = this.cInstanceCache.putIfAbsent(key, format = this.createInstance(pattern, (TimeZone)var2_2, (Locale)var3_3))) != null) {
            void var1_1;
            format = var1_1;
        }
        return (F)format;
    }

    protected abstract F createInstance(String var1, TimeZone var2, Locale var3);

    /*
     * WARNING - void declaration
     */
    private F getDateTimeInstance(Integer dateStyle, Integer timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var1_1;
        void var2_2;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String pattern = FormatCache.getPatternForStyle(dateStyle, (Integer)var2_2, locale);
        return this.getInstance((String)var1_1, (TimeZone)var3_3, locale);
    }

    /*
     * WARNING - void declaration
     */
    F getDateTimeInstance(int dateStyle, int timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance((Integer)((int)var1_1), (Integer)((int)var2_2), (TimeZone)var3_3, locale);
    }

    /*
     * WARNING - void declaration
     */
    F getDateInstance(int dateStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance((Integer)((int)var1_1), null, (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    F getTimeInstance(int timeStyle, TimeZone timeZone, Locale locale) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDateTimeInstance(null, (Integer)((int)var1_1), (TimeZone)var2_2, (Locale)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static String getPatternForStyle(Integer dateStyle, Integer timeStyle, Locale locale) {
        MultipartKey key = new MultipartKey(dateStyle, timeStyle, locale);
        Object pattern = (String)cDateTimeInstanceCache.get(key);
        if (pattern == null) {
            try {
                void var3_3;
                void var1_1;
                String formatter;
                formatter = dateStyle == null ? DateFormat.getTimeInstance(timeStyle, locale) : (timeStyle == null ? DateFormat.getDateInstance((Integer)((Object)formatter), locale) : DateFormat.getDateTimeInstance((Integer)((Object)formatter), var1_1.intValue(), locale));
                pattern = ((SimpleDateFormat)((Object)formatter)).toPattern();
                String previous = cDateTimeInstanceCache.putIfAbsent((MultipartKey)var3_3, (String)pattern);
                if (previous != null) {
                    String string;
                    pattern = string;
                }
            }
            catch (ClassCastException classCastException) {
                void var2_2;
                throw new IllegalArgumentException("No date time pattern for locale: " + var2_2);
            }
        }
        return pattern;
    }

    private static class MultipartKey {
        private final Object[] keys;
        private int hashCode;

        /*
         * WARNING - void declaration
         */
        public MultipartKey(Object ... keys) {
            void var1_1;
            this.keys = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            return Arrays.equals(this.keys, ((MultipartKey)var1_1).keys);
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            if (this.hashCode == 0) {
                void var1_1;
                int rc = 0;
                Object[] objectArray = this.keys;
                int n = this.keys.length;
                for (int i = 0; i < n; ++i) {
                    Object key = objectArray[i];
                    if (key == null) continue;
                    rc = rc * 7 + key.hashCode();
                }
                this.hashCode = var1_1;
            }
            return this.hashCode;
        }
    }
}

