/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

public class FixedDateFormat {
    private static final char NONE = '\u0000';
    private final FixedFormat fixedFormat;
    private final TimeZone timeZone;
    private final int length;
    private final int secondFractionDigits;
    private final FastDateFormat fastDateFormat;
    private final char timeSeparatorChar;
    private final char millisSeparatorChar;
    private final int timeSeparatorLength;
    private final int millisSeparatorLength;
    private final FixedTimeZoneFormat fixedTimeZoneFormat;
    private volatile long midnightToday;
    private volatile long midnightTomorrow;
    private final int[] dstOffsets = new int[25];
    private char[] cachedDate;
    private int dateLength;
    static int[] TABLE = new int[]{100000, 10000, 1000, 100, 10, 1};

    /*
     * WARNING - void declaration
     */
    FixedDateFormat(FixedFormat fixedFormat, TimeZone tz) {
        this(fixedFormat, (TimeZone)var2_2, var1_1.getSecondFractionDigits());
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    FixedDateFormat(FixedFormat fixedFormat, TimeZone tz, int secondFractionDigits) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.fixedFormat = Objects.requireNonNull(fixedFormat);
        this.timeZone = Objects.requireNonNull(tz);
        this.timeSeparatorChar = fixedFormat.timeSeparatorChar;
        this.timeSeparatorLength = fixedFormat.timeSeparatorLength;
        this.millisSeparatorChar = fixedFormat.millisSeparatorChar;
        this.millisSeparatorLength = fixedFormat.millisSeparatorLength;
        this.fixedTimeZoneFormat = fixedFormat.fixedTimeZoneFormat;
        this.length = fixedFormat.getLength();
        this.secondFractionDigits = Math.max(1, Math.min(9, (int)var3_3));
        this.fastDateFormat = var1_1.getFastDateFormat((TimeZone)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static FixedDateFormat createIfSupported(String ... options) {
        void var1_6;
        void var0_5;
        void secondFractionDigits22;
        if (options == null || options.length == 0 || options[0] == null) {
            return new FixedDateFormat(FixedFormat.DEFAULT, TimeZone.getDefault());
        }
        TimeZone tz = options.length > 1 ? (options[1] != null ? TimeZone.getTimeZone(options[1]) : TimeZone.getDefault()) : TimeZone.getDefault();
        String option0 = options[0];
        FixedFormat withoutNanos = FixedFormat.lookupIgnoringNanos(option0);
        if (withoutNanos != null) {
            void var2_7;
            void var3_8;
            int[] nanoRange232 = FixedFormat.nanoRange(option0);
            int nanoStart = nanoRange232[0];
            int secondFractionDigits22 = nanoRange232[1];
            secondFractionDigits22 = secondFractionDigits22 - var3_8;
            return new FixedDateFormat((FixedFormat)var2_7, tz, secondFractionDigits22);
        }
        FixedFormat type = FixedFormat.lookup((String)secondFractionDigits22);
        if (type == null) {
            return null;
        }
        return new FixedDateFormat((FixedFormat)var0_5, (TimeZone)var1_6);
    }

    public static FixedDateFormat create(FixedFormat format) {
        FixedFormat fixedFormat;
        return new FixedDateFormat(fixedFormat, TimeZone.getDefault());
    }

    /*
     * WARNING - void declaration
     */
    public static FixedDateFormat create(FixedFormat format, TimeZone tz) {
        void var1_1;
        FixedFormat fixedFormat;
        return new FixedDateFormat(fixedFormat, (TimeZone)(tz != null ? var1_1 : TimeZone.getDefault()));
    }

    public String getFormat() {
        return this.fixedFormat.getPattern();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    /*
     * WARNING - void declaration
     */
    public long millisSinceMidnight(long currentTime) {
        void var1_1;
        if (currentTime >= this.midnightTomorrow || currentTime < this.midnightToday) {
            this.updateMidnightMillis(currentTime);
        }
        return (long)(var1_1 - this.midnightToday);
    }

    /*
     * WARNING - void declaration
     */
    private void updateMidnightMillis(long now) {
        if (now >= this.midnightTomorrow || now < this.midnightToday) {
            FixedDateFormat fixedDateFormat = this;
            synchronized (fixedDateFormat) {
                void var1_1;
                this.updateCachedDate(now);
                this.midnightToday = this.calcMidnightMillis(now, 0);
                this.midnightTomorrow = this.calcMidnightMillis((long)var1_1, 1);
                this.updateDaylightSavingTime();
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private long calcMidnightMillis(long time, int addDays) {
        void var3_2;
        void var1_1;
        Calendar cal = Calendar.getInstance(this.timeZone);
        cal.setTimeInMillis((long)var1_1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, (int)var3_2);
        return cal.getTimeInMillis();
    }

    /*
     * WARNING - void declaration
     */
    private void updateDaylightSavingTime() {
        Arrays.fill(this.dstOffsets, 0);
        int ONE_HOUR = (int)TimeUnit.HOURS.toMillis(1L);
        if (this.timeZone.getOffset(this.midnightToday) != this.timeZone.getOffset(this.midnightToday + (long)(ONE_HOUR * 23))) {
            int i;
            for (i = 0; i < this.dstOffsets.length; ++i) {
                void var3_3;
                long time = this.midnightToday + (long)(i * ONE_HOUR);
                this.dstOffsets[i] = this.timeZone.getOffset((long)var3_3) - this.timeZone.getRawOffset();
            }
            if (this.dstOffsets[0] > this.dstOffsets[23]) {
                i = this.dstOffsets.length - 1;
                while (i >= 0) {
                    int n = i--;
                    this.dstOffsets[n] = this.dstOffsets[n] - this.dstOffsets[0];
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateCachedDate(long now) {
        if (this.fastDateFormat != null) {
            void var1_2;
            StringBuilder result = this.fastDateFormat.format(now, new StringBuilder());
            this.cachedDate = result.toString().toCharArray();
            this.dateLength = var1_2.length();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String formatInstant(Instant instant) {
        void var1_2;
        void var2_3;
        char[] result = new char[this.length << 1];
        int written = this.formatInstant(instant, result, 0);
        return new String((char[])var2_3, 0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public int formatInstant(Instant instant, char[] buffer, int startPos) {
        void var1_2;
        void var2_3;
        void var3_4;
        long epochMillisecond = instant.getEpochMillisecond();
        int n = this.format(epochMillisecond, buffer, startPos);
        int result = n - this.digitsLessThanThree();
        int pos = this.formatNanoOfMillisecond(instant.getNanoOfMillisecond(), buffer, (int)(var3_4 + result));
        return this.writeTimeZone(epochMillisecond, (char[])var2_3, (int)var1_2);
    }

    private int digitsLessThanThree() {
        return Math.max(0, FixedFormat.MILLI_FRACTION_DIGITS - this.secondFractionDigits);
    }

    /*
     * WARNING - void declaration
     */
    public String format(long epochMillis) {
        void var1_2;
        void var3_3;
        char[] result = new char[this.length << 1];
        int written = this.format(epochMillis, result, 0);
        return new String((char[])var3_3, 0, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public int format(long epochMillis, char[] buffer, int startPos) {
        void var3_3;
        int n;
        int ms = (int)this.millisSinceMidnight(epochMillis);
        this.writeDate(buffer, startPos);
        n = this.writeTime(n, (char[])var3_3, startPos + this.dateLength);
        return n - startPos;
    }

    /*
     * WARNING - void declaration
     */
    private void writeDate(char[] buffer, int startPos) {
        if (this.cachedDate != null) {
            void var2_2;
            void var1_1;
            System.arraycopy(this.cachedDate, 0, var1_1, (int)var2_2, this.dateLength);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int writeTime(int ms, char[] buffer, int pos) {
        void var3_3;
        void var1_1;
        int hourOfDay = ms / 3600000;
        int hours = hourOfDay + this.daylightSavingTime(hourOfDay) / 3600000;
        int minutes = (ms -= hourOfDay * 3600000) / 60000;
        int seconds = (ms -= minutes * 60000) / 1000;
        ms -= seconds * 1000;
        int temp = hours / 10;
        buffer[pos++] = (char)(temp + 48);
        buffer[pos++] = (char)(hours - temp * 10 + 48);
        buffer[pos] = this.timeSeparatorChar;
        pos += this.timeSeparatorLength;
        temp = minutes / 10;
        buffer[pos++] = (char)(temp + 48);
        buffer[pos++] = (char)(minutes - temp * 10 + 48);
        buffer[pos] = this.timeSeparatorChar;
        pos += this.timeSeparatorLength;
        temp = seconds / 10;
        buffer[pos++] = (char)(temp + 48);
        buffer[pos++] = (char)(seconds - temp * 10 + 48);
        buffer[pos] = this.millisSeparatorChar;
        pos += this.millisSeparatorLength;
        temp = ms / 100;
        buffer[pos++] = (char)(temp + 48);
        ms -= temp * 100;
        temp = ms / 10;
        buffer[pos++] = (char)(temp + 48);
        ms -= temp * 10;
        var2_2[pos++] = (char)(var1_1 + 48);
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int writeTimeZone(long epochMillis, char[] buffer, int pos) {
        if (this.fixedTimeZoneFormat != null) {
            void var3_2;
            void var1_1;
            pos = FixedTimeZoneFormat.access$700(this.fixedTimeZoneFormat, this.timeZone.getOffset((long)var1_1), (char[])var3_2, pos);
        }
        return pos;
    }

    /*
     * WARNING - void declaration
     */
    private int formatNanoOfMillisecond(int nanoOfMillisecond, char[] buffer, int pos) {
        void var3_3;
        int remain = nanoOfMillisecond;
        for (int i = 0; i < this.secondFractionDigits - FixedFormat.MILLI_FRACTION_DIGITS; ++i) {
            void var1_1;
            int divisor = TABLE[i];
            int temp = remain / divisor;
            buffer[pos++] = (char)(temp + 48);
            remain -= divisor * var1_1;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private int daylightSavingTime(int hourOfDay) {
        void var1_1;
        if (hourOfDay > 23) {
            return this.dstOffsets[23];
        }
        return this.dstOffsets[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEquivalent(long oldEpochSecond, int oldNanoOfSecond, long epochSecond, int nanoOfSecond) {
        if (oldEpochSecond == epochSecond) {
            void var3_2;
            if (this.secondFractionDigits <= 3) {
                return (long)oldNanoOfSecond / 1000000L == (long)nanoOfSecond / 1000000L;
            }
            return var3_2 == nanoOfSecond;
        }
        return false;
    }

    public static enum FixedTimeZoneFormat {
        HH('\u0000', false, 3),
        HHMM('\u0000', true, 5),
        HHCMM(':', true, 6);

        private final char timeSeparatorChar;
        private final int timeSeparatorCharLen;
        private final boolean useMinutes;
        private final int length;

        private FixedTimeZoneFormat() {
            this('\u0000', true, 4);
        }

        /*
         * WARNING - void declaration
         */
        private FixedTimeZoneFormat(char timeSeparatorChar, boolean minutes, int length) {
            void var3_3;
            this.timeSeparatorChar = timeSeparatorChar;
            this.timeSeparatorCharLen = var3_3 != false ? 1 : 0;
            this.useMinutes = minutes;
            this.length = length;
        }

        public final int getLength() {
            return this.length;
        }

        /*
         * WARNING - void declaration
         */
        private int write(int offset, char[] buffer, int pos) {
            void var3_3;
            buffer[pos++] = offset < 0 ? 45 : 43;
            int absOffset = Math.abs(offset);
            int hours = absOffset / 3600000;
            int ms = absOffset - hours * 3600000;
            int temp = hours / 10;
            buffer[pos++] = (char)(temp + 48);
            buffer[pos++] = (char)(hours - temp * 10 + 48);
            if (this.useMinutes) {
                void var1_1;
                buffer[pos] = this.timeSeparatorChar;
                pos += this.timeSeparatorCharLen;
                int minutes = ms / 60000;
                temp = minutes / 10;
                buffer[pos++] = (char)(temp + 48);
                var2_2[pos++] = (char)(var1_1 - temp * 10 + 48);
            }
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$700(FixedTimeZoneFormat x0, int x1, char[] x2, int x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            return x0.write((int)var1_1, (char[])var2_2, (int)var3_3);
        }
    }

    public static enum FixedFormat {
        ABSOLUTE("HH:mm:ss,SSS", null, 0, ':', 1, ',', 1, 3, null),
        ABSOLUTE_MICROS("HH:mm:ss,nnnnnn", null, 0, ':', 1, ',', 1, 6, null),
        ABSOLUTE_NANOS("HH:mm:ss,nnnnnnnnn", null, 0, ':', 1, ',', 1, 9, null),
        ABSOLUTE_PERIOD("HH:mm:ss.SSS", null, 0, ':', 1, '.', 1, 3, null),
        COMPACT("yyyyMMddHHmmssSSS", "yyyyMMdd", 0, ' ', 0, ' ', 0, 3, null),
        DATE("dd MMM yyyy HH:mm:ss,SSS", "dd MMM yyyy ", 0, ':', 1, ',', 1, 3, null),
        DATE_PERIOD("dd MMM yyyy HH:mm:ss.SSS", "dd MMM yyyy ", 0, ':', 1, '.', 1, 3, null),
        DEFAULT("yyyy-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 3, null),
        DEFAULT_MICROS("yyyy-MM-dd HH:mm:ss,nnnnnn", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 6, null),
        DEFAULT_NANOS("yyyy-MM-dd HH:mm:ss,nnnnnnnnn", "yyyy-MM-dd ", 0, ':', 1, ',', 1, 9, null),
        DEFAULT_PERIOD("yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd ", 0, ':', 1, '.', 1, 3, null),
        ISO8601_BASIC("yyyyMMdd'T'HHmmss,SSS", "yyyyMMdd'T'", 2, ' ', 0, ',', 1, 3, null),
        ISO8601_BASIC_PERIOD("yyyyMMdd'T'HHmmss.SSS", "yyyyMMdd'T'", 2, ' ', 0, '.', 1, 3, null),
        ISO8601("yyyy-MM-dd'T'HH:mm:ss,SSS", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, null),
        ISO8601_OFFSET_DATE_TIME_HH("yyyy-MM-dd'T'HH:mm:ss,SSSX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedTimeZoneFormat.HH),
        ISO8601_OFFSET_DATE_TIME_HHMM("yyyy-MM-dd'T'HH:mm:ss,SSSXX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedTimeZoneFormat.HHMM),
        ISO8601_OFFSET_DATE_TIME_HHCMM("yyyy-MM-dd'T'HH:mm:ss,SSSXXX", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1, 3, FixedTimeZoneFormat.HHCMM),
        ISO8601_PERIOD("yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'", 2, ':', 1, '.', 1, 3, null),
        ISO8601_PERIOD_MICROS("yyyy-MM-dd'T'HH:mm:ss.nnnnnn", "yyyy-MM-dd'T'", 2, ':', 1, '.', 1, 6, null),
        US_MONTH_DAY_YEAR2_TIME("dd/MM/yy HH:mm:ss.SSS", "dd/MM/yy ", 0, ':', 1, '.', 1, 3, null),
        US_MONTH_DAY_YEAR4_TIME("dd/MM/yyyy HH:mm:ss.SSS", "dd/MM/yyyy ", 0, ':', 1, '.', 1, 3, null);

        private static final String DEFAULT_SECOND_FRACTION_PATTERN = "SSS";
        private static final int MILLI_FRACTION_DIGITS;
        private static final char SECOND_FRACTION_PATTERN = 'n';
        private final String pattern;
        private final String datePattern;
        private final int escapeCount;
        private final char timeSeparatorChar;
        private final int timeSeparatorLength;
        private final char millisSeparatorChar;
        private final int millisSeparatorLength;
        private final int secondFractionDigits;
        private final FixedTimeZoneFormat fixedTimeZoneFormat;
        private static final int[] EMPTY_RANGE;

        /*
         * WARNING - void declaration
         */
        private FixedFormat(String pattern, String datePattern, int escapeCount, char timeSeparator, int timeSepLength, char millisSeparator, int millisSepLength, int secondFractionDigits, FixedTimeZoneFormat timeZoneFormat) {
            void var3_3;
            this.timeSeparatorChar = timeSeparator;
            this.timeSeparatorLength = timeSepLength;
            this.millisSeparatorChar = millisSeparator;
            this.millisSeparatorLength = millisSepLength;
            this.pattern = (String)Objects.requireNonNull(var3_3);
            this.datePattern = datePattern;
            this.escapeCount = escapeCount;
            this.secondFractionDigits = secondFractionDigits;
            this.fixedTimeZoneFormat = timeZoneFormat;
        }

        public final String getPattern() {
            return this.pattern;
        }

        public final String getDatePattern() {
            return this.datePattern;
        }

        public static FixedFormat lookup(String nameOrPattern) {
            for (FixedFormat type : FixedFormat.values()) {
                if (!type.name().equals(nameOrPattern) && !type.getPattern().equals(nameOrPattern)) continue;
                return type;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        static FixedFormat lookupIgnoringNanos(String pattern) {
            int[] nanoRange = FixedFormat.nanoRange(pattern);
            int nanoStart = nanoRange[0];
            int nanoEnd = nanoRange[1];
            if (nanoStart > 0) {
                void var1_2;
                int n;
                String subPattern = pattern.substring(0, n) + DEFAULT_SECOND_FRACTION_PATTERN + pattern.substring((int)var1_2, pattern.length());
                for (FixedFormat type : FixedFormat.values()) {
                    if (!type.getPattern().equals(subPattern)) continue;
                    return type;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private static int[] nanoRange(String pattern) {
            void var2_2;
            void var1_1;
            int indexStart = pattern.indexOf(110);
            int indexEnd = -1;
            if (indexStart >= 0) {
                indexEnd = pattern.indexOf(90, indexStart);
                indexEnd = indexEnd < 0 ? pattern.indexOf(88, indexStart) : indexEnd;
                indexEnd = indexEnd < 0 ? pattern.length() : indexEnd;
                for (int i = indexStart + 1; i < indexEnd; ++i) {
                    if (pattern.charAt(i) == 'n') continue;
                    return EMPTY_RANGE;
                }
            }
            return new int[]{var1_1, var2_2};
        }

        public final int getLength() {
            return this.pattern.length() - this.escapeCount;
        }

        public final int getDatePatternLength() {
            if (this.getDatePattern() == null) {
                return 0;
            }
            return this.getDatePattern().length() - this.escapeCount;
        }

        public final FastDateFormat getFastDateFormat() {
            return this.getFastDateFormat(null);
        }

        /*
         * WARNING - void declaration
         */
        public final FastDateFormat getFastDateFormat(TimeZone tz) {
            void var1_1;
            if (this.getDatePattern() == null) {
                return null;
            }
            return FastDateFormat.getInstance(this.getDatePattern(), (TimeZone)var1_1);
        }

        public final int getSecondFractionDigits() {
            return this.secondFractionDigits;
        }

        public final FixedTimeZoneFormat getFixedTimeZoneFormat() {
            return this.fixedTimeZoneFormat;
        }

        static {
            MILLI_FRACTION_DIGITS = 3;
            EMPTY_RANGE = new int[]{-1, -1};
        }
    }
}

