/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.datetime.DateParser;

public class FastDateParser
implements Serializable,
DateParser {
    private static final long serialVersionUID = 3L;
    static final Locale JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private final int century;
    private final int startYear;
    private transient List<StrategyAndWidth> patterns;
    private static final Comparator<String> LONGER_FIRST_LOWERCASE = (left, right) -> {
        String string;
        return right.compareTo(string);
    };
    private static final ConcurrentMap<Locale, Strategy>[] caches = new ConcurrentMap[17];
    private static final Strategy ABBREVIATED_YEAR_STRATEGY = new NumberStrategy(1){
        {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int modify(FastDateParser parser, int iValue) {
            void var2_2;
            if (iValue < 100) {
                void var1_1;
                return FastDateParser.access$700((FastDateParser)var1_1, iValue);
            }
            return (int)var2_2;
        }
    };
    private static final Strategy NUMBER_MONTH_STRATEGY = new NumberStrategy(2){
        {
            void var1_1;
        }

        @Override
        final int modify(FastDateParser parser, int iValue) {
            return iValue - 1;
        }
    };
    private static final Strategy LITERAL_YEAR_STRATEGY = new NumberStrategy(1);
    private static final Strategy WEEK_OF_YEAR_STRATEGY = new NumberStrategy(3);
    private static final Strategy WEEK_OF_MONTH_STRATEGY = new NumberStrategy(4);
    private static final Strategy DAY_OF_YEAR_STRATEGY = new NumberStrategy(6);
    private static final Strategy DAY_OF_MONTH_STRATEGY = new NumberStrategy(5);
    private static final Strategy DAY_OF_WEEK_STRATEGY = new NumberStrategy(7){
        {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int modify(FastDateParser parser, int iValue) {
            if (iValue != 7) {
                void var2_2;
                return (int)(var2_2 + true);
            }
            return 1;
        }
    };
    private static final Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY = new NumberStrategy(8);
    private static final Strategy HOUR_OF_DAY_STRATEGY = new NumberStrategy(11);
    private static final Strategy HOUR24_OF_DAY_STRATEGY = new NumberStrategy(11){
        {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int modify(FastDateParser parser, int iValue) {
            void var2_2;
            if (iValue == 24) {
                return 0;
            }
            return (int)var2_2;
        }
    };
    private static final Strategy HOUR12_STRATEGY = new NumberStrategy(10){
        {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int modify(FastDateParser parser, int iValue) {
            void var2_2;
            if (iValue == 12) {
                return 0;
            }
            return (int)var2_2;
        }
    };
    private static final Strategy HOUR_STRATEGY = new NumberStrategy(10);
    private static final Strategy MINUTE_STRATEGY = new NumberStrategy(12);
    private static final Strategy SECOND_STRATEGY = new NumberStrategy(13);
    private static final Strategy MILLISECOND_STRATEGY = new NumberStrategy(14);

    /*
     * WARNING - void declaration
     */
    protected FastDateParser(String pattern, TimeZone timeZone, Locale locale) {
        this((String)var1_1, (TimeZone)var2_2, (Locale)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected FastDateParser(String pattern, TimeZone timeZone, Locale locale, Date centuryStart) {
        void var1_1;
        void var2_3;
        void var3_4;
        int centuryStartYear;
        this.pattern = pattern;
        this.timeZone = timeZone;
        this.locale = locale;
        Calendar definingCalendar = Calendar.getInstance(timeZone, locale);
        if (centuryStart != null) {
            definingCalendar.setTime(centuryStart);
            centuryStartYear = definingCalendar.get(1);
        } else if (var3_4.equals(JAPANESE_IMPERIAL)) {
            centuryStartYear = 0;
        } else {
            definingCalendar.setTime(new Date());
            centuryStartYear = definingCalendar.get(1) - 80;
        }
        this.century = centuryStartYear / 100 * 100;
        this.startYear = var2_3 - this.century;
        this.init((Calendar)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void init(Calendar definingCalendar) {
        StrategyAndWidth field;
        this.patterns = new ArrayList<StrategyAndWidth>();
        StrategyParser fm = new StrategyParser(definingCalendar);
        while ((field = fm.getNextStrategy()) != null) {
            void var2_2;
            this.patterns.add((StrategyAndWidth)var2_2);
        }
    }

    private static boolean isFormatLetter(char c) {
        char c2;
        return c >= 'A' && c <= 'Z' || c >= 'a' && c2 <= 'z';
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (!(obj instanceof FastDateParser)) {
            return false;
        }
        FastDateParser other = (FastDateParser)obj;
        return this.pattern.equals(other.pattern) && this.timeZone.equals(other.timeZone) && this.locale.equals(var1_1.locale);
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    public String toString() {
        return "FastDateParser[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        void var1_1;
        in.defaultReadObject();
        Calendar definingCalendar = Calendar.getInstance(this.timeZone, this.locale);
        this.init((Calendar)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object parseObject(String source) throws ParseException {
        void var1_1;
        return this.parse((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Date parse(String source) throws ParseException {
        void var3_3;
        ParsePosition pp = new ParsePosition(0);
        Date date = this.parse(source, pp);
        if (date == null) {
            void var2_2;
            void var1_1;
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\nUnparseable date: \"" + source, pp.getErrorIndex());
            }
            throw new ParseException("Unparseable date: " + (String)var1_1, var2_2.getErrorIndex());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object parseObject(String source, ParsePosition pos) {
        void var2_2;
        void var1_1;
        return this.parse((String)var1_1, (ParsePosition)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Date parse(String source, ParsePosition pos) {
        void var2_2;
        void var1_1;
        Calendar cal = Calendar.getInstance(this.timeZone, this.locale);
        cal.clear();
        if (this.parse((String)var1_1, (ParsePosition)var2_2, cal)) {
            void var3_3;
            return var3_3.getTime();
        }
        return null;
    }

    @Override
    public boolean parse(String source, ParsePosition pos, Calendar calendar) {
        ListIterator<StrategyAndWidth> lt = this.patterns.listIterator();
        while (lt.hasNext()) {
            StrategyAndWidth strategyAndWidth = lt.next();
            int maxWidth = strategyAndWidth.getMaxWidth(lt);
            if (strategyAndWidth.strategy.parse(this, calendar, source, pos, maxWidth)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuilder simpleQuote(StringBuilder sb, String value) {
        StringBuilder stringBuilder;
        for (int i = 0; i < value.length(); ++i) {
            void var3_3;
            char c = value.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    sb.append('\\');
                }
            }
            sb.append((char)var3_3);
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Integer> appendDisplayNames(Calendar cal, Locale locale, int field, StringBuilder regex) {
        void var2_3;
        Iterator iterator;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        Iterator displayNames = cal.getDisplayNames(field, 0, locale);
        TreeSet<String> sorted = new TreeSet<String>(LONGER_FIRST_LOWERCASE);
        for (Map.Entry displayName : iterator.entrySet()) {
            String key = ((String)displayName.getKey()).toLowerCase(locale);
            if (!sorted.add(key)) continue;
            values.put(key, (Integer)displayName.getValue());
        }
        for (String symbol : var2_3) {
            FastDateParser.simpleQuote(regex, symbol).append('|');
        }
        return values;
    }

    /*
     * WARNING - void declaration
     */
    private int adjustYear(int twoDigitYear) {
        void var2_2;
        void var1_1;
        int trial = this.century + twoDigitYear;
        if (var1_1 >= this.startYear) {
            return trial;
        }
        return (int)(var2_2 + 100);
    }

    /*
     * WARNING - void declaration
     */
    private Strategy getStrategy(char f, int width, Calendar definingCalendar) {
        void var3_3;
        switch (f) {
            default: {
                void var1_1;
                throw new IllegalArgumentException("Format '" + (char)var1_1 + "' not supported");
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, definingCalendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, definingCalendar);
            }
            case 'H': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                if (width >= 3) {
                    return this.getLocaleSpecificStrategy(2, definingCalendar);
                }
                return NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, definingCalendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return HOUR12_STRATEGY;
            }
            case 'k': {
                return HOUR24_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'u': {
                return DAY_OF_WEEK_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'Y': 
            case 'y': {
                if (width > 2) {
                    return LITERAL_YEAR_STRATEGY;
                }
                return ABBREVIATED_YEAR_STRATEGY;
            }
            case 'X': {
                return ISO8601TimeZoneStrategy.getStrategy(width);
            }
            case 'Z': {
                void var2_2;
                if (var2_2 != 2) break;
                return ISO8601TimeZoneStrategy.ISO_8601_3_STRATEGY;
            }
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, (Calendar)var3_3);
    }

    private static ConcurrentMap<Locale, Strategy> getCache(int field) {
        ConcurrentMap<Locale, Strategy>[] concurrentMapArray = caches;
        synchronized (caches) {
            int n;
            if (caches[field] == null) {
                FastDateParser.caches[field] = new ConcurrentHashMap<Locale, Strategy>(3);
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return caches[n];
        }
    }

    /*
     * WARNING - void declaration
     */
    private Strategy getLocaleSpecificStrategy(int field, Calendar definingCalendar) {
        void var2_3;
        void var3_4;
        Strategy inCache;
        ConcurrentMap<Locale, Strategy> cache = FastDateParser.getCache(field);
        Strategy strategy = (Strategy)cache.get(this.locale);
        if (strategy == null && (inCache = var3_4.putIfAbsent(this.locale, strategy = field == 15 ? new TimeZoneStrategy(this.locale) : new CaseInsensitiveTextStrategy(field, (Calendar)var2_3, this.locale))) != null) {
            void var1_2;
            return var1_2;
        }
        return strategy;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Strategy access$200(FastDateParser x0, char x1, int x2, Calendar x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.getStrategy((char)var1_1, (int)var2_2, (Calendar)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$600(Calendar x0, Locale x1, int x2, StringBuilder x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return FastDateParser.appendDisplayNames(x0, (Locale)var1_1, (int)var2_2, (StringBuilder)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$700(FastDateParser x0, int x1) {
        void var1_1;
        return x0.adjustYear((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ StringBuilder access$900(StringBuilder x0, String x1) {
        void var1_1;
        return FastDateParser.simpleQuote(x0, (String)var1_1);
    }

    private static class ISO8601TimeZoneStrategy
    extends PatternStrategy {
        private static final Strategy ISO_8601_1_STRATEGY = new ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}))");
        private static final Strategy ISO_8601_2_STRATEGY = new ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}\\d{2}))");
        private static final Strategy ISO_8601_3_STRATEGY = new ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}(?::)\\d{2}))");

        /*
         * WARNING - void declaration
         */
        ISO8601TimeZoneStrategy(String pattern) {
            void var1_1;
            this.createPattern((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setCalendar(FastDateParser parser, Calendar cal, String value) {
            void var3_3;
            void var2_2;
            if (value.equals("Z")) {
                cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                return;
            }
            var2_2.setTimeZone(TimeZone.getTimeZone("GMT" + (String)var3_3));
        }

        static Strategy getStrategy(int tokenLen) {
            switch (tokenLen) {
                case 1: {
                    return ISO_8601_1_STRATEGY;
                }
                case 2: {
                    return ISO_8601_2_STRATEGY;
                }
                case 3: {
                    return ISO_8601_3_STRATEGY;
                }
            }
            throw new IllegalArgumentException("invalid number of X");
        }
    }

    static class TimeZoneStrategy
    extends PatternStrategy {
        private static final String RFC_822_TIME_ZONE = "[+-]\\d{4}";
        private static final String GMT_OPTION = "GMT[+-]\\d{1,2}:\\d{2}";
        private final Locale locale;
        private final Map<String, TzInfo> tzNames = new HashMap<String, TzInfo>();
        private static final int ID = 0;

        /*
         * WARNING - void declaration
         */
        TimeZoneStrategy(Locale locale) {
            void var2_2;
            void var3_3;
            this.locale = locale;
            StringBuilder sb = new StringBuilder();
            sb.append("((?iu)[+-]\\d{4}|GMT[+-]\\d{1,2}:\\d{2}");
            TreeSet<String> sorted = new TreeSet<String>(LONGER_FIRST_LOWERCASE);
            String[][] stringArray = DateFormatSymbols.getInstance(locale).getZoneStrings();
            Object object = stringArray;
            object = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                TzInfo standard;
                String[] zoneNames = object[i];
                String tzId = zoneNames[0];
                if (tzId.equalsIgnoreCase("GMT")) continue;
                TimeZone tz = TimeZone.getTimeZone(tzId);
                TzInfo tzInfo = standard = new TzInfo(tz, false);
                for (int i2 = 1; i2 < zoneNames.length; ++i2) {
                    String key;
                    switch (i2) {
                        case 3: {
                            tzInfo = new TzInfo(tz, true);
                            break;
                        }
                        case 5: {
                            tzInfo = standard;
                        }
                    }
                    if (zoneNames[i2] == null || !sorted.add(key = zoneNames[i2].toLowerCase(locale))) continue;
                    this.tzNames.put(key, tzInfo);
                }
            }
            for (String zoneName : var3_3) {
                FastDateParser.access$900(sb.append('|'), zoneName);
            }
            sb.append(")");
            this.createPattern((StringBuilder)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setCalendar(FastDateParser parser, Calendar cal, String value) {
            void var1_1;
            void var2_2;
            void var3_3;
            TimeZone tz;
            if (value.charAt(0) == '+' || value.charAt(0) == '-') {
                tz = TimeZone.getTimeZone("GMT" + value);
                cal.setTimeZone(tz);
                return;
            }
            if (value.regionMatches(true, 0, "GMT", 0, 3)) {
                tz = TimeZone.getTimeZone(value.toUpperCase());
                cal.setTimeZone(tz);
                return;
            }
            TzInfo tzInfo = this.tzNames.get(var3_3.toLowerCase(this.locale));
            cal.set(16, tzInfo.dstOffset);
            var2_2.set(15, var1_1.zone.getRawOffset());
        }

        private static class TzInfo {
            TimeZone zone;
            int dstOffset;

            /*
             * WARNING - void declaration
             */
            TzInfo(TimeZone tz, boolean useDst) {
                void var1_1;
                void var2_2;
                this.zone = tz;
                this.dstOffset = var2_2 != false ? var1_1.getDSTSavings() : 0;
            }
        }
    }

    private static class NumberStrategy
    extends Strategy {
        private final int field;

        /*
         * WARNING - void declaration
         */
        NumberStrategy(int field) {
            void var1_1;
            this.field = var1_1;
        }

        @Override
        boolean isNumber() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean parse(FastDateParser parser, Calendar calendar, String source, ParsePosition pos, int maxWidth) {
            void var1_1;
            void var2_2;
            void var3_3;
            int end;
            int idx;
            int last = source.length();
            if (maxWidth == 0) {
                for (idx = pos.getIndex(); idx < last; ++idx) {
                    char c = source.charAt(idx);
                    maxWidth = c;
                    if (!Character.isWhitespace(c)) break;
                }
                pos.setIndex(idx);
            } else {
                end = idx + maxWidth;
                if (last > end) {
                    last = end;
                }
            }
            while (idx < last) {
                char c = source.charAt(idx);
                end = c;
                if (!Character.isDigit(c)) break;
                ++idx;
            }
            if (pos.getIndex() == idx) {
                pos.setErrorIndex(idx);
                return false;
            }
            int value = Integers.parseInt(var3_3.substring(pos.getIndex(), idx));
            pos.setIndex(idx);
            var2_2.set(this.field, this.modify((FastDateParser)var1_1, value));
            return true;
        }

        int modify(FastDateParser parser, int iValue) {
            return iValue;
        }
    }

    private static class CaseInsensitiveTextStrategy
    extends PatternStrategy {
        private final int field;
        final Locale locale;
        private final Map<String, Integer> lKeyValues;

        /*
         * WARNING - void declaration
         */
        CaseInsensitiveTextStrategy(int field, Calendar definingCalendar, Locale locale) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.field = field;
            this.locale = locale;
            StringBuilder regex = new StringBuilder();
            regex.append("((?iu)");
            this.lKeyValues = FastDateParser.access$600((Calendar)var2_2, (Locale)var3_3, (int)var1_1, regex);
            StringBuilder stringBuilder = regex;
            stringBuilder.setLength(stringBuilder.length() - 1);
            regex.append(")");
            this.createPattern(regex);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setCalendar(FastDateParser parser, Calendar cal, String value) {
            void var1_1;
            void var2_2;
            void var3_3;
            Integer iVal = this.lKeyValues.get(var3_3.toLowerCase(this.locale));
            var2_2.set(this.field, var1_1.intValue());
        }
    }

    private static class CopyQuotedStrategy
    extends Strategy {
        private final String formatField;

        /*
         * WARNING - void declaration
         */
        CopyQuotedStrategy(String formatField) {
            void var1_1;
            this.formatField = var1_1;
        }

        @Override
        boolean isNumber() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean parse(FastDateParser parser, Calendar calendar, String source, ParsePosition pos, int maxWidth) {
            for (int idx = 0; idx < this.formatField.length(); ++idx) {
                void var2_4;
                int sIdx = idx + pos.getIndex();
                if (sIdx == source.length()) {
                    pos.setErrorIndex(sIdx);
                    return false;
                }
                if (this.formatField.charAt(idx) == source.charAt(sIdx)) continue;
                pos.setErrorIndex((int)var2_4);
                return false;
            }
            pos.setIndex(this.formatField.length() + pos.getIndex());
            return true;
        }
    }

    private static abstract class PatternStrategy
    extends Strategy {
        private Pattern pattern;

        private PatternStrategy() {
        }

        /*
         * WARNING - void declaration
         */
        void createPattern(StringBuilder regex) {
            void var1_1;
            this.createPattern(var1_1.toString());
        }

        /*
         * WARNING - void declaration
         */
        void createPattern(String regex) {
            void var1_1;
            this.pattern = Pattern.compile((String)var1_1);
        }

        @Override
        boolean isNumber() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean parse(FastDateParser parser, Calendar calendar, String source, ParsePosition pos, int maxWidth) {
            void var3_3;
            void var2_2;
            void var1_1;
            Matcher matcher = this.pattern.matcher(source.substring(pos.getIndex()));
            if (!matcher.lookingAt()) {
                ParsePosition parsePosition = pos;
                parsePosition.setErrorIndex(parsePosition.getIndex());
                return false;
            }
            ParsePosition parsePosition = pos;
            parsePosition.setIndex(parsePosition.getIndex() + matcher.end(1));
            this.setCalendar((FastDateParser)var1_1, (Calendar)var2_2, var3_3.group(1));
            return true;
        }

        abstract void setCalendar(FastDateParser var1, Calendar var2, String var3);
    }

    private static abstract class Strategy {
        private Strategy() {
        }

        boolean isNumber() {
            return false;
        }

        abstract boolean parse(FastDateParser var1, Calendar var2, String var3, ParsePosition var4, int var5);
    }

    private class StrategyParser {
        private final Calendar definingCalendar;
        private int currentIdx;

        /*
         * WARNING - void declaration
         */
        StrategyParser(Calendar definingCalendar) {
            void var2_2;
            this.definingCalendar = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        StrategyAndWidth getNextStrategy() {
            if (this.currentIdx >= FastDateParser.this.pattern.length()) {
                return null;
            }
            char c = FastDateParser.this.pattern.charAt(this.currentIdx);
            if (FastDateParser.isFormatLetter(c)) {
                void var1_1;
                return this.letterPattern((char)var1_1);
            }
            return this.literal();
        }

        /*
         * WARNING - void declaration
         */
        private StrategyAndWidth letterPattern(char c) {
            void var2_2;
            void var1_1;
            int begin = this.currentIdx;
            while (++this.currentIdx < FastDateParser.this.pattern.length() && FastDateParser.this.pattern.charAt(this.currentIdx) == c) {
            }
            int width = this.currentIdx - begin;
            return new StrategyAndWidth(FastDateParser.access$200(FastDateParser.this, (char)var1_1, width, this.definingCalendar), (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private StrategyAndWidth literal() {
            void var3_4;
            void var2_2;
            void var1_1;
            boolean activeQuote = false;
            StringBuilder sb = new StringBuilder();
            while (this.currentIdx < FastDateParser.this.pattern.length()) {
                char c = FastDateParser.this.pattern.charAt(this.currentIdx);
                if (!activeQuote && FastDateParser.isFormatLetter(c)) break;
                if (c == '\'' && (++this.currentIdx == FastDateParser.this.pattern.length() || FastDateParser.this.pattern.charAt(this.currentIdx) != '\'')) {
                    activeQuote = !activeQuote;
                    continue;
                }
                ++this.currentIdx;
                sb.append(c);
            }
            if (var1_1 != false) {
                throw new IllegalArgumentException("Unterminated quote");
            }
            String formatField = var2_2.toString();
            return new StrategyAndWidth(new CopyQuotedStrategy(formatField), var3_4.length());
        }
    }

    private static class StrategyAndWidth {
        final Strategy strategy;
        final int width;

        /*
         * WARNING - void declaration
         */
        StrategyAndWidth(Strategy strategy, int width) {
            void var2_2;
            void var1_1;
            this.strategy = var1_1;
            this.width = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        int getMaxWidth(ListIterator<StrategyAndWidth> lt) {
            void var2_2;
            void var1_1;
            if (!this.strategy.isNumber() || !lt.hasNext()) {
                return 0;
            }
            Strategy nextStrategy = lt.next().strategy;
            var1_1.previous();
            if (var2_2.isNumber()) {
                return this.width;
            }
            return 0;
        }
    }
}

