/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.util.AbstractWatcher;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.Watcher;

public class WrappedFileWatcher
extends AbstractWatcher
implements FileWatcher {
    private final FileWatcher watcher;
    private volatile long lastModifiedMillis;

    /*
     * WARNING - void declaration
     */
    public WrappedFileWatcher(FileWatcher watcher, Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> configurationListeners, long lastModifiedMillis) {
        super((Configuration)var2_2, (Reconfigurable)var3_3, configurationListeners);
        void var1_1;
        void var3_3;
        void var2_2;
        this.watcher = var1_1;
        this.lastModifiedMillis = lastModifiedMillis;
    }

    /*
     * WARNING - void declaration
     */
    public WrappedFileWatcher(FileWatcher watcher) {
        super(null, null, null);
        void var1_1;
        this.watcher = var1_1;
    }

    @Override
    public long getLastModified() {
        return this.lastModifiedMillis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fileModified(File file) {
        void var1_1;
        this.watcher.fileModified((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isModified() {
        long lastModified = this.getSource().getFile().lastModified();
        if (this.lastModifiedMillis != lastModified) {
            void var1_1;
            this.lastModifiedMillis = var1_1;
            return true;
        }
        return false;
    }

    @Override
    public List<ConfigurationListener> getListeners() {
        if (super.getListeners() != null) {
            return Collections.unmodifiableList(super.getListeners());
        }
        return null;
    }

    @Override
    public void modified() {
        if (((AbstractWatcher)this).getListeners() != null) {
            super.modified();
        }
        WrappedFileWatcher wrappedFileWatcher = this;
        wrappedFileWatcher.fileModified(wrappedFileWatcher.getSource().getFile());
        this.lastModifiedMillis = this.getSource().getFile().lastModified();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void watching(Source source) {
        void var1_1;
        this.lastModifiedMillis = source.getFile().lastModified();
        super.watching((Source)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Watcher newWatcher(Reconfigurable reconfigurable, List<ConfigurationListener> listeners, long lastModifiedMillis) {
        void var1_1;
        void var3_3;
        void var2_2;
        WrappedFileWatcher watcher = new WrappedFileWatcher(this.watcher, this.getConfiguration(), reconfigurable, (List<ConfigurationListener>)var2_2, (long)var3_3);
        if (this.getSource() != null) {
            ((AbstractWatcher)watcher).watching(this.getSource());
        }
        return var1_1;
    }
}

