/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFileWatcher;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.status.StatusLogger;

public class WatcherFactory {
    private static Logger LOGGER = StatusLogger.getLogger();
    private static PluginManager pluginManager = new PluginManager("Watcher");
    private static volatile WatcherFactory factory;
    private final Map<String, PluginType<?>> plugins;

    /*
     * WARNING - void declaration
     */
    private WatcherFactory(List<String> packages) {
        void var1_1;
        pluginManager.collectPlugins((List<String>)var1_1);
        this.plugins = pluginManager.getPlugins();
    }

    public static WatcherFactory getInstance(List<String> packages) {
        if (factory == null) {
            PluginManager pluginManager = WatcherFactory.pluginManager;
            synchronized (pluginManager) {
                if (factory == null) {
                    List<String> list;
                    factory = new WatcherFactory(list);
                }
            }
        }
        return factory;
    }

    /*
     * WARNING - void declaration
     */
    public Watcher newWatcher(Source source, Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> configurationListeners, long lastModifiedMillis) {
        void var1_1;
        if (source.getFile() != null) {
            return new ConfigurationFileWatcher(configuration, reconfigurable, configurationListeners, lastModifiedMillis);
        }
        String name = source.getURI().getScheme();
        PluginType<?> pluginType = this.plugins.get(name);
        if (pluginType != null) {
            void var3_3;
            void var2_2;
            return WatcherFactory.instantiate(name, pluginType.getPluginClass(), (Configuration)var2_2, (Reconfigurable)var3_3, configurationListeners, lastModifiedMillis);
        }
        LOGGER.info("No Watcher plugin is available for protocol '{}'", (Object)var1_1);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Watcher> T instantiate(String name, Class<T> clazz, Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> listeners, long lastModifiedMillis) {
        Objects.requireNonNull(clazz, "No class provided");
        try {
            void var3_6;
            void var2_5;
            clazz = clazz.getConstructor(Configuration.class, Reconfigurable.class, List.class, Long.TYPE);
            return (T)((Watcher)((Constructor)clazz).newInstance(var2_5, var3_6, listeners, lastModifiedMillis));
        }
        catch (NoSuchMethodException ex) {
            String string;
            throw new IllegalArgumentException("No valid constructor for Watcher plugin " + string, ex);
        }
        catch (InstantiationException | LinkageError e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            void var1_4;
            throw new IllegalStateException((Throwable)var1_4);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwables.rethrow(invocationTargetException.getCause());
            throw new InternalError("Unreachable");
        }
    }
}

