/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.ConfigurationFileWatcher;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.WatchEventService;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.core.util.WrappedFileWatcher;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

public class WatchManager
extends AbstractLifeCycle {
    private static Logger logger = StatusLogger.getLogger();
    private final ConcurrentMap<Source, ConfigurationMonitor> watchers = new ConcurrentHashMap<Source, ConfigurationMonitor>();
    private int intervalSeconds = 0;
    private ScheduledFuture<?> future;
    private final ConfigurationScheduler scheduler;
    private final List<WatchEventService> eventServiceList;
    private final UUID id = LocalUUID.get();

    /*
     * WARNING - void declaration
     */
    public WatchManager(ConfigurationScheduler scheduler) {
        void var1_1;
        this.scheduler = (ConfigurationScheduler)Objects.requireNonNull(var1_1, "scheduler");
        this.eventServiceList = ServiceLoaderUtil.loadServices(WatchEventService.class, (MethodHandles.Lookup)MethodHandles.lookup(), (boolean)true).collect(Collectors.toList());
    }

    public void checkFiles() {
        new WatchRunnable().run();
    }

    /*
     * WARNING - void declaration
     */
    public Map<Source, Watcher> getConfigurationWatchers() {
        void var1_1;
        HashMap map = new HashMap(this.watchers.size());
        for (Map.Entry entry : this.watchers.entrySet()) {
            void var3_3;
            map.put(entry.getKey(), ((ConfigurationMonitor)var3_3.getValue()).getWatcher());
        }
        return var1_1;
    }

    public UUID getId() {
        return this.id;
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Map<File, FileWatcher> getWatchers() {
        void var1_1;
        HashMap<File, FileWatcher> map = new HashMap<File, FileWatcher>(this.watchers.size());
        for (Map.Entry entry : this.watchers.entrySet()) {
            void var3_3;
            if (((ConfigurationMonitor)entry.getValue()).getWatcher() instanceof ConfigurationFileWatcher) {
                map.put(((Source)entry.getKey()).getFile(), (FileWatcher)((Object)((ConfigurationMonitor)entry.getValue()).getWatcher()));
                continue;
            }
            map.put(((Source)entry.getKey()).getFile(), new WrappedFileWatcher((FileWatcher)((Object)((ConfigurationMonitor)var3_3.getValue()).getWatcher())));
        }
        return var1_1;
    }

    public boolean hasEventListeners() {
        return this.eventServiceList.size() > 0;
    }

    /*
     * WARNING - void declaration
     */
    private String millisToString(long millis) {
        void var1_1;
        return new Date((long)var1_1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public void reset() {
        logger.debug("Resetting {}", (Object)this);
        for (Source source : this.watchers.keySet()) {
            void var2_2;
            this.reset((Source)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reset(File file) {
        void var1_1;
        if (file == null) {
            return;
        }
        Source source = new Source(file);
        this.reset((Source)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void reset(Source source) {
        Watcher watcher;
        if (source == null) {
            return;
        }
        ConfigurationMonitor monitor = (ConfigurationMonitor)this.watchers.get(source);
        if (monitor != null && (watcher = monitor.getWatcher()).isModified()) {
            void var2_2;
            void var3_3;
            long lastModifiedMillis = var3_3.getLastModified();
            if (logger.isDebugEnabled()) {
                void var1_1;
                logger.debug("Resetting file monitor for '{}' from {} ({}) to {} ({})", (Object)var1_1.getLocation(), (Object)this.millisToString(monitor.lastModifiedMillis), (Object)monitor.lastModifiedMillis, (Object)this.millisToString(lastModifiedMillis), (Object)lastModifiedMillis);
            }
            ConfigurationMonitor.access$500((ConfigurationMonitor)var2_2, lastModifiedMillis);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setIntervalSeconds(int intervalSeconds) {
        if (!this.isStarted()) {
            void var1_1;
            if (this.intervalSeconds > 0 && intervalSeconds == 0) {
                this.scheduler.decrementScheduledItems();
            } else if (this.intervalSeconds == 0 && intervalSeconds > 0) {
                this.scheduler.incrementScheduledItems();
            }
            this.intervalSeconds = var1_1;
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.intervalSeconds > 0) {
            this.future = this.scheduler.scheduleWithFixedDelay(new WatchRunnable(), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
        }
        for (WatchEventService watchEventService : this.eventServiceList) {
            watchEventService.subscribe(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        void var1_3;
        this.setStopping();
        for (WatchEventService watchEventService : this.eventServiceList) {
            watchEventService.unsubscribe(this);
        }
        WatchManager watchManager = this;
        boolean stopped = watchManager.stop(watchManager.future);
        this.setStopped();
        return (boolean)var1_3;
    }

    public String toString() {
        return "WatchManager [intervalSeconds=" + this.intervalSeconds + ", watchers=" + this.watchers + ", scheduler=" + this.scheduler + ", future=" + this.future + "]";
    }

    /*
     * WARNING - void declaration
     */
    public void unwatch(Source source) {
        void var1_1;
        logger.debug("Unwatching configuration {}", (Object)source);
        this.watchers.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void unwatchFile(File file) {
        void var1_1;
        Source source = new Source(file);
        this.unwatch((Source)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void watch(Source source, Watcher watcher) {
        void var2_2;
        void var3_3;
        void var1_1;
        watcher.watching(source);
        long lastModified = watcher.getLastModified();
        if (logger.isDebugEnabled()) {
            logger.debug("Watching configuration '{}' for lastModified {} ({})", (Object)source, (Object)this.millisToString(lastModified), (Object)lastModified);
        }
        this.watchers.put((Source)var1_1, new ConfigurationMonitor((long)var3_3, (Watcher)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void watchFile(File file, FileWatcher fileWatcher) {
        void var2_2;
        void var1_1;
        Watcher watcher;
        watcher = fileWatcher instanceof Watcher ? (Watcher)((Object)fileWatcher) : new WrappedFileWatcher((FileWatcher)((Object)watcher));
        Source source = new Source(file);
        this.watch((Source)var1_1, (Watcher)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$200(WatchManager x0, long x1) {
        void var1_1;
        return x0.millisToString((long)var1_1);
    }

    private final class WatchRunnable
    implements Runnable {
        private final String SIMPLE_NAME = WatchRunnable.class.getSimpleName();

        private WatchRunnable() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            logger.trace("{} run triggered.", (Object)this.SIMPLE_NAME);
            for (Map.Entry entry : WatchManager.this.watchers.entrySet()) {
                void var2_2;
                Source source = (Source)entry.getKey();
                ConfigurationMonitor monitor = (ConfigurationMonitor)entry.getValue();
                if (!monitor.getWatcher().isModified()) continue;
                long lastModified = monitor.getWatcher().getLastModified();
                if (logger.isInfoEnabled()) {
                    void var3_3;
                    logger.info("Source '{}' was modified on {} ({}), previous modification was on {} ({})", (Object)var3_3, (Object)WatchManager.access$200(WatchManager.this, lastModified), (Object)lastModified, (Object)WatchManager.access$200(WatchManager.this, monitor.lastModifiedMillis), (Object)monitor.lastModifiedMillis);
                }
                ConfigurationMonitor.access$302(monitor, lastModified);
                var2_2.getWatcher().modified();
            }
            logger.trace("{} run ended.", (Object)this.SIMPLE_NAME);
        }
    }

    private static class LocalUUID {
        private static final long LOW_MASK = 0xFFFFFFFFL;
        private static final long MID_MASK = 0xFFFF00000000L;
        private static final long HIGH_MASK = 0xFFF000000000000L;
        private static final int NODE_SIZE = 8;
        private static final int SHIFT_2 = 16;
        private static final int SHIFT_4 = 32;
        private static final int SHIFT_6 = 48;
        private static final int HUNDRED_NANOS_PER_MILLI = 10000;
        private static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;
        private static final AtomicInteger COUNT = new AtomicInteger(0);
        private static final long TYPE1 = 4096L;
        private static final byte VARIANT = -128;
        private static final int SEQUENCE_MASK = 16383;

        private LocalUUID() {
        }

        /*
         * WARNING - void declaration
         */
        public static UUID get() {
            void var2_1;
            void var0;
            long time = System.currentTimeMillis() * 10000L + 122192928000000000L + (long)(COUNT.incrementAndGet() % 10000);
            long timeLow = (time & 0xFFFFFFFFL) << 32;
            long timeMid = (time & 0xFFFF00000000L) >> 16;
            void timeHi = (var0 & 0xFFF000000000000L) >> 48;
            void most = var2_1 | timeMid | 0x1000L | timeHi;
            return new UUID((long)most, COUNT.incrementAndGet());
        }
    }

    private final class ConfigurationMonitor {
        private final Watcher watcher;
        private volatile long lastModifiedMillis;

        /*
         * WARNING - void declaration
         */
        public ConfigurationMonitor(long lastModifiedMillis, Watcher watcher) {
            void var2_2;
            this.watcher = watcher;
            this.lastModifiedMillis = var2_2;
        }

        public final Watcher getWatcher() {
            return this.watcher;
        }

        /*
         * WARNING - void declaration
         */
        private void setLastModifiedMillis(long lastModifiedMillis) {
            void var1_1;
            this.lastModifiedMillis = var1_1;
        }

        public final String toString() {
            return "ConfigurationMonitor [watcher=" + this.watcher + ", lastModifiedMillis=" + this.lastModifiedMillis + "]";
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ long access$302(ConfigurationMonitor x0, long x1) {
            void var1_1;
            x0.lastModifiedMillis = var1_1;
            return x0.lastModifiedMillis;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$500(ConfigurationMonitor x0, long x1) {
            void var1_1;
            x0.setLastModifiedMillis((long)var1_1);
        }
    }
}

