/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class UuidUtil {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final String UUID_SEQUENCE = "org.apache.logging.log4j.uuidSequence";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String ASSIGNED_SEQUENCES = "org.apache.logging.log4j.assignedSequences";
    private static final AtomicInteger COUNT = new AtomicInteger(0);
    private static final long TYPE1 = 4096L;
    private static final byte VARIANT = -128;
    private static final int SEQUENCE_MASK = 16383;
    private static final long NUM_100NS_INTERVALS_SINCE_UUID_EPOCH = 122192928000000000L;
    private static final long INITIAL_UUID_SEQNO = PropertiesUtil.getProperties().getLongProperty("org.apache.logging.log4j.uuidSequence", 0L);
    private static final long LOW_MASK = 0xFFFFFFFFL;
    private static final long MID_MASK = 0xFFFF00000000L;
    private static final long HIGH_MASK = 0xFFF000000000000L;
    private static final int NODE_SIZE = 8;
    private static final int SHIFT_2 = 16;
    private static final int SHIFT_4 = 32;
    private static final int SHIFT_6 = 48;
    private static final int HUNDRED_NANOS_PER_MILLI = 10000;
    private static final long LEAST = UuidUtil.initialize(NetUtils.getMacAddress());

    private UuidUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static long initialize(byte[] mac) {
        Object object;
        void var3_4;
        int n;
        long[] sequences;
        SecureRandom randomGenerator = new SecureRandom();
        if (mac == null || mac.length == 0) {
            mac = new byte[6];
            ((Random)randomGenerator).nextBytes(mac);
        }
        int length = mac.length >= 6 ? 6 : mac.length;
        int index = mac.length >= 6 ? mac.length - 6 : 0;
        byte[] byArray = new byte[8];
        byte[] node = byArray;
        byArray[0] = -128;
        node[1] = 0;
        for (int i = 2; i < 8; ++i) {
            node[i] = 0;
        }
        System.arraycopy(mac, index, node, 2, length);
        ByteBuffer buf = ByteBuffer.wrap(node);
        long rand = INITIAL_UUID_SEQNO;
        String string = PropertiesUtil.getProperties().getStringProperty(ASSIGNED_SEQUENCES);
        Object assigned = string;
        if (string == null) {
            sequences = EMPTY_LONG_ARRAY;
        } else {
            String[] array = ((String)assigned).split(Patterns.COMMA_SEPARATOR);
            sequences = new long[array.length];
            int i = 0;
            String[] stringArray = array;
            n = array.length;
            for (int j = 0; j < n; ++j) {
                String value = stringArray[j];
                sequences[i] = Long.parseLong(value);
                ++i;
            }
        }
        if (rand == 0L) {
            void var1_1;
            rand = var1_1.nextLong();
        }
        rand &= 0x3FFFL;
        do {
            boolean duplicate = false;
            long[] lArray = sequences;
            int n2 = sequences.length;
            for (n = 0; n < n2; ++n) {
                long l = lArray[n];
                if (l != rand) continue;
                duplicate = true;
                break;
            }
            if (!duplicate) continue;
            rand = rand + 1L & 0x3FFFL;
        } while (var3_4 != false);
        assigned = assigned == null ? Long.toString(rand) : (String)assigned + ',' + Long.toString(rand);
        System.setProperty(ASSIGNED_SEQUENCES, (String)object);
        return buf.getLong() | rand << 48;
    }

    /*
     * WARNING - void declaration
     */
    public static UUID getTimeBasedUuid() {
        void var2_1;
        void var0;
        long time = System.currentTimeMillis() * 10000L + 122192928000000000L + (long)(COUNT.incrementAndGet() % 10000);
        long timeLow = (time & 0xFFFFFFFFL) << 32;
        long timeMid = (time & 0xFFFF00000000L) >> 16;
        void timeHi = (var0 & 0xFFF000000000000L) >> 48;
        void most = var2_1 | timeMid | 0x1000L | timeHi;
        return new UUID((long)most, LEAST);
    }
}

