/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class TypeUtil {
    private TypeUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public static List<Field> getAllDeclaredFields(Class<?> cls) {
        void var1_1;
        ArrayList fields = new ArrayList();
        while (cls != null) {
            Collections.addAll(fields, cls.getDeclaredFields());
            cls = cls.getSuperclass();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isAssignable(Type lhs, Type rhs) {
        while (true) {
            void var2_2;
            Class rhsClass;
            Objects.requireNonNull(lhs, "No left hand side type provided");
            Objects.requireNonNull(rhs, "No right hand side type provided");
            if (lhs.equals(rhs)) {
                return true;
            }
            if (Object.class.equals((Object)lhs)) {
                return true;
            }
            if (lhs instanceof Class) {
                Type rhsRawType;
                Class lhsClass = lhs;
                if (rhs instanceof Class) {
                    rhsClass = rhs;
                    return lhsClass.isAssignableFrom(rhsClass);
                }
                if (rhs instanceof ParameterizedType && (rhsRawType = ((ParameterizedType)((Object)rhs)).getRawType()) instanceof Class) {
                    return lhsClass.isAssignableFrom((Class)rhsRawType);
                }
                if (lhsClass.isArray() && rhs instanceof GenericArrayType) {
                    rhs = ((GenericArrayType)((Object)rhs)).getGenericComponentType();
                    lhs = lhsClass.getComponentType();
                    continue;
                }
            }
            if (lhs instanceof ParameterizedType) {
                ParameterizedType lhsType = (ParameterizedType)lhs;
                if (rhs instanceof Class) {
                    Type lhsRawType = lhsType.getRawType();
                    if (lhsRawType instanceof Class) {
                        return ((Class)lhsRawType).isAssignableFrom(rhs);
                    }
                } else if (rhs instanceof ParameterizedType) {
                    ParameterizedType rhsType = (ParameterizedType)((Object)rhs);
                    return TypeUtil.isParameterizedAssignable(lhsType, rhsType);
                }
            }
            if (!(lhs instanceof GenericArrayType)) break;
            Type lhsComponentType = ((GenericArrayType)lhs).getGenericComponentType();
            if (rhs instanceof Class) {
                void var3_3;
                rhsClass = rhs;
                if (!rhsClass.isArray()) break;
                rhs = var3_3.getComponentType();
                lhs = lhsComponentType;
                continue;
            }
            if (!(rhs instanceof GenericArrayType)) break;
            rhs = ((GenericArrayType)((Object)rhs)).getGenericComponentType();
            lhs = var2_2;
        }
        if (lhs instanceof WildcardType) {
            void var1_1;
            Type type;
            return TypeUtil.isWildcardAssignable((WildcardType)type, (Type)var1_1);
        }
        return false;
    }

    private static boolean isParameterizedAssignable(ParameterizedType lhs, ParameterizedType rhs) {
        int size;
        if (lhs.equals(rhs)) {
            return true;
        }
        Type[] lhsTypeArguments = lhs.getActualTypeArguments();
        Type[] rhsTypeArguments = rhs.getActualTypeArguments();
        if (rhsTypeArguments.length != (size = lhsTypeArguments.length)) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Type lhsArgument = lhsTypeArguments[i];
            Type rhsArgument = rhsTypeArguments[i];
            if (lhsArgument.equals(rhsArgument) || lhsArgument instanceof WildcardType && TypeUtil.isWildcardAssignable((WildcardType)lhsArgument, rhsArgument)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isWildcardAssignable(WildcardType lhs, Type rhs2) {
        Type[] lhsUpperBounds = TypeUtil.getEffectiveUpperBounds(lhs);
        Type[] lhsLowerBounds = TypeUtil.getEffectiveLowerBounds(lhs);
        if (rhs2 instanceof WildcardType) {
            int n;
            int n2;
            Type[] typeArray;
            void var3_4;
            WildcardType rhsType = (WildcardType)rhs2;
            Type[] rhsUpperBounds = TypeUtil.getEffectiveUpperBounds(rhsType);
            Type[] rhsLowerBounds = TypeUtil.getEffectiveLowerBounds((WildcardType)var3_4);
            for (Type lhsUpperBound : lhsUpperBounds) {
                typeArray = rhsUpperBounds;
                n2 = rhsUpperBounds.length;
                for (n = 0; n < n2; ++n) {
                    Type rhsUpperBound = typeArray[n];
                    if (TypeUtil.isBoundAssignable(lhsUpperBound, rhsUpperBound)) continue;
                    return false;
                }
                typeArray = rhsLowerBounds;
                n2 = rhsLowerBounds.length;
                for (n = 0; n < n2; ++n) {
                    Type rhsLowerBound = typeArray[n];
                    if (TypeUtil.isBoundAssignable(lhsUpperBound, rhsLowerBound)) continue;
                    return false;
                }
            }
            lhsUpperBounds = lhsLowerBounds;
            int rhs2 = lhsLowerBounds.length;
            for (int i = 0; i < rhs2; ++i) {
                Type type;
                Type lhsLowerBound = lhsUpperBounds[i];
                typeArray = rhsUpperBounds;
                n2 = rhsUpperBounds.length;
                for (n = 0; n < n2; ++n) {
                    type = typeArray[n];
                    if (TypeUtil.isBoundAssignable(type, lhsLowerBound)) continue;
                    return false;
                }
                typeArray = rhsLowerBounds;
                n2 = rhsLowerBounds.length;
                for (n = 0; n < n2; ++n) {
                    type = typeArray[n];
                    if (TypeUtil.isBoundAssignable(type, lhsLowerBound)) continue;
                    return false;
                }
            }
        } else {
            Type[] typeArray;
            Type rhs2;
            for (Type type : type) {
                if (TypeUtil.isBoundAssignable(type, rhs2)) continue;
                return false;
            }
            Type[] typeArray2 = typeArray;
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                type = typeArray2[i];
                if (TypeUtil.isBoundAssignable(type, rhs2)) continue;
                return false;
            }
        }
        return true;
    }

    private static Type[] getEffectiveUpperBounds(WildcardType type) {
        Type[] typeArray;
        Type[] upperBounds = type.getUpperBounds();
        if (upperBounds.length == 0) {
            return new Type[]{Object.class};
        }
        return typeArray;
    }

    private static Type[] getEffectiveLowerBounds(WildcardType type) {
        Type[] typeArray;
        Type[] lowerBounds = type.getLowerBounds();
        if (lowerBounds.length == 0) {
            return new Type[]{null};
        }
        return typeArray;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isBoundAssignable(Type lhs, Type rhs) {
        void var1_1;
        Type type;
        return rhs == null || lhs != null && TypeUtil.isAssignable(type, (Type)var1_1);
    }
}

