/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class Source {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final File file;
    private final URI uri;
    private final String location;

    /*
     * WARNING - void declaration
     */
    private static String normalize(File file) {
        try {
            return file.getCanonicalFile().getAbsolutePath();
        }
        catch (IOException e) {
            void var0_1;
            throw new IllegalArgumentException((Throwable)var0_1);
        }
    }

    private static File toFile(Path path) {
        try {
            return Objects.requireNonNull(path, "path").toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static File toFile(URI uri) {
        try {
            void var1_1;
            String scheme = Objects.requireNonNull(uri, "uri").getScheme();
            if (Strings.isBlank((String)scheme) || var1_1.equals("file")) {
                return new File(uri.getPath());
            }
            LOGGER.debug("uri does not represent a local file: " + uri);
            return null;
        }
        catch (Exception exception) {
            URI uRI;
            LOGGER.debug("uri is malformed: " + uRI.toString());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static URI toURI(URL url) {
        try {
            return Objects.requireNonNull(url, "url").toURI();
        }
        catch (URISyntaxException e) {
            void var0_1;
            throw new IllegalArgumentException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Source(ConfigurationSource source) {
        void var1_1;
        this.file = source.getFile();
        this.uri = source.getURI();
        this.location = var1_1.getLocation();
    }

    /*
     * WARNING - void declaration
     */
    public Source(File file) {
        void var1_1;
        this.file = Objects.requireNonNull(file, "file");
        this.location = Source.normalize(file);
        this.uri = var1_1.toURI();
    }

    /*
     * WARNING - void declaration
     */
    public Source(Path path) {
        void var1_1;
        Path normPath = Objects.requireNonNull(path, "path").normalize();
        this.file = Source.toFile(normPath);
        this.uri = normPath.toUri();
        this.location = var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Source(URI uri) {
        void var1_1;
        URI normUri;
        this.uri = normUri = Objects.requireNonNull(uri, "uri").normalize();
        this.location = normUri.toString();
        this.file = Source.toFile((URI)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public Source(URI uri, long lastModified) {
        this((URI)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Source(URL url) {
        void var1_1;
        this.uri = Source.toURI((URL)var1_1);
        this.location = this.uri.toString();
        this.file = Source.toFile(this.uri);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.location, var1_1.location);
    }

    public File getFile() {
        return this.file;
    }

    public String getLocation() {
        return this.location;
    }

    public Path getPath() {
        if (this.file != null) {
            return this.file.toPath();
        }
        if (this.uri != null) {
            return Paths.get(this.uri);
        }
        return Paths.get(this.location, new String[0]);
    }

    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public URL getURL() {
        try {
            return this.uri.toURL();
        }
        catch (MalformedURLException e) {
            void var1_1;
            throw new IllegalStateException((Throwable)var1_1);
        }
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }

    public String toString() {
        return this.location;
    }
}

