/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.logging.log4j.core.util.Throwables;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T extends AccessibleObject> boolean isAccessible(T member) {
        T t;
        Objects.requireNonNull(member, "No member provided");
        return Modifier.isPublic(((Member)((Object)member)).getModifiers()) && Modifier.isPublic(((Member)((Object)t)).getDeclaringClass().getModifiers());
    }

    public static <T extends AccessibleObject> void makeAccessible(T member) {
        if (!ReflectionUtil.isAccessible(member) && !member.isAccessible()) {
            T t;
            t.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        Objects.requireNonNull(field, "No field provided");
        if (!(ReflectionUtil.isAccessible(field) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            Field field2;
            field2.setAccessible(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object getFieldValue(Field field, Object instance) {
        ReflectionUtil.makeAccessible(field);
        if (!Modifier.isStatic(field.getModifiers())) {
            Objects.requireNonNull(instance, "No instance given for non-static field");
        }
        try {
            void var1_2;
            return field.get(var1_2);
        }
        catch (IllegalAccessException e) {
            void var0_1;
            throw new UnsupportedOperationException((Throwable)var0_1);
        }
    }

    public static Object getStaticFieldValue(Field field) {
        return ReflectionUtil.getFieldValue(field, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void setFieldValue(Field field, Object instance, Object value) {
        ReflectionUtil.makeAccessible(field);
        if (!Modifier.isStatic(field.getModifiers())) {
            Objects.requireNonNull(instance, "No instance given for non-static field");
        }
        try {
            void var2_3;
            void var1_2;
            field.set(var1_2, var2_3);
            return;
        }
        catch (IllegalAccessException e) {
            void var0_1;
            throw new UnsupportedOperationException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setStaticFieldValue(Field field, Object value) {
        void var1_1;
        ReflectionUtil.setFieldValue(field, null, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz) {
        Objects.requireNonNull(clazz, "No class provided");
        try {
            void var1_2;
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            ReflectionUtil.makeAccessible(constructor);
            return var1_2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                GenericDeclaration constructor = clazz.getConstructor(new Class[0]);
                ReflectionUtil.makeAccessible(constructor);
                return constructor;
            }
            catch (NoSuchMethodException e) {
                void var0_1;
                throw new IllegalStateException((Throwable)var0_1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T instantiate(Class<T> clazz) {
        Objects.requireNonNull(clazz, "No class provided");
        Constructor<T> constructor = ReflectionUtil.getDefaultConstructor(clazz);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException | LinkageError e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            void var0_2;
            throw new IllegalStateException((Throwable)var0_2);
        }
        catch (InvocationTargetException invocationTargetException) {
            Constructor<T> constructor2 = invocationTargetException;
            Throwables.rethrow(invocationTargetException.getCause());
            throw new InternalError("Unreachable");
        }
    }
}

