/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public final class OptionConverter {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String DELIM_START = "${";
    private static final char DELIM_STOP = '}';
    private static final int DELIM_START_LEN = 2;
    private static final int DELIM_STOP_LEN = 1;
    private static final int ONE_K = 1024;

    private OptionConverter() {
    }

    /*
     * WARNING - void declaration
     */
    public static String[] concatenateArrays(String[] l, String[] r) {
        void var2_3;
        void var1_1;
        String[] stringArray;
        int n = l.length + r.length;
        String[] a = new String[n];
        System.arraycopy(l, 0, a, 0, l.length);
        System.arraycopy(r, 0, a, stringArray.length, ((void)var1_1).length);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static String convertSpecialChars(String s) {
        void var3_2;
        int len = s.length();
        StringBuilder sbuf = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            void var1_4;
            int c;
            if ((c = s.charAt(i++)) == 92) {
                c = s.charAt(i++);
                switch (c) {
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 34: {
                        c = 34;
                        break;
                    }
                    case 39: {
                        c = 39;
                        break;
                    }
                    case 92: {
                        c = 92;
                    }
                }
            }
            sbuf.append((char)var1_4);
        }
        return var3_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Object instantiateByKey(Properties props, String key, Class<?> superClass, Object defaultValue) {
        void var3_3;
        void var2_2;
        String string;
        String className = OptionConverter.findAndSubst(key, props);
        if (className == null) {
            void var1_1;
            LOGGER.error("Could not find value for key {}", (Object)var1_1);
            return defaultValue;
        }
        return OptionConverter.instantiateByClassName(string.trim(), var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean toBoolean(String value, boolean defaultValue) {
        void var1_1;
        String string;
        if (value == null) {
            return defaultValue;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int toInt(String value, int defaultValue) {
        void var1_1;
        if (value != null) {
            try {
                String s;
                return Integers.parseInt(s);
            }
            catch (NumberFormatException e) {
                void var2_2;
                String string;
                LOGGER.error("[{}] is not in proper int form.", (Object)string, (Object)var2_2);
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Level toLevel(String value, Level defaultValue) {
        void var3_9;
        if (value == null) {
            return defaultValue;
        }
        int hashIndex = (value = value.trim()).indexOf(35);
        if (hashIndex == -1) {
            if ("NULL".equalsIgnoreCase(value)) {
                return null;
            }
            return Level.toLevel((String)value, (Level)defaultValue);
        }
        Level result = defaultValue;
        String clazz = value.substring(hashIndex + 1);
        String levelName = value.substring(0, hashIndex);
        if ("NULL".equalsIgnoreCase(levelName)) {
            return null;
        }
        LOGGER.debug("toLevel:class=[" + clazz + "]:pri=[" + levelName + "]");
        try {
            Object object;
            Class<?> customLevel = Loader.loadClass(clazz);
            Class[] paramTypes = new Class[]{String.class, Level.class};
            Method toLevelMethod = customLevel.getMethod("toLevel", paramTypes);
            Object[] params = new Object[]{levelName, defaultValue};
            object = toLevelMethod.invoke(null, (Object[])object);
            result = (Level)object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.warn("custom level class [" + clazz + "] not found.");
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn("custom level class [" + clazz + "] does not have a class function toLevel(String, Level)", (Throwable)e);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException e = invocationTargetException;
            if (invocationTargetException.getTargetException() instanceof InterruptedException || e.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.warn("custom level class [" + clazz + "] could not be instantiated", (Throwable)e);
        }
        catch (ClassCastException e) {
            LOGGER.warn("class [" + clazz + "] is not a subclass of org.apache.log4j.Level", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("class [" + clazz + "] cannot be instantiated due to access restrictions", (Throwable)e);
        }
        catch (RuntimeException e) {
            void var2_8;
            String string;
            LOGGER.warn("class [" + clazz + "], level [" + string + "] conversion failed.", (Throwable)var2_8);
        }
        return var3_9;
    }

    /*
     * WARNING - void declaration
     */
    public static long toFileSize(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        String str = value.trim().toUpperCase(Locale.ENGLISH);
        long multiplier = 1L;
        int index = str.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            str = str.substring(0, index);
        } else {
            index = str.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                str = str.substring(0, index);
            } else {
                index = str.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    str = str.substring(0, index);
                }
            }
        }
        try {
            return Long.parseLong(str) * multiplier;
        }
        catch (NumberFormatException e) {
            void var1_1;
            String string;
            void var3_2;
            LOGGER.error("[{}] is not in proper int form.", (Object)var3_2);
            LOGGER.error("[{}] not in expected format.", (Object)string, (Object)e);
            return (long)var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String findAndSubst(String key, Properties props) {
        String value = props.getProperty(key);
        if (value == null) {
            return null;
        }
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e) {
            String string;
            void var1_2;
            LOGGER.error("Bad option value [{}].", (Object)value, (Object)var1_2);
            return string;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object instantiateByClassName(String className, Class<?> superClass, Object defaultValue) {
        void var2_2;
        if (className != null) {
            try {
                Class<?> classObj = Loader.loadClass(className);
                if (!superClass.isAssignableFrom(classObj)) {
                    void var1_1;
                    LOGGER.error("A \"{}\" object is not assignable to a \"{}\" variable.", (Object)className, (Object)superClass.getName());
                    LOGGER.error("The class \"{}\" was loaded by [{}] whereas object of type [{}] was loaded by [{}].", (Object)superClass.getName(), (Object)var1_1.getClassLoader(), (Object)classObj.getTypeName(), (Object)classObj.getName());
                    return defaultValue;
                }
                return classObj.newInstance();
            }
            catch (Exception e) {
                void var3_4;
                String string;
                LOGGER.error("Could not instantiate class [{}].", (Object)string, (Object)var3_4);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static String substVars(String val, Properties props) throws IllegalArgumentException {
        void var1_1;
        return OptionConverter.substVars(val, (Properties)var1_1, new ArrayList<String>());
    }

    private static String substVars(String val, Properties props, List<String> keys) throws IllegalArgumentException {
        StringBuilder sbuf = new StringBuilder();
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(125, j);
            if (k == -1) {
                throw new IllegalArgumentException(Strings.dquote((String)val) + " has no closing brace. Opening brace at position " + j + '.');
            }
            String key = val.substring(j += 2, k);
            String replacement = PropertiesUtil.getProperties().getStringProperty(key, null);
            if (replacement == null && props != null) {
                replacement = props.getProperty(key);
            }
            if (replacement != null) {
                if (!keys.contains(key)) {
                    ArrayList<String> usedKeys = new ArrayList<String>(keys);
                    usedKeys.add(key);
                    String recursiveReplacement = OptionConverter.substVars(replacement, props, usedKeys);
                    sbuf.append(recursiveReplacement);
                } else {
                    sbuf.append(replacement);
                }
            }
            int n = k + 1;
        }
    }
}

