/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectArrayIterator<E>
implements Iterator<E> {
    final E[] array;
    final int startIndex;
    final int endIndex;
    int index = 0;

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public ObjectArrayIterator(E ... array) {
        this(array, 0, ((void)var1_1).length);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectArrayIterator(E[] array, int start) {
        this(array, (int)var2_2, ((void)var1_1).length);
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectArrayIterator(E[] array, int start, int end) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("Start index must not be less than zero");
        }
        if (end > array.length) {
            throw new ArrayIndexOutOfBoundsException("End index must not be greater than the array length");
        }
        if (start > array.length) {
            throw new ArrayIndexOutOfBoundsException("Start index must not be greater than the array length");
        }
        if (end < start) {
            throw new IllegalArgumentException("End index must not be less than start index");
        }
        this.array = var1_1;
        this.startIndex = start;
        this.endIndex = var3_3;
        this.index = var2_2;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.endIndex;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.array[this.index++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method is not supported for an ObjectArrayIterator");
    }

    public E[] getArray() {
        return this.array;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void reset() {
        this.index = this.startIndex;
    }
}

