/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.ArrayUtils;
import org.apache.logging.log4j.status.StatusLogger;

public final class NetUtils {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String UNKNOWN_LOCALHOST = "UNKNOWN_LOCALHOST";

    private NetUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            if (addr == null) {
                return UNKNOWN_LOCALHOST;
            }
            return addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            void var0_1;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                if (interfaces != null) {
                    while (interfaces.hasMoreElements()) {
                        NetworkInterface networkInterface = interfaces.nextElement();
                        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            void var3_4;
                            String hostname;
                            InetAddress address = addresses.nextElement();
                            if (address.isLoopbackAddress() || (hostname = address.getHostName()) == null) continue;
                            return var3_4;
                        }
                    }
                }
            }
            catch (SocketException socketException) {}
            LOGGER.error("Could not determine local host name", (Throwable)var0_1);
            return UNKNOWN_LOCALHOST;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] getMacAddress() {
        void var0;
        byte[] mac = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            try {
                Enumeration<NetworkInterface> networkInterfaces;
                NetworkInterface localInterface = NetworkInterface.getByInetAddress(localHost);
                if (NetUtils.isUpAndNotLoopback(localInterface)) {
                    mac = localInterface.getHardwareAddress();
                }
                if (mac == null && (networkInterfaces = NetworkInterface.getNetworkInterfaces()) != null) {
                    while (networkInterfaces.hasMoreElements() && mac == null) {
                        void var3_4;
                        NetworkInterface nic = networkInterfaces.nextElement();
                        if (!NetUtils.isUpAndNotLoopback(nic)) continue;
                        mac = var3_4.getHardwareAddress();
                    }
                }
            }
            catch (SocketException e) {
                void var2_3;
                LOGGER.catching((Throwable)var2_3);
            }
            if (ArrayUtils.isEmpty(mac) && localHost != null) {
                void var1_1;
                byte[] byArray = var1_1.getAddress();
                mac = Arrays.copyOf(byArray, 6);
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    public static String getMacAddressString() {
        byte[] macAddr = NetUtils.getMacAddress();
        if (!ArrayUtils.isEmpty(macAddr)) {
            void var1_1;
            StringBuilder sb = new StringBuilder(String.format("%02x", macAddr[0]));
            for (int i = 1; i < macAddr.length; ++i) {
                sb.append(":").append(String.format("%02x", macAddr[i]));
            }
            return var1_1.toString();
        }
        return null;
    }

    private static boolean isUpAndNotLoopback(NetworkInterface ni) throws SocketException {
        NetworkInterface networkInterface;
        return ni != null && !ni.isLoopback() && networkInterface.isUp();
    }

    /*
     * WARNING - void declaration
     */
    public static URI toURI(String path) {
        try {
            return new URI(path);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                void var1_1;
                URL url = new URL(path);
                return new URI(url.getProtocol(), url.getHost(), var1_1.getPath(), null);
            }
            catch (MalformedURLException | URISyntaxException exception) {
                String string;
                return new File(string).toURI();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<URI> toURIs(String path) {
        void var2_2;
        String[] stringArray;
        String[] parts = path.split(",");
        String scheme = null;
        ArrayList<URI> uris = new ArrayList<URI>(parts.length);
        for (String part : stringArray) {
            URI uri = NetUtils.toURI(scheme != null ? scheme + ":" + part.trim() : part.trim());
            if (scheme == null && uri.getScheme() != null) {
                scheme = uri.getScheme();
            }
            uris.add(uri);
        }
        return var2_2;
    }
}

