/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.util.Log4jThread;

public class Log4jThreadFactory
implements ThreadFactory {
    private static final String PREFIX = "TF-";
    private static final AtomicInteger FACTORY_NUMBER = new AtomicInteger(1);
    private static final AtomicInteger THREAD_NUMBER = new AtomicInteger(1);
    private final boolean daemon;
    private final ThreadGroup group;
    private final int priority;
    private final String threadNamePrefix;

    public static Log4jThreadFactory createDaemonThreadFactory(String threadFactoryName) {
        String string;
        return new Log4jThreadFactory(string, true, 5);
    }

    public static Log4jThreadFactory createThreadFactory(String threadFactoryName) {
        String string;
        return new Log4jThreadFactory(string, false, 5);
    }

    /*
     * WARNING - void declaration
     */
    public Log4jThreadFactory(String threadFactoryName, boolean daemon, int priority) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.threadNamePrefix = PREFIX + FACTORY_NUMBER.getAndIncrement() + "-" + threadFactoryName + "-";
        this.daemon = var2_2;
        this.priority = var3_3;
        SecurityManager securityManager = System.getSecurityManager();
        this.group = securityManager != null ? var1_1.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Thread newThread(Runnable runnable) {
        void var1_1;
        Log4jThread thread = new Log4jThread(this.group, runnable, this.threadNamePrefix + THREAD_NUMBER.getAndIncrement(), 0L);
        if (thread.isDaemon() != this.daemon) {
            thread.setDaemon(this.daemon);
        }
        if (thread.getPriority() != this.priority) {
            thread.setPriority(this.priority);
        }
        return var1_1;
    }
}

