/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class Loader {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";

    private Loader() {
    }

    public static ClassLoader getClassLoader() {
        return Loader.getClassLoader(Loader.class, null);
    }

    public static ClassLoader getThreadContextClassLoader() {
        return LoaderUtil.getThreadContextClassLoader();
    }

    /*
     * WARNING - void declaration
     */
    public static ClassLoader getClassLoader(Class<?> class1, Class<?> class2) {
        void var1_1;
        ClassLoader loader2;
        ClassLoader threadContextClassLoader = Loader.getThreadContextClassLoader();
        ClassLoader loader1 = class1 == null ? null : class1.getClassLoader();
        ClassLoader classLoader = loader2 = class2 == null ? null : class2.getClassLoader();
        if (Loader.isChild(threadContextClassLoader, loader1)) {
            if (Loader.isChild(threadContextClassLoader, loader2)) {
                void var2_2;
                return var2_2;
            }
            return loader2;
        }
        if (Loader.isChild(loader1, loader2)) {
            ClassLoader classLoader2;
            return classLoader2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static URL getResource(String resource, ClassLoader defaultLoader) {
        String string;
        try {
            Object url;
            ClassLoader classLoader = Loader.getThreadContextClassLoader();
            if (classLoader != null) {
                LOGGER.trace("Trying to find [{}] using context class loader {}.", (Object)resource, (Object)classLoader);
                url = classLoader.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
            if ((url = Loader.class.getClassLoader()) != null) {
                LOGGER.trace("Trying to find [{}] using {} class loader.", (Object)resource, url);
                url = ((ClassLoader)url).getResource(resource);
                if (url != null) {
                    return url;
                }
            }
            if (defaultLoader != null) {
                void var1_1;
                LOGGER.trace("Trying to find [{}] using {} class loader.", (Object)resource, (Object)defaultLoader);
                url = var1_1.getResource(resource);
                if (url != null) {
                    return url;
                }
            }
        }
        catch (Throwable t) {
            void var2_3;
            LOGGER.warn(TSTR, (Throwable)var2_3);
        }
        LOGGER.trace("Trying to find [{}] using ClassLoader.getSystemResource().", (Object)resource);
        return ClassLoader.getSystemResource(string);
    }

    /*
     * WARNING - void declaration
     */
    public static InputStream getResourceAsStream(String resource, ClassLoader defaultLoader) {
        String string;
        try {
            Object is;
            ClassLoader classLoader = Loader.getThreadContextClassLoader();
            if (classLoader != null) {
                LOGGER.trace("Trying to find [{}] using context class loader {}.", (Object)resource, (Object)classLoader);
                is = classLoader.getResourceAsStream(resource);
                if (is != null) {
                    return is;
                }
            }
            if ((is = Loader.class.getClassLoader()) != null) {
                LOGGER.trace("Trying to find [{}] using {} class loader.", (Object)resource, is);
                is = ((ClassLoader)is).getResourceAsStream(resource);
                if (is != null) {
                    return is;
                }
            }
            if (defaultLoader != null) {
                void var1_1;
                LOGGER.trace("Trying to find [{}] using {} class loader.", (Object)resource, (Object)defaultLoader);
                is = var1_1.getResourceAsStream(resource);
                if (is != null) {
                    return is;
                }
            }
        }
        catch (Throwable t) {
            void var2_3;
            LOGGER.warn(TSTR, (Throwable)var2_3);
        }
        LOGGER.trace("Trying to find [{}] using ClassLoader.getSystemResource().", (Object)resource);
        return ClassLoader.getSystemResourceAsStream(string);
    }

    private static boolean isChild(ClassLoader loader1, ClassLoader loader2) {
        ClassLoader classLoader;
        if (loader1 != null && loader2 != null) {
            for (ClassLoader parent = loader1.getParent(); parent != null && parent != loader2; parent = parent.getParent()) {
            }
            return classLoader != null;
        }
        return classLoader != null;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> initializeClass(String className, ClassLoader loader) throws ClassNotFoundException {
        void var1_1;
        return Class.forName(className, true, (ClassLoader)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        if (loader != null) {
            String string;
            void var1_1;
            return var1_1.loadClass(string);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> loadSystemClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className, true, ClassLoader.getSystemClassLoader());
        }
        catch (Throwable t) {
            String string;
            void var1_1;
            LOGGER.trace("Couldn't use SystemClassLoader. Trying Class.forName({}).", (Object)className, (Object)var1_1);
            return Class.forName(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T newInstanceOf(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Object object;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Loader.getClassLoader());
            object = LoaderUtil.newInstanceOf((String)object);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (Throwable throwable) {
            void var1_2;
            Thread.currentThread().setContextClassLoader((ClassLoader)var1_2);
            throw throwable;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T newCheckedInstanceOf(String className, Class<T> clazz) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object object;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            void var1_2;
            Thread.currentThread().setContextClassLoader(Loader.getClassLoader());
            object = LoaderUtil.newCheckedInstanceOf((String)object, (Class)var1_2);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (Throwable throwable) {
            void var2_3;
            Thread.currentThread().setContextClassLoader((ClassLoader)var2_3);
            throw throwable;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T newCheckedInstanceOfProperty(String propertyName, Class<T> clazz) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Object object;
        PropertiesUtil.getProperties().getStringProperty(propertyName);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            void var1_2;
            Thread.currentThread().setContextClassLoader(Loader.getClassLoader());
            object = LoaderUtil.newCheckedInstanceOfProperty((String)object, (Class)var1_2);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        catch (Throwable throwable) {
            void var2_3;
            Thread.currentThread().setContextClassLoader((ClassLoader)var2_3);
            throw throwable;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClassAvailable(String className) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String string;
            Thread.currentThread().setContextClassLoader(Loader.getClassLoader());
            boolean bl = LoaderUtil.isClassAvailable((String)string);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            return bl;
        }
        catch (Throwable throwable) {
            void var1_3;
            Thread.currentThread().setContextClassLoader((ClassLoader)var1_3);
            throw throwable;
        }
    }

    public static boolean isJansiAvailable() {
        return Loader.isClassAvailable("org.fusesource.jansi.AnsiRenderer");
    }

    /*
     * WARNING - void declaration
     */
    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class clazz;
            Thread.currentThread().setContextClassLoader(Loader.getClassLoader());
            clazz = LoaderUtil.loadClass((String)((Object)clazz));
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            return clazz;
        }
        catch (Throwable throwable) {
            void var1_2;
            Thread.currentThread().setContextClassLoader((ClassLoader)var1_2);
            throw throwable;
        }
    }
}

