/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public final class FileUtils {
    private static final String PROTOCOL_FILE = "file";
    private static final String JBOSS_FILE = "vfsfile";
    private static final Logger LOGGER = StatusLogger.getLogger();

    private FileUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static File fileFromUri(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.isAbsolute()) {
            if (JBOSS_FILE.equals(uri.getScheme())) {
                try {
                    uri = new URI(PROTOCOL_FILE, uri.getSchemeSpecificPart(), uri.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            try {
                if (PROTOCOL_FILE.equals(uri.getScheme())) {
                    return new File(uri);
                }
            }
            catch (Exception exception) {
                LOGGER.warn("Invalid URI {}", (Object)uri);
            }
        } else {
            File file = new File(uri.toString());
            try {
                void var1_1;
                if (file.exists()) {
                    return file;
                }
                String path = uri.getPath();
                return new File((String)var1_1);
            }
            catch (Exception exception) {
                URI uRI;
                LOGGER.warn("Invalid URI {}", (Object)uRI);
            }
        }
        return null;
    }

    public static boolean isFile(URL url) {
        URL uRL;
        return url != null && (url.getProtocol().equals(PROTOCOL_FILE) || uRL.getProtocol().equals(JBOSS_FILE));
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            String string;
            Object object = string;
            return ((String)object).substring(((String)object).lastIndexOf(".") + 1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void mkdir(File dir, boolean createDirectoryIfNotExisting) throws IOException {
        void var1_1;
        if (!dir.exists() && var1_1 == false) {
            throw new IOException("The directory " + dir.getAbsolutePath() + " does not exist.");
        }
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            return;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            if (!dir.isDirectory()) {
                throw new IOException("File " + dir + " exists and is not a directory. Unable to create directory.");
            }
            return;
        }
        catch (Exception exception) {
            File file;
            throw new IOException("Could not create directory " + file.getAbsolutePath());
        }
    }

    public static void makeParentDirs(File file) throws IOException {
        File parent = Objects.requireNonNull(file, PROTOCOL_FILE).getCanonicalFile().getParentFile();
        if (parent != null) {
            File file2;
            FileUtils.mkdir(file2, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void defineFilePosixAttributeView(Path path, Set<PosixFilePermission> filePermissions, String fileOwner, String fileGroup) throws IOException {
        PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (view != null) {
            void var3_3;
            GroupPrincipal groupPrincipal;
            UserPrincipal userPrincipal;
            UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            if (fileOwner != null && (userPrincipal = lookupService.lookupPrincipalByName(fileOwner)) != null) {
                view.setOwner(userPrincipal);
            }
            if (fileGroup != null && (groupPrincipal = lookupService.lookupPrincipalByGroupName((String)var3_3)) != null) {
                void var2_2;
                view.setGroup((GroupPrincipal)var2_2);
            }
            if (filePermissions != null) {
                void var1_1;
                PosixFileAttributeView posixFileAttributeView;
                posixFileAttributeView.setPermissions((Set<PosixFilePermission>)var1_1);
            }
        }
    }

    public static boolean isFilePosixAttributeViewSupported() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }
}

