/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class ExecutorServices {
    private static final Logger LOGGER = StatusLogger.getLogger();

    /*
     * WARNING - void declaration
     */
    public static boolean shutdown(ExecutorService executorService, long timeout, TimeUnit timeUnit, String source) {
        if (executorService == null || executorService.isTerminated()) {
            return true;
        }
        executorService.shutdown();
        if (timeout > 0L && timeUnit == null) {
            throw new IllegalArgumentException(String.format("%s can't shutdown %s when timeout = %,d and timeUnit = %s.", new Object[]{source, executorService, timeout, timeUnit}));
        }
        if (timeout > 0L) {
            try {
                if (!executorService.awaitTermination(timeout, timeUnit)) {
                    executorService.shutdownNow();
                    if (!executorService.awaitTermination(timeout, timeUnit)) {
                        void var3_2;
                        void var1_1;
                        LOGGER.error("{} pool {} did not terminate after {} {}", (Object)source, (Object)executorService, (Object)((long)var1_1), (Object)var3_2);
                    }
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        } else {
            ExecutorService executorService2;
            executorService2.shutdown();
        }
        return true;
    }

    public static void ensureInitialized() {
    }
}

