/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LifeCycle2;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.status.StatusLogger;

public class DefaultShutdownCallbackRegistry
implements Runnable,
LifeCycle2,
ShutdownCallbackRegistry {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    private final AtomicReference<LifeCycle.State> state = new AtomicReference<LifeCycle.State>(LifeCycle.State.INITIALIZED);
    private final ThreadFactory threadFactory;
    private final Collection<Reference<Cancellable>> hooks = new CopyOnWriteArrayList<Reference<Cancellable>>();
    private Reference<Thread> shutdownHookRef;

    public DefaultShutdownCallbackRegistry() {
        this(Executors.defaultThreadFactory());
    }

    /*
     * WARNING - void declaration
     */
    protected DefaultShutdownCallbackRegistry(ThreadFactory threadFactory) {
        void var1_1;
        this.threadFactory = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        if (this.state.compareAndSet(LifeCycle.State.STARTED, LifeCycle.State.STOPPING)) {
            for (Reference<Cancellable> reference : this.hooks) {
                Cancellable hook = reference.get();
                if (hook == null) continue;
                try {
                    hook.run();
                }
                catch (Throwable t1) {
                    try {
                        LOGGER.error(SHUTDOWN_HOOK_MARKER, "Caught exception executing shutdown hook {}", (Object)hook, (Object)t1);
                    }
                    catch (Throwable t2) {
                        void var3_4;
                        void var2_3;
                        System.err.println("Caught exception " + var2_3.getClass() + " logging exception " + t1.getClass());
                        var3_4.printStackTrace();
                    }
                }
            }
            this.state.set(LifeCycle.State.STOPPED);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Cancellable addShutdownCallback(Runnable callback) {
        if (this.isStarted()) {
            void var1_1;
            RegisteredCancellable receipt = new RegisteredCancellable(callback, this.hooks);
            this.hooks.add(new SoftReference<RegisteredCancellable>(receipt));
            return var1_1;
        }
        throw new IllegalStateException("Cannot add new shutdown hook as this is not started. Current state: " + this.state.get().name());
    }

    @Override
    public void initialize() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        if (this.state.compareAndSet(LifeCycle.State.INITIALIZED, LifeCycle.State.STARTING)) {
            try {
                DefaultShutdownCallbackRegistry defaultShutdownCallbackRegistry = this;
                defaultShutdownCallbackRegistry.addShutdownHook(defaultShutdownCallbackRegistry.threadFactory.newThread(this));
                this.state.set(LifeCycle.State.STARTED);
                return;
            }
            catch (IllegalStateException ex) {
                this.state.set(LifeCycle.State.STOPPED);
                throw ex;
            }
            catch (Exception e) {
                void var1_2;
                LOGGER.catching((Throwable)var1_2);
                this.state.set(LifeCycle.State.STOPPED);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addShutdownHook(Thread thread) {
        void var1_1;
        this.shutdownHookRef = new WeakReference<Thread>(thread);
        Runtime.getRuntime().addShutdownHook((Thread)var1_1);
    }

    @Override
    public void stop() {
        this.stop(0L, AbstractLifeCycle.DEFAULT_STOP_TIMEUNIT);
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        if (this.state.compareAndSet(LifeCycle.State.STARTED, LifeCycle.State.STOPPING)) {
            try {
                this.removeShutdownHook();
            }
            finally {
                this.state.set(LifeCycle.State.STOPPED);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void removeShutdownHook() {
        Thread shutdownThread = this.shutdownHookRef.get();
        if (shutdownThread != null) {
            void var1_1;
            Runtime.getRuntime().removeShutdownHook((Thread)var1_1);
            this.shutdownHookRef.enqueue();
        }
    }

    @Override
    public LifeCycle.State getState() {
        return this.state.get();
    }

    @Override
    public boolean isStarted() {
        return this.state.get() == LifeCycle.State.STARTED;
    }

    @Override
    public boolean isStopped() {
        return this.state.get() == LifeCycle.State.STOPPED;
    }

    private static class RegisteredCancellable
    implements Cancellable {
        private Runnable callback;
        private Collection<Reference<Cancellable>> registered;

        /*
         * WARNING - void declaration
         */
        RegisteredCancellable(Runnable callback, Collection<Reference<Cancellable>> registered) {
            void var2_2;
            void var1_1;
            this.callback = var1_1;
            this.registered = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void cancel() {
            this.callback = null;
            Collection<Reference<Cancellable>> references = this.registered;
            if (references != null) {
                void var1_1;
                this.registered = null;
                var1_1.removeIf(ref -> {
                    void var1_1;
                    Cancellable value = (Cancellable)ref.get();
                    return value == null || var1_1 == this;
                });
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Runnable runnableHook = this.callback;
            if (runnableHook != null) {
                void var1_1;
                var1_1.run();
                this.callback = null;
            }
        }

        public String toString() {
            return String.valueOf(this.callback);
        }
    }
}

