/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.lang.reflect.Array;

public final class CyclicBuffer<T> {
    private final T[] ring;
    private int first = 0;
    private int last = 0;
    private int numElems = 0;
    private final Class<T> clazz;

    /*
     * WARNING - void declaration
     */
    public CyclicBuffer(Class<T> clazz, int size) throws IllegalArgumentException {
        void var1_1;
        void var2_2;
        if (size < 0) {
            throw new IllegalArgumentException("The maxSize argument (" + size + ") cannot be negative.");
        }
        this.ring = this.makeArray(clazz, (int)var2_2);
        this.clazz = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private T[] makeArray(Class<T> cls, int size) {
        void var2_2;
        return (Object[])Array.newInstance(cls, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void add(T item) {
        if (this.ring.length > 0) {
            void var1_1;
            this.ring[this.last] = var1_1;
            if (++this.last == this.ring.length) {
                this.last = 0;
            }
            if (this.numElems < this.ring.length) {
                ++this.numElems;
                return;
            }
            if (++this.first == this.ring.length) {
                this.first = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized T[] removeAll() {
        void var1_1;
        CyclicBuffer cyclicBuffer = this;
        T[] array = cyclicBuffer.makeArray(cyclicBuffer.clazz, this.numElems);
        int index = 0;
        while (this.numElems > 0) {
            --this.numElems;
            array[index++] = this.ring[this.first];
            this.ring[this.first] = null;
            if (++this.first != this.ring.length) continue;
            this.first = 0;
        }
        return var1_1;
    }

    public final boolean isEmpty() {
        return this.numElems == 0;
    }
}

