/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.logging.log4j.core.util.Integers;

public final class CronExpression {
    protected static final int SECOND = 0;
    protected static final int MINUTE = 1;
    protected static final int HOUR = 2;
    protected static final int DAY_OF_MONTH = 3;
    protected static final int MONTH = 4;
    protected static final int DAY_OF_WEEK = 5;
    protected static final int YEAR = 6;
    protected static final int ALL_SPEC_INT = 99;
    protected static final int NO_SPEC_INT = 98;
    protected static final Integer ALL_SPEC = 99;
    protected static final Integer NO_SPEC = 98;
    protected static final Map<String, Integer> monthMap = new HashMap<String, Integer>(20);
    protected static final Map<String, Integer> dayMap = new HashMap<String, Integer>(60);
    private final String cronExpression;
    private TimeZone timeZone = null;
    protected transient TreeSet<Integer> seconds;
    protected transient TreeSet<Integer> minutes;
    protected transient TreeSet<Integer> hours;
    protected transient TreeSet<Integer> daysOfMonth;
    protected transient TreeSet<Integer> months;
    protected transient TreeSet<Integer> daysOfWeek;
    protected transient TreeSet<Integer> years;
    protected transient boolean lastdayOfWeek = false;
    protected transient int nthdayOfWeek = 0;
    protected transient boolean lastdayOfMonth = false;
    protected transient boolean nearestWeekday = false;
    protected transient int lastdayOffset = 0;
    protected transient boolean expressionParsed = false;
    public static final int MAX_YEAR;
    public static final Calendar MIN_CAL;
    public static final Date MIN_DATE;

    /*
     * WARNING - void declaration
     */
    public CronExpression(String cronExpression) throws ParseException {
        void var1_1;
        if (cronExpression == null) {
            throw new IllegalArgumentException("cronExpression cannot be null");
        }
        this.cronExpression = var1_1.toUpperCase(Locale.US);
        CronExpression cronExpression2 = this;
        cronExpression2.buildExpression(cronExpression2.cronExpression);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSatisfiedBy(Date date) {
        void var1_1;
        void var2_2;
        Calendar testDateCal = Calendar.getInstance(this.getTimeZone());
        testDateCal.setTime(date);
        testDateCal.set(14, 0);
        Date originalDate = testDateCal.getTime();
        testDateCal.add(13, -1);
        Date timeAfter = this.getTimeAfter(testDateCal.getTime());
        return timeAfter != null && var2_2.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Date getNextValidTimeAfter(Date date) {
        void var1_1;
        return this.getTimeAfter((Date)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Date getNextInvalidTimeAfter(Date date) {
        void var1_1;
        Date newDate;
        long difference = 1000L;
        Calendar adjustCal = Calendar.getInstance(this.getTimeZone());
        adjustCal.setTime(date);
        adjustCal.set(14, 0);
        Date lastDate = adjustCal.getTime();
        while (difference == 1000L && (newDate = this.getTimeAfter(lastDate)) != null) {
            difference = newDate.getTime() - lastDate.getTime();
            if (difference != 1000L) continue;
            lastDate = newDate;
        }
        return new Date(var1_1.getTime() + 1000L);
    }

    public final TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTimeZone(TimeZone timeZone) {
        void var1_1;
        this.timeZone = var1_1;
    }

    public final String toString() {
        return this.cronExpression;
    }

    public static boolean isValidExpression(String cronExpression) {
        try {
            String string;
            new CronExpression(string);
        }
        catch (ParseException parseException) {
            return false;
        }
        return true;
    }

    public static void validateExpression(String cronExpression) throws ParseException {
        String string;
        new CronExpression(string);
    }

    /*
     * WARNING - void declaration
     */
    protected final void buildExpression(String expression) throws ParseException {
        this.expressionParsed = true;
        try {
            void var1_2;
            boolean dayOfWSpec;
            int exprOn;
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            StringTokenizer exprsTok = new StringTokenizer(expression, " \t", false);
            for (exprOn = 0; exprsTok.hasMoreTokens() && exprOn <= 6; ++exprOn) {
                String expr = exprsTok.nextToken().trim();
                if (exprOn == 3 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw new ParseException("Support for specifying 'L' and 'LW' with other days of the month is not implemented", -1);
                }
                if (exprOn == 5 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw new ParseException("Support for specifying 'L' with other days of the week is not implemented", -1);
                }
                if (exprOn == 5 && expr.indexOf(35) != -1 && expr.indexOf(35, expr.indexOf(35) + 1) != -1) {
                    throw new ParseException("Support for specifying multiple \"nth\" days is not implemented.", -1);
                }
                StringTokenizer vTok = new StringTokenizer(expr, ",");
                while (vTok.hasMoreTokens()) {
                    String v = vTok.nextToken();
                    this.storeExpressionVals(0, v, exprOn);
                }
            }
            if (exprOn <= 5) {
                throw new ParseException("Unexpected end of expression.", expression.length());
            }
            if (exprOn <= 6) {
                this.storeExpressionVals(0, "*", 6);
            }
            TreeSet<Integer> dow = this.getSet(5);
            TreeSet<Integer> treeSet = this.getSet(3);
            boolean dayOfMSpec = !treeSet.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !dow.contains(NO_SPEC);
            if (!(dayOfMSpec && !dayOfWSpec || var1_2 != false && !dayOfMSpec)) {
                throw new ParseException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.", 0);
            }
            return;
        }
        catch (ParseException parseException) {
            ParseException exprOn = parseException;
            throw parseException;
        }
        catch (Exception e) {
            void var2_5;
            throw new ParseException("Illegal cron expression format (" + var2_5.toString() + ")", 0);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final int storeExpressionVals(int pos, String s, int type) throws ParseException {
        void var1_1;
        int incr = 0;
        int i = this.skipWhiteSpace(pos, s);
        if (i >= s.length()) {
            return i;
        }
        char c = s.charAt(i);
        if (!(c < 'A' || c > 'Z' || s.equals("L") || s.equals("LW") || s.matches("^L-[0-9]*[W]?"))) {
            int sval;
            int n = i;
            String sub = s.substring(n, n + 3);
            int eval = -1;
            if (type == 4) {
                sval = this.getMonthNumber(sub) + 1;
                if (sval <= 0) {
                    throw new ParseException("Invalid Month value: '" + sub + "'", i);
                }
                if (s.length() > i + 3 && (c = s.charAt(i + 3)) == '-') {
                    int n2 = i += 4;
                    sub = s.substring(n2, n2 + 3);
                    eval = this.getMonthNumber(sub) + 1;
                    if (eval <= 0) {
                        throw new ParseException("Invalid Month value: '" + sub + "'", i);
                    }
                }
            } else {
                if (type != 5) throw new ParseException("Illegal characters for this position: '" + sub + "'", i);
                sval = this.getDayOfWeekNumber(sub);
                if (sval < 0) {
                    throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
                }
                if (s.length() > i + 3) {
                    c = s.charAt(i + 3);
                    switch (c) {
                        case '-': {
                            int n3 = i += 4;
                            sub = s.substring(n3, n3 + 3);
                            eval = this.getDayOfWeekNumber(sub);
                            if (eval < 0) {
                                throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
                            }
                            break;
                        }
                        case '#': {
                            try {
                                this.nthdayOfWeek = Integers.parseInt(s.substring(i += 4));
                                if (this.nthdayOfWeek <= 0) throw new Exception();
                                if (this.nthdayOfWeek > 5) {
                                    throw new Exception();
                                }
                                break;
                            }
                            catch (Exception exception) {
                                throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
                            }
                        }
                        case 'L': {
                            this.lastdayOfWeek = true;
                            ++i;
                            break;
                        }
                    }
                }
            }
            if (eval != -1) {
                incr = 1;
            }
            this.addToSet(sval, eval, incr, type);
            return i + 3;
        }
        switch (c) {
            case '?': {
                int sub;
                if (++i + 1 < s.length() && s.charAt(i) != ' ' && s.charAt(i + 1) != '\t') {
                    throw new ParseException("Illegal character after '?': " + s.charAt(i), i);
                }
                if (type != 5 && type != 3) {
                    throw new ParseException("'?' can only be specfied for Day-of-Month or Day-of-Week.", i);
                }
                if (type == 5 && !this.lastdayOfMonth && (sub = this.daysOfMonth.last().intValue()) == 98) {
                    throw new ParseException("'?' can only be specfied for Day-of-Month -OR- Day-of-Week.", i);
                }
                this.addToSet(98, -1, 0, type);
                return i;
            }
            case '*': 
            case '/': {
                if (c == '*' && i + 1 >= s.length()) {
                    this.addToSet(99, -1, 0, type);
                    return i + 1;
                }
                if (c == '/') {
                    if (i + 1 >= s.length()) throw new ParseException("'/' must be followed by an integer.", i);
                    if (s.charAt(i + 1) == ' ') throw new ParseException("'/' must be followed by an integer.", i);
                    if (s.charAt(i + 1) == '\t') {
                        throw new ParseException("'/' must be followed by an integer.", i);
                    }
                }
                if (c == '*') {
                    ++i;
                }
                if ((c = s.charAt(i)) == '/') {
                    if (++i >= s.length()) {
                        throw new ParseException("Unexpected end of string.", i);
                    }
                    incr = this.getNumericValue(s, i);
                    ++i;
                    if (incr > 10) {
                        ++i;
                    }
                    if (incr > 59) {
                        if (type == 0) throw new ParseException("Increment > 60 : " + incr, i);
                        if (type == 1) {
                            throw new ParseException("Increment > 60 : " + incr, i);
                        }
                    }
                    if (incr > 23 && type == 2) {
                        throw new ParseException("Increment > 24 : " + incr, i);
                    }
                    if (incr > 31 && type == 3) {
                        throw new ParseException("Increment > 31 : " + incr, i);
                    }
                    if (incr > 7 && type == 5) {
                        throw new ParseException("Increment > 7 : " + incr, i);
                    }
                    if (incr > 12 && type == 4) {
                        throw new ParseException("Increment > 12 : " + incr, i);
                    }
                } else {
                    incr = 1;
                }
                this.addToSet(99, -1, incr, type);
                return i;
            }
            case 'L': {
                ++i;
                if (type == 3) {
                    this.lastdayOfMonth = true;
                }
                if (type == 5) {
                    this.addToSet(7, 7, 0, type);
                }
                if (type != 3) return i;
                if (s.length() <= i) return i;
                c = s.charAt(i);
                if (c == '-') {
                    ValueSet vs = this.getValue(0, s, i + 1);
                    this.lastdayOffset = vs.value;
                    if (this.lastdayOffset > 30) {
                        throw new ParseException("Offset from last day must be <= 30", i + 1);
                    }
                    i = vs.pos;
                }
                if (s.length() <= i) return i;
                c = s.charAt(i);
                if (c != 'W') return i;
                this.nearestWeekday = true;
                ++i;
                return i;
            }
        }
        if (c < '0') throw new ParseException("Unexpected character: " + c, i);
        if (c > '9') throw new ParseException("Unexpected character: " + c, i);
        int val = Integer.parseInt(String.valueOf(c));
        if (++i < s.length()) {
            void var3_3;
            void var2_2;
            c = s.charAt(i);
            if (c < '0') return this.checkNext(i, (String)var2_2, val, (int)var3_3);
            if (c > '9') return this.checkNext(i, (String)var2_2, val, (int)var3_3);
            ValueSet vs = this.getValue(val, s, i);
            val = vs.value;
            i = vs.pos;
            return this.checkNext(i, (String)var2_2, val, (int)var3_3);
        }
        this.addToSet(val, -1, -1, type);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final int checkNext(int pos2, String s, int val, int type) throws ParseException {
        void var3_6;
        int n;
        int i = pos2;
        if (i >= s.length()) {
            this.addToSet(val, -1, -1, type);
            return i;
        }
        char c = s.charAt(pos2);
        if (c == 'L') {
            if (type == 5) {
                if (val <= 0 || val > 7) {
                    throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
                }
            } else {
                throw new ParseException("'L' option is not valid here. (pos=" + i + ")", i);
            }
            this.lastdayOfWeek = true;
            TreeSet<Integer> pos2 = this.getSet(type);
            pos2.add(val);
            return ++i;
        }
        if (c == 'W') {
            if (type != 3) {
                throw new ParseException("'W' option is not valid here. (pos=" + i + ")", i);
            }
            this.nearestWeekday = true;
            if (val > 31) {
                throw new ParseException("The 'W' option does not make sense with values larger than 31 (max number of days in a month)", i);
            }
            TreeSet<Integer> pos2 = this.getSet(type);
            pos2.add(val);
            return ++i;
        }
        switch (c) {
            case '#': {
                if (type != 5) {
                    throw new ParseException("'#' option is not valid here. (pos=" + i + ")", i);
                }
                ++i;
                try {
                    this.nthdayOfWeek = Integers.parseInt(s.substring(i));
                    if (this.nthdayOfWeek <= 0 || this.nthdayOfWeek > 5) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
                }
                TreeSet<Integer> pos2 = this.getSet(type);
                pos2.add(val);
                return ++i;
            }
            case '-': {
                void var1_1;
                int v3;
                ValueSet vs;
                int v;
                c = s.charAt(++i);
                int end = v = Integer.parseInt(String.valueOf(c));
                if (++i >= s.length()) {
                    this.addToSet(val, end, 1, type);
                    return i;
                }
                c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs2 = this.getValue(v, s, i);
                    end = vs2.value;
                    i = vs2.pos;
                }
                if (i < s.length() && s.charAt(i) == '/') {
                    c = s.charAt(++i);
                    int v2 = Integer.parseInt(String.valueOf(c));
                    if (++i >= s.length()) {
                        this.addToSet(val, end, v2, type);
                        return i;
                    }
                    c = s.charAt(i);
                    if (c >= '0' && c <= '9') {
                        vs = this.getValue(v2, s, i);
                        v3 = vs.value;
                        this.addToSet(val, end, v3, type);
                        v3 = vs.pos;
                    } else {
                        this.addToSet(val, end, v2, type);
                    }
                    return v3;
                }
                this.addToSet(val, (int)var1_1, 1, type);
                return v3;
            }
            case '/': {
                int v3;
                ValueSet vs;
                c = ((String)((Object)vs)).charAt(++v3);
                int v2 = Integer.parseInt(String.valueOf(c));
                if (++v3 >= ((String)((Object)vs)).length()) {
                    this.addToSet(val, -1, v2, type);
                    return v3;
                }
                c = ((String)((Object)vs)).charAt(v3);
                if (c >= '0' && c <= '9') {
                    void var2_5;
                    vs = this.getValue(v2, (String)((Object)vs), v3);
                    v3 = vs.value;
                    this.addToSet(val, -1, v3, type);
                    n = var2_5.pos;
                    return n;
                }
                throw new ParseException("Unexpected character '" + c + "' after '/'", n);
            }
        }
        this.addToSet((int)var3_6, -1, 0, type);
        return ++n;
    }

    public final String getCronExpression() {
        return this.cronExpression;
    }

    /*
     * WARNING - void declaration
     */
    public final String getExpressionSummary() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        buf.append("seconds: ");
        CronExpression cronExpression = this;
        buf.append(cronExpression.getExpressionSetSummary(cronExpression.seconds));
        buf.append("\n");
        buf.append("minutes: ");
        CronExpression cronExpression2 = this;
        buf.append(cronExpression2.getExpressionSetSummary(cronExpression2.minutes));
        buf.append("\n");
        buf.append("hours: ");
        CronExpression cronExpression3 = this;
        buf.append(cronExpression3.getExpressionSetSummary(cronExpression3.hours));
        buf.append("\n");
        buf.append("daysOfMonth: ");
        CronExpression cronExpression4 = this;
        buf.append(cronExpression4.getExpressionSetSummary(cronExpression4.daysOfMonth));
        buf.append("\n");
        buf.append("months: ");
        CronExpression cronExpression5 = this;
        buf.append(cronExpression5.getExpressionSetSummary(cronExpression5.months));
        buf.append("\n");
        buf.append("daysOfWeek: ");
        CronExpression cronExpression6 = this;
        buf.append(cronExpression6.getExpressionSetSummary(cronExpression6.daysOfWeek));
        buf.append("\n");
        buf.append("lastdayOfWeek: ");
        buf.append(this.lastdayOfWeek);
        buf.append("\n");
        buf.append("nearestWeekday: ");
        buf.append(this.nearestWeekday);
        buf.append("\n");
        buf.append("NthDayOfWeek: ");
        buf.append(this.nthdayOfWeek);
        buf.append("\n");
        buf.append("lastdayOfMonth: ");
        buf.append(this.lastdayOfMonth);
        buf.append("\n");
        buf.append("years: ");
        CronExpression cronExpression7 = this;
        buf.append(cronExpression7.getExpressionSetSummary(cronExpression7.years));
        buf.append("\n");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected final String getExpressionSetSummary(Set<Integer> set) {
        void var2_2;
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = set.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer n = itr.next();
            String val = n.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected final String getExpressionSetSummary(ArrayList<Integer> list) {
        void var2_2;
        if (list.contains(NO_SPEC)) {
            return "?";
        }
        if (list.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = list.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer n = itr.next();
            String val = n.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected final int skipWhiteSpace(int i, String s) {
        void var1_1;
        while (i < s.length() && (s.charAt(i) == ' ' || s.charAt(i) == '\t')) {
            ++i;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final int findNextWhiteSpace(int i, String s) {
        void var1_1;
        while (i < s.length() && (s.charAt(i) != ' ' || s.charAt(i) != '\t')) {
            ++i;
        }
        return (int)var1_1;
    }

    protected final void addToSet(int val, int end, int incr, int type) throws ParseException {
        int stopAt;
        TreeSet<Integer> set = this.getSet(type);
        switch (type) {
            case 0: 
            case 1: {
                if (val >= 0 && val <= 59 && end <= 59 || val == 99) break;
                throw new ParseException("Minute and Second values must be between 0 and 59", -1);
            }
            case 2: {
                if (val >= 0 && val <= 23 && end <= 23 || val == 99) break;
                throw new ParseException("Hour values must be between 0 and 23", -1);
            }
            case 3: {
                if (val > 0 && val <= 31 && end <= 31 || val == 99 || val == 98) break;
                throw new ParseException("Day of month values must be between 1 and 31", -1);
            }
            case 4: {
                if (val > 0 && val <= 12 && end <= 12 || val == 99) break;
                throw new ParseException("Month values must be between 1 and 12", -1);
            }
            case 5: {
                if (val != 0 && val <= 7 && end <= 7 || val == 99 || val == 98) break;
                throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
            }
        }
        if ((incr == 0 || incr == -1) && val != 99) {
            if (val != -1) {
                set.add(val);
                return;
            }
            set.add(NO_SPEC);
            return;
        }
        int startAt = val;
        if (val == 99 && incr <= 0) {
            incr = 1;
            set.add(ALL_SPEC);
        }
        switch (type) {
            case 0: 
            case 1: {
                if (stopAt == -1) {
                    stopAt = 59;
                }
                if (startAt != -1 && startAt != 99) break;
                startAt = 0;
                break;
            }
            case 2: {
                if (stopAt == -1) {
                    stopAt = 23;
                }
                if (startAt != -1 && startAt != 99) break;
                startAt = 0;
                break;
            }
            case 3: {
                if (stopAt == -1) {
                    stopAt = 31;
                }
                if (startAt != -1 && startAt != 99) break;
                startAt = 1;
                break;
            }
            case 4: {
                if (stopAt == -1) {
                    stopAt = 12;
                }
                if (startAt != -1 && startAt != 99) break;
                startAt = 1;
                break;
            }
            case 5: {
                if (stopAt == -1) {
                    stopAt = 7;
                }
                if (startAt != -1 && startAt != 99) break;
                startAt = 1;
                break;
            }
            case 6: {
                if (stopAt == -1) {
                    stopAt = MAX_YEAR;
                }
                if (startAt != -1 && startAt != 99) break;
                startAt = 1970;
            }
        }
        int max = -1;
        if (stopAt < startAt) {
            switch (type) {
                case 0: {
                    max = 60;
                    break;
                }
                case 1: {
                    max = 60;
                    break;
                }
                case 2: {
                    max = 24;
                    break;
                }
                case 4: {
                    max = 12;
                    break;
                }
                case 5: {
                    max = 7;
                    break;
                }
                case 3: {
                    max = 31;
                    break;
                }
                case 6: {
                    throw new IllegalArgumentException("Start year must be less than stop year");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type encountered");
                }
            }
            stopAt += max;
        }
        for (int i = startAt; i <= stopAt; i += incr) {
            if (max == -1) {
                set.add(i);
                continue;
            }
            int i2 = i % max;
            if (i2 == 0 && (type == 4 || type == 5 || type == 3)) {
                i2 = max;
            }
            set.add(i2);
        }
    }

    final TreeSet<Integer> getSet(int type) {
        switch (type) {
            case 0: {
                return this.seconds;
            }
            case 1: {
                return this.minutes;
            }
            case 2: {
                return this.hours;
            }
            case 3: {
                return this.daysOfMonth;
            }
            case 4: {
                return this.months;
            }
            case 5: {
                return this.daysOfWeek;
            }
            case 6: {
                return this.years;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected final ValueSet getValue(int v, String s, int i) {
        void var1_2;
        void var3_4;
        void var2_3;
        char c = s.charAt(i);
        StringBuilder s1 = new StringBuilder(String.valueOf(v));
        while (c >= '0' && c <= '9') {
            s1.append(c);
            if (++i >= s.length()) break;
            c = s.charAt(i);
        }
        ValueSet val = new ValueSet();
        new ValueSet().pos = i < var2_3.length() ? i : var3_4 + true;
        val.value = Integers.parseInt(var1_2.toString());
        return val;
    }

    /*
     * WARNING - void declaration
     */
    protected final int getNumericValue(String s, int i) {
        void var3_3;
        void var2_2;
        String string;
        int endOfVal = this.findNextWhiteSpace(i, s);
        string = string.substring((int)var2_2, (int)var3_3);
        return Integers.parseInt(string);
    }

    /*
     * WARNING - void declaration
     */
    protected final int getMonthNumber(String s) {
        void var1_1;
        Integer integer = monthMap.get(s);
        if (integer == null) {
            return -1;
        }
        return var1_1.intValue();
    }

    /*
     * WARNING - void declaration
     */
    protected final int getDayOfWeekNumber(String s) {
        void var1_1;
        Integer integer = dayMap.get(s);
        if (integer == null) {
            return -1;
        }
        return var1_1.intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final Date getTimeAfter(Date afterTime) {
        void var2_2;
        GregorianCalendar cl = new GregorianCalendar(this.getTimeZone());
        afterTime = new Date(afterTime.getTime() + 1000L);
        cl.setTime(afterTime);
        cl.set(14, 0);
        boolean gotOne = false;
        while (!gotOne) {
            void dow22;
            int lastDay;
            boolean dayOfWSpec;
            if (cl.get(1) > 2999) {
                return null;
            }
            int sec22 = cl.get(13);
            int min = cl.get(12);
            SortedSet<Integer> st = this.seconds.tailSet(sec22);
            if (st != null && st.size() != 0) {
                sec22 = st.first();
            } else {
                sec22 = this.seconds.first();
                cl.set(12, ++min);
            }
            cl.set(13, sec22);
            min = cl.get(12);
            int hr = cl.get(11);
            int t = -1;
            st = this.minutes.tailSet(min);
            if (st != null && st.size() != 0) {
                t = min;
                min = st.first();
            } else {
                min = this.minutes.first();
                ++hr;
            }
            if (min != t) {
                cl.set(13, 0);
                cl.set(12, min);
                this.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(12, min);
            hr = cl.get(11);
            int day = cl.get(5);
            t = -1;
            st = this.hours.tailSet(hr);
            if (st != null && st.size() != 0) {
                t = hr;
                hr = st.first();
            } else {
                hr = this.hours.first();
                ++day;
            }
            if (hr != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(5, day);
                this.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(11, hr);
            day = cl.get(5);
            int mon = cl.get(2) + 1;
            t = -1;
            int tmon = mon;
            boolean dayOfMSpec2 = !this.daysOfMonth.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
            if (dayOfMSpec2 && !dayOfWSpec) {
                void dow22;
                int ldom;
                SortedSet<Integer> dayOfMSpec2 = this.daysOfMonth.tailSet(day);
                if (this.lastdayOfMonth) {
                    if (!this.nearestWeekday) {
                        t = day;
                        day = this.getLastDayOfMonth(mon, cl.get(1));
                        if (t > (day -= this.lastdayOffset)) {
                            if (++mon > 12) {
                                mon = 1;
                                tmon = 3333;
                                ((Calendar)cl).add(1, 1);
                            }
                            day = 1;
                        }
                    } else {
                        t = day;
                        day = this.getLastDayOfMonth(mon, cl.get(1));
                        Calendar tcal = Calendar.getInstance(this.getTimeZone());
                        tcal.set(13, 0);
                        tcal.set(12, 0);
                        tcal.set(11, 0);
                        tcal.set(5, day -= this.lastdayOffset);
                        tcal.set(2, mon - 1);
                        tcal.set(1, cl.get(1));
                        ldom = this.getLastDayOfMonth(mon, cl.get(1));
                        int dow3 = tcal.get(7);
                        if (dow3 == 7 && day == 1) {
                            day += 2;
                        } else if (dow3 == 7) {
                            --day;
                        } else if (dow3 == 1 && day == ldom) {
                            day -= 2;
                        } else if (dow3 == 1) {
                            ++day;
                        }
                        tcal.set(13, sec22);
                        tcal.set(12, min);
                        tcal.set(11, hr);
                        tcal.set(5, day);
                        tcal.set(2, mon - 1);
                        Date sec22 = tcal.getTime();
                        if (sec22.before(afterTime)) {
                            day = 1;
                            ++mon;
                        }
                    }
                } else if (this.nearestWeekday) {
                    t = day;
                    day = this.daysOfMonth.first();
                    Calendar tcal = Calendar.getInstance(this.getTimeZone());
                    tcal.set(13, 0);
                    tcal.set(12, 0);
                    tcal.set(11, 0);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    tcal.set(1, cl.get(1));
                    ldom = this.getLastDayOfMonth(mon, cl.get(1));
                    int dow22 = tcal.get(7);
                    if (dow22 == 7 && day == 1) {
                        day += 2;
                    } else if (dow22 == 7) {
                        --day;
                    } else if (dow22 == 1 && day == ldom) {
                        day -= 2;
                    } else if (dow22 == 1) {
                        ++day;
                    }
                    tcal.set(13, sec22);
                    tcal.set(12, min);
                    tcal.set(11, hr);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    Date sec22 = tcal.getTime();
                    if (sec22.before(afterTime)) {
                        day = this.daysOfMonth.first();
                        ++mon;
                    }
                } else if (dow22 != null && dow22.size() != 0) {
                    t = day;
                    day = (Integer)dow22.first();
                    if (day > (lastDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        day = this.daysOfMonth.first();
                        ++mon;
                    }
                } else {
                    day = this.daysOfMonth.first();
                    ++mon;
                }
                if (day != t || mon != tmon) {
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    cl.set(5, day);
                    cl.set(2, mon - 1);
                    continue;
                }
            } else if (lastDay != 0 && dow22 == false) {
                int lDay;
                int daysToAdd;
                int cDow;
                int dow4;
                if (this.lastdayOfWeek) {
                    dow4 = this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow4) {
                        daysToAdd = dow4 - cDow;
                    }
                    if (cDow > dow4) {
                        daysToAdd = dow4 + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    while (day + daysToAdd + 7 <= lDay) {
                        daysToAdd += 7;
                    }
                    day += daysToAdd;
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else if (this.nthdayOfWeek != 0) {
                    dow4 = this.daysOfWeek.first();
                    cDow = cl.get(7);
                    daysToAdd = 0;
                    if (cDow < dow4) {
                        daysToAdd = dow4 - cDow;
                    } else if (cDow > dow4) {
                        daysToAdd = dow4 + (7 - cDow);
                    }
                    boolean dayShifted = false;
                    if (daysToAdd > 0) {
                        dayShifted = true;
                    }
                    int weekOfMonth = (day += daysToAdd) / 7;
                    if (day % 7 > 0) {
                        ++weekOfMonth;
                    }
                    if ((daysToAdd = (this.nthdayOfWeek - weekOfMonth) * 7) < 0 || (day += daysToAdd) > this.getLastDayOfMonth(mon, cl.get(1))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0 || dayShifted) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else {
                    int cDow2 = cl.get(7);
                    int dow5 = this.daysOfWeek.first();
                    SortedSet<Integer> daysToAdd2 = this.daysOfWeek.tailSet(cDow2);
                    if (daysToAdd2 != null && daysToAdd2.size() > 0) {
                        dow5 = daysToAdd2.first();
                    }
                    int daysToAdd22 = 0;
                    if (cDow2 < dow5) {
                        daysToAdd22 = dow5 - cDow2;
                    }
                    if (cDow2 > dow5) {
                        daysToAdd22 = dow5 + (7 - cDow2);
                    }
                    if (day + daysToAdd22 > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd22 > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day + daysToAdd22);
                        cl.set(2, mon - 1);
                        continue;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
            }
            cl.set(5, day);
            mon = cl.get(2) + 1;
            int year = cl.get(1);
            t = -1;
            if (year > MAX_YEAR) {
                return null;
            }
            SortedSet<Integer> sortedSet = this.months.tailSet(mon);
            if (sortedSet != null && sortedSet.size() != 0) {
                t = mon;
                mon = sortedSet.first();
            } else {
                mon = this.months.first();
                ++year;
            }
            if (mon != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, mon - 1);
                cl.set(1, year);
                continue;
            }
            cl.set(2, mon - 1);
            year = cl.get(1);
            sortedSet = this.years.tailSet(year);
            if (sortedSet == null || sortedSet.size() == 0) {
                return null;
            }
            t = year;
            year = sortedSet.first();
            if (year != t) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, 0);
                cl.set(1, year);
                continue;
            }
            cl.set(1, year);
            gotOne = true;
        }
        return var2_2.getTime();
    }

    /*
     * WARNING - void declaration
     */
    protected final void setCalendarHour(Calendar cal, int hour) {
        cal.set(11, hour);
        if (cal.get(11) != hour && hour != 24) {
            void var2_2;
            void var1_1;
            var1_1.set(11, (int)(var2_2 + true));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final Date getTimeBefore(Date targetDate) {
        void var3_4;
        Date prevFireTime;
        Date targetDateNoMs;
        Calendar cl = Calendar.getInstance(this.getTimeZone());
        cl.setTime(targetDate);
        cl.set(14, 0);
        Date start = targetDateNoMs = cl.getTime();
        long minIncrement = this.findMinIncrement();
        do {
            Date prevCheckDate;
            if ((prevFireTime = this.getTimeAfter(prevCheckDate = new Date(start.getTime() - minIncrement))) != null && !prevFireTime.before(MIN_DATE)) continue;
            return null;
        } while (prevFireTime.compareTo(targetDateNoMs) >= 0);
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public final Date getPrevFireTime(Date targetDate) {
        void var1_1;
        return this.getTimeBefore((Date)var1_1);
    }

    private long findMinIncrement() {
        if (this.seconds.size() != 1) {
            CronExpression cronExpression = this;
            return cronExpression.minInSet(cronExpression.seconds) * 1000;
        }
        if (this.seconds.first() == 99) {
            return 1000L;
        }
        if (this.minutes.size() != 1) {
            CronExpression cronExpression = this;
            return cronExpression.minInSet(cronExpression.minutes) * 60000;
        }
        if (this.minutes.first() == 99) {
            return 60000L;
        }
        if (this.hours.size() != 1) {
            CronExpression cronExpression = this;
            return cronExpression.minInSet(cronExpression.hours) * 3600000;
        }
        if (this.hours.first() == 99) {
            return 3600000L;
        }
        return 86400000L;
    }

    /*
     * WARNING - void declaration
     */
    private int minInSet(TreeSet<Integer> set) {
        void var3_3;
        Iterator iterator;
        int previous = 0;
        int min = Integer.MAX_VALUE;
        boolean first = true;
        iterator = ((TreeSet)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            if (first) {
                previous = value;
                first = false;
                continue;
            }
            int diff = value - previous;
            if (diff >= min) continue;
            min = diff;
        }
        return (int)var3_3;
    }

    public final Date getFinalFireTime() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean isLeapYear(int year) {
        void var1_1;
        return year % 4 == 0 && year % 100 != 0 || var1_1 % 400 == false;
    }

    /*
     * WARNING - void declaration
     */
    protected final int getLastDayOfMonth(int monthNum, int year) {
        void var1_1;
        switch (monthNum) {
            case 1: {
                return 31;
            }
            case 2: {
                void var2_2;
                if (this.isLeapYear((int)var2_2)) {
                    return 29;
                }
                return 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + (int)var1_1);
    }

    static {
        monthMap.put("JAN", 0);
        monthMap.put("FEB", 1);
        monthMap.put("MAR", 2);
        monthMap.put("APR", 3);
        monthMap.put("MAY", 4);
        monthMap.put("JUN", 5);
        monthMap.put("JUL", 6);
        monthMap.put("AUG", 7);
        monthMap.put("SEP", 8);
        monthMap.put("OCT", 9);
        monthMap.put("NOV", 10);
        monthMap.put("DEC", 11);
        dayMap.put("SUN", 1);
        dayMap.put("MON", 2);
        dayMap.put("TUE", 3);
        dayMap.put("WED", 4);
        dayMap.put("THU", 5);
        dayMap.put("FRI", 6);
        dayMap.put("SAT", 7);
        MAX_YEAR = Calendar.getInstance().get(1) + 100;
        MIN_CAL = Calendar.getInstance();
        MIN_CAL.set(1970, 0, 1);
        MIN_DATE = MIN_CAL.getTime();
    }

    private class ValueSet {
        public int value;
        public int pos;

        private ValueSet() {
        }
    }
}

