/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.util.List;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationListener;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.util.Log4jThreadFactory;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.Watcher;

public abstract class AbstractWatcher
implements Watcher {
    private final Reconfigurable reconfigurable;
    private final List<ConfigurationListener> configurationListeners;
    private final Log4jThreadFactory threadFactory;
    private final Configuration configuration;
    private Source source;

    /*
     * WARNING - void declaration
     */
    public AbstractWatcher(Configuration configuration, Reconfigurable reconfigurable, List<ConfigurationListener> configurationListeners) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.configuration = var1_1;
        this.reconfigurable = var2_2;
        this.configurationListeners = configurationListeners;
        this.threadFactory = var3_3 != null ? Log4jThreadFactory.createDaemonThreadFactory("ConfigurationFileWatcher") : null;
    }

    @Override
    public List<ConfigurationListener> getListeners() {
        return this.configurationListeners;
    }

    @Override
    public void modified() {
        for (ConfigurationListener configurationListener : this.configurationListeners) {
            Thread thread;
            thread = this.threadFactory.newThread(new ReconfigurationRunnable((ConfigurationListener)((Object)thread), this.reconfigurable));
            thread.start();
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public abstract long getLastModified();

    @Override
    public abstract boolean isModified();

    /*
     * WARNING - void declaration
     */
    @Override
    public void watching(Source source) {
        void var1_1;
        this.source = var1_1;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    public static class ReconfigurationRunnable
    implements Runnable {
        private final ConfigurationListener configurationListener;
        private final Reconfigurable reconfigurable;

        /*
         * WARNING - void declaration
         */
        public ReconfigurationRunnable(ConfigurationListener configurationListener, Reconfigurable reconfigurable) {
            void var2_2;
            void var1_1;
            this.configurationListener = var1_1;
            this.reconfigurable = var2_2;
        }

        @Override
        public void run() {
            this.configurationListener.onChange(this.reconfigurable);
        }
    }
}

