/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.tools.picocli;

import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Time;
import java.text.BreakIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.util.Integers;

public class CommandLine {
    public static final String VERSION = "2.0.3";
    private final Tracer tracer = new Tracer();
    private final Interpreter interpreter;
    private String commandName = "<main class>";
    private boolean overwrittenOptionsAllowed = false;
    private boolean unmatchedArgumentsAllowed = false;
    private final List<String> unmatchedArguments = new ArrayList<String>();
    private CommandLine parent;
    private boolean usageHelpRequested;
    private boolean versionHelpRequested;
    private final List<String> versionLines = new ArrayList<String>();

    /*
     * WARNING - void declaration
     */
    public CommandLine(Object command) {
        void var1_1;
        this.interpreter = new Interpreter(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CommandLine addSubcommand(String name, Object command) {
        void var2_2;
        void var1_1;
        CommandLine commandLine = CommandLine.toCommandLine(command);
        CommandLine.toCommandLine(command).parent = this;
        this.interpreter.commands.put(var1_1, var2_2);
        return this;
    }

    public Map<String, CommandLine> getSubcommands() {
        return new LinkedHashMap<String, CommandLine>(this.interpreter.commands);
    }

    public CommandLine getParent() {
        return this.parent;
    }

    public <T> T getCommand() {
        return (T)this.interpreter.command;
    }

    public boolean isUsageHelpRequested() {
        return this.usageHelpRequested;
    }

    public boolean isVersionHelpRequested() {
        return this.versionHelpRequested;
    }

    public boolean isOverwrittenOptionsAllowed() {
        return this.overwrittenOptionsAllowed;
    }

    public CommandLine setOverwrittenOptionsAllowed(boolean newValue) {
        this.overwrittenOptionsAllowed = newValue;
        for (CommandLine commandLine : this.interpreter.commands.values()) {
            commandLine.setOverwrittenOptionsAllowed(newValue);
        }
        return this;
    }

    public boolean isUnmatchedArgumentsAllowed() {
        return this.unmatchedArgumentsAllowed;
    }

    public CommandLine setUnmatchedArgumentsAllowed(boolean newValue) {
        this.unmatchedArgumentsAllowed = newValue;
        for (CommandLine commandLine : this.interpreter.commands.values()) {
            commandLine.setUnmatchedArgumentsAllowed(newValue);
        }
        return this;
    }

    public List<String> getUnmatchedArguments() {
        return this.unmatchedArguments;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T populateCommand(T command, String ... args) {
        T t;
        void var1_1;
        CommandLine commandLine = CommandLine.toCommandLine(command);
        commandLine.parse((String[])var1_1);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    public List<CommandLine> parse(String ... args) {
        void var1_1;
        return this.interpreter.parse((String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean printHelpIfRequested(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
        for (CommandLine parsed : parsedCommands) {
            void var3_3;
            if (parsed.isUsageHelpRequested()) {
                parsed.usage(out, ansi);
                return true;
            }
            if (!parsed.isVersionHelpRequested()) continue;
            var3_3.printVersionHelp(out, ansi);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Object execute(CommandLine parsed) {
        void var1_1;
        CommandLine commandLine;
        Object command = parsed.getCommand();
        if (command instanceof Runnable) {
            try {
                ((Runnable)command).run();
                return null;
            }
            catch (Exception ex) {
                throw new ExecutionException(parsed, "Error while running command (" + command + ")", ex);
            }
        }
        if (command instanceof Callable) {
            try {
                return ((Callable)command).call();
            }
            catch (Exception ex) {
                void var2_3;
                throw new ExecutionException(parsed, "Error while calling command (" + command + ")", (Exception)var2_3);
            }
        }
        throw new ExecutionException(commandLine, "Parsed command (" + var1_1 + ") is not Runnable or Callable");
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> parseWithHandler(IParseResultHandler handler, PrintStream out, String ... args) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.parseWithHandlers((IParseResultHandler)var1_1, (PrintStream)var2_2, Help.Ansi.AUTO, new DefaultExceptionHandler(), (String[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> parseWithHandlers(IParseResultHandler handler, PrintStream out, Help.Ansi ansi, IExceptionHandler exceptionHandler, String ... args) {
        try {
            void var1_1;
            List<CommandLine> result = this.parse(args);
            return var1_1.handleParseResult(result, out, ansi);
        }
        catch (ParameterException ex) {
            void var3_3;
            void var2_2;
            return exceptionHandler.handleException(ex, (PrintStream)var2_2, (Help.Ansi)var3_3, args);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void usage(Object command, PrintStream out) {
        void var1_1;
        CommandLine.toCommandLine(command).usage((PrintStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void usage(Object command, PrintStream out, Help.Ansi ansi) {
        void var2_2;
        void var1_1;
        CommandLine.toCommandLine(command).usage((PrintStream)var1_1, (Help.Ansi)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void usage(Object command, PrintStream out, Help.ColorScheme colorScheme) {
        void var2_2;
        void var1_1;
        CommandLine.toCommandLine(command).usage((PrintStream)var1_1, (Help.ColorScheme)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void usage(PrintStream out) {
        void var1_1;
        this.usage((PrintStream)var1_1, Help.Ansi.AUTO);
    }

    /*
     * WARNING - void declaration
     */
    public void usage(PrintStream out, Help.Ansi ansi) {
        void var2_2;
        void var1_1;
        this.usage((PrintStream)var1_1, Help.defaultColorScheme((Help.Ansi)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void usage(PrintStream out, Help.ColorScheme colorScheme) {
        void var2_2;
        void var1_1;
        Help help = new Help(this.interpreter.command, colorScheme).addAllSubcommands(this.getSubcommands());
        if (!"=".equals(this.getSeparator())) {
            help.separator = this.getSeparator();
            help.parameterLabelRenderer = help.createDefaultParamLabelRenderer();
        }
        if (!"<main class>".equals(this.getCommandName())) {
            help.commandName = this.getCommandName();
        }
        Help help2 = help;
        StringBuilder sb = new StringBuilder().append(help.headerHeading(new Object[0])).append(help.header(new Object[0])).append(help.synopsisHeading(new Object[0])).append(help2.synopsis(help2.synopsisHeadingLength())).append(help.descriptionHeading(new Object[0])).append(help.description(new Object[0])).append(help.parameterListHeading(new Object[0])).append(help.parameterList()).append(help.optionListHeading(new Object[0])).append(help.optionList()).append(help.commandListHeading(new Object[0])).append(help.commandList()).append(help.footerHeading(new Object[0])).append(help.footer(new Object[0]));
        var1_1.print(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void printVersionHelp(PrintStream out) {
        void var1_1;
        this.printVersionHelp((PrintStream)var1_1, Help.Ansi.AUTO);
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi) {
        for (String versionInfo : this.versionLines) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(new Help.Ansi.Text(ansi2, versionInfo));
        }
    }

    public void printVersionHelp(PrintStream out, Help.Ansi ansi, Object ... params) {
        for (String versionInfo : this.versionLines) {
            Help.Ansi ansi2 = ansi;
            ((Object)((Object)ansi2)).getClass();
            out.println(new Help.Ansi.Text(ansi2, String.format(versionInfo, params)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, String ... args) {
        void var2_2;
        void var1_1;
        return CommandLine.call(callable, (PrintStream)var1_1, Help.Ansi.AUTO, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Callable<T>, T> T call(C callable, PrintStream out, Help.Ansi ansi, String ... args) {
        List<Object> list;
        void var3_3;
        void var2_2;
        void var1_1;
        List<Object> results = ((CommandLine)(callable = new CommandLine(callable))).parseWithHandlers(new RunLast(), (PrintStream)var1_1, (Help.Ansi)var2_2, new DefaultExceptionHandler(), (String[])var3_3);
        if (results == null || results.isEmpty()) {
            return null;
        }
        return (T)list.get(0);
    }

    /*
     * WARNING - void declaration
     */
    public static <R extends Runnable> void run(R runnable, PrintStream out, String ... args) {
        void var2_2;
        void var1_1;
        CommandLine.run(runnable, (PrintStream)var1_1, Help.Ansi.AUTO, (String[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <R extends Runnable> void run(R runnable, PrintStream out, Help.Ansi ansi, String ... args) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object object;
        object = new CommandLine(object);
        ((CommandLine)object).parseWithHandlers(new RunLast(), (PrintStream)var1_1, (Help.Ansi)var2_2, new DefaultExceptionHandler(), (String[])var3_3);
    }

    public <K> CommandLine registerConverter(Class<K> cls, ITypeConverter<K> converter) {
        this.interpreter.converterRegistry.put(Assert.notNull(cls, "class"), Assert.notNull(converter, "converter"));
        for (CommandLine commandLine : this.interpreter.commands.values()) {
            commandLine.registerConverter(cls, converter);
        }
        return this;
    }

    public String getSeparator() {
        return this.interpreter.separator;
    }

    /*
     * WARNING - void declaration
     */
    public CommandLine setSeparator(String separator) {
        void var1_1;
        Interpreter.access$502(this.interpreter, (String)Assert.notNull(var1_1, "separator"));
        return this;
    }

    public String getCommandName() {
        return this.commandName;
    }

    /*
     * WARNING - void declaration
     */
    public CommandLine setCommandName(String commandName) {
        void var1_1;
        this.commandName = (String)Assert.notNull(var1_1, "commandName");
        return this;
    }

    private static boolean empty(String str) {
        String string;
        return str == null || string.trim().length() == 0;
    }

    private static boolean empty(Object[] array) {
        Object[] objectArray;
        return array == null || objectArray.length == 0;
    }

    private static boolean empty(Help.Ansi.Text txt) {
        Help.Ansi.Text text;
        return txt == null || text.plain.toString().trim().length() == 0;
    }

    /*
     * WARNING - void declaration
     */
    private static String str(String[] arr, int i) {
        void var1_1;
        String[] stringArray;
        if (arr == null || arr.length == 0) {
            return "";
        }
        return stringArray[var1_1];
    }

    private static boolean isBoolean(Class<?> type) {
        Class<?> clazz;
        return type == Boolean.class || clazz == Boolean.TYPE;
    }

    private static CommandLine toCommandLine(Object obj) {
        Object object;
        if (obj instanceof CommandLine) {
            return (CommandLine)obj;
        }
        return new CommandLine(object);
    }

    private static boolean isMultiValue(Field field) {
        return CommandLine.isMultiValue(field.getType());
    }

    private static boolean isMultiValue(Class<?> cls) {
        Class<?> clazz;
        return cls.isArray() || Collection.class.isAssignableFrom(cls) || Map.class.isAssignableFrom(clazz);
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?>[] getTypeAttribute(Field field) {
        Object object;
        Class<?>[] explicit = field.isAnnotationPresent(Parameters.class) ? field.getAnnotation(Parameters.class).type() : field.getAnnotation(Option.class).type();
        if (explicit.length > 0) {
            return explicit;
        }
        if (field.getType().isArray()) {
            return new Class[]{field.getType().getComponentType()};
        }
        if (CommandLine.isMultiValue(field)) {
            Object type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                void var1_1;
                type = (ParameterizedType)type;
                Object paramTypes = type.getActualTypeArguments();
                Object[] result = new Class[((Type[])paramTypes).length];
                for (int i = 0; i < ((Type[])paramTypes).length; ++i) {
                    if (paramTypes[i] instanceof Class) {
                        result[i] = (Class)paramTypes[i];
                        continue;
                    }
                    if (paramTypes[i] instanceof WildcardType) {
                        WildcardType wildcardType = (WildcardType)paramTypes[i];
                        Type[] lower = wildcardType.getLowerBounds();
                        if (lower.length > 0 && lower[0] instanceof Class) {
                            result[i] = (Class)lower[0];
                            continue;
                        }
                        Type[] upper = wildcardType.getUpperBounds();
                        if (upper.length > 0 && upper[0] instanceof Class) {
                            void var3_3;
                            result[i] = (Class)var3_3[0];
                            continue;
                        }
                    }
                    Arrays.fill(result, String.class);
                    return result;
                }
                return var1_1;
            }
            return new Class[]{String.class, String.class};
        }
        return new Class[]{object.getType()};
    }

    static void init(Class<?> cls, List<Field> requiredFields, Map<String, Field> optionName2Field, Map<Character, Field> singleCharOption2Field, List<Field> positionalParametersFields) {
        Field[] fieldArray = cls.getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray2[i];
            field.setAccessible(true);
            if (field.isAnnotationPresent(Option.class)) {
                Option option = field.getAnnotation(Option.class);
                if (option.required()) {
                    requiredFields.add(field);
                }
                for (String name : option.names()) {
                    char flag;
                    Field existing2;
                    Field existing = optionName2Field.put(name, field);
                    if (existing != null && existing != field) {
                        throw DuplicateOptionAnnotationsException.access$1000(name, field, existing);
                    }
                    if (name.length() != 2 || !name.startsWith("-") || (existing2 = singleCharOption2Field.put(Character.valueOf(flag = name.charAt(1)), field)) == null || existing2 == field) continue;
                    throw DuplicateOptionAnnotationsException.access$1000(name, field, existing2);
                }
            }
            if (!field.isAnnotationPresent(Parameters.class)) continue;
            if (field.isAnnotationPresent(Option.class)) {
                throw new DuplicateOptionAnnotationsException("A field can be either @Option or @Parameters, but '" + field.getName() + "' is both.");
            }
            positionalParametersFields.add(field);
            Range range = Range.parameterArity(field);
            if (range.min <= 0) continue;
            requiredFields.add(field);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void validatePositionalParameters(List<Field> positionalParametersFields) {
        Iterator<Field> iterator;
        int min = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Field field = (Field)iterator.next();
            Range index = Range.parameterIndex(field);
            if (index.min > min) {
                void var2_2;
                throw new ParameterIndexGapException("Missing field annotated with @Parameter(index=" + min + "). Nearest field '" + var2_2.getName() + "' has index=" + index.min);
            }
            min = (min = Math.max(min, var3_3.max)) == Integer.MAX_VALUE ? min : min + 1;
        }
    }

    private static <T> Stack<T> reverse(Stack<T> stack) {
        Stack<T> stack2;
        Collections.reverse(stack);
        return stack2;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CommandLine access$1302(CommandLine x0, CommandLine x1) {
        void var1_1;
        x0.parent = var1_1;
        return x0.parent;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$1402(CommandLine x0, String x1) {
        void var1_1;
        x0.commandName = var1_1;
        return x0.commandName;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1702(CommandLine x0, boolean x1) {
        void var1_1;
        x0.versionHelpRequested = var1_1;
        return x0.versionHelpRequested;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1802(CommandLine x0, boolean x1) {
        void var1_1;
        x0.usageHelpRequested = var1_1;
        return x0.usageHelpRequested;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$3200(String[] x0, int x1) {
        void var1_1;
        return CommandLine.str(x0, (int)var1_1);
    }

    public static class MissingTypeConverterException
    extends ParameterException {
        private static final long serialVersionUID = -6050931703233083760L;

        /*
         * WARNING - void declaration
         */
        public MissingTypeConverterException(CommandLine commandLine, String msg) {
            super((CommandLine)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static class OverwrittenOptionException
    extends ParameterException {
        private static final long serialVersionUID = 1338029208271055776L;

        /*
         * WARNING - void declaration
         */
        public OverwrittenOptionException(CommandLine commandLine, String msg) {
            super((CommandLine)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static class MaxValuesforFieldExceededException
    extends ParameterException {
        private static final long serialVersionUID = 6536145439570100641L;

        /*
         * WARNING - void declaration
         */
        public MaxValuesforFieldExceededException(CommandLine commandLine, String msg) {
            super((CommandLine)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static class UnmatchedArgumentException
    extends ParameterException {
        private static final long serialVersionUID = -8700426380701452440L;

        /*
         * WARNING - void declaration
         */
        public UnmatchedArgumentException(CommandLine commandLine, String msg) {
            super((CommandLine)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public UnmatchedArgumentException(CommandLine commandLine, Stack<String> args) {
            this((CommandLine)var1_1, new ArrayList<String>(CommandLine.reverse((Stack)var2_2)));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public UnmatchedArgumentException(CommandLine commandLine, List<String> args) {
            this((CommandLine)var1_1, "Unmatched argument" + (args.size() == 1 ? " " : "s ") + var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static class ParameterIndexGapException
    extends InitializationException {
        private static final long serialVersionUID = -1520981133257618319L;

        /*
         * WARNING - void declaration
         */
        public ParameterIndexGapException(String msg) {
            super((String)var1_1);
            void var1_1;
        }
    }

    public static class DuplicateOptionAnnotationsException
    extends InitializationException {
        private static final long serialVersionUID = -3355128012575075641L;

        /*
         * WARNING - void declaration
         */
        public DuplicateOptionAnnotationsException(String msg) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private static DuplicateOptionAnnotationsException create(String name, Field field1, Field field2) {
            void var2_2;
            void var1_1;
            String string;
            return new DuplicateOptionAnnotationsException("Option name '" + string + "' is used by both " + field1.getDeclaringClass().getName() + "." + var1_1.getName() + " and " + field2.getDeclaringClass().getName() + "." + var2_2.getName());
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ DuplicateOptionAnnotationsException access$1000(String x0, Field x1, Field x2) {
            void var2_2;
            void var1_1;
            return DuplicateOptionAnnotationsException.create(x0, (Field)var1_1, (Field)var2_2);
        }
    }

    public static class MissingParameterException
    extends ParameterException {
        private static final long serialVersionUID = 5075678535706338753L;

        /*
         * WARNING - void declaration
         */
        public MissingParameterException(CommandLine commandLine, String msg) {
            super((CommandLine)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private static MissingParameterException create(CommandLine cmd, Collection<Field> missing, String separator) {
            void var3_3;
            CommandLine commandLine;
            Iterator iterator;
            if (missing.size() == 1) {
                return new MissingParameterException(cmd, "Missing required option '" + MissingParameterException.describe(missing.iterator().next(), separator) + "'");
            }
            ArrayList<String> names = new ArrayList<String>(missing.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                names.add(MissingParameterException.describe(field, separator));
            }
            return new MissingParameterException(commandLine, "Missing required options " + var3_3.toString());
        }

        /*
         * WARNING - void declaration
         */
        private static String describe(Field field, String separator) {
            Field field2;
            void var1_1;
            String prefix = field.isAnnotationPresent(Option.class) ? field.getAnnotation(Option.class).names()[0] + separator : "params[" + field.getAnnotation(Parameters.class).index() + "]" + separator;
            return (String)var1_1 + Help.DefaultParamLabelRenderer.renderParameterName(field2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ MissingParameterException access$2000(CommandLine x0, Collection x1, String x2) {
            void var2_2;
            void var1_1;
            return MissingParameterException.create(x0, (Collection<Field>)var1_1, (String)var2_2);
        }
    }

    public static class ParameterException
    extends PicocliException {
        private static final long serialVersionUID = 1477112829129763139L;
        private final CommandLine commandLine;

        /*
         * WARNING - void declaration
         */
        public ParameterException(CommandLine commandLine, String msg) {
            super((String)var2_2);
            void var1_1;
            void var2_2;
            this.commandLine = (CommandLine)Assert.notNull(var1_1, "commandLine");
        }

        /*
         * WARNING - void declaration
         */
        public ParameterException(CommandLine commandLine, String msg, Exception ex) {
            super((String)var2_2, (Exception)var3_3);
            void var1_1;
            void var3_3;
            void var2_2;
            this.commandLine = (CommandLine)Assert.notNull(var1_1, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }

        /*
         * WARNING - void declaration
         */
        private static ParameterException create(CommandLine cmd, Exception ex, String arg, int i, String[] args) {
            void var1_1;
            void var2_2;
            CommandLine commandLine;
            void var3_3;
            String msg = ex.getClass().getSimpleName() + ": " + ex.getLocalizedMessage() + " while processing argument at or before arg[" + (int)var3_3 + "] '" + arg + "' in " + Arrays.toString(args) + ": " + ex.toString();
            return new ParameterException(commandLine, (String)var2_2, (Exception)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ ParameterException access$1900(CommandLine x0, Exception x1, String x2, int x3, String[] x4) {
            void var3_3;
            void var2_2;
            void var1_1;
            return ParameterException.create(x0, (Exception)var1_1, (String)var2_2, (int)var3_3, x4);
        }
    }

    public static class TypeConversionException
    extends PicocliException {
        private static final long serialVersionUID = 4251973913816346114L;

        /*
         * WARNING - void declaration
         */
        public TypeConversionException(String msg) {
            super((String)var1_1);
            void var1_1;
        }
    }

    public static class ExecutionException
    extends PicocliException {
        private static final long serialVersionUID = 7764539594267007998L;
        private final CommandLine commandLine;

        /*
         * WARNING - void declaration
         */
        public ExecutionException(CommandLine commandLine, String msg) {
            super((String)var2_2);
            void var1_1;
            void var2_2;
            this.commandLine = (CommandLine)Assert.notNull(var1_1, "commandLine");
        }

        /*
         * WARNING - void declaration
         */
        public ExecutionException(CommandLine commandLine, String msg, Exception ex) {
            super((String)var2_2, (Exception)var3_3);
            void var1_1;
            void var3_3;
            void var2_2;
            this.commandLine = (CommandLine)Assert.notNull(var1_1, "commandLine");
        }

        public CommandLine getCommandLine() {
            return this.commandLine;
        }
    }

    public static class InitializationException
    extends PicocliException {
        private static final long serialVersionUID = 8423014001666638895L;

        /*
         * WARNING - void declaration
         */
        public InitializationException(String msg) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public InitializationException(String msg, Exception ex) {
            super((String)var1_1, (Exception)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    public static class PicocliException
    extends RuntimeException {
        private static final long serialVersionUID = -2574128880125050818L;

        /*
         * WARNING - void declaration
         */
        public PicocliException(String msg) {
            super((String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public PicocliException(String msg, Exception ex) {
            super((String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    private static class Tracer {
        TraceLevel level = TraceLevel.lookup(System.getProperty("picocli.trace"));
        PrintStream stream = System.err;

        private Tracer() {
        }

        /*
         * WARNING - void declaration
         */
        void warn(String msg, Object ... params) {
            void var2_2;
            void var1_1;
            TraceLevel.access$2600(TraceLevel.WARN, this, (String)var1_1, (Object[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        void info(String msg, Object ... params) {
            void var2_2;
            void var1_1;
            TraceLevel.access$2600(TraceLevel.INFO, this, (String)var1_1, (Object[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        void debug(String msg, Object ... params) {
            void var2_2;
            void var1_1;
            TraceLevel.access$2600(TraceLevel.DEBUG, this, (String)var1_1, (Object[])var2_2);
        }

        boolean isWarn() {
            return this.level.isEnabled(TraceLevel.WARN);
        }

        boolean isInfo() {
            return this.level.isEnabled(TraceLevel.INFO);
        }

        boolean isDebug() {
            return this.level.isEnabled(TraceLevel.DEBUG);
        }
    }

    private static enum TraceLevel {
        OFF,
        WARN,
        INFO,
        DEBUG;


        /*
         * WARNING - void declaration
         */
        public final boolean isEnabled(TraceLevel other) {
            void var1_1;
            return this.ordinal() >= var1_1.ordinal();
        }

        /*
         * WARNING - void declaration
         */
        private void print(Tracer tracer, String msg, Object ... params) {
            if (tracer.level.isEnabled(this)) {
                void var3_3;
                void var2_2;
                void var1_1;
                var1_1.stream.printf(this.prefix((String)var2_2), (Object[])var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private String prefix(String msg) {
            void var1_1;
            return "[picocli " + (Object)((Object)this) + "] " + (String)var1_1;
        }

        static TraceLevel lookup(String key) {
            String string;
            if (key == null) {
                return WARN;
            }
            if (CommandLine.empty(key) || "true".equalsIgnoreCase(key)) {
                return INFO;
            }
            return TraceLevel.valueOf(string);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$2600(TraceLevel x0, Tracer x1, String x2, Object[] x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            x0.print((Tracer)var1_1, (String)var2_2, (Object[])var3_3);
        }
    }

    private static final class Assert {
        /*
         * WARNING - void declaration
         */
        static <T> T notNull(T object, String description) {
            T t;
            if (object == null) {
                void var1_1;
                throw new NullPointerException((String)var1_1);
            }
            return t;
        }

        private Assert() {
        }
    }

    public static class Help {
        protected static final String DEFAULT_COMMAND_NAME = "<main class>";
        protected static final String DEFAULT_SEPARATOR = "=";
        private static final int usageHelpWidth = 80;
        private static final int optionsColumnWidth = 29;
        private final Object command;
        private final Map<String, Help> commands = new LinkedHashMap<String, Help>();
        final ColorScheme colorScheme;
        public final List<Field> optionFields;
        public final List<Field> positionalParametersFields;
        public String separator;
        public String commandName = "<main class>";
        public String[] description = new String[0];
        public String[] customSynopsis = new String[0];
        public String[] header = new String[0];
        public String[] footer = new String[0];
        public IParamLabelRenderer parameterLabelRenderer;
        public Boolean abbreviateSynopsis;
        public Boolean sortOptions;
        public Boolean showDefaultValues;
        public Character requiredOptionMarker;
        public String headerHeading;
        public String synopsisHeading;
        public String descriptionHeading;
        public String parameterListHeading;
        public String optionListHeading;
        public String commandListHeading;
        public String footerHeading;

        /*
         * WARNING - void declaration
         */
        public Help(Object command) {
            this((Object)var1_1, Ansi.AUTO);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Help(Object command, Ansi ansi) {
            this((Object)var1_1, Help.defaultColorScheme((Ansi)var2_2));
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Help(Object command, ColorScheme colorScheme) {
            void var2_2;
            void var3_3;
            this.command = Assert.notNull(command, "command");
            this.colorScheme = Assert.notNull(colorScheme, "colorScheme").applySystemProperties();
            ArrayList<Field> options = new ArrayList<Field>();
            ArrayList<Field> operands = new ArrayList<Field>();
            for (Class<?> cls = command.getClass(); cls != null; cls = cls.getSuperclass()) {
                for (Field field : cls.getDeclaredFields()) {
                    Option option;
                    field.setAccessible(true);
                    if (field.isAnnotationPresent(Option.class) && !(option = field.getAnnotation(Option.class)).hidden()) {
                        options.add(field);
                    }
                    if (!field.isAnnotationPresent(Parameters.class)) continue;
                    operands.add(field);
                }
                if (!cls.isAnnotationPresent(Command.class)) continue;
                Command cmd = cls.getAnnotation(Command.class);
                if (DEFAULT_COMMAND_NAME.equals(this.commandName)) {
                    this.commandName = cmd.name();
                }
                this.separator = this.separator == null ? cmd.separator() : this.separator;
                this.abbreviateSynopsis = this.abbreviateSynopsis == null ? cmd.abbreviateSynopsis() : this.abbreviateSynopsis.booleanValue();
                this.sortOptions = this.sortOptions == null ? cmd.sortOptions() : this.sortOptions.booleanValue();
                this.requiredOptionMarker = Character.valueOf(this.requiredOptionMarker == null ? cmd.requiredOptionMarker() : this.requiredOptionMarker.charValue());
                this.showDefaultValues = this.showDefaultValues == null ? cmd.showDefaultValues() : this.showDefaultValues.booleanValue();
                this.customSynopsis = CommandLine.empty(this.customSynopsis) ? cmd.customSynopsis() : this.customSynopsis;
                this.description = CommandLine.empty(this.description) ? cmd.description() : this.description;
                this.header = CommandLine.empty(this.header) ? cmd.header() : this.header;
                this.footer = CommandLine.empty(this.footer) ? cmd.footer() : this.footer;
                this.headerHeading = CommandLine.empty(this.headerHeading) ? cmd.headerHeading() : this.headerHeading;
                this.synopsisHeading = CommandLine.empty(this.synopsisHeading) || "Usage: ".equals(this.synopsisHeading) ? cmd.synopsisHeading() : this.synopsisHeading;
                this.descriptionHeading = CommandLine.empty(this.descriptionHeading) ? cmd.descriptionHeading() : this.descriptionHeading;
                this.parameterListHeading = CommandLine.empty(this.parameterListHeading) ? cmd.parameterListHeading() : this.parameterListHeading;
                this.optionListHeading = CommandLine.empty(this.optionListHeading) ? cmd.optionListHeading() : this.optionListHeading;
                this.commandListHeading = CommandLine.empty(this.commandListHeading) || "Commands:%n".equals(this.commandListHeading) ? cmd.commandListHeading() : this.commandListHeading;
                this.footerHeading = CommandLine.empty(this.footerHeading) ? cmd.footerHeading() : this.footerHeading;
            }
            this.sortOptions = this.sortOptions == null ? true : this.sortOptions;
            this.abbreviateSynopsis = this.abbreviateSynopsis == null ? false : this.abbreviateSynopsis;
            this.requiredOptionMarker = Character.valueOf(this.requiredOptionMarker == null ? (char)' ' : this.requiredOptionMarker.charValue());
            this.showDefaultValues = this.showDefaultValues == null ? false : this.showDefaultValues;
            this.synopsisHeading = this.synopsisHeading == null ? "Usage: " : this.synopsisHeading;
            this.commandListHeading = this.commandListHeading == null ? "Commands:%n" : this.commandListHeading;
            this.separator = this.separator == null ? DEFAULT_SEPARATOR : this.separator;
            this.parameterLabelRenderer = this.createDefaultParamLabelRenderer();
            Collections.sort(operands, new PositionalParametersSorter());
            this.positionalParametersFields = Collections.unmodifiableList(var3_3);
            this.optionFields = Collections.unmodifiableList(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Help addAllSubcommands(Map<String, CommandLine> commands) {
            if (commands != null) {
                Iterator iterator;
                for (Map.Entry entry : iterator.entrySet()) {
                    void var2_2;
                    this.addSubcommand((String)entry.getKey(), ((CommandLine)var2_2.getValue()).getCommand());
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Help addSubcommand(String commandName, Object command) {
            void var2_2;
            void var1_1;
            this.commands.put((String)var1_1, new Help(var2_2));
            return this;
        }

        @Deprecated
        public String synopsis() {
            return this.synopsis(0);
        }

        /*
         * WARNING - void declaration
         */
        public String synopsis(int synopsisHeadingLength) {
            void var1_1;
            if (!CommandLine.empty(this.customSynopsis)) {
                return this.customSynopsis(new Object[0]);
            }
            if (this.abbreviateSynopsis.booleanValue()) {
                return this.abbreviatedSynopsis();
            }
            return this.detailedSynopsis((int)var1_1, Help.createShortOptionArityAndNameComparator(), true);
        }

        /*
         * WARNING - void declaration
         */
        public String abbreviatedSynopsis() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            if (!this.optionFields.isEmpty()) {
                sb.append(" [OPTIONS]");
            }
            for (Field positionalParam : this.positionalParametersFields) {
                void var3_3;
                if (positionalParam.getAnnotation(Parameters.class).hidden()) continue;
                sb.append(' ').append(this.parameterLabelRenderer.renderParameterLabel((Field)var3_3, this.ansi(), this.colorScheme.parameterStyles));
            }
            return this.colorScheme.commandText(this.commandName).toString() + var1_1.toString() + System.getProperty("line.separator");
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public String detailedSynopsis(Comparator<Field> optionSort, boolean clusterBooleanOptions) {
            void var2_2;
            void var1_1;
            return this.detailedSynopsis(0, (Comparator<Field>)var1_1, (boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public String detailedSynopsis(int synopsisHeadingLength, Comparator<Field> optionSort, boolean clusterBooleanOptions) {
            void var1_1;
            void var3_8;
            void var2_3;
            Ansi ansi = this.ansi();
            ((Object)((Object)ansi)).getClass();
            Ansi.Text optionText = new Ansi.Text(ansi, 0);
            ArrayList<Field> fields = new ArrayList<Field>(this.optionFields);
            if (optionSort != null) {
                Collections.sort(fields, optionSort);
            }
            if (clusterBooleanOptions) {
                Iterator<Field> booleanOptions = new ArrayList();
                StringBuilder clusteredRequired = new StringBuilder("-");
                StringBuilder clusteredOptional = new StringBuilder("-");
                for (Field field : fields) {
                    Option option;
                    String shortestName;
                    if (field.getType() != Boolean.TYPE && field.getType() != Boolean.class || (shortestName = ShortestFirst.sort((option = field.getAnnotation(Option.class)).names())[0]).length() != 2 || !shortestName.startsWith("-")) continue;
                    booleanOptions.add(field);
                    if (option.required()) {
                        clusteredRequired.append(shortestName.substring(1));
                        continue;
                    }
                    clusteredOptional.append(shortestName.substring(1));
                }
                fields.removeAll((Collection<?>)((Object)booleanOptions));
                if (clusteredRequired.length() > 1) {
                    optionText = optionText.append(" ").append(this.colorScheme.optionText(clusteredRequired.toString()));
                }
                if (clusteredOptional.length() > 1) {
                    optionText = optionText.append(" [").append(this.colorScheme.optionText(clusteredOptional.toString())).append("]");
                }
            }
            for (Field field : fields) {
                Option option = field.getAnnotation(Option.class);
                if (option.hidden()) continue;
                if (option.required()) {
                    optionText = this.appendOptionSynopsis(optionText, field, ShortestFirst.sort(option.names())[0], " ", "");
                    if (!CommandLine.isMultiValue(field)) continue;
                    optionText = this.appendOptionSynopsis(optionText, field, ShortestFirst.sort(option.names())[0], " [", "]...");
                    continue;
                }
                optionText = this.appendOptionSynopsis(optionText, field, ShortestFirst.sort(option.names())[0], " [", "]");
                if (!CommandLine.isMultiValue(field)) continue;
                optionText = optionText.append("...");
            }
            for (Field positionalParam : this.positionalParametersFields) {
                if (positionalParam.getAnnotation(Parameters.class).hidden()) continue;
                optionText = optionText.append(" ");
                Ansi.Text label = this.parameterLabelRenderer.renderParameterLabel(positionalParam, this.colorScheme.ansi(), this.colorScheme.parameterStyles);
                optionText = optionText.append(label);
            }
            int firstColumnLength = this.commandName.length() + synopsisHeadingLength;
            TextTable textTable = new TextTable(this.ansi(), firstColumnLength, 80 - var2_3);
            new TextTable(this.ansi(), firstColumnLength, 80 - var2_3).indentWrappedLines = 1;
            Ansi ansi2 = Ansi.OFF;
            ((Object)((Object)ansi2)).getClass();
            Ansi.Text PADDING = new Ansi.Text(ansi2, Help.stringOf('X', synopsisHeadingLength));
            textTable.addRowValues(PADDING.append(this.colorScheme.commandText(this.commandName)), optionText);
            return var3_8.toString().substring((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private Ansi.Text appendOptionSynopsis(Ansi.Text optionText, Field field, String optionName, String prefix, String suffix) {
            void var2_2;
            void var3_3;
            void var1_1;
            Ansi.Text optionParamText = this.parameterLabelRenderer.renderParameterLabel(field, this.colorScheme.ansi(), this.colorScheme.optionParamStyles);
            return var1_1.append(prefix).append(this.colorScheme.optionText((String)var3_3)).append((Ansi.Text)var2_2).append(suffix);
        }

        /*
         * WARNING - void declaration
         */
        public int synopsisHeadingLength() {
            void var1_1;
            Ansi ansi = Ansi.OFF;
            ((Object)((Object)ansi)).getClass();
            String[] lines = new Ansi.Text(ansi, this.synopsisHeading).toString().split("\\r?\\n|\\r|%n", -1);
            return lines[((void)var1_1).length - 1].length();
        }

        /*
         * WARNING - void declaration
         */
        public String optionList() {
            void var1_1;
            Comparator<Field> sortOrder = this.sortOptions == null || this.sortOptions != false ? Help.createShortOptionNameComparator() : null;
            Help help = this;
            return help.optionList(help.createDefaultLayout(), (Comparator<Field>)var1_1, this.parameterLabelRenderer);
        }

        /*
         * WARNING - void declaration
         */
        public String optionList(Layout layout, Comparator<Field> optionSort, IParamLabelRenderer valueLabelRenderer) {
            void var1_1;
            void var3_3;
            ArrayList<Field> fields = new ArrayList<Field>(this.optionFields);
            if (optionSort != null) {
                void var2_2;
                Collections.sort(fields, var2_2);
            }
            layout.addOptions(fields, (IParamLabelRenderer)var3_3);
            return var1_1.toString();
        }

        public String parameterList() {
            Help help = this;
            return help.parameterList(help.createDefaultLayout(), this.parameterLabelRenderer);
        }

        /*
         * WARNING - void declaration
         */
        public String parameterList(Layout layout, IParamLabelRenderer paramLabelRenderer) {
            void var1_1;
            void var2_2;
            layout.addPositionalParameters(this.positionalParametersFields, (IParamLabelRenderer)var2_2);
            return var1_1.toString();
        }

        /*
         * WARNING - void declaration
         */
        private static String heading(Ansi ansi, String values, Object ... params) {
            void var1_1;
            Object object;
            void var2_2;
            Object result = ((StringBuilder)(ansi = Help.join(ansi, new String[]{values}, new StringBuilder(), (Object[])var2_2))).toString();
            result = ((String)result).endsWith(System.getProperty("line.separator")) ? ((String)result).substring(0, ((String)result).length() - System.getProperty("line.separator").length()) : result;
            return (String)object + new String(Help.spaces(Help.countTrailingSpaces((String)var1_1)));
        }

        /*
         * WARNING - void declaration
         */
        private static char[] spaces(int length) {
            void var0_1;
            char[] result = new char[length];
            Arrays.fill(result, ' ');
            return var0_1;
        }

        /*
         * WARNING - void declaration
         */
        private static int countTrailingSpaces(String str) {
            void var1_1;
            if (str == null) {
                return 0;
            }
            int trailingSpaces = 0;
            for (int i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
                ++trailingSpaces;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public static StringBuilder join(Ansi ansi, String[] values, StringBuilder sb, Object ... params) {
            void var2_2;
            if (values != null) {
                void var1_1;
                TextTable table = new TextTable(ansi, 80);
                new TextTable(ansi, 80).indentWrappedLines = 0;
                for (void summaryLine : var1_1) {
                    Ansi ansi2 = ansi;
                    ((Object)((Object)ansi2)).getClass();
                    Ansi.Text[] textArray = new Ansi.Text(ansi2, Help.format((String)summaryLine, params)).splitLines();
                    Ansi.Text[] textArray2 = textArray;
                    textArray2 = textArray;
                    int n = textArray.length;
                    for (int i = 0; i < n; ++i) {
                        Ansi.Text line = textArray2[i];
                        table.addRowValues(line);
                    }
                }
                table.toString(sb);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private static String format(String formatString, Object ... params) {
            void var1_1;
            String string;
            if (formatString == null) {
                return "";
            }
            return String.format(string, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String customSynopsis(Object ... params) {
            void var1_1;
            return Help.join(this.ansi(), this.customSynopsis, new StringBuilder(), (Object[])var1_1).toString();
        }

        /*
         * WARNING - void declaration
         */
        public String description(Object ... params) {
            void var1_1;
            return Help.join(this.ansi(), this.description, new StringBuilder(), (Object[])var1_1).toString();
        }

        /*
         * WARNING - void declaration
         */
        public String header(Object ... params) {
            void var1_1;
            return Help.join(this.ansi(), this.header, new StringBuilder(), (Object[])var1_1).toString();
        }

        /*
         * WARNING - void declaration
         */
        public String footer(Object ... params) {
            void var1_1;
            return Help.join(this.ansi(), this.footer, new StringBuilder(), (Object[])var1_1).toString();
        }

        /*
         * WARNING - void declaration
         */
        public String headerHeading(Object ... params) {
            void var1_1;
            return Help.heading(this.ansi(), this.headerHeading, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String synopsisHeading(Object ... params) {
            void var1_1;
            return Help.heading(this.ansi(), this.synopsisHeading, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String descriptionHeading(Object ... params) {
            void var1_1;
            if (CommandLine.empty(this.descriptionHeading)) {
                return "";
            }
            return Help.heading(this.ansi(), this.descriptionHeading, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String parameterListHeading(Object ... params) {
            void var1_1;
            if (this.positionalParametersFields.isEmpty()) {
                return "";
            }
            return Help.heading(this.ansi(), this.parameterListHeading, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String optionListHeading(Object ... params) {
            void var1_1;
            if (this.optionFields.isEmpty()) {
                return "";
            }
            return Help.heading(this.ansi(), this.optionListHeading, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String commandListHeading(Object ... params) {
            void var1_1;
            if (this.commands.isEmpty()) {
                return "";
            }
            return Help.heading(this.ansi(), this.commandListHeading, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String footerHeading(Object ... params) {
            void var1_1;
            return Help.heading(this.ansi(), this.footerHeading, (Object[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String commandList() {
            void var1_2;
            if (this.commands.isEmpty()) {
                return "";
            }
            int commandLength = Help.maxLength(this.commands.keySet());
            TextTable textTable = new TextTable(this.ansi(), new Column(commandLength + 2, 2, Column.Overflow.SPAN), new Column(80 - (commandLength + 2), 2, Column.Overflow.WRAP));
            for (Map.Entry<String, Help> entry : this.commands.entrySet()) {
                void var3_4;
                Help command = entry.getValue();
                String header = command.header != null && command.header.length > 0 ? command.header[0] : (command.description != null && command.description.length > 0 ? command.description[0] : "");
                Ansi.Text[] textArray = new Ansi.Text[2];
                textArray[0] = this.colorScheme.commandText((String)var3_4.getKey());
                Ansi ansi = this.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray[1] = new Ansi.Text(ansi, header);
                textTable.addRowValues(textArray);
            }
            return var1_2.toString();
        }

        private static int maxLength(Collection<String> any) {
            Collection<String> collection;
            Collection<String> strings = new ArrayList<String>(any);
            Collections.sort(strings, Collections.reverseOrder(Help.shortestFirst()));
            return ((String)collection.get(0)).length();
        }

        private static String join(String[] names, int offset, int length, String separator) {
            if (names == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            for (int i = offset; i < offset + length; ++i) {
                result.append(i > offset ? separator : "").append(names[i]);
            }
            return result.toString();
        }

        /*
         * WARNING - void declaration
         */
        private static String stringOf(char chr, int length) {
            void var1_2;
            char c;
            char[] buff = new char[length];
            Arrays.fill(buff, c);
            return new String((char[])var1_2);
        }

        public Layout createDefaultLayout() {
            return new Layout(this.colorScheme, new TextTable(this.colorScheme.ansi()), this.createDefaultOptionRenderer(), this.createDefaultParameterRenderer());
        }

        /*
         * WARNING - void declaration
         */
        public IOptionRenderer createDefaultOptionRenderer() {
            void var1_1;
            DefaultOptionRenderer result = new DefaultOptionRenderer();
            new DefaultOptionRenderer().requiredMarker = String.valueOf(this.requiredOptionMarker);
            if (this.showDefaultValues != null && this.showDefaultValues.booleanValue()) {
                result.command = this.command;
            }
            return var1_1;
        }

        public static IOptionRenderer createMinimalOptionRenderer() {
            return new MinimalOptionRenderer();
        }

        /*
         * WARNING - void declaration
         */
        public IParameterRenderer createDefaultParameterRenderer() {
            void var1_1;
            DefaultParameterRenderer result = new DefaultParameterRenderer();
            new DefaultParameterRenderer().requiredMarker = String.valueOf(this.requiredOptionMarker);
            return var1_1;
        }

        public static IParameterRenderer createMinimalParameterRenderer() {
            return new MinimalParameterRenderer();
        }

        public static IParamLabelRenderer createMinimalParamLabelRenderer() {
            return new IParamLabelRenderer(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final Ansi.Text renderParameterLabel(Field field, Ansi ansi, List<Ansi.IStyle> styles) {
                    void var3_3;
                    void var1_1;
                    void var2_2;
                    String text = DefaultParamLabelRenderer.renderParameterName(field);
                    return var2_2.apply((String)var1_1, (List<Ansi.IStyle>)var3_3);
                }

                @Override
                public final String separator() {
                    return "";
                }
            };
        }

        public IParamLabelRenderer createDefaultParamLabelRenderer() {
            return new DefaultParamLabelRenderer(this.separator);
        }

        public static Comparator<Field> createShortOptionNameComparator() {
            return new SortByShortestOptionNameAlphabetically();
        }

        public static Comparator<Field> createShortOptionArityAndNameComparator() {
            return new SortByOptionArityAndNameAlphabetically();
        }

        public static Comparator<String> shortestFirst() {
            return new ShortestFirst();
        }

        public Ansi ansi() {
            return this.colorScheme.ansi;
        }

        public static ColorScheme defaultColorScheme(Ansi ansi) {
            Ansi ansi2;
            return new ColorScheme(ansi2).commands(Ansi.Style.bold).options(Ansi.Style.fg_yellow).parameters(Ansi.Style.fg_yellow).optionParams(Ansi.Style.italic);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$3000(String[] x0, int x1, int x2, String x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            return Help.join(x0, (int)var1_1, (int)var2_2, (String)var3_3);
        }

        public static enum Ansi {
            AUTO,
            ON,
            OFF;

            static Text EMPTY_TEXT;
            static final boolean isWindows;
            static final boolean isXterm;
            static final boolean ISATTY;

            static final boolean calcTTY() {
                if (isWindows && isXterm) {
                    return true;
                }
                try {
                    return System.class.getDeclaredMethod("console", new Class[0]).invoke(null, new Object[0]) != null;
                }
                catch (Throwable throwable) {
                    return true;
                }
            }

            private static boolean ansiPossible() {
                return ISATTY && (!isWindows || isXterm);
            }

            public final boolean enabled() {
                if (this == ON) {
                    return true;
                }
                if (this == OFF) {
                    return false;
                }
                if (System.getProperty("picocli.ansi") == null) {
                    return Ansi.ansiPossible();
                }
                return Boolean.getBoolean("picocli.ansi");
            }

            /*
             * WARNING - void declaration
             */
            public final Text apply(String plainText, List<IStyle> styles) {
                void var3_3;
                void var1_1;
                void var2_2;
                if (plainText.length() == 0) {
                    return new Text(this, 0);
                }
                Text result = new Text(this, plainText.length());
                List<IStyle> list = styles;
                IStyle[] all = list.toArray(new IStyle[list.size()]);
                result.sections.add(new StyledSection(0, plainText.length(), Style.on(all), Style.off((IStyle[])Ansi.reverse(var2_2)) + Style.reset.off()));
                result.plain.append((String)var1_1);
                Text text = result;
                Text.access$3102(text, text.plain.length());
                return var3_3;
            }

            /*
             * WARNING - void declaration
             */
            private static <T> T[] reverse(T[] all) {
                T[] TArray;
                for (int i = 0; i < all.length / 2; ++i) {
                    void var2_2;
                    T temp = all[i];
                    all[i] = all[all.length - i - 1];
                    all[all.length - i - 1] = var2_2;
                }
                return TArray;
            }

            static {
                Ansi ansi = OFF;
                ((Object)((Object)ansi)).getClass();
                EMPTY_TEXT = new Text(ansi, 0);
                isWindows = System.getProperty("os.name").startsWith("Windows");
                isXterm = System.getenv("TERM") != null && System.getenv("TERM").startsWith("xterm");
                ISATTY = Ansi.calcTTY();
            }

            public class Text
            implements Cloneable {
                private final int maxLength;
                private int from;
                private int length;
                private StringBuilder plain;
                private List<StyledSection> sections;
                final /* synthetic */ Ansi this$0;

                /*
                 * WARNING - void declaration
                 */
                public Text(Ansi this$0, int maxLength) {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.plain = new StringBuilder();
                    this.sections = new ArrayList<StyledSection>();
                    this.maxLength = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                public Text(Ansi this$0, String input) {
                    this.this$0 = this$0;
                    this.plain = new StringBuilder();
                    this.sections = new ArrayList<StyledSection>();
                    this.maxLength = -1;
                    this.plain.setLength(0);
                    int i = 0;
                    while (true) {
                        void var3_4;
                        int j22;
                        if ((j22 = input.indexOf("@|", i)) == -1) {
                            if (i == 0) {
                                this.plain.append(input);
                                this.length = this.plain.length();
                                return;
                            }
                            this.plain.append(input.substring(i, input.length()));
                            this.length = this.plain.length();
                            return;
                        }
                        this.plain.append(input.substring(i, j22));
                        int k = input.indexOf("|@", j22);
                        if (k == -1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        String j22 = input.substring(j22 += 2, k);
                        String[] items = j22.split(" ", 2);
                        if (items.length == 1) {
                            this.plain.append(input);
                            this.length = this.plain.length();
                            return;
                        }
                        Object[] styles = Style.parse(items[0]);
                        Text text = this;
                        text.addStyledSection(text.plain.length(), items[1].length(), Style.on((IStyle[])styles), Style.off((IStyle[])Ansi.reverse(styles)) + Style.reset.off());
                        this.plain.append((String)var3_4[1]);
                        var1_2 += 2;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                private void addStyledSection(int start, int length, String startStyle, String endStyle) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.sections.add(new StyledSection((int)var1_1, (int)var2_2, (String)var3_3, endStyle));
                }

                /*
                 * WARNING - void declaration
                 */
                public Object clone() {
                    try {
                        return super.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        void var1_1;
                        throw new IllegalStateException((Throwable)var1_1);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public Text[] splitLines() {
                    void var1_1;
                    void var2_2;
                    ArrayList<Text> result = new ArrayList<Text>();
                    boolean trailingEmptyString = false;
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    while (i < this.plain.length()) {
                        char c = this.plain.charAt(i);
                        boolean bl = c == '\n';
                        bl = bl | (c == '\r' && i + 1 < this.plain.length() && this.plain.charAt(i + 1) == '\n' && ++i > 0);
                        if (bl |= c == '\r') {
                            result.add(this.substring(start, end));
                            trailingEmptyString = i == this.plain.length() - 1;
                            start = i + 1;
                        }
                        end = ++i;
                    }
                    if (start < this.plain.length() || var2_2 != false) {
                        void var3_3;
                        result.add(this.substring((int)var3_3, this.plain.length()));
                    }
                    void v0 = var1_1;
                    return v0.toArray(new Text[v0.size()]);
                }

                /*
                 * WARNING - void declaration
                 */
                public Text substring(int start) {
                    void var1_1;
                    return this.substring((int)var1_1, this.length);
                }

                /*
                 * WARNING - void declaration
                 */
                public Text substring(int start, int end) {
                    void var3_3;
                    void var1_1;
                    void var2_2;
                    Text result = (Text)this.clone();
                    ((Text)this.clone()).from = this.from + start;
                    result.length = var2_2 - var1_1;
                    return var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                public Text append(String string) {
                    void var1_1;
                    return this.append(new Text(this.this$0, (String)var1_1));
                }

                /*
                 * WARNING - void declaration
                 */
                public Text append(Text other) {
                    void var2_2;
                    Text result = (Text)this.clone();
                    ((Text)this.clone()).plain = new StringBuilder(this.plain.toString().substring(this.from, this.from + this.length));
                    result.from = 0;
                    result.sections = new ArrayList<StyledSection>();
                    Iterator<StyledSection> iterator = this.sections.iterator();
                    while (iterator.hasNext()) {
                        StyledSection section;
                        StyledSection styledSection = section = iterator.next();
                        result.sections.add(styledSection.withStartIndex(styledSection.startIndex - this.from));
                    }
                    result.plain.append(other.plain.toString().substring(other.from, other.from + other.length));
                    for (StyledSection section : other.sections) {
                        int index = result.length + section.startIndex - other.from;
                        result.sections.add(section.withStartIndex(index));
                    }
                    result.length = result.plain.length();
                    return var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                public void getStyledChars(int from, int length, Text destination, int offset) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    if (destination.length < offset) {
                        for (int i = destination.length; i < offset; ++i) {
                            destination.plain.append(' ');
                        }
                        destination.length = offset;
                    }
                    Iterator<StyledSection> iterator = this.sections.iterator();
                    while (iterator.hasNext()) {
                        StyledSection section;
                        StyledSection styledSection = section = iterator.next();
                        destination.sections.add(styledSection.withStartIndex(styledSection.startIndex - from + destination.length));
                    }
                    void v1 = var1_1;
                    destination.plain.append(this.plain.toString().substring((int)v1, (int)(v1 + var2_2)));
                    var3_3.length = var3_3.plain.length();
                }

                public String plainString() {
                    return this.plain.toString().substring(this.from, this.from + this.length);
                }

                /*
                 * WARNING - void declaration
                 */
                public boolean equals(Object obj) {
                    void var1_1;
                    return this.toString().equals(String.valueOf(var1_1));
                }

                public int hashCode() {
                    return this.toString().hashCode();
                }

                /*
                 * WARNING - void declaration
                 */
                public String toString() {
                    void var1_1;
                    if (!this.this$0.enabled()) {
                        return this.plain.toString().substring(this.from, this.from + this.length);
                    }
                    if (this.length == 0) {
                        return "";
                    }
                    StringBuilder sb = new StringBuilder(this.plain.length() + 20 * this.sections.size());
                    StyledSection current = null;
                    int end = Math.min(this.from + this.length, this.plain.length());
                    for (int i = this.from; i < end; ++i) {
                        StyledSection section = this.findSectionContaining(i);
                        if (section != current) {
                            if (current != null) {
                                sb.append(current.endStyles);
                            }
                            if (section != null) {
                                sb.append(section.startStyles);
                            }
                            current = section;
                        }
                        sb.append(this.plain.charAt(i));
                    }
                    if (current != null) {
                        void var2_2;
                        sb.append(var2_2.endStyles);
                    }
                    return var1_1.toString();
                }

                /*
                 * WARNING - void declaration
                 */
                private StyledSection findSectionContaining(int index) {
                    for (StyledSection section : this.sections) {
                        void var3_3;
                        if (index < section.startIndex || index >= section.startIndex + section.length) continue;
                        return var3_3;
                    }
                    return null;
                }

                /*
                 * WARNING - void declaration
                 */
                static /* synthetic */ int access$3102(Text x0, int x1) {
                    void var1_1;
                    x0.length = var1_1;
                    return x0.length;
                }
            }

            private static class StyledSection {
                int startIndex;
                int length;
                String startStyles;
                String endStyles;

                /*
                 * WARNING - void declaration
                 */
                StyledSection(int start, int len, String style1, String style2) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.startIndex = var1_1;
                    this.length = var2_2;
                    this.startStyles = var3_3;
                    this.endStyles = style2;
                }

                /*
                 * WARNING - void declaration
                 */
                StyledSection withStartIndex(int newStart) {
                    void var1_1;
                    return new StyledSection((int)var1_1, this.length, this.startStyles, this.endStyles);
                }
            }

            static class Palette256Color
            implements IStyle {
                private final int fgbg;
                private final int color;

                /*
                 * WARNING - void declaration
                 */
                Palette256Color(boolean foreground, String color) {
                    void var2_3;
                    this.fgbg = foreground ? 38 : 48;
                    String[] rgb = color.split(";");
                    if (rgb.length == 3) {
                        void var1_2;
                        this.color = 16 + 36 * Integer.decode(rgb[0]) + 6 * Integer.decode(rgb[1]) + Integer.decode((String)var1_2[2]);
                        return;
                    }
                    this.color = Integer.decode((String)var2_3);
                }

                @Override
                public String on() {
                    return String.format("\u001b[%d;5;%dm", this.fgbg, this.color);
                }

                @Override
                public String off() {
                    return "\u001b[" + (this.fgbg + 1) + "m";
                }
            }

            public static enum Style implements IStyle
            {
                reset(0, 0),
                bold(1, 21),
                faint(2, 22),
                italic(3, 23),
                underline(4, 24),
                blink(5, 25),
                reverse(7, 27),
                fg_black(30, 39),
                fg_red(31, 39),
                fg_green(32, 39),
                fg_yellow(33, 39),
                fg_blue(34, 39),
                fg_magenta(35, 39),
                fg_cyan(36, 39),
                fg_white(37, 39),
                bg_black(40, 49),
                bg_red(41, 49),
                bg_green(42, 49),
                bg_yellow(43, 49),
                bg_blue(44, 49),
                bg_magenta(45, 49),
                bg_cyan(46, 49),
                bg_white(47, 49);

                private final int startCode;
                private final int endCode;

                /*
                 * WARNING - void declaration
                 */
                private Style(int startCode, int endCode) {
                    void var3_3;
                    this.startCode = var3_3;
                    this.endCode = endCode;
                }

                @Override
                public final String on() {
                    return "\u001b[" + this.startCode + "m";
                }

                @Override
                public final String off() {
                    return "\u001b[" + this.endCode + "m";
                }

                /*
                 * WARNING - void declaration
                 */
                public static String on(IStyle ... styles) {
                    void var1_1;
                    IStyle[] iStyleArray;
                    StringBuilder result = new StringBuilder();
                    for (IStyle style : iStyleArray) {
                        result.append(style.on());
                    }
                    return var1_1.toString();
                }

                /*
                 * WARNING - void declaration
                 */
                public static String off(IStyle ... styles) {
                    void var1_1;
                    IStyle[] iStyleArray;
                    StringBuilder result = new StringBuilder();
                    for (IStyle style : iStyleArray) {
                        result.append(style.off());
                    }
                    return var1_1.toString();
                }

                public static IStyle fg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("fg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            String string;
                            return new Palette256Color(true, string);
                        }
                    }
                }

                public static IStyle bg(String str) {
                    try {
                        return Style.valueOf(str.toLowerCase(Locale.ENGLISH));
                    }
                    catch (Exception exception) {
                        try {
                            return Style.valueOf("bg_" + str.toLowerCase(Locale.ENGLISH));
                        }
                        catch (Exception exception2) {
                            String string;
                            return new Palette256Color(false, string);
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public static IStyle[] parse(String commaSeparatedCodes) {
                    void var1_1;
                    String[] codes = commaSeparatedCodes.split(",");
                    IStyle[] styles = new IStyle[codes.length];
                    for (int i = 0; i < codes.length; ++i) {
                        int end;
                        if (codes[i].toLowerCase(Locale.ENGLISH).startsWith("fg(")) {
                            end = codes[i].indexOf(41);
                            styles[i] = Style.fg(codes[i].substring(3, end < 0 ? codes[i].length() : end));
                            continue;
                        }
                        if (codes[i].toLowerCase(Locale.ENGLISH).startsWith("bg(")) {
                            void var3_3;
                            end = codes[i].indexOf(41);
                            styles[i] = Style.bg(codes[i].substring(3, end < 0 ? codes[i].length() : var3_3));
                            continue;
                        }
                        styles[i] = Style.fg(codes[i]);
                    }
                    return var1_1;
                }
            }

            public static interface IStyle {
                public static final String CSI = "\u001b[";

                public String on();

                public String off();
            }
        }

        public static class ColorScheme {
            public final List<Ansi.IStyle> commandStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> parameterStyles = new ArrayList<Ansi.IStyle>();
            public final List<Ansi.IStyle> optionParamStyles = new ArrayList<Ansi.IStyle>();
            private final Ansi ansi;

            public ColorScheme() {
                this(Ansi.AUTO);
            }

            /*
             * WARNING - void declaration
             */
            public ColorScheme(Ansi ansi) {
                void var1_1;
                this.ansi = (Ansi)Assert.notNull(var1_1, "ansi");
            }

            /*
             * WARNING - void declaration
             */
            public ColorScheme commands(Ansi.IStyle ... styles) {
                void var1_1;
                ColorScheme colorScheme = this;
                return colorScheme.addAll(colorScheme.commandStyles, (Ansi.IStyle[])var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public ColorScheme options(Ansi.IStyle ... styles) {
                void var1_1;
                ColorScheme colorScheme = this;
                return colorScheme.addAll(colorScheme.optionStyles, (Ansi.IStyle[])var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public ColorScheme parameters(Ansi.IStyle ... styles) {
                void var1_1;
                ColorScheme colorScheme = this;
                return colorScheme.addAll(colorScheme.parameterStyles, (Ansi.IStyle[])var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public ColorScheme optionParams(Ansi.IStyle ... styles) {
                void var1_1;
                ColorScheme colorScheme = this;
                return colorScheme.addAll(colorScheme.optionParamStyles, (Ansi.IStyle[])var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public Ansi.Text commandText(String command) {
                void var1_1;
                return this.ansi().apply((String)var1_1, this.commandStyles);
            }

            /*
             * WARNING - void declaration
             */
            public Ansi.Text optionText(String option) {
                void var1_1;
                return this.ansi().apply((String)var1_1, this.optionStyles);
            }

            /*
             * WARNING - void declaration
             */
            public Ansi.Text parameterText(String parameter) {
                void var1_1;
                return this.ansi().apply((String)var1_1, this.parameterStyles);
            }

            /*
             * WARNING - void declaration
             */
            public Ansi.Text optionParamText(String optionParam) {
                void var1_1;
                return this.ansi().apply((String)var1_1, this.optionParamStyles);
            }

            public ColorScheme applySystemProperties() {
                ColorScheme colorScheme = this;
                colorScheme.replace(colorScheme.commandStyles, System.getProperty("picocli.color.commands"));
                ColorScheme colorScheme2 = this;
                colorScheme2.replace(colorScheme2.optionStyles, System.getProperty("picocli.color.options"));
                ColorScheme colorScheme3 = this;
                colorScheme3.replace(colorScheme3.parameterStyles, System.getProperty("picocli.color.parameters"));
                ColorScheme colorScheme4 = this;
                colorScheme4.replace(colorScheme4.optionParamStyles, System.getProperty("picocli.color.optionParams"));
                return this;
            }

            /*
             * WARNING - void declaration
             */
            private void replace(List<Ansi.IStyle> styles, String property) {
                if (property != null) {
                    void var2_2;
                    void var1_1;
                    styles.clear();
                    this.addAll((List<Ansi.IStyle>)var1_1, Ansi.Style.parse((String)var2_2));
                }
            }

            /*
             * WARNING - void declaration
             */
            private ColorScheme addAll(List<Ansi.IStyle> styles, Ansi.IStyle ... add) {
                void var2_2;
                styles.addAll(Arrays.asList(var2_2));
                return this;
            }

            public Ansi ansi() {
                return this.ansi;
            }
        }

        public static class Column {
            public final int width;
            public final int indent;
            public final Overflow overflow;

            /*
             * WARNING - void declaration
             */
            public Column(int width, int indent, Overflow overflow) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.width = var1_1;
                this.indent = var2_2;
                this.overflow = (Overflow)Assert.notNull(var3_3, "overflow");
            }

            public static enum Overflow {
                TRUNCATE,
                SPAN,
                WRAP;

            }
        }

        public static class TextTable {
            public final Column[] columns;
            protected final List<Ansi.Text> columnValues = new ArrayList<Ansi.Text>();
            public int indentWrappedLines = 2;
            private final Ansi ansi;

            /*
             * WARNING - void declaration
             */
            public TextTable(Ansi ansi) {
                this((Ansi)var1_1, new Column(2, 0, Column.Overflow.TRUNCATE), new Column(2, 0, Column.Overflow.TRUNCATE), new Column(1, 0, Column.Overflow.TRUNCATE), new Column(24, 1, Column.Overflow.SPAN), new Column(51, 1, Column.Overflow.WRAP));
                void var1_1;
            }

            public TextTable(Ansi ansi, int ... columnWidths) {
                this.ansi = Assert.notNull(ansi, "ansi");
                this.columns = new Column[columnWidths.length];
                for (int i = 0; i < columnWidths.length; ++i) {
                    this.columns[i] = new Column(columnWidths[i], 0, i == columnWidths.length - 1 ? Column.Overflow.SPAN : Column.Overflow.WRAP);
                }
            }

            /*
             * WARNING - void declaration
             */
            public TextTable(Ansi ansi, Column ... columns) {
                void var2_2;
                void var1_1;
                this.ansi = (Ansi)Assert.notNull(var1_1, "ansi");
                this.columns = Assert.notNull(columns, "columns");
                if (((void)var2_2).length == 0) {
                    throw new IllegalArgumentException("At least one column is required");
                }
            }

            /*
             * WARNING - void declaration
             */
            public Ansi.Text textAt(int row, int col) {
                void var1_1;
                void var2_2;
                return this.columnValues.get((int)(var2_2 + var1_1 * this.columns.length));
            }

            /*
             * WARNING - void declaration
             */
            @Deprecated
            public Ansi.Text cellAt(int row, int col) {
                void var2_2;
                void var1_1;
                return this.textAt((int)var1_1, (int)var2_2);
            }

            public int rowCount() {
                return this.columnValues.size() / this.columns.length;
            }

            public void addEmptyRow() {
                for (int i = 0; i < this.columns.length; ++i) {
                    Ansi ansi = this.ansi;
                    ((Object)((Object)ansi)).getClass();
                    this.columnValues.add(new Ansi.Text(ansi, this.columns[i].width));
                }
            }

            /*
             * WARNING - void declaration
             */
            public void addRowValues(String ... values) {
                void var2_2;
                Ansi.Text[] array = new Ansi.Text[values.length];
                for (int i = 0; i < array.length; ++i) {
                    Ansi.Text text;
                    if (values[i] == null) {
                        text = Ansi.EMPTY_TEXT;
                    } else {
                        Ansi ansi = this.ansi;
                        ((Object)((Object)ansi)).getClass();
                        text = new Ansi.Text(ansi, values[i]);
                    }
                    array[i] = text;
                }
                this.addRowValues((Ansi.Text[])var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void addRowValues(Ansi.Text ... values) {
                if (values.length > this.columns.length) {
                    throw new IllegalArgumentException(values.length + " values don't fit in " + this.columns.length + " columns");
                }
                this.addEmptyRow();
                for (int col = 0; col < values.length; ++col) {
                    void var3_3;
                    int row = this.rowCount() - 1;
                    Cell cell = this.putValue(row, col, values[col]);
                    if (cell.row == var3_3 && cell.column == col || col == values.length - 1) continue;
                    this.addEmptyRow();
                }
            }

            /*
             * WARNING - void declaration
             */
            public Cell putValue(int row, int col, Ansi.Text value) {
                if (row > this.rowCount() - 1) {
                    throw new IllegalArgumentException("Cannot write to row " + row + ": rowCount=" + this.rowCount());
                }
                if (value == null || value.plain.length() == 0) {
                    return new Cell(col, row);
                }
                Column column = this.columns[col];
                int indent = column.indent;
                switch (column.overflow) {
                    case TRUNCATE: {
                        TextTable.copy(value, this.textAt(row, col), indent);
                        return new Cell(col, row);
                    }
                    case SPAN: {
                        int charsWritten;
                        int startColumn = col;
                        do {
                            boolean bl = col == this.columns.length - 1;
                            charsWritten = bl ? this.copy(BreakIterator.getLineInstance(), value, this.textAt(row, col), indent) : TextTable.copy(value, this.textAt(row, col), indent);
                            value = value.substring(charsWritten);
                            charsWritten = 0;
                            if (value.length > 0) {
                                ++col;
                            }
                            if (value.length <= 0 || col < this.columns.length) continue;
                            this.addEmptyRow();
                            ++row;
                            col = startColumn;
                            charsWritten = column.indent + this.indentWrappedLines;
                        } while (value.length > 0);
                        return new Cell(col, row);
                    }
                    case WRAP: {
                        void var1_1;
                        void var2_2;
                        int charsWritten;
                        BreakIterator lineBreakIterator = BreakIterator.getLineInstance();
                        do {
                            charsWritten = this.copy(lineBreakIterator, value, this.textAt(row, col), charsWritten);
                            value = value.substring(charsWritten);
                            int n = column.indent + this.indentWrappedLines;
                            if (value.length <= 0) continue;
                            ++row;
                            this.addEmptyRow();
                        } while (value.length > 0);
                        return new Cell((int)var2_2, (int)var1_1);
                    }
                }
                throw new IllegalStateException(column.overflow.toString());
            }

            private static int length(Ansi.Text str) {
                return str.length;
            }

            /*
             * WARNING - void declaration
             */
            private int copy(BreakIterator line, Ansi.Text text, Ansi.Text columnValue, int offset) {
                line.setText(text.plainString().replace("-", "\u00ff"));
                int done = 0;
                int start = line.first();
                int end = line.next();
                while (end != -1) {
                    Ansi.Text word = text.substring(start, end);
                    if (columnValue.maxLength < offset + done + TextTable.length(word)) break;
                    done += TextTable.copy(word, columnValue, offset + done);
                    int n = end;
                    end = line.next();
                }
                if (done == 0 && TextTable.length(text) > columnValue.maxLength) {
                    void var3_3;
                    void var2_2;
                    done = TextTable.copy((Ansi.Text)var2_2, (Ansi.Text)var3_3, offset);
                }
                return done;
            }

            /*
             * WARNING - void declaration
             */
            private static int copy(Ansi.Text value, Ansi.Text destination, int offset) {
                void var3_3;
                void var2_2;
                void var1_1;
                Ansi.Text text;
                int length = Math.min(value.length, destination.maxLength - offset);
                Ansi.Text text2 = text;
                text2.getStyledChars(text2.from, length, (Ansi.Text)var1_1, (int)var2_2);
                return (int)var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public StringBuilder toString(StringBuilder text) {
                void var1_1;
                int columnCount = this.columns.length;
                StringBuilder row = new StringBuilder(80);
                for (int i = 0; i < this.columnValues.size(); ++i) {
                    int lastChar;
                    Ansi.Text column = this.columnValues.get(i);
                    row.append(column.toString());
                    row.append(new String(Help.spaces(this.columns[i % columnCount].width - column.length)));
                    if (i % columnCount != columnCount - 1) continue;
                    for (lastChar = row.length() - 1; lastChar >= 0 && row.charAt(lastChar) == ' '; --lastChar) {
                    }
                    row.setLength(lastChar + 1);
                    text.append(row.toString()).append(System.getProperty("line.separator"));
                    row.setLength(0);
                }
                return var1_1;
            }

            public String toString() {
                return this.toString(new StringBuilder()).toString();
            }

            public static class Cell {
                public final int column;
                public final int row;

                /*
                 * WARNING - void declaration
                 */
                public Cell(int column, int row) {
                    void var2_2;
                    void var1_1;
                    this.column = var1_1;
                    this.row = var2_2;
                }
            }
        }

        static class SortByOptionArityAndNameAlphabetically
        extends SortByShortestOptionNameAlphabetically {
            SortByOptionArityAndNameAlphabetically() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int compare(Field f1, Field f2) {
                f1.getAnnotation(Option.class);
                f2.getAnnotation(Option.class);
                Range arity1 = Range.optionArity(f1);
                Range arity2 = Range.optionArity(f2);
                int result = arity1.max - arity2.max;
                if (result == 0) {
                    void var3_3;
                    result = var3_3.min - arity2.min;
                }
                if (result == 0) {
                    if (CommandLine.isMultiValue(f1) && !CommandLine.isMultiValue(f2)) {
                        result = 1;
                    }
                    if (!CommandLine.isMultiValue(f1) && CommandLine.isMultiValue(f2)) {
                        result = -1;
                    }
                }
                if (result == 0) {
                    void var2_2;
                    void var1_1;
                    return super.compare((Field)var1_1, (Field)var2_2);
                }
                return result;
            }
        }

        static class SortByShortestOptionNameAlphabetically
        implements Comparator<Field> {
            SortByShortestOptionNameAlphabetically() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int compare(Field f1, Field f2) {
                void var2_2;
                void var1_1;
                void var3_3;
                Option o1 = f1.getAnnotation(Option.class);
                Option o2 = f2.getAnnotation(Option.class);
                if (o1 == null) {
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                String[] names1 = ShortestFirst.sort(o1.names());
                String[] names2 = ShortestFirst.sort(o2.names());
                int result = names1[0].toUpperCase().compareTo(names2[0].toUpperCase());
                int n = result = result == 0 ? -var3_3[0].compareTo(names2[0]) : result;
                if (var1_1.help() == o2.help()) {
                    return result;
                }
                if (var2_2.help()) {
                    return -1;
                }
                return 1;
            }
        }

        static class ShortestFirst
        implements Comparator<String> {
            ShortestFirst() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int compare(String o1, String o2) {
                void var2_2;
                return o1.length() - var2_2.length();
            }

            public static String[] sort(String[] names) {
                String[] stringArray;
                Arrays.sort(names, new ShortestFirst());
                return stringArray;
            }
        }

        public static class Layout {
            protected final ColorScheme colorScheme;
            protected final TextTable table;
            protected IOptionRenderer optionRenderer;
            protected IParameterRenderer parameterRenderer;

            /*
             * WARNING - void declaration
             */
            public Layout(ColorScheme colorScheme) {
                this(colorScheme, new TextTable(var1_1.ansi()));
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Layout(ColorScheme colorScheme, TextTable textTable) {
                this((ColorScheme)var1_1, (TextTable)var2_2, new DefaultOptionRenderer(), new DefaultParameterRenderer());
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Layout(ColorScheme colorScheme, TextTable textTable, IOptionRenderer optionRenderer, IParameterRenderer parameterRenderer) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.colorScheme = (ColorScheme)Assert.notNull(var1_1, "colorScheme");
                this.table = (TextTable)Assert.notNull(var2_2, "textTable");
                this.optionRenderer = (IOptionRenderer)Assert.notNull(var3_3, "optionRenderer");
                this.parameterRenderer = Assert.notNull(parameterRenderer, "parameterRenderer");
            }

            public void layout(Field field, Ansi.Text[][] cellValues) {
                Ansi.Text[][] textArray = cellValues;
                int n = cellValues.length;
                for (int i = 0; i < n; ++i) {
                    Ansi.Text[] oneRow = textArray[i];
                    this.table.addRowValues(oneRow);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void addOptions(List<Field> fields, IParamLabelRenderer paramLabelRenderer) {
                for (Field field : fields) {
                    void var3_3;
                    Option option = field.getAnnotation(Option.class);
                    if (option.hidden()) continue;
                    this.addOption((Field)var3_3, paramLabelRenderer);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void addOption(Field field, IParamLabelRenderer paramLabelRenderer) {
                void var2_2;
                void var1_1;
                void var3_3;
                Option option = field.getAnnotation(Option.class);
                Ansi.Text[][] values = this.optionRenderer.render((Option)var3_3, field, paramLabelRenderer, this.colorScheme);
                this.layout((Field)var1_1, (Ansi.Text[][])var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void addPositionalParameters(List<Field> fields, IParamLabelRenderer paramLabelRenderer) {
                for (Field field : fields) {
                    void var3_3;
                    Parameters parameters = field.getAnnotation(Parameters.class);
                    if (parameters.hidden()) continue;
                    this.addPositionalParameter((Field)var3_3, paramLabelRenderer);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void addPositionalParameter(Field field, IParamLabelRenderer paramLabelRenderer) {
                void var2_2;
                void var1_1;
                void var3_3;
                Parameters option = field.getAnnotation(Parameters.class);
                Ansi.Text[][] values = this.parameterRenderer.render((Parameters)var3_3, field, paramLabelRenderer, this.colorScheme);
                this.layout((Field)var1_1, (Ansi.Text[][])var2_2);
            }

            public String toString() {
                return this.table.toString();
            }
        }

        static class DefaultParamLabelRenderer
        implements IParamLabelRenderer {
            public final String separator;

            /*
             * WARNING - void declaration
             */
            public DefaultParamLabelRenderer(String separator) {
                void var1_1;
                this.separator = (String)Assert.notNull(var1_1, "separator");
            }

            @Override
            public String separator() {
                return this.separator;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Ansi.Text renderParameterLabel(Field field, Ansi ansi, List<Ansi.IStyle> styles) {
                Ansi.Text result;
                block6: {
                    int i;
                    Ansi.Text paramName;
                    String sep;
                    Range arity;
                    boolean isOptionParameter;
                    block4: {
                        block5: {
                            void var3_4;
                            isOptionParameter = field.isAnnotationPresent(Option.class);
                            arity = isOptionParameter ? Range.optionArity(field) : Range.parameterCapacity(field);
                            String split = isOptionParameter ? field.getAnnotation(Option.class).split() : field.getAnnotation(Parameters.class).split();
                            Ansi ansi2 = ansi;
                            ((Object)((Object)ansi2)).getClass();
                            result = new Ansi.Text(ansi2, "");
                            sep = isOptionParameter ? this.separator : "";
                            paramName = ansi.apply(DefaultParamLabelRenderer.renderParameterName(field), (List<Ansi.IStyle>)var3_4);
                            if (!CommandLine.empty(split)) {
                                paramName = paramName.append("[" + split).append(paramName).append("]...");
                            }
                            for (i = 0; i < arity.min; ++i) {
                                result = result.append(sep).append(paramName);
                                sep = " ";
                            }
                            if (!arity.isVariable) break block4;
                            if (result.length != 0) break block5;
                            result = result.append(sep + "[").append(paramName).append("]...");
                            break block6;
                        }
                        if (result.plainString().endsWith("...")) break block6;
                        result = result.append("...");
                        break block6;
                    }
                    sep = result.length == 0 ? (isOptionParameter ? this.separator : "") : " ";
                    for (i = arity.min; i < arity.max; ++i) {
                        result = sep.trim().length() == 0 ? result.append(sep + "[").append(paramName) : result.append("[" + sep).append(paramName);
                        sep = " ";
                    }
                    for (i = arity.min; i < arity.max; ++i) {
                        result = result.append("]");
                    }
                }
                return result;
            }

            /*
             * WARNING - void declaration
             */
            private static String renderParameterName(Field field) {
                void var1_1;
                String result = null;
                if (field.isAnnotationPresent(Option.class)) {
                    result = field.getAnnotation(Option.class).paramLabel();
                } else if (field.isAnnotationPresent(Parameters.class)) {
                    result = field.getAnnotation(Parameters.class).paramLabel();
                }
                if (result != null && result.trim().length() > 0) {
                    return result.trim();
                }
                String name = field.getName();
                if (Map.class.isAssignableFrom(field.getType())) {
                    Class[] classArray;
                    Class[] paramTypes = CommandLine.getTypeAttribute(field);
                    name = paramTypes.length < 2 || paramTypes[0] == null || paramTypes[1] == null ? "String=String" : paramTypes[0].getSimpleName() + Help.DEFAULT_SEPARATOR + classArray[1].getSimpleName();
                }
                return "<" + (String)var1_1 + ">";
            }
        }

        public static interface IParamLabelRenderer {
            public Ansi.Text renderParameterLabel(Field var1, Ansi var2, List<Ansi.IStyle> var3);

            public String separator();
        }

        static class DefaultParameterRenderer
        implements IParameterRenderer {
            public String requiredMarker = " ";

            DefaultParameterRenderer() {
            }

            @Override
            public Ansi.Text[][] render(Parameters params, Field field, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                int i;
                Ansi.Text[] textArray;
                Ansi.Text label = paramLabelRenderer.renderParameterLabel(field, scheme.ansi(), scheme.parameterStyles);
                Ansi.Text requiredParameter = scheme.parameterText(Range.parameterArity((Field)field).min > 0 ? this.requiredMarker : "");
                Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
                ArrayList<Ansi.Text[]> result = new ArrayList<Ansi.Text[]>();
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                Ansi.Text[] descriptionFirstLines = new Ansi.Text(ansi, CommandLine.access$3200(params.description(), 0)).splitLines();
                if (descriptionFirstLines.length == 0) {
                    descriptionFirstLines = new Ansi.Text[]{EMPTY};
                }
                result.add(new Ansi.Text[]{requiredParameter, EMPTY, EMPTY, textArray, descriptionFirstLines[0]});
                for (i = 1; i < descriptionFirstLines.length; ++i) {
                    result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, descriptionFirstLines[i]});
                }
                for (i = 1; i < params.description().length; ++i) {
                    Ansi ansi2 = scheme.ansi();
                    ((Object)((Object)ansi2)).getClass();
                    Ansi.Text[] textArray2 = new Ansi.Text(ansi2, params.description()[i]).splitLines();
                    textArray = textArray2;
                    textArray = textArray2;
                    int n = textArray2.length;
                    for (int j = 0; j < n; ++j) {
                        Ansi.Text line = textArray[j];
                        result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, line});
                    }
                }
                ArrayList<Ansi.Text[]> arrayList = result;
                return (Ansi.Text[][])arrayList.toArray((T[])new Ansi.Text[arrayList.size()][]);
            }
        }

        public static interface IParameterRenderer {
            public Ansi.Text[][] render(Parameters var1, Field var2, IParamLabelRenderer var3, ColorScheme var4);
        }

        static class MinimalParameterRenderer
        implements IParameterRenderer {
            MinimalParameterRenderer() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Ansi.Text[][] render(Parameters param, Field field, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                void var1_1;
                void var2_2;
                void var3_3;
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = var3_3.renderParameterLabel((Field)var2_2, scheme.ansi(), scheme.parameterStyles);
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = new Ansi.Text(ansi, param.description().length == 0 ? "" : var1_1.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class MinimalOptionRenderer
        implements IOptionRenderer {
            MinimalOptionRenderer() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Ansi.Text[][] render(Option option, Field field, IParamLabelRenderer parameterLabelRenderer, ColorScheme scheme) {
                void var1_1;
                void var2_2;
                void var3_3;
                Ansi.Text optionText = scheme.optionText(option.names()[0]);
                Ansi.Text paramLabelText = var3_3.renderParameterLabel(field, scheme.ansi(), scheme.optionParamStyles);
                optionText = optionText.append((Ansi.Text)var2_2);
                Ansi.Text[][] textArray = new Ansi.Text[1][];
                Ansi.Text[] textArray2 = new Ansi.Text[2];
                textArray2[0] = optionText;
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                textArray2[1] = new Ansi.Text(ansi, option.description().length == 0 ? "" : var1_1.description()[0]);
                textArray[0] = textArray2;
                return textArray;
            }
        }

        static class DefaultOptionRenderer
        implements IOptionRenderer {
            public String requiredMarker = " ";
            public Object command;
            private String sep;
            private boolean showDefault;

            DefaultOptionRenderer() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Ansi.Text[][] render(Option option, Field field, IParamLabelRenderer paramLabelRenderer, ColorScheme scheme) {
                void var2_2;
                void var3_3;
                void var1_1;
                String[] names = ShortestFirst.sort(option.names());
                int shortOptionCount = names[0].length() == 2 ? 1 : 0;
                String shortOption = shortOptionCount > 0 ? names[0] : "";
                this.sep = shortOptionCount > 0 && names.length > 1 ? "," : "";
                String longOption = Help.access$3000(names, shortOptionCount, names.length - shortOptionCount, ", ");
                Ansi.Text longOptionText = this.createLongOptionText(field, paramLabelRenderer, scheme, longOption);
                this.showDefault = this.command != null && !option.help() && !CommandLine.isBoolean(field.getType());
                Object defaultValue = this.createDefaultValue(field);
                String requiredOption = option.required() ? this.requiredMarker : "";
                return this.renderDescriptionLines((Option)var1_1, scheme, requiredOption, shortOption, (Ansi.Text)var3_3, var2_2);
            }

            /*
             * WARNING - void declaration
             */
            private Object createDefaultValue(Field field) {
                void var2_2;
                Object defaultValue = null;
                try {
                    defaultValue = field.get(this.command);
                    if (defaultValue == null) {
                        this.showDefault = false;
                    } else if (field.getType().isArray()) {
                        void var1_1;
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < Array.getLength(defaultValue); ++i) {
                            sb.append(i > 0 ? ", " : "").append(Array.get(defaultValue, i));
                        }
                        defaultValue = var1_1.insert(0, "[").append("]").toString();
                    }
                }
                catch (Exception exception) {
                    this.showDefault = false;
                }
                return var2_2;
            }

            /*
             * WARNING - void declaration
             */
            private Ansi.Text createLongOptionText(Field field, IParamLabelRenderer renderer, ColorScheme scheme, String longOption) {
                void var1_1;
                void var3_4;
                Ansi.Text paramLabelText = renderer.renderParameterLabel(field, scheme.ansi(), scheme.optionParamStyles);
                if (paramLabelText.length > 0 && longOption.length() == 0) {
                    void var2_3;
                    this.sep = renderer.separator();
                    int sepStart = paramLabelText.plainString().indexOf(this.sep);
                    Ansi.Text text = paramLabelText.substring(0, sepStart);
                    paramLabelText = text.append(paramLabelText.substring((int)(var2_3 + this.sep.length())));
                }
                Ansi.Text text = var3_4.optionText(longOption);
                text = text.append((Ansi.Text)var1_1);
                return text;
            }

            /*
             * WARNING - void declaration
             */
            private Ansi.Text[][] renderDescriptionLines(Option option, ColorScheme scheme, String requiredOption, String shortOption, Ansi.Text longOptionText, Object defaultValue) {
                int i;
                Ansi.Text EMPTY = Ansi.EMPTY_TEXT;
                ArrayList<Ansi.Text[]> result = new ArrayList<Ansi.Text[]>();
                Ansi ansi = scheme.ansi();
                ((Object)((Object)ansi)).getClass();
                Ansi.Text[] descriptionFirstLines = new Ansi.Text(ansi, CommandLine.access$3200(option.description(), 0)).splitLines();
                if (descriptionFirstLines.length == 0) {
                    if (this.showDefault) {
                        Ansi.Text[] textArray = new Ansi.Text[1];
                        Ansi ansi2 = scheme.ansi();
                        ((Object)((Object)ansi2)).getClass();
                        textArray[0] = new Ansi.Text(ansi2, "  Default: " + defaultValue);
                        descriptionFirstLines = textArray;
                        this.showDefault = false;
                    } else {
                        descriptionFirstLines = new Ansi.Text[]{EMPTY};
                    }
                }
                Ansi.Text[] textArray = new Ansi.Text[5];
                textArray[0] = scheme.optionText(requiredOption);
                textArray[1] = scheme.optionText(shortOption);
                Ansi ansi3 = scheme.ansi();
                ((Object)((Object)ansi3)).getClass();
                textArray[2] = new Ansi.Text(ansi3, this.sep);
                textArray[3] = longOptionText;
                textArray[4] = descriptionFirstLines[0];
                result.add(textArray);
                for (i = 1; i < descriptionFirstLines.length; ++i) {
                    result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, descriptionFirstLines[i]});
                }
                for (i = 1; i < option.description().length; ++i) {
                    Ansi ansi4 = scheme.ansi();
                    ((Object)((Object)ansi4)).getClass();
                    Ansi.Text[] textArray2 = new Ansi.Text(ansi4, option.description()[i]).splitLines();
                    Ansi.Text[] textArray3 = textArray2;
                    textArray3 = textArray2;
                    int n = textArray2.length;
                    for (int j = 0; j < n; ++j) {
                        Ansi.Text line = textArray3[j];
                        result.add(new Ansi.Text[]{EMPTY, EMPTY, EMPTY, EMPTY, line});
                    }
                }
                if (this.showDefault) {
                    void var2_2;
                    Ansi.Text[] textArray4 = new Ansi.Text[5];
                    textArray4[0] = EMPTY;
                    textArray4[1] = EMPTY;
                    textArray4[2] = EMPTY;
                    textArray4[3] = EMPTY;
                    Ansi ansi5 = var2_2.ansi();
                    ((Object)((Object)ansi5)).getClass();
                    textArray4[4] = new Ansi.Text(ansi5, "  Default: " + defaultValue);
                    result.add(textArray4);
                }
                ArrayList<Ansi.Text[]> arrayList = result;
                return (Ansi.Text[][])arrayList.toArray((T[])new Ansi.Text[arrayList.size()][]);
            }
        }

        public static interface IOptionRenderer {
            public Ansi.Text[][] render(Option var1, Field var2, IParamLabelRenderer var3, ColorScheme var4);
        }
    }

    private static class BuiltIn {
        private BuiltIn() {
        }

        static class UUIDConverter
        implements ITypeConverter<UUID> {
            UUIDConverter() {
            }

            @Override
            public UUID convert(String s) throws Exception {
                return UUID.fromString(s);
            }
        }

        static class PatternConverter
        implements ITypeConverter<Pattern> {
            PatternConverter() {
            }

            @Override
            public Pattern convert(String s) {
                return Pattern.compile(s);
            }
        }

        static class InetAddressConverter
        implements ITypeConverter<InetAddress> {
            InetAddressConverter() {
            }

            @Override
            public InetAddress convert(String s) throws Exception {
                return InetAddress.getByName(s);
            }
        }

        static class CharsetConverter
        implements ITypeConverter<Charset> {
            CharsetConverter() {
            }

            @Override
            public Charset convert(String s) {
                return Charset.forName(s);
            }
        }

        static class BigIntegerConverter
        implements ITypeConverter<BigInteger> {
            BigIntegerConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public BigInteger convert(String value) {
                void var1_1;
                return new BigInteger((String)var1_1);
            }
        }

        static class BigDecimalConverter
        implements ITypeConverter<BigDecimal> {
            BigDecimalConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public BigDecimal convert(String value) {
                void var1_1;
                return new BigDecimal((String)var1_1);
            }
        }

        static class ISO8601TimeConverter
        implements ITypeConverter<Time> {
            ISO8601TimeConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Time convert(String value) {
                void var1_1;
                try {
                    if (value.length() <= 5) {
                        return new Time(new SimpleDateFormat("HH:mm").parse(value).getTime());
                    }
                    if (value.length() <= 8) {
                        return new Time(new SimpleDateFormat("HH:mm:ss").parse(value).getTime());
                    }
                    if (value.length() <= 12) {
                        try {
                            return new Time(new SimpleDateFormat("HH:mm:ss.SSS").parse(value).getTime());
                        }
                        catch (ParseException parseException) {
                            return new Time(new SimpleDateFormat("HH:mm:ss,SSS").parse(value).getTime());
                        }
                    }
                }
                catch (ParseException parseException) {}
                throw new TypeConversionException("'" + (String)var1_1 + "' is not a HH:mm[:ss[.SSS]] time");
            }
        }

        static class ISO8601DateConverter
        implements ITypeConverter<Date> {
            ISO8601DateConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Date convert(String value) {
                try {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(value);
                }
                catch (ParseException parseException) {
                    void var1_1;
                    throw new TypeConversionException("'" + (String)var1_1 + "' is not a yyyy-MM-dd date");
                }
            }
        }

        static class URIConverter
        implements ITypeConverter<URI> {
            URIConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public URI convert(String value) throws URISyntaxException {
                void var1_1;
                return new URI((String)var1_1);
            }
        }

        static class URLConverter
        implements ITypeConverter<URL> {
            URLConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public URL convert(String value) throws MalformedURLException {
                void var1_1;
                return new URL((String)var1_1);
            }
        }

        static class FileConverter
        implements ITypeConverter<File> {
            FileConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public File convert(String value) {
                void var1_1;
                return new File((String)var1_1);
            }
        }

        static class DoubleConverter
        implements ITypeConverter<Double> {
            DoubleConverter() {
            }

            @Override
            public Double convert(String value) {
                return Double.valueOf(value);
            }
        }

        static class FloatConverter
        implements ITypeConverter<Float> {
            FloatConverter() {
            }

            @Override
            public Float convert(String value) {
                return Float.valueOf(value);
            }
        }

        static class LongConverter
        implements ITypeConverter<Long> {
            LongConverter() {
            }

            @Override
            public Long convert(String value) {
                return Long.valueOf(value);
            }
        }

        static class IntegerConverter
        implements ITypeConverter<Integer> {
            IntegerConverter() {
            }

            @Override
            public Integer convert(String value) {
                return Integer.valueOf(value);
            }
        }

        static class ShortConverter
        implements ITypeConverter<Short> {
            ShortConverter() {
            }

            @Override
            public Short convert(String value) {
                return Short.valueOf(value);
            }
        }

        static class CharacterConverter
        implements ITypeConverter<Character> {
            CharacterConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Character convert(String value) {
                void var1_1;
                if (value.length() > 1) {
                    throw new TypeConversionException("'" + value + "' is not a single character");
                }
                return Character.valueOf(var1_1.charAt(0));
            }
        }

        static class BooleanConverter
        implements ITypeConverter<Boolean> {
            BooleanConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Boolean convert(String value) {
                void var1_1;
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    return Boolean.parseBoolean(value);
                }
                throw new TypeConversionException("'" + (String)var1_1 + "' is not a boolean");
            }
        }

        static class ByteConverter
        implements ITypeConverter<Byte> {
            ByteConverter() {
            }

            @Override
            public Byte convert(String value) {
                return Byte.valueOf(value);
            }
        }

        static class CharSequenceConverter
        implements ITypeConverter<CharSequence> {
            CharSequenceConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }

        static class StringBuilderConverter
        implements ITypeConverter<StringBuilder> {
            StringBuilderConverter() {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public StringBuilder convert(String value) {
                void var1_1;
                return new StringBuilder((String)var1_1);
            }
        }

        static class StringConverter
        implements ITypeConverter<String> {
            StringConverter() {
            }

            @Override
            public String convert(String value) {
                return value;
            }
        }

        static class PathConverter
        implements ITypeConverter<Path> {
            PathConverter() {
            }

            @Override
            public Path convert(String value) {
                return Paths.get(value, new String[0]);
            }
        }
    }

    private static class PositionalParametersSorter
    implements Comparator<Field> {
        private PositionalParametersSorter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compare(Field o1, Field o2) {
            void var3_3;
            int result = Range.parameterIndex(o1).compareTo(Range.parameterIndex(o2));
            if (result == 0) {
                void var2_2;
                void var1_1;
                return Range.parameterArity((Field)var1_1).compareTo(Range.parameterArity((Field)var2_2));
            }
            return (int)var3_3;
        }
    }

    private class Interpreter {
        private final Map<String, CommandLine> commands = new LinkedHashMap<String, CommandLine>();
        private final Map<Class<?>, ITypeConverter<?>> converterRegistry = new HashMap();
        private final Map<String, Field> optionName2Field = new HashMap<String, Field>();
        private final Map<Character, Field> singleCharOption2Field = new HashMap<Character, Field>();
        private final List<Field> requiredFields = new ArrayList<Field>();
        private final List<Field> positionalParametersFields = new ArrayList<Field>();
        private final Object command;
        private boolean isHelpRequested;
        private String separator = "=";
        private int position;

        /*
         * WARNING - void declaration
         */
        Interpreter(Object command) {
            this.converterRegistry.put(Path.class, new BuiltIn.PathConverter());
            this.converterRegistry.put(Object.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(String.class, new BuiltIn.StringConverter());
            this.converterRegistry.put(StringBuilder.class, new BuiltIn.StringBuilderConverter());
            this.converterRegistry.put(CharSequence.class, new BuiltIn.CharSequenceConverter());
            this.converterRegistry.put(Byte.class, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Byte.TYPE, new BuiltIn.ByteConverter());
            this.converterRegistry.put(Boolean.class, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Boolean.TYPE, new BuiltIn.BooleanConverter());
            this.converterRegistry.put(Character.class, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Character.TYPE, new BuiltIn.CharacterConverter());
            this.converterRegistry.put(Short.class, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Short.TYPE, new BuiltIn.ShortConverter());
            this.converterRegistry.put(Integer.class, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Integer.TYPE, new BuiltIn.IntegerConverter());
            this.converterRegistry.put(Long.class, new BuiltIn.LongConverter());
            this.converterRegistry.put(Long.TYPE, new BuiltIn.LongConverter());
            this.converterRegistry.put(Float.class, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Float.TYPE, new BuiltIn.FloatConverter());
            this.converterRegistry.put(Double.class, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(Double.TYPE, new BuiltIn.DoubleConverter());
            this.converterRegistry.put(File.class, new BuiltIn.FileConverter());
            this.converterRegistry.put(URI.class, new BuiltIn.URIConverter());
            this.converterRegistry.put(URL.class, new BuiltIn.URLConverter());
            this.converterRegistry.put(Date.class, new BuiltIn.ISO8601DateConverter());
            this.converterRegistry.put(Time.class, new BuiltIn.ISO8601TimeConverter());
            this.converterRegistry.put(BigDecimal.class, new BuiltIn.BigDecimalConverter());
            this.converterRegistry.put(BigInteger.class, new BuiltIn.BigIntegerConverter());
            this.converterRegistry.put(Charset.class, new BuiltIn.CharsetConverter());
            this.converterRegistry.put(InetAddress.class, new BuiltIn.InetAddressConverter());
            this.converterRegistry.put(Pattern.class, new BuiltIn.PatternConverter());
            this.converterRegistry.put(UUID.class, new BuiltIn.UUIDConverter());
            this.command = Assert.notNull(command, "command");
            String declaredName = null;
            String declaredSeparator = null;
            boolean hasCommandAnnotation = false;
            for (Class<?> cls = command.getClass(); cls != null; cls = cls.getSuperclass()) {
                CommandLine.init(cls, this.requiredFields, this.optionName2Field, this.singleCharOption2Field, this.positionalParametersFields);
                if (!cls.isAnnotationPresent(Command.class)) continue;
                hasCommandAnnotation = true;
                Command cmd = cls.getAnnotation(Command.class);
                declaredSeparator = declaredSeparator == null ? cmd.separator() : declaredSeparator;
                declaredName = declaredName == null ? cmd.name() : declaredName;
                CommandLine.this.versionLines.addAll(Arrays.asList(cmd.version()));
                for (Class<?> sub : cmd.subcommands()) {
                    Object commandLine2;
                    Command subCommand = sub.getAnnotation(Command.class);
                    if (subCommand == null || "<main class>".equals(subCommand.name())) {
                        throw new InitializationException("Subcommand " + sub.getName() + " is missing the mandatory @Command annotation with a 'name' attribute");
                    }
                    try {
                        Constructor<?> constructor = sub.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        commandLine2 = CommandLine.toCommandLine(constructor.newInstance(new Object[0]));
                        CommandLine.access$1302((CommandLine)commandLine2, CommandLine.this);
                        this.commands.put(subCommand.name(), (CommandLine)commandLine2);
                    }
                    catch (InitializationException initializationException) {
                        commandLine2 = initializationException;
                        throw initializationException;
                    }
                    catch (NoSuchMethodException ex) {
                        throw new InitializationException("Cannot instantiate subcommand " + sub.getName() + ": the class has no constructor", ex);
                    }
                    catch (Exception ex) {
                        throw new InitializationException("Could not instantiate and add subcommand " + sub.getName() + ": " + ex, ex);
                    }
                }
            }
            this.separator = declaredSeparator != null ? declaredSeparator : this.separator;
            CommandLine.access$1402(CommandLine.this, declaredName != null ? declaredName : CommandLine.this.commandName);
            Collections.sort(this.positionalParametersFields, new PositionalParametersSorter());
            CommandLine.validatePositionalParameters(this.positionalParametersFields);
            if (this.positionalParametersFields.isEmpty() && this.optionName2Field.isEmpty() && !hasCommandAnnotation) {
                void var2_2;
                throw new InitializationException(command + " (" + var2_2.getClass() + ") is not a command: it has no @Command, @Option or @Parameters annotations");
            }
        }

        /*
         * WARNING - void declaration
         */
        List<CommandLine> parse(String ... args) {
            void var3_4;
            void var1_1;
            void var2_2;
            Assert.notNull(args, "argument array");
            if (CommandLine.this.tracer.isInfo()) {
                CommandLine.this.tracer.info("Parsing %d command line args %s%n", args.length, Arrays.toString(args));
            }
            Stack<String> arguments = new Stack<String>();
            for (int i = args.length - 1; i >= 0; --i) {
                arguments.push(args[i]);
            }
            ArrayList<CommandLine> result = new ArrayList<CommandLine>();
            this.parse(result, (Stack<String>)var2_2, (String[])var1_1);
            return var3_4;
        }

        /*
         * WARNING - void declaration
         */
        private void parse(List<CommandLine> parsedCommands, Stack<String> argumentStack, String[] originalArgs) {
            void var2_3;
            this.isHelpRequested = false;
            CommandLine.access$1702(CommandLine.this, false);
            CommandLine.access$1802(CommandLine.this, false);
            Class<?> cmdClass = this.command.getClass();
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Initializing %s: %d options, %d positional parameters, %d required, %d subcommands.%n", cmdClass.getName(), new HashSet<Field>(this.optionName2Field.values()).size(), this.positionalParametersFields.size(), this.requiredFields.size(), this.commands.size());
            }
            parsedCommands.add((CommandLine)CommandLine.this);
            ArrayList<Field> required = new ArrayList<Field>(this.requiredFields);
            HashSet<Field> initialized = new HashSet<Field>();
            Collections.sort(required, new PositionalParametersSorter());
            try {
                this.processArguments((List<CommandLine>)parsedCommands, argumentStack, (Collection<Field>)required, (Set<Field>)initialized, originalArgs);
            }
            catch (ParameterException parameterException) {
                parsedCommands = parameterException;
                throw parameterException;
            }
            catch (Exception ex) {
                void var3_4;
                void var1_2;
                int offendingArgIndex = originalArgs.length - argumentStack.size() - 1;
                String arg = offendingArgIndex >= 0 && offendingArgIndex < originalArgs.length ? originalArgs[offendingArgIndex] : "?";
                throw ParameterException.access$1900(CommandLine.this, (Exception)var1_2, (String)var2_3, offendingArgIndex, (String[])var3_4);
            }
            if (!this.isAnyHelpRequested() && !required.isEmpty()) {
                for (Field missing : required) {
                    if (missing.isAnnotationPresent(Option.class)) {
                        throw MissingParameterException.access$2000(CommandLine.this, required, this.separator);
                    }
                    Field field = missing;
                    this.assertNoMissingParameters(field, Range.parameterArity((Field)field).min, (Stack<String>)var2_3);
                }
            }
            if (!CommandLine.this.unmatchedArguments.isEmpty()) {
                if (!CommandLine.this.isUnmatchedArgumentsAllowed()) {
                    throw new UnmatchedArgumentException(CommandLine.this, CommandLine.this.unmatchedArguments);
                }
                if (CommandLine.this.tracer.isWarn()) {
                    CommandLine.this.tracer.warn("Unmatched arguments: %s%n", CommandLine.this.unmatchedArguments);
                }
            }
        }

        private void processArguments(List<CommandLine> parsedCommands, Stack<String> args, Collection<Field> required, Set<Field> initialized, String[] originalArgs) throws Exception {
            while (!args.isEmpty()) {
                String arg = args.pop();
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Processing argument '%s'. Remainder=%s%n", arg, CommandLine.reverse((Stack)args.clone()));
                }
                if ("--".equals(arg)) {
                    CommandLine.this.tracer.info("Found end-of-options delimiter '--'. Treating remainder as positional parameters.%n", new Object[0]);
                    this.processRemainderAsPositionalParameters(required, initialized, args);
                    return;
                }
                if (this.commands.containsKey(arg)) {
                    if (!this.isHelpRequested && !required.isEmpty()) {
                        throw MissingParameterException.access$2000(CommandLine.this, required, this.separator);
                    }
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Found subcommand '%s' (%s)%n", arg, ((CommandLine)this.commands.get((Object)arg)).interpreter.command.getClass().getName());
                    }
                    this.commands.get(arg).interpreter.parse(parsedCommands, args, originalArgs);
                    return;
                }
                boolean paramAttachedToOption = false;
                int separatorIndex = arg.indexOf(this.separator);
                if (separatorIndex > 0) {
                    String key = arg.substring(0, separatorIndex);
                    if (this.optionName2Field.containsKey(key) && !this.optionName2Field.containsKey(arg)) {
                        paramAttachedToOption = true;
                        String optionParam = arg.substring(separatorIndex + this.separator.length());
                        args.push(optionParam);
                        arg = key;
                        if (CommandLine.this.tracer.isDebug()) {
                            CommandLine.this.tracer.debug("Separated '%s' option from '%s' option parameter%n", key, optionParam);
                        }
                    } else if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("'%s' contains separator '%s' but '%s' is not a known option%n", arg, this.separator, key);
                    }
                } else if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("'%s' cannot be separated into <option>%s<option-parameter>%n", arg, this.separator);
                }
                if (this.optionName2Field.containsKey(arg)) {
                    this.processStandaloneOption(required, initialized, arg, args, paramAttachedToOption);
                    continue;
                }
                if (arg.length() > 2 && arg.startsWith("-")) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Trying to process '%s' as clustered short options%n", arg, args);
                    }
                    this.processClusteredShortOptions(required, initialized, arg, args);
                    continue;
                }
                args.push(arg);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Could not find option '%s', deciding whether to treat as unmatched option or positional parameter...%n", arg);
                }
                if (this.resemblesOption(arg)) {
                    this.handleUnmatchedArguments(args.pop());
                    continue;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option named '%s' found. Processing remainder as positional parameters%n", arg);
                }
                this.processPositionalParameter(required, initialized, args);
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean resemblesOption(String arg) {
            void var3_4;
            boolean result;
            int count = 0;
            for (String optionName : this.optionName2Field.keySet()) {
                for (int i = 0; i < arg.length() && optionName.length() > i && arg.charAt(i) == optionName.charAt(i); ++i) {
                    ++count;
                }
            }
            boolean bl = result = count > 0 && count * 10 >= this.optionName2Field.size() * 9;
            if (CommandLine.this.tracer.isDebug()) {
                void var2_2;
                void var1_1;
                CommandLine.this.tracer.debug("%s %s an option: %d matching prefix chars out of %d option names%n", var1_1, result ? "resembles" : "doesn't resemble", (int)var2_2, this.optionName2Field.size());
            }
            return (boolean)var3_4;
        }

        /*
         * WARNING - void declaration
         */
        private void handleUnmatchedArguments(String arg) {
            void var2_2;
            void var1_1;
            Stack<void> args = new Stack<void>();
            args.add(var1_1);
            this.handleUnmatchedArguments((Stack<String>)var2_2);
        }

        private void handleUnmatchedArguments(Stack<String> args) {
            while (!args.isEmpty()) {
                CommandLine.this.unmatchedArguments.add(args.pop());
            }
        }

        private void processRemainderAsPositionalParameters(Collection<Field> required, Set<Field> initialized, Stack<String> args) throws Exception {
            while (!args.empty()) {
                this.processPositionalParameter(required, initialized, args);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processPositionalParameter(Collection<Field> required, Set<Field> initialized, Stack<String> args) throws Exception {
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Processing next arg as a positional parameter at index=%d. Remainder=%s%n", this.position, CommandLine.reverse((Stack)args.clone()));
            }
            int consumed = 0;
            for (Field positionalParam : this.positionalParametersFields) {
                Range indexRange = Range.parameterIndex(positionalParam);
                if (!indexRange.contains(this.position)) continue;
                Stack argsCopy = (Stack)args.clone();
                Range arity = Range.parameterArity(positionalParam);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Position %d is in index range %s. Trying to assign args to %s, arity=%s%n", this.position, indexRange, positionalParam, arity);
                }
                this.assertNoMissingParameters(positionalParam, arity.min, argsCopy);
                int originalSize = argsCopy.size();
                this.applyOption(positionalParam, Parameters.class, arity, false, argsCopy, initialized, "args[" + indexRange + "] at position " + this.position);
                int count = originalSize - argsCopy.size();
                if (count > 0) {
                    required.remove(positionalParam);
                }
                consumed = Math.max(consumed, count);
            }
            for (int i = 0; i < consumed; ++i) {
                args.pop();
            }
            this.position += consumed;
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Consumed %d arguments, moving position to index %d.%n", consumed, this.position);
            }
            if (consumed == 0 && !args.isEmpty()) {
                void var3_3;
                this.handleUnmatchedArguments((String)var3_3.pop());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void processStandaloneOption(Collection<Field> required, Set<Field> initialized, String arg, Stack<String> args, boolean paramAttachedToKey) throws Exception {
            void var3_3;
            void var2_2;
            void var1_1;
            Field field = this.optionName2Field.get(arg);
            required.remove(field);
            Range arity = Range.optionArity(field);
            if (paramAttachedToKey) {
                arity = arity.min(Math.max(1, arity.min));
            }
            if (CommandLine.this.tracer.isDebug()) {
                CommandLine.this.tracer.debug("Found option named '%s': field %s, arity=%s%n", arg, field, arity);
            }
            this.applyOption(field, Option.class, (Range)var1_1, paramAttachedToKey, args, (Set<Field>)var2_2, "option " + (String)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private void processClusteredShortOptions(Collection<Field> required, Set<Field> initialized, String arg, Stack<String> args) throws Exception {
            void var2_2;
            void var1_1;
            String prefix = arg.substring(0, 1);
            String cluster = arg.substring(1);
            boolean paramAttachedToOption = true;
            while (cluster.length() > 0 && this.singleCharOption2Field.containsKey(Character.valueOf(cluster.charAt(0)))) {
                Field field = this.singleCharOption2Field.get(Character.valueOf(cluster.charAt(0)));
                Range arity = Range.optionArity(field);
                String argDescription = "option " + prefix + cluster.charAt(0);
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Found option '%s%s' in %s: field %s, arity=%s%n", prefix, Character.valueOf(cluster.charAt(0)), arg, field, arity);
                }
                required.remove(field);
                cluster = cluster.length() > 0 ? cluster.substring(1) : "";
                boolean bl = paramAttachedToOption = cluster.length() > 0;
                if (cluster.startsWith(this.separator)) {
                    cluster = cluster.substring(this.separator.length());
                    arity = arity.min(Math.max(1, arity.min));
                }
                if (arity.min > 0 && !CommandLine.empty(cluster) && CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("Trying to process '%s' as option parameter%n", cluster);
                }
                if (!CommandLine.empty(cluster)) {
                    args.push(cluster);
                }
                int consumed = this.applyOption(field, Option.class, arity, paramAttachedToOption, args, initialized, argDescription);
                if (CommandLine.empty(cluster) || consumed > 0 || args.isEmpty()) {
                    return;
                }
                cluster = args.pop();
            }
            if (cluster.length() == 0) {
                return;
            }
            if (arg.endsWith(cluster)) {
                args.push(paramAttachedToOption ? prefix + cluster : cluster);
                if (args.peek().equals(arg)) {
                    if (CommandLine.this.tracer.isDebug()) {
                        CommandLine.this.tracer.debug("Could not match any short options in %s, deciding whether to treat as unmatched option or positional parameter...%n", arg);
                    }
                    if (this.resemblesOption(arg)) {
                        this.handleUnmatchedArguments(args.pop());
                        return;
                    }
                    this.processPositionalParameter(required, initialized, args);
                    return;
                }
                if (CommandLine.this.tracer.isDebug()) {
                    CommandLine.this.tracer.debug("No option found for %s in %s%n", cluster, arg);
                }
                this.handleUnmatchedArguments(args.pop());
                return;
            }
            args.push(cluster);
            if (CommandLine.this.tracer.isDebug()) {
                void var3_3;
                CommandLine.this.tracer.debug("%s is not an option parameter for %s%n", cluster, var3_3);
            }
            this.processPositionalParameter((Collection<Field>)var1_1, (Set<Field>)var2_2, args);
        }

        /*
         * WARNING - void declaration
         */
        private int applyOption(Field field, Class<?> annotation, Range arity, boolean valueAttachedToOption, Stack<String> args, Set<Field> initialized, String argDescription) throws Exception {
            void var3_3;
            void var1_1;
            this.updateHelpRequested(field);
            args.size();
            this.assertNoMissingParameters(field, arity.min, args);
            Class cls = field.getType();
            if (cls.isArray()) {
                return this.applyValuesToArrayField(field, annotation, arity, args, cls, argDescription);
            }
            if (Collection.class.isAssignableFrom(cls)) {
                return this.applyValuesToCollectionField(field, annotation, arity, args, cls, argDescription);
            }
            if (Map.class.isAssignableFrom(cls)) {
                void var2_2;
                return this.applyValuesToMapField(field, (Class<?>)var2_2, arity, args, cls, argDescription);
            }
            cls = CommandLine.getTypeAttribute(field)[0];
            return this.applyValueToSingleValuedField((Field)var1_1, (Range)var3_3, args, cls, initialized, argDescription);
        }

        /*
         * WARNING - void declaration
         */
        private int applyValueToSingleValuedField(Field field, Range arity, Stack<String> args, Class<?> cls, Set<Field> initialized, String argDescription) throws Exception {
            void var2_2;
            void var1_1;
            boolean noMoreValues = args.isEmpty();
            String value = args.isEmpty() ? null : this.trim(args.pop());
            int result = arity.min;
            if ((cls == Boolean.class || cls == Boolean.TYPE) && arity.min <= 0) {
                if (arity.max > 0 && ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value))) {
                    result = 1;
                } else {
                    Boolean currentValue;
                    if (value != null) {
                        args.push(value);
                    }
                    value = String.valueOf((currentValue = (Boolean)field.get(this.command)) == null ? true : currentValue == false);
                }
            }
            if (noMoreValues && value == null) {
                return 0;
            }
            ITypeConverter<?> converter = this.getTypeConverter(cls, field);
            Object newValue = this.tryConvert(field, -1, converter, value, cls);
            Object oldValue = field.get(this.command);
            TraceLevel level = TraceLevel.INFO;
            String traceMessage = "Setting %s field '%s.%s' to '%5$s' (was '%4$s') for %6$s%n";
            if (initialized != null) {
                if (initialized.contains(field)) {
                    if (!CommandLine.this.isOverwrittenOptionsAllowed()) {
                        throw new OverwrittenOptionException(CommandLine.this, this.optionDescription("", field, 0) + " should be specified only once");
                    }
                    level = TraceLevel.WARN;
                    traceMessage = "Overwriting %s field '%s.%s' value '%s' with '%s' for %s%n";
                }
                initialized.add(field);
            }
            if (((CommandLine)CommandLine.this).tracer.level.isEnabled(level)) {
                void var3_3;
                TraceLevel.access$2600(level, CommandLine.this.tracer, traceMessage, new Object[]{field.getType().getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), String.valueOf(var3_3), String.valueOf(newValue), argDescription});
            }
            var1_1.set(this.command, var2_2);
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private int applyValuesToMapField(Field field, Class<?> annotation, Range arity, Stack<String> args, Class<?> cls, String argDescription) throws Exception {
            void var2_2;
            void var3_3;
            void var1_1;
            Class[] classes = CommandLine.getTypeAttribute(field);
            if (classes.length < 2) {
                throw new ParameterException(CommandLine.this, "Field " + field + " needs two types (one for the map key, one for the value) but only has " + classes.length + " types configured.");
            }
            ITypeConverter<?> keyConverter = this.getTypeConverter(classes[0], field);
            ITypeConverter<?> valueConverter = this.getTypeConverter(classes[1], field);
            Map<Object, Object> result = (Map<Object, Object>)field.get(this.command);
            if (result == null) {
                result = this.createMap(cls);
                field.set(this.command, result);
            }
            int originalSize = result.size();
            this.consumeMapArguments((Field)var1_1, (Range)var3_3, args, (Class<?>[])var2_2, keyConverter, valueConverter, result, argDescription);
            return result.size() - originalSize;
        }

        private void consumeMapArguments(Field field, Range arity, Stack<String> args, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, Map<Object, Object> result, String argDescription) throws Exception {
            int i;
            for (i = 0; i < arity.min; ++i) {
                this.consumeOneMapArgument(field, arity, args, classes, keyConverter, valueConverter, result, i, argDescription);
            }
            for (i = arity.min; i < arity.max && !args.isEmpty(); ++i) {
                if (!field.isAnnotationPresent(Parameters.class) && (this.commands.containsKey(args.peek()) || this.isOption(args.peek()))) {
                    return;
                }
                this.consumeOneMapArgument(field, arity, args, classes, keyConverter, valueConverter, result, i, argDescription);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void consumeOneMapArgument(Field field, Range arity, Stack<String> args, Class<?>[] classes, ITypeConverter<?> keyConverter, ITypeConverter<?> valueConverter, Map<Object, Object> result, int index, String argDescription) throws Exception {
            void var3_3;
            Interpreter interpreter = this;
            String[] stringArray = interpreter.split(interpreter.trim((String)var3_3.pop()), field);
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String value = stringArray2[i];
                String[] keyValue = value.split("=");
                if (keyValue.length < 2) {
                    String splitRegex = this.splitRegex(field);
                    if (splitRegex.length() == 0) {
                        throw new ParameterException(CommandLine.this, "Value for option " + this.optionDescription("", field, 0) + " should be in KEY=VALUE format but was " + value);
                    }
                    throw new ParameterException(CommandLine.this, "Value for option " + this.optionDescription("", field, 0) + " should be in KEY=VALUE[" + splitRegex + "KEY=VALUE]... format but was " + value);
                }
                Object mapKey = this.tryConvert(field, index, keyConverter, keyValue[0], classes[0]);
                Object mapValue = this.tryConvert(field, index, valueConverter, keyValue[1], classes[1]);
                result.put(mapKey, mapValue);
                if (!CommandLine.this.tracer.isInfo()) continue;
                CommandLine.this.tracer.info("Putting [%s : %s] in %s<%s, %s> field '%s.%s' for %s%n", String.valueOf(mapKey), String.valueOf(mapValue), result.getClass().getSimpleName(), classes[0].getSimpleName(), classes[1].getSimpleName(), field.getDeclaringClass().getSimpleName(), field.getName(), argDescription);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void checkMaxArityExceeded(Range arity, int remainder, Field field, String[] values) {
            void var2_2;
            void var1_1;
            void var3_3;
            if (values.length <= remainder) {
                return;
            }
            if (arity.max == remainder) {
                new StringBuilder().append(remainder);
            } else {
                new StringBuilder().append(arity).append(", remainder=").append(remainder);
            }
            throw new MaxValuesforFieldExceededException(CommandLine.this, this.optionDescription("", (Field)var3_3, -1) + " max number of values (" + var1_1.max + ") exceeded: remainder is " + (int)var2_2 + " but " + values.length + " values were specified: " + Arrays.toString(values));
        }

        /*
         * WARNING - void declaration
         */
        private int applyValuesToArrayField(Field field, Class<?> annotation, Range arity, Stack<String> args, Class<?> cls, String argDescription) throws Exception {
            void var2_2;
            void var1_1;
            Object existing = field.get(this.command);
            int length = existing == null ? 0 : Array.getLength(existing);
            Class type = CommandLine.getTypeAttribute(field)[0];
            List<Object> converted = this.consumeArguments(field, annotation, arity, args, type, length, argDescription);
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                newValues.add(Array.get(existing, i));
            }
            for (Object obj : converted) {
                if (obj instanceof Collection) {
                    newValues.addAll((Collection)obj);
                    continue;
                }
                newValues.add(obj);
            }
            Object array = Array.newInstance(type, newValues.size());
            var1_1.set(this.command, array);
            for (int i = 0; i < newValues.size(); ++i) {
                Array.set(array, i, newValues.get(i));
            }
            return var2_2.size();
        }

        /*
         * WARNING - void declaration
         */
        private int applyValuesToCollectionField(Field field, Class<?> annotation, Range arity, Stack<String> args, Class<?> cls, String argDescription) throws Exception {
            void var2_2;
            Collection<Object> collection = (Collection<Object>)field.get(this.command);
            Class type = CommandLine.getTypeAttribute(field)[0];
            int length = collection == null ? 0 : collection.size();
            List<Object> converted = this.consumeArguments(field, annotation, arity, args, type, length, argDescription);
            if (collection == null) {
                Iterator<Object> iterator;
                collection = this.createCollection(cls);
                ((Field)((Object)iterator)).set(this.command, collection);
            }
            for (Object element : converted) {
                void var3_3;
                if (element instanceof Collection) {
                    collection.addAll((Collection)element);
                    continue;
                }
                collection.add(var3_3);
            }
            return var2_2.size();
        }

        private List<Object> consumeArguments(Field field, Class<?> annotation, Range arity, Stack<String> args, Class<?> type, int originalSize, String argDescription) throws Exception {
            int i;
            ArrayList<Object> result = new ArrayList<Object>();
            for (i = 0; i < arity.min; ++i) {
                this.consumeOneArgument(field, arity, args, type, result, i, originalSize, argDescription);
            }
            for (i = arity.min; i < arity.max && !args.isEmpty(); ++i) {
                if (annotation != Parameters.class && (this.commands.containsKey(args.peek()) || this.isOption(args.peek()))) {
                    return result;
                }
                this.consumeOneArgument(field, arity, args, type, result, i, originalSize, argDescription);
            }
            return result;
        }

        private int consumeOneArgument(Field field, Range arity, Stack<String> args, Class<?> type, List<Object> result, int index, int originalSize, String argDescription) throws Exception {
            Interpreter interpreter = this;
            String[] values = interpreter.split(interpreter.trim(args.pop()), field);
            ITypeConverter<?> converter = this.getTypeConverter(type, field);
            for (int j = 0; j < values.length; ++j) {
                result.add(this.tryConvert(field, index, converter, values[j], type));
                if (!CommandLine.this.tracer.isInfo()) continue;
                if (field.getType().isArray()) {
                    Object[] objectArray = new Object[5];
                    List<Object> list = result;
                    objectArray[0] = String.valueOf(list.get(list.size() - 1));
                    objectArray[1] = type.getSimpleName();
                    objectArray[2] = field.getDeclaringClass().getSimpleName();
                    objectArray[3] = field.getName();
                    objectArray[4] = argDescription;
                    CommandLine.this.tracer.info("Adding [%s] to %s[] field '%s.%s' for %s%n", objectArray);
                    continue;
                }
                Object[] objectArray = new Object[6];
                List<Object> list = result;
                objectArray[0] = String.valueOf(list.get(list.size() - 1));
                objectArray[1] = field.getType().getSimpleName();
                objectArray[2] = type.getSimpleName();
                objectArray[3] = field.getDeclaringClass().getSimpleName();
                objectArray[4] = field.getName();
                objectArray[5] = argDescription;
                CommandLine.this.tracer.info("Adding [%s] to %s<%s> field '%s.%s' for %s%n", objectArray);
            }
            return ++index;
        }

        /*
         * WARNING - void declaration
         */
        private String splitRegex(Field field) {
            if (field.isAnnotationPresent(Option.class)) {
                return field.getAnnotation(Option.class).split();
            }
            if (field.isAnnotationPresent(Parameters.class)) {
                void var1_1;
                return var1_1.getAnnotation(Parameters.class).split();
            }
            return "";
        }

        /*
         * WARNING - void declaration
         */
        private String[] split(String value, Field field) {
            void var2_2;
            void var1_1;
            String regex = this.splitRegex(field);
            if (regex.length() == 0) {
                return new String[]{value};
            }
            return var1_1.split((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private boolean isOption(String arg) {
            void var1_1;
            void var2_2;
            if ("--".equals(arg)) {
                return true;
            }
            if (this.optionName2Field.containsKey(arg)) {
                return true;
            }
            int separatorIndex = arg.indexOf(this.separator);
            if (separatorIndex > 0 && this.optionName2Field.containsKey(arg.substring(0, (int)var2_2))) {
                return true;
            }
            return arg.length() > 2 && arg.startsWith("-") && this.singleCharOption2Field.containsKey(Character.valueOf(var1_1.charAt(1)));
        }

        /*
         * WARNING - void declaration
         */
        private Object tryConvert(Field field, int index, ITypeConverter<?> converter, String value, Class<?> type) throws Exception {
            try {
                return converter.convert(value);
            }
            catch (TypeConversionException ex) {
                throw new ParameterException(CommandLine.this, ex.getMessage() + this.optionDescription(" for ", field, index));
            }
            catch (Exception other) {
                void var3_5;
                void var1_1;
                void var2_2;
                String desc = this.optionDescription(" for ", field, (int)var2_2) + ": " + other;
                throw new ParameterException(CommandLine.this, "Could not convert '" + value + "' to " + type.getSimpleName() + (String)var1_1, (Exception)var3_5);
            }
        }

        /*
         * WARNING - void declaration
         */
        private String optionDescription(String prefix, Field field, int index) {
            Help.IParamLabelRenderer labelRenderer = Help.createMinimalParamLabelRenderer();
            String desc = "";
            if (field.isAnnotationPresent(Option.class)) {
                desc = prefix + "option '" + field.getAnnotation(Option.class).names()[0] + "'";
                if (index >= 0) {
                    Range range = Range.optionArity(field);
                    if (range.max > 1) {
                        void var3_3;
                        desc = desc + " at index " + (int)var3_3;
                    }
                    desc = desc + " (" + labelRenderer.renderParameterLabel(field, Help.Ansi.OFF, Collections.emptyList()) + ")";
                }
            } else if (field.isAnnotationPresent(Parameters.class)) {
                void var2_2;
                void var1_1;
                Range indexRange = Range.parameterIndex(field);
                Help.Ansi.Text label = labelRenderer.renderParameterLabel(field, Help.Ansi.OFF, Collections.emptyList());
                desc = (String)var1_1 + "positional parameter at index " + indexRange + " (" + var2_2 + ")";
            }
            return desc;
        }

        private boolean isAnyHelpRequested() {
            return this.isHelpRequested || CommandLine.this.versionHelpRequested || CommandLine.this.usageHelpRequested;
        }

        /*
         * WARNING - void declaration
         */
        private void updateHelpRequested(Field field) {
            if (field.isAnnotationPresent(Option.class)) {
                void var1_1;
                this.isHelpRequested |= this.is(field, "help", field.getAnnotation(Option.class).help());
                CommandLine commandLine = CommandLine.this;
                CommandLine.access$1702(commandLine, commandLine.versionHelpRequested | this.is(field, "versionHelp", field.getAnnotation(Option.class).versionHelp()));
                commandLine = CommandLine.this;
                CommandLine.access$1802(commandLine, commandLine.usageHelpRequested | this.is(field, "usageHelp", var1_1.getAnnotation(Option.class).usageHelp()));
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean is(Field f, String description, boolean value) {
            void var3_3;
            if (value && CommandLine.this.tracer.isInfo()) {
                void var2_2;
                void var1_1;
                CommandLine.this.tracer.info("Field '%s.%s' has '%s' annotation: not validating required fields%n", f.getDeclaringClass().getSimpleName(), var1_1.getName(), var2_2);
            }
            return (boolean)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private Collection<Object> createCollection(Class<?> collectionClass) throws Exception {
            void var1_1;
            if (collectionClass.isInterface()) {
                if (SortedSet.class.isAssignableFrom(collectionClass)) {
                    return new TreeSet<Object>();
                }
                if (Set.class.isAssignableFrom(collectionClass)) {
                    return new LinkedHashSet<Object>();
                }
                if (Queue.class.isAssignableFrom(collectionClass)) {
                    return new LinkedList<Object>();
                }
                return new ArrayList<Object>();
            }
            return (Collection)var1_1.newInstance();
        }

        private Map<Object, Object> createMap(Class<?> mapClass) throws Exception {
            try {
                return (Map)mapClass.newInstance();
            }
            catch (Exception exception) {
                return new LinkedHashMap<Object, Object>();
            }
        }

        /*
         * WARNING - void declaration
         */
        private ITypeConverter<?> getTypeConverter(Class<?> type, Field field) {
            void var2_2;
            void var1_1;
            ITypeConverter<?> result = this.converterRegistry.get(type);
            if (result != null) {
                void var3_3;
                return var3_3;
            }
            if (type.isEnum()) {
                return new ITypeConverter<Object>(this, type){
                    final /* synthetic */ Class val$type;
                    final /* synthetic */ Interpreter this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$type = clazz;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Object convert(String value) throws Exception {
                        void var1_1;
                        return Enum.valueOf(this.val$type, (String)var1_1);
                    }
                };
            }
            throw new MissingTypeConverterException(CommandLine.this, "No TypeConverter registered for " + var1_1.getName() + " of field " + var2_2);
        }

        /*
         * Unable to fully structure code
         */
        private void assertNoMissingParameters(Field field, int arity, Stack<String> args) {
            block5: {
                block6: {
                    block7: {
                        if (arity <= args.size()) break block5;
                        if (arity != 1) break block6;
                        if (field.isAnnotationPresent(Option.class)) {
                            throw new MissingParameterException(CommandLine.this, "Missing required parameter for " + this.optionDescription("", (Field)field, 0));
                        }
                        indexRange = Range.parameterIndex((Field)field);
                        labelRenderer = Help.createMinimalParamLabelRenderer();
                        sep = "";
                        names = "";
                        count = 0;
                        for (i = indexRange.min; i < this.positionalParametersFields.size(); ++i) {
                            if (Range.parameterArity((Field)this.positionalParametersFields.get((int)i)).min <= 0) continue;
                            names = names + sep + labelRenderer.renderParameterLabel(this.positionalParametersFields.get(i), Help.Ansi.OFF, Collections.emptyList());
                            sep = ", ";
                            ++count;
                        }
                        msg = "Missing required parameter";
                        field = Range.parameterArity((Field)field);
                        if (!field.isVariable) break block7;
                        v0 = new StringBuilder().append(msg).append("s at positions ").append(var2_3);
                        ** GOTO lbl-1000
                    }
                    v0 = new StringBuilder().append(msg);
                    if (count > 1) {
                        v1 = "s: ";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = ": ";
                    }
                    msg = v0.append(v1).toString();
                    throw new MissingParameterException(CommandLine.this, msg + names);
                }
                if (var3_4.isEmpty()) {
                    throw new MissingParameterException(CommandLine.this, this.optionDescription("", (Field)field, 0) + " requires at least " + (int)var2_2 + " values, but none were specified.");
                }
                throw new MissingParameterException(CommandLine.this, this.optionDescription("", (Field)var1_1, 0) + " requires at least " + (int)var2_2 + " values, but only " + var3_4.size() + " were specified: " + CommandLine.access$2200((Stack)var3_4));
            }
        }

        /*
         * WARNING - void declaration
         */
        private String trim(String value) {
            void var1_1;
            return this.unquote((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private String unquote(String value) {
            void var1_1;
            if (value == null) {
                return null;
            }
            if (value.length() > 1 && value.startsWith("\"") && value.endsWith("\"")) {
                return value.substring(1, value.length() - 1);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ String access$502(Interpreter x0, String x1) {
            void var1_1;
            x0.separator = var1_1;
            return x0.separator;
        }
    }

    public static class Range
    implements Comparable<Range> {
        public final int min;
        public final int max;
        public final boolean isVariable;
        private final boolean isUnspecified;
        private final String originalValue;

        /*
         * WARNING - void declaration
         */
        public Range(int min, int max, boolean variable, boolean unspecified, String originalValue) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.min = var1_1;
            this.max = var2_2;
            this.isVariable = var3_3;
            this.isUnspecified = unspecified;
            this.originalValue = originalValue;
        }

        public static Range optionArity(Field field) {
            if (field.isAnnotationPresent(Option.class)) {
                Field field2;
                return Range.adjustForType(Range.valueOf(field.getAnnotation(Option.class).arity()), field2);
            }
            return new Range(0, 0, false, true, "0");
        }

        public static Range parameterArity(Field field) {
            if (field.isAnnotationPresent(Parameters.class)) {
                Field field2;
                return Range.adjustForType(Range.valueOf(field.getAnnotation(Parameters.class).arity()), field2);
            }
            return new Range(0, 0, false, true, "0");
        }

        public static Range parameterIndex(Field field) {
            if (field.isAnnotationPresent(Parameters.class)) {
                Field field2;
                return Range.valueOf(field2.getAnnotation(Parameters.class).index());
            }
            return new Range(0, 0, false, true, "0");
        }

        /*
         * WARNING - void declaration
         */
        static Range adjustForType(Range result, Field field) {
            Range range;
            if (result.isUnspecified) {
                void var1_1;
                return Range.defaultArity((Field)var1_1);
            }
            return range;
        }

        /*
         * WARNING - void declaration
         */
        public static Range defaultArity(Field field) {
            void var1_1;
            Field field2;
            Class<?> type = field.getType();
            if (field2.isAnnotationPresent(Option.class)) {
                return Range.defaultArity(type);
            }
            if (CommandLine.isMultiValue((Class)var1_1)) {
                return Range.valueOf("0..1");
            }
            return Range.valueOf("1");
        }

        public static Range defaultArity(Class<?> type) {
            if (CommandLine.isBoolean(type)) {
                return Range.valueOf("0");
            }
            return Range.valueOf("1");
        }

        private int size() {
            return 1 + this.max - this.min;
        }

        /*
         * WARNING - void declaration
         */
        static Range parameterCapacity(Field field) {
            Range range;
            void var1_1;
            Range arity = Range.parameterArity(field);
            if (!CommandLine.isMultiValue(field)) {
                return arity;
            }
            Range index = Range.parameterIndex(field);
            if (arity.max == 0) {
                return arity;
            }
            if (super.size() == 1) {
                return arity;
            }
            if (index.isVariable) {
                return Range.valueOf(arity.min + "..*");
            }
            if (arity.size() == 1) {
                return Range.valueOf("" + arity.min * super.size());
            }
            if (arity.isVariable) {
                return Range.valueOf(arity.min * super.size() + "..*");
            }
            return Range.valueOf(arity.min * super.size() + ".." + var1_1.max * super.size());
        }

        /*
         * WARNING - void declaration
         */
        public static Range valueOf(String range) {
            Range range2;
            void var1_1;
            void var3_2;
            void var2_3;
            boolean variable;
            int max;
            int min;
            boolean unspecified = (range = range.trim()).length() == 0 || range.startsWith("..");
            int dots = range.indexOf("..");
            if (dots >= 0) {
                min = Range.parseInt(range.substring(0, dots), 0);
                max = Range.parseInt(range.substring(dots + 2), Integer.MAX_VALUE);
                variable = max == Integer.MAX_VALUE;
            } else {
                max = Range.parseInt(range, Integer.MAX_VALUE);
                variable = max == Integer.MAX_VALUE;
                min = variable ? 0 : max;
            }
            range2 = new Range((int)var2_3, (int)var3_2, variable, (boolean)var1_1, (String)((Object)range2));
            return range2;
        }

        /*
         * WARNING - void declaration
         */
        private static int parseInt(String str, int defaultValue) {
            try {
                return Integers.parseInt(str);
            }
            catch (Exception exception) {
                void var1_1;
                return (int)var1_1;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Range min(int newMin) {
            void var1_1;
            void v0 = var1_1;
            return new Range((int)v0, Math.max((int)v0, this.max), this.isVariable, this.isUnspecified, this.originalValue);
        }

        /*
         * WARNING - void declaration
         */
        public Range max(int newMax) {
            void var1_1;
            return new Range(Math.min(this.min, newMax), (int)var1_1, this.isVariable, this.isUnspecified, this.originalValue);
        }

        /*
         * WARNING - void declaration
         */
        public boolean contains(int value) {
            void var1_1;
            return this.min <= value && this.max >= var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object object) {
            void var1_1;
            if (!(object instanceof Range)) {
                return false;
            }
            Range other = (Range)object;
            return other.max == this.max && other.min == this.min && var1_1.isVariable == this.isVariable;
        }

        public int hashCode() {
            return ((629 + this.max) * 37 + this.min) * 37 + (this.isVariable ? 1 : 0);
        }

        public String toString() {
            if (this.min == this.max) {
                return String.valueOf(this.min);
            }
            return this.min + ".." + (this.isVariable ? "*" : Integer.valueOf(this.max));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int compareTo(Range other) {
            void var2_2;
            int result = this.min - other.min;
            if (result == 0) {
                void var1_1;
                return this.max - var1_1.max;
            }
            return (int)var2_2;
        }
    }

    public static interface ITypeConverter<K> {
        public K convert(String var1) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.LOCAL_VARIABLE, ElementType.PACKAGE})
    public static @interface Command {
        public String name() default "<main class>";

        public Class<?>[] subcommands() default {};

        public String separator() default "=";

        public String[] version() default {};

        public String headerHeading() default "";

        public String[] header() default {};

        public String synopsisHeading() default "Usage: ";

        public boolean abbreviateSynopsis() default false;

        public String[] customSynopsis() default {};

        public String descriptionHeading() default "";

        public String[] description() default {};

        public String parameterListHeading() default "";

        public String optionListHeading() default "";

        public boolean sortOptions() default true;

        public char requiredOptionMarker() default 32;

        public boolean showDefaultValues() default false;

        public String commandListHeading() default "Commands:%n";

        public String footerHeading() default "";

        public String[] footer() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Parameters {
        public String index() default "*";

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public Class<?>[] type() default {};

        public String split() default "";

        public boolean hidden() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public String[] names();

        public boolean required() default false;

        public boolean help() default false;

        public boolean usageHelp() default false;

        public boolean versionHelp() default false;

        public String[] description() default {};

        public String arity() default "";

        public String paramLabel() default "";

        public Class<?>[] type() default {};

        public String split() default "";

        public boolean hidden() default false;
    }

    public static class RunAll
    implements IParseResultHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            void var2_2;
            Iterator iterator;
            if (CommandLine.printHelpIfRequested(parsedCommands, out, ansi)) {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                CommandLine parsed = (CommandLine)iterator.next();
                result.add(CommandLine.execute((CommandLine)var3_3));
            }
            return var2_2;
        }
    }

    public static class RunLast
    implements IParseResultHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (CommandLine.printHelpIfRequested(parsedCommands, (PrintStream)var2_2, (Help.Ansi)var3_3)) {
                return Collections.emptyList();
            }
            List<CommandLine> list = parsedCommands;
            CommandLine last = list.get(list.size() - 1);
            return Arrays.asList(CommandLine.execute((CommandLine)var1_1));
        }
    }

    public static class RunFirst
    implements IParseResultHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        public List<Object> handleParseResult(List<CommandLine> parsedCommands, PrintStream out, Help.Ansi ansi) {
            void var1_1;
            void var3_3;
            void var2_2;
            if (CommandLine.printHelpIfRequested(parsedCommands, (PrintStream)var2_2, (Help.Ansi)var3_3)) {
                return Collections.emptyList();
            }
            return Arrays.asList(CommandLine.execute((CommandLine)var1_1.get(0)));
        }
    }

    public static class DefaultExceptionHandler
    implements IExceptionHandler {
        /*
         * WARNING - void declaration
         */
        @Override
        public List<Object> handleException(ParameterException ex, PrintStream out, Help.Ansi ansi, String ... args) {
            void var3_3;
            void var2_2;
            void var1_1;
            out.println(ex.getMessage());
            var1_1.getCommandLine().usage((PrintStream)var2_2, (Help.Ansi)var3_3);
            return Collections.emptyList();
        }
    }

    public static interface IExceptionHandler {
        public List<Object> handleException(ParameterException var1, PrintStream var2, Help.Ansi var3, String ... var4);
    }

    public static interface IParseResultHandler {
        public List<Object> handleParseResult(List<CommandLine> var1, PrintStream var2, Help.Ansi var3) throws ExecutionException;
    }
}

