/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.time;

import java.io.Serializable;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.PreciseClock;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public class MutableInstant
implements Serializable,
TemporalAccessor,
Instant {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int NANOS_PER_SECOND = 1000000000;
    private long epochSecond;
    private int nanoOfSecond;

    @Override
    public long getEpochSecond() {
        return this.epochSecond;
    }

    @Override
    public int getNanoOfSecond() {
        return this.nanoOfSecond;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getEpochMillisecond() {
        void var1_1;
        int millis = this.nanoOfSecond / 1000000;
        long l = this.epochSecond * 1000L + (long)var1_1;
        return l;
    }

    @Override
    public int getNanoOfMillisecond() {
        int n;
        int millis = this.nanoOfSecond / 1000000;
        n = this.nanoOfSecond - n * 1000000;
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void initFrom(Instant other) {
        void var1_1;
        this.epochSecond = other.getEpochSecond();
        this.nanoOfSecond = var1_1.getNanoOfSecond();
    }

    /*
     * WARNING - void declaration
     */
    public void initFromEpochMilli(long epochMilli, int nanoOfMillisecond) {
        void var3_2;
        void var1_1;
        this.validateNanoOfMillisecond(nanoOfMillisecond);
        this.epochSecond = epochMilli / 1000L;
        this.nanoOfSecond = (int)(var1_1 - this.epochSecond * 1000L) * 1000000 + var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private void validateNanoOfMillisecond(int nanoOfMillisecond) {
        if (nanoOfMillisecond < 0 || nanoOfMillisecond >= 1000000) {
            void var1_1;
            throw new IllegalArgumentException("Invalid nanoOfMillisecond " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initFrom(Clock clock) {
        void var1_1;
        if (clock instanceof PreciseClock) {
            ((PreciseClock)clock).init(this);
            return;
        }
        this.initFromEpochMilli(var1_1.currentTimeMillis(), 0);
    }

    /*
     * WARNING - void declaration
     */
    public void initFromEpochSecond(long epochSecond, int nano) {
        void var3_2;
        void var1_1;
        this.validateNanoOfSecond(nano);
        this.epochSecond = var1_1;
        this.nanoOfSecond = var3_2;
    }

    /*
     * WARNING - void declaration
     */
    private void validateNanoOfSecond(int nano) {
        if (nano < 0 || nano >= 1000000000) {
            void var1_1;
            throw new IllegalArgumentException("Invalid nanoOfSecond " + (int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void instantToMillisAndNanos(long epochSecond, int nano, long[] result) {
        void var2_1;
        long l;
        int millis = nano / 1000000;
        result[0] = l * 1000L + (long)millis;
        var3_2[1] = (long)(var2_1 - millis * 1000000);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSupported(TemporalField field) {
        void var1_1;
        if (field instanceof ChronoField) {
            return field == ChronoField.INSTANT_SECONDS || field == ChronoField.NANO_OF_SECOND || field == ChronoField.MICRO_OF_SECOND || field == ChronoField.MILLI_OF_SECOND;
        }
        return field != null && var1_1.isSupportedBy(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(TemporalField field) {
        void var1_1;
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case NANO_OF_SECOND: {
                    return this.nanoOfSecond;
                }
                case MICRO_OF_SECOND: {
                    return this.nanoOfSecond / 1000;
                }
                case MILLI_OF_SECOND: {
                    return this.nanoOfSecond / 1000000;
                }
                case INSTANT_SECONDS: {
                    return this.epochSecond;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return var1_1.getFrom(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ValueRange range(TemporalField field) {
        void var1_1;
        return TemporalAccessor.super.range((TemporalField)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int get(TemporalField field) {
        void var1_1;
        if (field instanceof ChronoField) {
            switch ((ChronoField)field) {
                case NANO_OF_SECOND: {
                    return this.nanoOfSecond;
                }
                case MICRO_OF_SECOND: {
                    return this.nanoOfSecond / 1000;
                }
                case MILLI_OF_SECOND: {
                    return this.nanoOfSecond / 1000000;
                }
                case INSTANT_SECONDS: {
                    ChronoField.INSTANT_SECONDS.checkValidIntValue(this.epochSecond);
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return this.range(field).checkValidIntValue(field.getFrom(this), (TemporalField)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R> R query(TemporalQuery<R> query) {
        void var1_1;
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        if (query == TemporalQueries.chronology() || query == TemporalQueries.zoneId() || query == TemporalQueries.zone() || query == TemporalQueries.offset() || query == TemporalQueries.localDate() || query == TemporalQueries.localTime()) {
            return null;
        }
        return var1_1.queryFrom(this);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableInstant)) {
            return false;
        }
        MutableInstant other = (MutableInstant)object;
        return this.epochSecond == other.epochSecond && this.nanoOfSecond == var1_1.nanoOfSecond;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = 527 + (int)(this.epochSecond ^ this.epochSecond >>> 32);
        var1_1 = var1_1 * 31 + this.nanoOfSecond;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(64);
        this.formatTo(sb);
        return var1_1.toString();
    }

    public void formatTo(StringBuilder buffer) {
        buffer.append("MutableInstant[epochSecond=").append(this.epochSecond).append(", nano=").append(this.nanoOfSecond).append("]");
    }
}

