/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.net.JndiManager;
import org.apache.logging.log4j.core.selector.NamedContextSelector;
import org.apache.logging.log4j.status.StatusLogger;

public class JndiContextSelector
implements NamedContextSelector {
    private static final LoggerContext CONTEXT = new LoggerContext("Default");
    private static final ConcurrentMap<String, LoggerContext> CONTEXT_MAP = new ConcurrentHashMap<String, LoggerContext>();
    private static final StatusLogger LOGGER = StatusLogger.getLogger();

    public JndiContextSelector() {
        if (!JndiManager.isJndiContextSelectorEnabled()) {
            throw new IllegalStateException("JNDI must be enabled by setting log4j2.enableJndiContextSelector=true");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        String loggingContextName;
        LoggerContext ctx = ContextAnchor.THREAD_CONTEXT.get();
        if (ctx == null && (loggingContextName = this.getContextName()) != null) {
            void var2_2;
            ctx = (LoggerContext)CONTEXT_MAP.get(var2_2);
        }
        if (ctx != null) {
            void var1_1;
            var1_1.stop(50L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        LoggerContext loggerContext;
        LoggerContext ctx = ContextAnchor.THREAD_CONTEXT.get();
        if (ctx == null) {
            String loggingContextName = this.getContextName();
            if (loggingContextName == null) {
                return false;
            }
            loggerContext = (LoggerContext)CONTEXT_MAP.get(loggerContext);
        }
        return loggerContext != null && loggerContext.isStarted();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getContext((String)var1_1, (ClassLoader)var2_2, (boolean)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        void var1_1;
        LoggerContext lc = ContextAnchor.THREAD_CONTEXT.get();
        if (lc != null) {
            return lc;
        }
        String loggingContextName = null;
        try {
            JndiManager jndiManager2 = JndiManager.getDefaultManager();
            Throwable throwable = null;
            try {
                loggingContextName = (String)jndiManager2.lookup("java:comp/env/log4j/context-name");
                if (jndiManager2 != null) {
                    jndiManager2.close();
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (jndiManager2 != null) {
                        if (throwable != null) {
                            try {
                                jndiManager2.close();
                            }
                            catch (Throwable jndiManager2) {
                                throwable.addSuppressed(jndiManager2);
                            }
                        } else {
                            jndiManager2.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        catch (NamingException ne) {
            void var2_4;
            LOGGER.error("Unable to lookup {}", (Object)"java:comp/env/log4j/context-name", (Object)var2_4);
        }
        if (loggingContextName == null) {
            return CONTEXT;
        }
        return this.locateContext((String)var1_1, null, configLocation);
    }

    /*
     * WARNING - void declaration
     */
    private String getContextName() {
        void var1_1;
        String loggingContextName = null;
        try {
            JndiManager jndiManager2 = JndiManager.getDefaultManager();
            Throwable throwable = null;
            try {
                loggingContextName = (String)jndiManager2.lookup("java:comp/env/log4j/context-name");
                if (jndiManager2 != null) {
                    jndiManager2.close();
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (jndiManager2 != null) {
                        if (throwable != null) {
                            try {
                                jndiManager2.close();
                            }
                            catch (Throwable jndiManager2) {
                                throwable.addSuppressed(jndiManager2);
                            }
                        } else {
                            jndiManager2.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        catch (NamingException ne) {
            void var2_4;
            LOGGER.error("Unable to lookup {}", (Object)"java:comp/env/log4j/context-name", (Object)var2_4);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext locateContext(String name, Object externalContext, URI configLocation) {
        void var1_1;
        if (name == null) {
            LOGGER.error("A context name is required to locate a LoggerContext");
            return null;
        }
        if (!CONTEXT_MAP.containsKey(name)) {
            void var2_2;
            void var3_3;
            LoggerContext ctx = new LoggerContext(name, externalContext, (URI)var3_3);
            CONTEXT_MAP.putIfAbsent(name, (LoggerContext)var2_2);
        }
        return (LoggerContext)CONTEXT_MAP.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeContext(LoggerContext context) {
        for (Map.Entry entry : CONTEXT_MAP.entrySet()) {
            void var3_3;
            if (!((LoggerContext)entry.getValue()).equals(context)) continue;
            CONTEXT_MAP.remove(var3_3.getKey());
        }
    }

    @Override
    public boolean isClassLoaderDependent() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext removeContext(String name) {
        void var1_1;
        return (LoggerContext)CONTEXT_MAP.remove(var1_1);
    }

    @Override
    public List<LoggerContext> getLoggerContexts() {
        return Collections.unmodifiableList(new ArrayList(CONTEXT_MAP.values()));
    }
}

