/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.selector;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.spi.LoggerContextShutdownAware;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StackLocatorUtil;

public class ClassLoaderContextSelector
implements ContextSelector,
LoggerContextShutdownAware {
    private static final AtomicReference<LoggerContext> DEFAULT_CONTEXT = new AtomicReference();
    protected static final StatusLogger LOGGER = StatusLogger.getLogger();
    protected static final ConcurrentMap<String, AtomicReference<WeakReference<LoggerContext>>> CONTEXT_MAP = new ConcurrentHashMap<String, AtomicReference<WeakReference<LoggerContext>>>();

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        void var3_3;
        LoggerContext ctx = null;
        if (var3_3 != false) {
            ctx = ContextAnchor.THREAD_CONTEXT.get();
        } else if (loader != null) {
            void var2_2;
            ctx = this.findContext((ClassLoader)var2_2);
        } else {
            Class clazz = StackLocatorUtil.getCallerClass((String)fqcn);
            if (clazz != null) {
                void var1_1;
                ctx = this.findContext(var1_1.getClassLoader());
            }
            if (ctx == null) {
                ctx = ContextAnchor.THREAD_CONTEXT.get();
            }
        }
        if (ctx != null) {
            ((AbstractLifeCycle)ctx).stop(50L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void contextShutdown(org.apache.logging.log4j.spi.LoggerContext loggerContext) {
        if (loggerContext instanceof LoggerContext) {
            void var1_1;
            this.removeContext((LoggerContext)var1_1);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        if (currentContext) ** GOTO lbl-1000
        if (loader != null) {
            ctx = this.findContext((ClassLoader)var2_2);
        } else {
            clazz = StackLocatorUtil.getCallerClass((String)ctx);
            if (clazz != null) {
                ctx = this.findContext(clazz.getClassLoader());
            } else lbl-1000:
            // 2 sources

            {
                ctx = ContextAnchor.THREAD_CONTEXT.get();
            }
        }
        return ctx != null && var1_1.isStarted() != false;
    }

    private LoggerContext findContext(ClassLoader loaderOrNull) {
        ClassLoader loader = loaderOrNull != null ? loaderOrNull : ClassLoader.getSystemClassLoader();
        String name = this.toContextMapKey(loader);
        AtomicReference ref = (AtomicReference)CONTEXT_MAP.get(name);
        if (ref != null) {
            WeakReference weakReference;
            weakReference = (WeakReference)((AtomicReference)((Object)weakReference)).get();
            return (LoggerContext)weakReference.get();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getContext((String)var1_1, (ClassLoader)var2_2, (boolean)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getContext((String)var1_1, (ClassLoader)var2_2, null, (boolean)var3_3, configLocation);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, Map.Entry<String, Object> entry, boolean currentContext, URI configLocation) {
        LoggerContext ctx;
        if (currentContext) {
            ctx = ContextAnchor.THREAD_CONTEXT.get();
            if (ctx != null) {
                return ctx;
            }
            return this.getDefault();
        }
        if (loader != null) {
            void var2_2;
            return this.locateContext((ClassLoader)var2_2, entry, configLocation);
        }
        Class clazz = StackLocatorUtil.getCallerClass((String)((Object)ctx));
        if (clazz != null) {
            void var3_3;
            return this.locateContext(clazz.getClassLoader(), (Map.Entry<String, Object>)var3_3, configLocation);
        }
        LoggerContext lc = ContextAnchor.THREAD_CONTEXT.get();
        if (lc != null) {
            void var1_1;
            return var1_1;
        }
        return this.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeContext(LoggerContext context) {
        for (Map.Entry entry : CONTEXT_MAP.entrySet()) {
            void var3_3;
            LoggerContext loggerContext = (LoggerContext)((WeakReference)((AtomicReference)entry.getValue()).get()).get();
            if (loggerContext != context) continue;
            CONTEXT_MAP.remove(var3_3.getKey());
        }
    }

    @Override
    public boolean isClassLoaderDependent() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<LoggerContext> getLoggerContexts() {
        void var1_1;
        ArrayList<AtomicReference> list = new ArrayList<AtomicReference>();
        Object object = CONTEXT_MAP.values();
        object = object.iterator();
        while (object.hasNext()) {
            AtomicReference atomicReference = (AtomicReference)object.next();
            LoggerContext ctx = (LoggerContext)((WeakReference)atomicReference.get()).get();
            if (ctx == null) continue;
            list.add(atomicReference);
        }
        return Collections.unmodifiableList(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private LoggerContext locateContext(ClassLoader loaderOrNull, Map.Entry<String, Object> entry, URI configLocation) {
        void var1_1;
        void var3_3;
        void var5_5;
        ClassLoader loader = loaderOrNull != null ? loaderOrNull : ClassLoader.getSystemClassLoader();
        String name = this.toContextMapKey(loader);
        AtomicReference ref = (AtomicReference)CONTEXT_MAP.get(name);
        if (ref == null) {
            LoggerContext newContext;
            if (configLocation == null) {
                for (ClassLoader parent = loader.getParent(); parent != null; parent = parent.getParent()) {
                    WeakReference weakReference;
                    LoggerContext ctx;
                    ref = (AtomicReference)CONTEXT_MAP.get(this.toContextMapKey(parent));
                    if (ref == null || (ctx = (LoggerContext)(weakReference = (WeakReference)ref.get()).get()) == null) continue;
                    return ctx;
                }
            }
            LoggerContext ctx = this.createContext(name, configLocation);
            if (entry != null) {
                ctx.putObject(entry.getKey(), entry.getValue());
            }
            if ((newContext = (LoggerContext)((WeakReference)CONTEXT_MAP.computeIfAbsent(name, k -> {
                LoggerContext loggerContext;
                return new AtomicReference<WeakReference<LoggerContext>>(new WeakReference<LoggerContext>(loggerContext));
            }).get()).get()) == ctx) {
                ctx.addShutdownListener(this);
            }
            return newContext;
        }
        WeakReference weakRef = (WeakReference)var5_5.get();
        LoggerContext ctx = (LoggerContext)weakRef.get();
        if (ctx != null) {
            if (entry != null && ctx.getObject(entry.getKey()) == null) {
                ctx.putObject(entry.getKey(), entry.getValue());
            }
            if (ctx.getConfigLocation() == null && configLocation != null) {
                LOGGER.debug("Setting configuration to {}", (Object)configLocation);
                ctx.setConfigLocation(configLocation);
            } else if (ctx.getConfigLocation() != null && configLocation != null && !ctx.getConfigLocation().equals(configLocation)) {
                LOGGER.warn("locateContext called with URI {}. Existing LoggerContext has URI {}", (Object)configLocation, (Object)ctx.getConfigLocation());
            }
            return ctx;
        }
        ctx = this.createContext(name, (URI)var3_3);
        if (entry != null) {
            void var2_2;
            ctx.putObject(entry.getKey(), var2_2.getValue());
        }
        var5_5.compareAndSet(var1_1, new WeakReference<LoggerContext>(ctx));
        return ctx;
    }

    /*
     * WARNING - void declaration
     */
    protected LoggerContext createContext(String name, URI configLocation) {
        void var2_2;
        void var1_1;
        return new LoggerContext((String)var1_1, null, (URI)var2_2);
    }

    protected String toContextMapKey(ClassLoader loader) {
        return Integer.toHexString(System.identityHashCode(loader));
    }

    /*
     * WARNING - void declaration
     */
    protected LoggerContext getDefault() {
        LoggerContext ctx = DEFAULT_CONTEXT.get();
        if (ctx != null) {
            void var1_1;
            return var1_1;
        }
        ClassLoaderContextSelector classLoaderContextSelector = this;
        DEFAULT_CONTEXT.compareAndSet(null, classLoaderContextSelector.createContext(classLoaderContextSelector.defaultContextName(), null));
        return DEFAULT_CONTEXT.get();
    }

    protected String defaultContextName() {
        return "Default";
    }
}

