/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.script;

import java.io.File;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptFile;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class ScriptManager
implements FileWatcher {
    private static final String KEY_THREADING = "THREADING";
    private static final Logger logger = StatusLogger.getLogger();
    private final Configuration configuration;
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ConcurrentMap<String, ScriptRunner> scriptRunners = new ConcurrentHashMap<String, ScriptRunner>();
    private final String languages;
    private final Set<String> allowedLanguages;
    private final WatchManager watchManager;

    /*
     * WARNING - void declaration
     */
    public ScriptManager(Configuration configuration, WatchManager watchManager, String scriptLanguages) {
        void var2_2;
        ScriptEngineFactory scriptEngineFactory;
        this.configuration = configuration;
        this.watchManager = watchManager;
        Object factories = this.manager.getEngineFactories();
        this.allowedLanguages = Arrays.stream(Strings.splitList((String)scriptLanguages)).map(String::toLowerCase).collect(Collectors.toSet());
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            int factorySize = factories.size();
            logger.debug("Installed {} script engine{}", (Object)factorySize, (Object)(factorySize != 1 ? "s" : ""));
            factories = factories.iterator();
            while (factories.hasNext()) {
                void var3_5;
                ScriptEngineFactory factory = (ScriptEngineFactory)factories.next();
                String threading = Objects.toString(factory.getParameter(KEY_THREADING), null);
                if (threading == null) {
                    threading = "Not Thread Safe";
                }
                StringBuilder names = new StringBuilder();
                List<String> languageNames = factory.getNames();
                for (String name : languageNames) {
                    if (!this.allowedLanguages.contains(name.toLowerCase(Locale.ROOT))) continue;
                    if (names.length() > 0) {
                        names.append(", ");
                    }
                    names.append(name);
                }
                if (names.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append((CharSequence)var3_5);
                boolean compiled = factory.getScriptEngine() instanceof Compilable;
                logger.debug("{} version: {}, language: {}, threading: {}, compile: {}, names: {}, factory class: {}", (Object)factory.getEngineName(), (Object)factory.getEngineVersion(), (Object)factory.getLanguageName(), (Object)threading, (Object)compiled, languageNames, (Object)factory.getClass().getName());
            }
            this.languages = sb.toString();
            return;
        }
        StringBuilder names = new StringBuilder();
        Iterator iterator = scriptEngineFactory.iterator();
        while (iterator.hasNext()) {
            scriptEngineFactory = (ScriptEngineFactory)iterator.next();
            for (String name : scriptEngineFactory.getNames()) {
                if (!this.allowedLanguages.contains(name.toLowerCase(Locale.ROOT))) continue;
                if (names.length() > 0) {
                    names.append(", ");
                }
                names.append(name);
            }
        }
        this.languages = var2_2.toString();
    }

    public Set<String> getAllowedLanguages() {
        return this.allowedLanguages;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addScript(AbstractScript script) {
        void var1_1;
        if (this.allowedLanguages.contains(script.getLanguage().toLowerCase(Locale.ROOT))) {
            ScriptEngine engine = this.manager.getEngineByName(script.getLanguage());
            if (engine == null) {
                logger.error("No ScriptEngine found for language " + script.getLanguage() + ". Available languages are: " + this.languages);
                return false;
            }
            if (engine.getFactory().getParameter(KEY_THREADING) == null) {
                this.scriptRunners.put(script.getName(), new ThreadLocalScriptRunner(script));
            } else {
                this.scriptRunners.put(script.getName(), new MainScriptRunner(engine, script));
            }
            if (script instanceof ScriptFile) {
                ScriptFile scriptFile = (ScriptFile)script;
                Path path = scriptFile.getPath();
                if (var1_1.isWatched() && path != null) {
                    void var2_2;
                    this.watchManager.watchFile(var2_2.toFile(), this);
                }
            }
        } else {
            logger.error("Unable to add script {}, {} has not been configured as an allowed language", (Object)var1_1.getName(), (Object)var1_1.getLanguage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Bindings createBindings(AbstractScript script) {
        void var1_1;
        return this.getScriptRunner((AbstractScript)var1_1).createBindings();
    }

    /*
     * WARNING - void declaration
     */
    public AbstractScript getScript(String name) {
        ScriptRunner runner = (ScriptRunner)this.scriptRunners.get(name);
        if (runner != null) {
            void var1_1;
            return var1_1.getScript();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fileModified(File file) {
        void var2_2;
        void var1_1;
        ScriptRunner runner = (ScriptRunner)this.scriptRunners.get(file.toString());
        if (runner == null) {
            logger.info("{} is not a running script", (Object)file.getName());
            return;
        }
        ScriptEngine engine = runner.getScriptEngine();
        AbstractScript script = runner.getScript();
        if (engine.getFactory().getParameter(KEY_THREADING) == null) {
            this.scriptRunners.put(script.getName(), new ThreadLocalScriptRunner(script));
            return;
        }
        this.scriptRunners.put(script.getName(), new MainScriptRunner((ScriptEngine)var1_1, (AbstractScript)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Object execute(String name, Bindings bindings) {
        void var2_2;
        void var3_3;
        ScriptRunner scriptRunner = (ScriptRunner)this.scriptRunners.get(name);
        if (scriptRunner == null) {
            void var1_1;
            logger.warn("No script named {} could be found", (Object)var1_1);
            return null;
        }
        return AccessController.doPrivileged(() -> ScriptManager.lambda$execute$0((ScriptRunner)var3_3, (Bindings)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private ScriptRunner getScriptRunner(AbstractScript script) {
        void var1_1;
        return (ScriptRunner)this.scriptRunners.get(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$execute$0(ScriptRunner scriptRunner, Bindings bindings) {
        void var1_1;
        return scriptRunner.execute((Bindings)var1_1);
    }

    private class ThreadLocalScriptRunner
    extends AbstractScriptRunner {
        private final AbstractScript script;
        private final ThreadLocal<MainScriptRunner> runners;

        /*
         * WARNING - void declaration
         */
        public ThreadLocalScriptRunner(AbstractScript script) {
            void var2_2;
            this.runners = new ThreadLocal<MainScriptRunner>(this){
                final /* synthetic */ ThreadLocalScriptRunner this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected MainScriptRunner initialValue() {
                    void var1_1;
                    ScriptEngine engine = this.this$1.ScriptManager.this.manager.getEngineByName(this.this$1.script.getLanguage());
                    return new MainScriptRunner((ScriptEngine)var1_1, this.this$1.script);
                }
            };
            this.script = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object execute(Bindings bindings) {
            void var1_1;
            return this.runners.get().execute((Bindings)var1_1);
        }

        @Override
        public AbstractScript getScript() {
            return this.script;
        }

        @Override
        public ScriptEngine getScriptEngine() {
            return this.runners.get().getScriptEngine();
        }
    }

    private class MainScriptRunner
    extends AbstractScriptRunner {
        private final AbstractScript script;
        private final CompiledScript compiledScript;
        private final ScriptEngine scriptEngine;

        /*
         * WARNING - void declaration
         */
        public MainScriptRunner(ScriptEngine scriptEngine, AbstractScript script) {
            this.script = script;
            this.scriptEngine = scriptEngine;
            CompiledScript compiled = null;
            if (scriptEngine instanceof Compilable) {
                void var3_3;
                void var2_2;
                logger.debug("Script {} is compilable", (Object)script.getName());
                compiled = AccessController.doPrivileged(() -> MainScriptRunner.lambda$new$0((ScriptEngine)var2_2, (AbstractScript)var3_3));
            }
            this.compiledScript = ScriptManager.this;
        }

        @Override
        public ScriptEngine getScriptEngine() {
            return this.scriptEngine;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object execute(Bindings bindings) {
            if (this.compiledScript != null) {
                try {
                    return this.compiledScript.eval(bindings);
                }
                catch (ScriptException ex) {
                    logger.error("Error running script " + this.script.getName(), (Throwable)ex);
                    return null;
                }
            }
            try {
                void ex;
                return this.scriptEngine.eval(this.script.getScriptText(), (Bindings)ex);
            }
            catch (ScriptException ex) {
                void var1_3;
                logger.error("Error running script " + this.script.getName(), (Throwable)var1_3);
                return null;
            }
        }

        @Override
        public AbstractScript getScript() {
            return this.script;
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ CompiledScript lambda$new$0(ScriptEngine scriptEngine, AbstractScript script) {
            try {
                void var1_2;
                return ((Compilable)((Object)scriptEngine)).compile(var1_2.getScriptText());
            }
            catch (Throwable ex) {
                void var0_1;
                logger.warn("Error compiling script", (Throwable)var0_1);
                return null;
            }
        }
    }

    private static interface ScriptRunner {
        public Bindings createBindings();

        public Object execute(Bindings var1);

        public AbstractScript getScript();

        public ScriptEngine getScriptEngine();
    }

    private abstract class AbstractScriptRunner
    implements ScriptRunner {
        private static final String KEY_STATUS_LOGGER = "statusLogger";
        private static final String KEY_CONFIGURATION = "configuration";

        private AbstractScriptRunner() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Bindings createBindings() {
            void var1_1;
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(KEY_CONFIGURATION, (Object)ScriptManager.this.configuration);
            bindings.put(KEY_STATUS_LOGGER, (Object)logger);
            return var1_1;
        }
    }
}

