/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.script;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.util.ExtensionLanguageMapping;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.IOUtils;
import org.apache.logging.log4j.core.util.NetUtils;

@Plugin(name="ScriptFile", category="Core", printObject=true)
public class ScriptFile
extends AbstractScript {
    private final Path filePath;
    private final boolean isWatched;

    /*
     * WARNING - void declaration
     */
    public ScriptFile(String name, Path filePath, String language, boolean isWatched, String scriptText) {
        super((String)var1_1, (String)var3_3, scriptText);
        void var2_2;
        void var3_3;
        void var1_1;
        this.filePath = var2_2;
        this.isWatched = isWatched;
    }

    public Path getPath() {
        return this.filePath;
    }

    public boolean isWatched() {
        return this.isWatched;
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static ScriptFile createScript(@PluginAttribute(value="name") String name2, @PluginAttribute(value="language") String language, @PluginAttribute(value="path") String filePathOrUri, @PluginAttribute(value="isWatched") Boolean isWatched22, @PluginAttribute(value="charset") Charset charset) {
        void var3_4;
        Boolean isWatched22;
        void var1_2;
        String string;
        String scriptText;
        ExtensionLanguageMapping mapping;
        String fileExtension;
        if (filePathOrUri == null) {
            LOGGER.error("No script path provided for ScriptFile");
            return null;
        }
        if (name2 == null) {
            name2 = filePathOrUri;
        }
        URI uri = NetUtils.toURI(filePathOrUri);
        File file = FileUtils.fileFromUri(uri);
        if (language == null && file != null && (fileExtension = FileUtils.getFileExtension(file)) != null && (mapping = ExtensionLanguageMapping.getByExtension(fileExtension)) != null) {
            language = mapping.getLanguage();
        }
        if (language == null) {
            LOGGER.info("No script language supplied, defaulting to {}", (Object)"JavaScript");
            language = "JavaScript";
        }
        Charset actualCharset = charset == null ? Charset.defaultCharset() : charset;
        try {
            InputStreamReader reader = new InputStreamReader(file != null ? new FileInputStream(file) : uri.toURL().openStream(), actualCharset);
            Throwable throwable = null;
            try {
                scriptText = IOUtils.toString(reader);
            }
            catch (Throwable throwable2) {
                try {
                    name2 = throwable2;
                    throwable = throwable2;
                    throw name2;
                }
                catch (Throwable name2) {
                    if (throwable != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable isWatched22) {
                            throwable.addSuppressed(isWatched22);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                    throw name2;
                }
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            void var2_3;
            LOGGER.error("{}: language={}, path={}, actualCharset={}", (Object)e.getClass().getSimpleName(), (Object)language, (Object)var2_3, (Object)actualCharset);
            return null;
        }
        Path path = file != null ? Paths.get(file.toURI()) : Paths.get(uri);
        if (path == null) {
            LOGGER.error("Unable to convert {} to a Path", (Object)uri.toString());
            return null;
        }
        return new ScriptFile(string, path, (String)var1_2, (Boolean)(isWatched22 == null ? Boolean.FALSE : var3_4), scriptText);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        if (!this.getName().equals(this.filePath.toString())) {
            sb.append("name=").append(this.getName()).append(", ");
        }
        sb.append("path=").append(this.filePath);
        if (this.getLanguage() != null) {
            sb.append(", language=").append(this.getLanguage());
        }
        sb.append(", isWatched=").append(this.isWatched);
        return var1_1.toString();
    }
}

