/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="notEmpty", category="Converter")
@ConverterKeys(value={"notEmpty", "varsNotEmpty", "variablesNotEmpty"})
@PerformanceSensitive(value={"allocation"})
public final class VariablesNotEmptyReplacementConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;

    /*
     * WARNING - void declaration
     */
    private VariablesNotEmptyReplacementConverter(List<PatternFormatter> formatters) {
        super("notEmpty", "notEmpty");
        void var1_1;
        this.formatters = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static VariablesNotEmptyReplacementConverter newInstance(Configuration config, String[] options) {
        List<PatternFormatter> list;
        void var1_1;
        if (options.length != 1) {
            LOGGER.error("Incorrect number of options on varsNotEmpty. Expected 1 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on varsNotEmpty");
            return null;
        }
        config = PatternLayout.createPatternParser((Configuration)config);
        List<PatternFormatter> formatters = ((PatternParser)config).parse((String)var1_1[0]);
        return new VariablesNotEmptyReplacementConverter(list);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        int start = toAppendTo.length();
        boolean allVarsEmpty = true;
        boolean hasVars = false;
        for (int i = 0; i < this.formatters.size(); ++i) {
            PatternFormatter formatter = this.formatters.get(i);
            int formatterStart = toAppendTo.length();
            formatter.format(event, toAppendTo);
            if (!formatter.getConverter().isVariable()) continue;
            hasVars = true;
            allVarsEmpty = allVarsEmpty && toAppendTo.length() == formatterStart;
        }
        if (!hasVars || allVarsEmpty) {
            void var3_3;
            void var2_2;
            var2_2.setLength((int)var3_3);
        }
    }
}

