/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.UUID;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.util.UuidUtil;

@Plugin(name="UuidPatternConverter", category="Converter")
@ConverterKeys(value={"u", "uuid"})
public final class UuidPatternConverter
extends LogEventPatternConverter {
    private final boolean isRandom;

    /*
     * WARNING - void declaration
     */
    private UuidPatternConverter(boolean isRandom) {
        super("u", "uuid");
        void var1_1;
        this.isRandom = var1_1;
    }

    public static UuidPatternConverter newInstance(String[] options) {
        String[] stringArray;
        if (options.length == 0) {
            return new UuidPatternConverter(false);
        }
        if (options.length > 1 || !options[0].equalsIgnoreCase("RANDOM") && !options[0].equalsIgnoreCase("Time")) {
            LOGGER.error("UUID Pattern Converter only accepts a single option with the value \"RANDOM\" or \"TIME\"");
        }
        return new UuidPatternConverter(stringArray[0].equalsIgnoreCase("RANDOM"));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        void var1_1;
        void var2_2;
        UUID uuid = this.isRandom ? UUID.randomUUID() : UuidUtil.getTimeBasedUuid();
        var2_2.append(var1_1.toString());
    }
}

