/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ThrowableFormatOptions;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.util.StringBuilderWriter;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="ThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"ex", "throwable", "exception"})
public class ThrowablePatternConverter
extends LogEventPatternConverter {
    protected final List<PatternFormatter> formatters;
    private String rawOption;
    private final boolean subShortOption;
    private final boolean nonStandardLineSeparator;
    protected final ThrowableFormatOptions options;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected ThrowablePatternConverter(String name, String style, String[] options) {
        this((String)var1_1, (String)var2_2, (String[])var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ThrowablePatternConverter(String name, String style, String[] options, Configuration config) {
        super((String)name, style);
        this.options = ThrowableFormatOptions.newInstance((String[])options);
        if (options != null && ((Object)options).length > 0) {
            this.rawOption = options[0];
        }
        if (this.options.getSuffix() != null) {
            void var2_3;
            name = PatternLayout.createPatternParser(config);
            List<PatternFormatter> parsedSuffixFormatters = ((PatternParser)name).parse(this.options.getSuffix());
            boolean hasThrowableSuffixFormatter = false;
            for (PatternFormatter patternFormatter : parsedSuffixFormatters) {
                if (!patternFormatter.handlesThrowable()) continue;
                hasThrowableSuffixFormatter = true;
            }
            if (var2_3 == false) {
                this.formatters = parsedSuffixFormatters;
            } else {
                void var3_4;
                ArrayList<void> suffixFormatters = new ArrayList<void>();
                for (PatternFormatter suffixFormatter : parsedSuffixFormatters) {
                    void var1_1;
                    if (suffixFormatter.handlesThrowable()) continue;
                    suffixFormatters.add(var1_1);
                }
                this.formatters = var3_4;
            }
        } else {
            this.formatters = Collections.emptyList();
        }
        this.subShortOption = "short.message".equalsIgnoreCase(this.rawOption) || "short.localizedMessage".equalsIgnoreCase(this.rawOption) || "short.fileName".equalsIgnoreCase(this.rawOption) || "short.lineNumber".equalsIgnoreCase(this.rawOption) || "short.methodName".equalsIgnoreCase(this.rawOption) || "short.className".equalsIgnoreCase(this.rawOption);
        this.nonStandardLineSeparator = !Strings.LINE_SEPARATOR.equals(this.options.getSeparator());
    }

    /*
     * WARNING - void declaration
     */
    public static ThrowablePatternConverter newInstance(Configuration config, String[] options) {
        Configuration configuration;
        void var1_1;
        return new ThrowablePatternConverter("Throwable", "throwable", (String[])var1_1, configuration);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void format(LogEvent event, StringBuilder buffer) {
        Throwable t = event.getThrown();
        if (this.subShortOption) {
            this.formatSubShortOption(t, this.getSuffix(event), buffer);
            return;
        }
        if (t != null && this.options.anyLines()) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.formatOption((Throwable)var3_3, this.getSuffix((LogEvent)var1_1), (StringBuilder)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void formatSubShortOption(Throwable t, String suffix, StringBuilder buffer) {
        StackTraceElement[] trace;
        StackTraceElement throwingMethod = null;
        if (t != null && (trace = t.getStackTrace()) != null && trace.length > 0) {
            throwingMethod = trace[0];
        }
        if (t != null && throwingMethod != null) {
            void var1_2;
            String toAppend = "";
            if ("short.className".equalsIgnoreCase(this.rawOption)) {
                toAppend = throwingMethod.getClassName();
            } else if ("short.methodName".equalsIgnoreCase(this.rawOption)) {
                toAppend = throwingMethod.getMethodName();
            } else if ("short.lineNumber".equalsIgnoreCase(this.rawOption)) {
                toAppend = String.valueOf(throwingMethod.getLineNumber());
            } else if ("short.message".equalsIgnoreCase(this.rawOption)) {
                toAppend = t.getMessage();
            } else if ("short.localizedMessage".equalsIgnoreCase(this.rawOption)) {
                toAppend = t.getLocalizedMessage();
            } else if ("short.fileName".equalsIgnoreCase(this.rawOption)) {
                toAppend = throwingMethod.getFileName();
            }
            int len = buffer.length();
            if (len > 0 && !Character.isWhitespace(buffer.charAt((int)(var1_2 - true)))) {
                buffer.append(' ');
            }
            buffer.append(toAppend);
            if (Strings.isNotBlank((String)suffix)) {
                void var2_3;
                void var3_4;
                buffer.append(' ');
                var3_4.append((String)var2_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void formatOption(Throwable throwable, String suffix, StringBuilder buffer) {
        void var3_3;
        void var1_1;
        int len = buffer.length();
        if (len > 0 && !Character.isWhitespace(buffer.charAt(len - 1))) {
            buffer.append(' ');
        }
        if (!this.options.allLines() || this.nonStandardLineSeparator || Strings.isNotBlank((String)suffix)) {
            StringWriter w = new StringWriter();
            throwable.printStackTrace(new PrintWriter(w));
            String[] array = w.toString().split(Strings.LINE_SEPARATOR);
            int limit = this.options.minLines(array.length) - 1;
            boolean suffixNotBlank = Strings.isNotBlank((String)suffix);
            for (int i = 0; i <= limit; ++i) {
                buffer.append(array[i]);
                if (suffixNotBlank) {
                    buffer.append(' ');
                    buffer.append(suffix);
                }
                if (i >= limit) continue;
                buffer.append(this.options.getSeparator());
            }
            return;
        }
        var1_1.printStackTrace(new PrintWriter(new StringBuilderWriter((StringBuilder)var3_3)));
    }

    @Override
    public boolean handlesThrowable() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected String getSuffix(LogEvent event) {
        void var2_2;
        if (this.formatters.isEmpty()) {
            return "";
        }
        StringBuilder toAppendTo = new StringBuilder();
        int size = this.formatters.size();
        for (int i = 0; i < size; ++i) {
            this.formatters.get(i).format(event, toAppendTo);
        }
        return var2_2.toString();
    }

    public ThrowableFormatOptions getOptions() {
        return this.options;
    }
}

