/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.AnsiConverter;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="style", category="Converter")
@ConverterKeys(value={"style"})
@PerformanceSensitive(value={"allocation"})
public final class StyleConverter
extends LogEventPatternConverter
implements AnsiConverter {
    private final List<PatternFormatter> patternFormatters;
    private final boolean noAnsi;
    private final String style;
    private final String defaultStyle;

    /*
     * WARNING - void declaration
     */
    private StyleConverter(List<PatternFormatter> patternFormatters, String style, boolean noAnsi) {
        super("style", "style");
        void var3_3;
        void var2_2;
        void var1_1;
        this.patternFormatters = var1_1;
        this.style = var2_2;
        this.defaultStyle = AnsiEscape.getDefaultStyle();
        this.noAnsi = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static StyleConverter newInstance(Configuration config, String[] options) {
        void var1_2;
        void var2_3;
        List<PatternFormatter> list;
        void var3_4;
        if (options == null) {
            return null;
        }
        if (options.length < 2) {
            LOGGER.error("Incorrect number of options on style. Expected at least 1, received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied for style converter");
            return null;
        }
        if (options[1] == null) {
            LOGGER.error("No style attributes supplied for style converter");
            return null;
        }
        config = PatternLayout.createPatternParser((Configuration)config);
        List<PatternFormatter> formatters = ((PatternParser)config).parse(options[0]);
        String style = AnsiEscape.createSequence(options[1].split(Patterns.COMMA_SPACE_SEPARATOR));
        boolean disableAnsi = Arrays.toString(options).contains("disableAnsi=true");
        boolean noConsoleNoAnsi = Arrays.toString(options).contains("noConsoleNoAnsi=true");
        boolean hideAnsi = var3_4 != false || noConsoleNoAnsi && System.console() == null;
        return new StyleConverter(list, (String)var2_3, (boolean)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        int start = 0;
        int end = 0;
        if (!this.noAnsi) {
            start = toAppendTo.length();
            toAppendTo.append(this.style);
            end = toAppendTo.length();
        }
        int size = this.patternFormatters.size();
        for (int i = 0; i < size; ++i) {
            this.patternFormatters.get(i).format(event, toAppendTo);
        }
        if (!this.noAnsi) {
            void var2_2;
            if (toAppendTo.length() == end) {
                void var3_3;
                toAppendTo.setLength((int)var3_3);
                return;
            }
            var2_2.append(this.defaultStyle);
        }
    }

    @Override
    public final boolean handlesThrowable() {
        for (PatternFormatter patternFormatter : this.patternFormatters) {
            if (!patternFormatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("[style=");
        sb.append(this.style);
        sb.append(", defaultStyle=");
        sb.append(this.defaultStyle);
        sb.append(", patternFormatters=");
        sb.append(this.patternFormatters);
        sb.append(", noAnsi=");
        sb.append(this.noAnsi);
        sb.append(']');
        return var1_1.toString();
    }
}

