/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.util.OptionConverter;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
abstract class SimpleLiteralPatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private SimpleLiteralPatternConverter() {
        super("SimpleLiteral", "literal");
    }

    static LogEventPatternConverter of(String literal, boolean convertBackslashes) {
        String string;
        string = convertBackslashes ? OptionConverter.convertSpecialChars(literal) : string;
        return SimpleLiteralPatternConverter.of(string);
    }

    static LogEventPatternConverter of(String literal) {
        String string;
        if (literal == null || literal.isEmpty()) {
            return Noop.INSTANCE;
        }
        if (" ".equals(literal)) {
            return Space.INSTANCE;
        }
        return new StringValue(string);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent ignored, StringBuilder output) {
        void var2_2;
        this.format((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(Object ignored, StringBuilder output) {
        void var2_2;
        this.format((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(StringBuilder output, Object ... args) {
        void var1_1;
        this.format((StringBuilder)var1_1);
    }

    abstract void format(StringBuilder var1);

    @Override
    public final boolean isVariable() {
        return false;
    }

    @Override
    public final boolean handlesThrowable() {
        return false;
    }

    private static final class StringValue
    extends SimpleLiteralPatternConverter {
        private final String literal;

        /*
         * WARNING - void declaration
         */
        StringValue(String literal) {
            void var1_1;
            this.literal = var1_1;
        }

        @Override
        final void format(StringBuilder output) {
            output.append(this.literal);
        }
    }

    private static final class Space
    extends SimpleLiteralPatternConverter {
        private static final Space INSTANCE = new Space();

        private Space() {
        }

        @Override
        final void format(StringBuilder output) {
            output.append(' ');
        }
    }

    private static final class Noop
    extends SimpleLiteralPatternConverter {
        private static final Noop INSTANCE = new Noop();

        private Noop() {
        }

        @Override
        final void format(StringBuilder output) {
        }
    }
}

