/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="RootThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"rEx", "rThrowable", "rException"})
public final class RootThrowablePatternConverter
extends ThrowablePatternConverter {
    /*
     * WARNING - void declaration
     */
    private RootThrowablePatternConverter(Configuration config, String[] options) {
        super("RootThrowable", "throwable", (String[])var2_2, (Configuration)var1_1);
        void var1_1;
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static RootThrowablePatternConverter newInstance(Configuration config, String[] options) {
        void var1_1;
        Configuration configuration;
        return new RootThrowablePatternConverter(configuration, (String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        ThrowableProxy proxy = event.getThrownProxy();
        Throwable throwable = event.getThrown();
        if (throwable != null && this.options.anyLines()) {
            void var1_1;
            void var2_2;
            if (proxy == null) {
                super.format(event, toAppendTo);
                return;
            }
            String trace = proxy.getCauseStackTraceAsString(this.options.getIgnorePackages(), this.options.getTextRenderer(), this.getSuffix(event), this.options.getSeparator());
            int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(' ');
            }
            if (!this.options.allLines() || !Strings.LINE_SEPARATOR.equals(this.options.getSeparator())) {
                void var3_5;
                StringBuilder sb = new StringBuilder();
                String[] array = trace.split(Strings.LINE_SEPARATOR);
                int limit = this.options.minLines(array.length) - 1;
                for (int i = 0; i <= limit; ++i) {
                    sb.append(array[i]);
                    if (i >= limit) continue;
                    sb.append(this.options.getSeparator());
                }
                toAppendTo.append(var3_5.toString());
                return;
            }
            var2_2.append((String)var1_1);
        }
    }
}

