/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="repeat", category="Converter")
@ConverterKeys(value={":|", "repeat"})
@PerformanceSensitive(value={"allocation"})
public final class RepeatPatternConverter
extends LogEventPatternConverter {
    private final String result;

    /*
     * WARNING - void declaration
     */
    public static RepeatPatternConverter newInstance(Configuration config, String[] options) {
        void var2_3;
        if (options.length != 2) {
            LOGGER.error("Incorrect number of options on repeat. Expected 2 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No string supplied on repeat");
            return null;
        }
        if (options[1] == null) {
            LOGGER.error("No repeat count supplied on repeat");
            return null;
        }
        String result = options[0];
        try {
            void var0_1;
            int count = Integers.parseInt(options[1]);
            result = Strings.repeat((String)options[0], (int)var0_1);
        }
        catch (Exception exception) {
            void var1_2;
            LOGGER.error("The repeat count is not an integer: {}", (Object)var1_2[1].trim());
        }
        return new RepeatPatternConverter((String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    private RepeatPatternConverter(String result) {
        super("repeat", "repeat");
        void var1_1;
        this.result = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(Object obj, StringBuilder toAppendTo) {
        void var2_2;
        this.format((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        void var2_2;
        this.format((StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void format(StringBuilder toAppendTo) {
        if (this.result != null) {
            void var1_1;
            var1_1.append(this.result);
        }
    }
}

