/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.lang.management.ManagementFactory;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="RelativeTimePatternConverter", category="Converter")
@ConverterKeys(value={"r", "relative"})
@PerformanceSensitive(value={"allocation"})
public class RelativeTimePatternConverter
extends LogEventPatternConverter {
    private final long startTime = ManagementFactory.getRuntimeMXBean().getStartTime();

    public RelativeTimePatternConverter() {
        super("Time", "time");
    }

    public static RelativeTimePatternConverter newInstance(String[] options) {
        return new RelativeTimePatternConverter();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        void var3_3;
        void var2_2;
        long timestamp = event.getTimeMillis();
        var2_2.append((long)(var3_3 - this.startTime));
    }
}

