/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;

@Plugin(name="replace", category="Converter")
@ConverterKeys(value={"replace"})
public final class RegexReplacementConverter
extends LogEventPatternConverter {
    private final Pattern pattern;
    private final String substitution;
    private final List<PatternFormatter> formatters;

    /*
     * WARNING - void declaration
     */
    private RegexReplacementConverter(List<PatternFormatter> formatters, Pattern pattern, String substitution) {
        super("replace", "replace");
        void var1_1;
        void var3_3;
        void var2_2;
        this.pattern = var2_2;
        this.substitution = var3_3;
        this.formatters = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static RegexReplacementConverter newInstance(Configuration config, String[] options) {
        void var1_1;
        void var2_2;
        List<PatternFormatter> list;
        if (options.length != 3) {
            LOGGER.error("Incorrect number of options on replace. Expected 3 received " + options.length);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on replace");
            return null;
        }
        if (options[1] == null) {
            LOGGER.error("No regular expression supplied on replace");
            return null;
        }
        if (options[2] == null) {
            LOGGER.error("No substitution supplied on replace");
            return null;
        }
        Pattern p = Pattern.compile(options[1]);
        config = PatternLayout.createPatternParser((Configuration)config);
        List<PatternFormatter> formatters = ((PatternParser)config).parse(options[0]);
        return new RegexReplacementConverter(list, (Pattern)var2_2, (String)var1_1[2]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        void var3_3;
        void var2_2;
        StringBuilder buf = new StringBuilder();
        for (PatternFormatter patternFormatter : this.formatters) {
            patternFormatter.format(event, buf);
        }
        var2_2.append(this.pattern.matcher(var3_3.toString()).replaceAll(this.substitution));
    }
}

