/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="replace", category="Core", printObject=true)
public final class RegexReplacement {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final Pattern pattern;
    private final String substitution;

    /*
     * WARNING - void declaration
     */
    private RegexReplacement(Pattern pattern, String substitution) {
        void var2_2;
        void var1_1;
        this.pattern = var1_1;
        this.substitution = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final String format(String msg) {
        void var1_1;
        return this.pattern.matcher((CharSequence)var1_1).replaceAll(this.substitution);
    }

    public final String toString() {
        return "replace(regex=" + this.pattern.pattern() + ", replacement=" + this.substitution + ')';
    }

    /*
     * WARNING - void declaration
     */
    @PluginFactory
    public static RegexReplacement createRegexReplacement(@PluginAttribute(value="regex") Pattern regex, @PluginAttribute(value="replacement") String replacement) {
        void var1_1;
        Pattern pattern;
        if (regex == null) {
            LOGGER.error("A regular expression is required for replacement");
            return null;
        }
        if (replacement == null) {
            LOGGER.error("A replacement string is required to perform replacement");
        }
        return new RegexReplacement(pattern, (String)var1_1);
    }
}

