/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.pattern.DynamicWordAbbreviator;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public abstract class NameAbbreviator {
    private static final NameAbbreviator DEFAULT = new NOPAbbreviator();

    /*
     * WARNING - void declaration
     */
    public static NameAbbreviator getAbbreviator(String pattern) {
        if (pattern.length() > 0) {
            void var1_3;
            int i;
            String number;
            boolean isNegativeNumber;
            String trimmed = pattern.trim();
            if (trimmed.isEmpty()) {
                return DEFAULT;
            }
            DynamicWordAbbreviator dwa = DynamicWordAbbreviator.create(trimmed);
            if (dwa != null) {
                return dwa;
            }
            if (trimmed.length() > 1 && trimmed.charAt(0) == '-') {
                isNegativeNumber = true;
                number = trimmed.substring(1);
            } else {
                isNegativeNumber = false;
                number = trimmed;
            }
            for (i = 0; i < number.length() && number.charAt(i) >= '0' && number.charAt(i) <= '9'; ++i) {
            }
            if (i == number.length()) {
                return new MaxElementAbbreviator(Integers.parseInt(number), isNegativeNumber ? MaxElementAbbreviator.Strategy.DROP : MaxElementAbbreviator.Strategy.RETAIN);
            }
            ArrayList<PatternAbbreviatorFragment> fragments = new ArrayList<PatternAbbreviatorFragment>(5);
            for (int pos = 0; pos < trimmed.length() && pos >= 0; ++pos) {
                void var2_5;
                void var3_6;
                int charCount;
                int ellipsisPos = pos;
                if (trimmed.charAt(pos) == '*') {
                    charCount = Integer.MAX_VALUE;
                    ++ellipsisPos;
                } else if (trimmed.charAt(pos) >= '0' && trimmed.charAt(pos) <= '9') {
                    charCount = trimmed.charAt(pos) - 48;
                    ++ellipsisPos;
                } else {
                    charCount = 0;
                }
                char ellipsis = '\u0000';
                if (ellipsisPos < trimmed.length() && (ellipsis = trimmed.charAt(ellipsisPos)) == '.') {
                    ellipsis = '\u0000';
                }
                fragments.add(new PatternAbbreviatorFragment((int)var3_6, (char)var2_5));
                pos = trimmed.indexOf(46, pos);
                if (pos == -1) break;
            }
            return new PatternAbbreviator((List<PatternAbbreviatorFragment>)var1_3);
        }
        return DEFAULT;
    }

    public static NameAbbreviator getDefaultAbbreviator() {
        return DEFAULT;
    }

    public abstract void abbreviate(String var1, StringBuilder var2);

    private static final class PatternAbbreviator
    extends NameAbbreviator {
        private final PatternAbbreviatorFragment[] fragments;

        /*
         * WARNING - void declaration
         */
        PatternAbbreviator(List<PatternAbbreviatorFragment> fragments) {
            void var1_1;
            if (fragments.isEmpty()) {
                throw new IllegalArgumentException("fragments must have at least one element");
            }
            this.fragments = var1_1.toArray(PatternAbbreviatorFragment.EMPTY_ARRAY);
        }

        @Override
        public final void abbreviate(String original, StringBuilder destination) {
            int originalIndex = 0;
            int iteration = 0;
            int originalLength = original.length();
            while (originalIndex >= 0 && originalIndex < originalLength) {
                originalIndex = this.fragment(iteration++).abbreviate(original, originalIndex, destination);
            }
        }

        final PatternAbbreviatorFragment fragment(int index) {
            return this.fragments[Math.min(index, this.fragments.length - 1)];
        }

        public final String toString() {
            return String.format("%s[fragments=%s]", this.getClass().getSimpleName(), Arrays.toString(this.fragments));
        }
    }

    private static final class PatternAbbreviatorFragment {
        static final PatternAbbreviatorFragment[] EMPTY_ARRAY = new PatternAbbreviatorFragment[0];
        private final int charCount;
        private final char ellipsis;

        /*
         * WARNING - void declaration
         */
        PatternAbbreviatorFragment(int charCount, char ellipsis) {
            void var2_2;
            void var1_1;
            this.charCount = var1_1;
            this.ellipsis = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        final int abbreviate(String input, int inputIndex, StringBuilder buf) {
            int nextDot = input.indexOf(46, inputIndex);
            if (nextDot < 0) {
                buf.append(input, inputIndex, input.length());
                return nextDot;
            }
            if (nextDot - inputIndex > this.charCount) {
                int n = inputIndex;
                buf.append(input, n, n + this.charCount);
                if (this.ellipsis != '\u0000') {
                    buf.append(this.ellipsis);
                }
                buf.append('.');
            } else {
                void var2_2;
                void var1_1;
                void var3_3;
                var3_3.append((CharSequence)var1_1, (int)var2_2, nextDot + 1);
            }
            return nextDot + 1;
        }

        public final String toString() {
            return String.format("%s[charCount=%s, ellipsis=%s]", this.getClass().getSimpleName(), this.charCount, Integer.toHexString(this.ellipsis));
        }
    }

    private static class MaxElementAbbreviator
    extends NameAbbreviator {
        private final int count;
        private final Strategy strategy;

        /*
         * WARNING - void declaration
         */
        public MaxElementAbbreviator(int count, Strategy strategy) {
            void var2_2;
            void var1_1;
            this.count = Math.max((int)var1_1, strategy.minCount);
            this.strategy = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void abbreviate(String original, StringBuilder destination) {
            void var2_2;
            void var1_1;
            this.strategy.abbreviate(this.count, (String)var1_1, (StringBuilder)var2_2);
        }

        private static enum Strategy {
            DROP(0){
                {
                    void var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                final void abbreviate(int count, String original, StringBuilder destination) {
                    void var2_2;
                    void var3_3;
                    int n;
                    int start = 0;
                    for (int i = 0; i < count; ++i) {
                        int nextStart = original.indexOf(46, start);
                        if (nextStart == -1) {
                            destination.append(original);
                            return;
                        }
                        n = nextStart + 1;
                    }
                    var3_3.append(original, n, var2_2.length());
                }
            }
            ,
            RETAIN(1){
                {
                    void var3_3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                final void abbreviate(int count, String original, StringBuilder destination) {
                    void var2_2;
                    void var3_3;
                    void i;
                    int end = original.length() - 1;
                    while (i > 0) {
                        if ((end = original.lastIndexOf(46, end - 1)) == -1) {
                            destination.append(original);
                            return;
                        }
                        --i;
                    }
                    var3_3.append(original, end + 1, var2_2.length());
                }
            };

            final int minCount;

            /*
             * WARNING - void declaration
             */
            private Strategy(int minCount) {
                void var3_3;
                this.minCount = var3_3;
            }

            abstract void abbreviate(int var1, String var2, StringBuilder var3);
        }
    }

    private static class NOPAbbreviator
    extends NameAbbreviator {
        /*
         * WARNING - void declaration
         */
        @Override
        public void abbreviate(String original, StringBuilder destination) {
            void var1_1;
            destination.append((String)var1_1);
        }
    }
}

