/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.HtmlTextRenderer;
import org.apache.logging.log4j.core.pattern.JAnsiTextRenderer;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="MessagePatternConverter", category="Converter")
@ConverterKeys(value={"m", "msg", "message"})
@PerformanceSensitive(value={"allocation"})
public class MessagePatternConverter
extends LogEventPatternConverter {
    private static final String LOOKUPS = "lookups";
    private static final String NOLOOKUPS = "nolookups";

    private MessagePatternConverter() {
        super("Message", "message");
    }

    private static TextRenderer loadMessageRenderer(String[] options) {
        if (options != null) {
            String[] stringArray = options;
            int n = options.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                switch (string.toUpperCase(Locale.ROOT)) {
                    case "ANSI": {
                        if (Loader.isJansiAvailable()) {
                            return new JAnsiTextRenderer(options, JAnsiTextRenderer.DefaultMessageStyleMap);
                        }
                        StatusLogger.getLogger().warn("You requested ANSI message rendering but JANSI is not on the classpath.");
                        return null;
                    }
                    case "HTML": {
                        return new HtmlTextRenderer(options);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static MessagePatternConverter newInstance(Configuration config, String[] options) {
        Object object;
        Object result;
        Object formats = MessagePatternConverter.withoutLookupOptions(options);
        TextRenderer textRenderer = MessagePatternConverter.loadMessageRenderer(formats);
        Object object2 = result = formats == null || ((String[])formats).length == 0 ? SimpleMessagePatternConverter.INSTANCE : new FormattedMessagePatternConverter((String[])formats);
        if (textRenderer != null) {
            void var1_1;
            result = new RenderingPatternConverter((MessagePatternConverter)result, (TextRenderer)var1_1);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] withoutLookupOptions(String[] options) {
        void var1_1;
        String[] stringArray;
        if (options == null || options.length == 0) {
            return options;
        }
        ArrayList<String> results = new ArrayList<String>(options.length);
        for (String option : stringArray) {
            if (LOOKUPS.equalsIgnoreCase(option) || NOLOOKUPS.equalsIgnoreCase(option)) {
                LOGGER.info("The {} option will be ignored. Message Lookups are no longer supported.", (Object)option);
                continue;
            }
            results.add(option);
        }
        return var1_1.toArray(Strings.EMPTY_ARRAY);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        throw new UnsupportedOperationException();
    }

    private static final class RenderingPatternConverter
    extends MessagePatternConverter {
        private final MessagePatternConverter delegate;
        private final TextRenderer textRenderer;

        /*
         * WARNING - void declaration
         */
        RenderingPatternConverter(MessagePatternConverter delegate, TextRenderer textRenderer) {
            void var2_2;
            void var1_1;
            this.delegate = var1_1;
            this.textRenderer = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void format(LogEvent event, StringBuilder toAppendTo) {
            void var2_2;
            void var3_3;
            void var1_1;
            StringBuilder workingBuilder = new StringBuilder(80);
            ((LogEventPatternConverter)this.delegate).format((LogEvent)var1_1, workingBuilder);
            this.textRenderer.render((StringBuilder)var3_3, (StringBuilder)var2_2);
        }
    }

    private static final class FormattedMessagePatternConverter
    extends MessagePatternConverter {
        private final String[] formats;

        /*
         * WARNING - void declaration
         */
        FormattedMessagePatternConverter(String[] formats) {
            void var1_1;
            this.formats = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void format(LogEvent event, StringBuilder toAppendTo) {
            Message msg = event.getMessage();
            if (msg instanceof StringBuilderFormattable) {
                if (msg instanceof MultiFormatStringBuilderFormattable) {
                    ((MultiFormatStringBuilderFormattable)msg).formatTo(this.formats, toAppendTo);
                    return;
                }
                ((StringBuilderFormattable)msg).formatTo(toAppendTo);
                return;
            }
            if (msg != null) {
                void var1_1;
                void var2_2;
                var2_2.append(msg instanceof MultiformatMessage ? ((MultiformatMessage)msg).getFormattedMessage(this.formats) : var1_1.getFormattedMessage());
            }
        }
    }

    private static final class SimpleMessagePatternConverter
    extends MessagePatternConverter {
        private static final MessagePatternConverter INSTANCE = new SimpleMessagePatternConverter();

        private SimpleMessagePatternConverter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void format(LogEvent event, StringBuilder toAppendTo) {
            Message msg = event.getMessage();
            if (msg instanceof StringBuilderFormattable) {
                ((StringBuilderFormattable)msg).formatTo(toAppendTo);
                return;
            }
            if (msg != null) {
                void var1_1;
                void var2_2;
                var2_2.append(var1_1.getFormattedMessage());
            }
        }
    }
}

