/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.TriConsumer;

@Plugin(name="MdcPatternConverter", category="Converter")
@ConverterKeys(value={"X", "mdc", "MDC"})
@PerformanceSensitive(value={"allocation"})
public final class MdcPatternConverter
extends LogEventPatternConverter {
    private final String key;
    private final String[] keys;
    private final boolean full;
    private static final TriConsumer<String, Object, StringBuilder> WRITE_KEY_VALUES_INTO = (key, value, sb) -> {
        void var2_2;
        void var1_1;
        String string;
        sb.append(string).append('=');
        StringBuilders.appendValue((StringBuilder)sb, (Object)var1_1);
        var2_2.append(", ");
    };

    /*
     * WARNING - void declaration
     */
    private MdcPatternConverter(String[] options) {
        super(options != null && options.length > 0 ? "MDC{" + options[0] + '}' : "MDC", "mdc");
        if (options != null && options.length > 0) {
            void var1_1;
            this.full = false;
            if (options[0].indexOf(44) > 0) {
                this.keys = options[0].split(",");
                for (int i = 0; i < this.keys.length; ++i) {
                    this.keys[i] = this.keys[i].trim();
                }
                this.key = null;
                return;
            }
            this.keys = null;
            this.key = var1_1[0];
            return;
        }
        this.full = true;
        this.key = null;
        this.keys = null;
    }

    public static MdcPatternConverter newInstance(String[] options) {
        String[] stringArray;
        return new MdcPatternConverter(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        Object value;
        ReadOnlyStringMap contextData = event.getContextData();
        if (this.full) {
            if (contextData == null || contextData.isEmpty()) {
                toAppendTo.append("{}");
                return;
            }
            MdcPatternConverter.appendFully(contextData, toAppendTo);
            return;
        }
        if (this.keys != null) {
            if (contextData == null || contextData.isEmpty()) {
                toAppendTo.append("{}");
                return;
            }
            MdcPatternConverter.appendSelectedKeys(this.keys, contextData, toAppendTo);
            return;
        }
        if (contextData != null && (value = contextData.getValue(this.key)) != null) {
            void var1_1;
            void var2_2;
            StringBuilders.appendValue((StringBuilder)var2_2, (Object)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendFully(ReadOnlyStringMap contextData, StringBuilder toAppendTo) {
        void var1_2;
        void var2_3;
        toAppendTo.append("{");
        int start = toAppendTo.length();
        contextData.forEach(WRITE_KEY_VALUES_INTO, (Object)toAppendTo);
        int end = toAppendTo.length();
        if (end > var2_3) {
            void var0_1;
            toAppendTo.setCharAt(end - 2, '}');
            toAppendTo.deleteCharAt((int)(var0_1 - true));
            return;
        }
        var1_2.append('}');
    }

    /*
     * WARNING - void declaration
     */
    private static void appendSelectedKeys(String[] keys, ReadOnlyStringMap contextData, StringBuilder sb) {
        void var2_2;
        int start = sb.length();
        sb.append('{');
        for (int i = 0; i < keys.length; ++i) {
            String theKey = keys[i];
            Object value = contextData.getValue(theKey);
            if (value == null) continue;
            if (sb.length() - start > 1) {
                sb.append(", ");
            }
            sb.append(theKey).append('=');
            StringBuilders.appendValue((StringBuilder)sb, (Object)value);
        }
        var2_2.append('}');
    }
}

