/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="maxLength", category="Converter")
@ConverterKeys(value={"maxLength", "maxLen"})
@PerformanceSensitive(value={"allocation"})
public final class MaxLengthConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final int maxLength;

    /*
     * WARNING - void declaration
     */
    public static MaxLengthConverter newInstance(Configuration config, String[] options) {
        void var1_1;
        List<PatternFormatter> list;
        if (options.length != 2) {
            LOGGER.error("Incorrect number of options on maxLength: expected 2 received {}: {}", (Object)options.length, (Object)options);
            return null;
        }
        if (options[0] == null) {
            LOGGER.error("No pattern supplied on maxLength");
            return null;
        }
        if (options[1] == null) {
            LOGGER.error("No length supplied on maxLength");
            return null;
        }
        config = PatternLayout.createPatternParser((Configuration)config);
        List<PatternFormatter> formatters = ((PatternParser)config).parse(options[0]);
        return new MaxLengthConverter(list, AbstractAppender.parseInt((String)var1_1[1], 100));
    }

    /*
     * WARNING - void declaration
     */
    private MaxLengthConverter(List<PatternFormatter> formatters, int maxLength) {
        super("MaxLength", "maxLength");
        void var2_2;
        void var1_1;
        this.maxLength = maxLength;
        this.formatters = var1_1;
        LOGGER.trace("new MaxLengthConverter with {}", (Object)((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        int initialLength = toAppendTo.length();
        for (int i = 0; i < this.formatters.size(); ++i) {
            PatternFormatter patternFormatter = this.formatters.get(i);
            patternFormatter.format(event, toAppendTo);
            if (toAppendTo.length() > initialLength + this.maxLength) break;
        }
        if (toAppendTo.length() > initialLength + this.maxLength) {
            void var3_3;
            toAppendTo.setLength((int)(var3_3 + this.maxLength));
            if (this.maxLength > 20) {
                void var2_2;
                var2_2.append("...");
            }
        }
    }
}

