/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.util.OptionConverter;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class LiteralPatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private final String literal;
    private final Configuration config;
    private final boolean substitute;

    /*
     * WARNING - void declaration
     */
    public LiteralPatternConverter(Configuration config, String literal, boolean convertBackslashes) {
        super("Literal", "literal");
        void var2_2;
        void var1_1;
        void var3_3;
        this.literal = var3_3 != false ? OptionConverter.convertSpecialChars(literal) : literal;
        this.config = config;
        this.substitute = var1_1 != null && LiteralPatternConverter.containsSubstitutionSequence((String)var2_2);
    }

    static boolean containsSubstitutionSequence(String literal) {
        String string;
        return literal != null && string.contains("${");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void format(LogEvent event, StringBuilder toAppendTo) {
        void var1_1;
        toAppendTo.append(this.substitute ? this.config.getStrSubstitutor().replace((LogEvent)var1_1, this.literal) : this.literal);
    }

    @Override
    public final void format(Object obj, StringBuilder output) {
        output.append(this.substitute ? this.config.getStrSubstitutor().replace(this.literal) : this.literal);
    }

    @Override
    public final void format(StringBuilder output, Object ... objects) {
        output.append(this.substitute ? this.config.getStrSubstitutor().replace(this.literal) : this.literal);
    }

    public final String getLiteral() {
        return this.literal;
    }

    @Override
    public final boolean isVariable() {
        return false;
    }

    public final String toString() {
        return "LiteralPatternConverter[literal=" + this.literal + ", config=" + this.config + ", substitute=" + this.substitute + "]";
    }
}

