/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="LevelPatternConverter", category="Converter")
@ConverterKeys(value={"p", "level"})
@PerformanceSensitive(value={"allocation"})
public class LevelPatternConverter
extends LogEventPatternConverter {
    private static final String OPTION_LENGTH = "length";
    private static final String OPTION_LOWER = "lowerCase";
    private static final LevelPatternConverter INSTANCE = new SimpleLevelPatternConverter();

    private LevelPatternConverter() {
        super("Level", "level");
    }

    /*
     * WARNING - void declaration
     */
    public static LevelPatternConverter newInstance(String[] options) {
        void var1_1;
        String[] stringArray;
        if (options == null || options.length == 0) {
            return INSTANCE;
        }
        HashMap<Object, String> levelMap = new HashMap<Object, String>();
        int length = Integer.MAX_VALUE;
        boolean lowerCase = false;
        String[] stringArray2 = stringArray[0].split(Patterns.COMMA_SEPARATOR);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            String[] pair = string.split("=");
            if (pair == null || pair.length != 2) {
                LOGGER.error("Invalid option {}", (Object)string);
                continue;
            }
            String string2 = pair[0].trim();
            String value = pair[1].trim();
            if (OPTION_LENGTH.equalsIgnoreCase(string2)) {
                length = Integers.parseInt(value);
                continue;
            }
            if (OPTION_LOWER.equalsIgnoreCase(string2)) {
                lowerCase = Boolean.parseBoolean(value);
                continue;
            }
            Level level = Level.toLevel((String)string2, null);
            if (level == null) {
                LOGGER.error("Invalid Level {}", (Object)string2);
                continue;
            }
            levelMap.put(level, value);
        }
        if (levelMap.isEmpty() && length == Integer.MAX_VALUE && !lowerCase) {
            return INSTANCE;
        }
        for (String string : Level.values()) {
            if (levelMap.containsKey(string)) continue;
            String left = LevelPatternConverter.left((Level)string, length);
            levelMap.put(string, lowerCase ? left.toLowerCase(Locale.US) : left);
        }
        return new LevelMapLevelPatternConverter((Map)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static String left(Level level, int length) {
        void var1_1;
        String string;
        String string2 = level.toString();
        if (length >= string2.length()) {
            return string2;
        }
        return string.substring(0, (int)var1_1);
    }

    @Override
    public void format(LogEvent event, StringBuilder output) {
        throw new UnsupportedOperationException("Overridden by subclasses");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getStyleClass(Object e) {
        if (e instanceof LogEvent) {
            void var1_1;
            return "level " + ((LogEvent)var1_1).getLevel().name().toLowerCase(Locale.ENGLISH);
        }
        return "level";
    }

    private static final class LevelMapLevelPatternConverter
    extends LevelPatternConverter {
        private final Map<Level, String> levelMap;

        /*
         * WARNING - void declaration
         */
        private LevelMapLevelPatternConverter(Map<Level, String> levelMap) {
            void var1_1;
            this.levelMap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void format(LogEvent event, StringBuilder output) {
            void var1_1;
            output.append(this.levelMap.get(var1_1.getLevel()));
        }
    }

    private static final class SimpleLevelPatternConverter
    extends LevelPatternConverter {
        private SimpleLevelPatternConverter() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void format(LogEvent event, StringBuilder output) {
            void var1_1;
            output.append(var1_1.getLevel());
        }
    }
}

